
<?php $__env->startSection('title','Emart | Flash Deal List'); ?>
<?php $__env->startSection("content"); ?>   
<!-- Home Start -->
<section id="home" class="home-main-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <nav aria-label="breadcrumb" class="breadcrumb-main-block">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" title="Home"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Flash Deals')); ?></li>
                    </ol>
                </nav>
                <div class="about-breadcrumb-block wishlist-breadcrumb" style="background-image: url('<?= URL::to('/'); ?>/frontend/assets/images/wishlist/breadcrum.png');">
                  <div class="breadcrumb-nav">
                      <h3 class="breadcrumb-title"><?php echo e(__('Flash Deals')); ?></h3>
                  </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Home End -->
<div id="flash-deal-bg" class="flashdeal-bg-main-block flash-deal-list-main-block">
    <div class="container">
        <div class="row">
            <?php if($deals): ?>
                <?php $__currentLoopData = $deals; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deal): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-3">
                    <a href="<?php echo e(route('flashdeals.view',['id' => $deal->id, 'slug' => str_slug($deal->title,'-')])); ?>" title="<?php echo e($deal->title); ?>">
                        <div class="card flash-deal-list-page border-hover">
                            <div class="border-hover-two">
                                <div class="flash-deal-list-page-img">
                                    <img src="<?php echo e(url('images/flashdeals/'.$deal->background_image)); ?>" class="img-fluid" alt="<?php echo e($deal->title); ?>">
                                </div>
                                <div class="card-body buttons">
                                    <h4 class="mb-3"><?php echo e($deal->title); ?></h4>
                                    <p class="card-text"><b><?php echo e(__("Sale Start Date:")); ?></b> <?php echo e(date('d-m-Y @ h:i A',strtotime($deal->start_date))); ?></p>
                                    <p class="card-text"><b><?php echo e(__("Sale End Date:")); ?></b> <?php echo e(date('d-m-Y @ h:i A',strtotime($deal->end_date))); ?></p>
                                    <a href="<?php echo e(route('flashdeals.view',['id' => $deal->id, 'slug' => str_slug($deal->title,'-')])); ?>" class="btn btn-primary"> <?php echo e(__("View Deal")); ?></a>
                                </div>
                            </div>
                        </div>
                    </a>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <?php else: ?>
            <div class="text-center">
                <h3><?php echo e(__("No deals")); ?></h3>
            </div>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make("frontend.layout.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\emart_live_preview\emart\resources\views/frontend/flash_deal_list.blade.php ENDPATH**/ ?>