<div class="col-lg-4 col-md-6 col-6">
    <div class="featured-product-block">
        <div class="featured-product-img">
            <a href="<?php echo e(route('show.product',['id' => $simple_pro->id, 'slug' => $simple_pro->slug])); ?>" title="">
                <?php if($simple_pro->thumbnail != '' && file_exists(public_path().'/images/simple_products/'.$simple_pro->thumbnail)): ?>
                            
                    <img class="img-fluid" src="<?php echo e(url('images/simple_products/'.$simple_pro->thumbnail)); ?>" alt="<?php echo e($simple_pro->product_name); ?>">

                <?php else: ?>

                    <img class="img-fluid" title="<?php echo e($simple_pro->product_name); ?>" src="<?php echo e(url('images/no-image.png')); ?>" alt="No Image" />

                <?php endif; ?>
            </a>
            <div class="overlay-bg"></div>
            <div class="featured-product-icon">
                <ul>
                    <li><a href="<?php echo e(route('show.product',['id' => $simple_pro->id, 'slug' => $simple_pro->slug])); ?>" title="eye"><i data-feather="eye"></i></a></li>
                    
                    <?php if(auth()->guard()->check()): ?>

                        <?php if($simple_pro->type != 'ex_product'): ?>
                            
                            <li class="lnk wishlist active">
                                <a class="text-dark add_in_wish_simple" data-proid="<?php echo e($simple_pro->id); ?>" data-status="<?php echo e(inwishlist($simple_pro->id)); ?>" data-toggle="tooltip" data-placement="right" title="<?php echo e(__('Wishlist')); ?>" href="javascript:void(0)">
                                    <i data-feather="heart"></i>
                                </a>
                            </li>

                        <?php endif; ?>

                    <?php endif; ?>
                    <li>
                        <form method="POST" action="<?php echo e($simple_pro->type == 'ex_product' ? $simple_pro->external_product_link : route('add.cart.simple',['pro_id' => $simple_pro->id, 'price' => $simple_pro->price, 'offerprice' => $simple_pro->offer_price])); ?>" class="addSimpleCardFrom<?php echo e($simple_pro->id); ?>">
                            <?php echo csrf_field(); ?>

                            <input name="qty" type="hidden" value="<?php echo e($simple_pro->min_order_qty); ?>" max="<?php echo e($simple_pro->max_order_qty); ?>" class="qty-section">

                            <a href="javascript:" onclick="addSimpleProCard(<?php echo e($simple_pro->id); ?>)" title="<?php echo e(__('Add To Card')); ?>"><i data-feather="briefcase"></i></a>

                        </form>
                    </li>
                </ul>
            </div>
            <?php if($simple_pro['sale_tag'] !== NULL && $simple_pro['sale_tag'] != ''): ?>
            <div class="featured-product-badge">
                <span class="badge" style="background : <?php echo e($simple_pro['sale_tag_color']); ?> ; color : <?php echo e($simple_pro['sale_tag_text_color']); ?>">
                            
                    <?php echo e($simple_pro['sale_tag']); ?>


                </span>
            </div>
            <?php endif; ?>
        </div>
        <div class="featured-product-dtl">
            <div class="row">
                <div class="col-xl-8 col-lg-7 col-md-7 col-7">
                    <h6 class="featured-product-title truncate">
                        <a href="<?php echo e(route('show.product',['id' => $simple_pro->id, 'slug' => $simple_pro->slug])); ?>">
                            <?php echo e($simple_pro->product_name); ?>

                        </a> 
                    </h6>
                    <p><?php echo e(__('By')); ?> 
                        <a href="<?php echo e(route('store.view',['uuid' => $simple_pro->store->uuid ?? 0, 'title' => $simple_pro->store->name])); ?>"><?php echo e($simple_pro->store->name); ?> 
                            <?php if($simple_pro->store->verified_store): ?> 
                            <div class="verified-icon">
                                <i data-feather="check-circle"></i>
                            </div>
                            <?php endif; ?>
                        </a>
                    </p>
                </div>
                <div class="col-xl-4 col-lg-5 col-md-5 col-5">
                    <div class="featured-product-price">
                        <?php if($price_login == 0 || auth()->check()): ?>
                            <?php if($simple_pro->offer_price != 0): ?>

                                <span>
                                    <i class="<?php echo e(session()->get('currency')['value']); ?>"></i>
                                    <?php echo e(price_format($simple_pro->offer_price * $conversion_rate)); ?>

                                </span>
                                <s>
                                    <i class="<?php echo e(session()->get('currency')['value']); ?>"></i>
                                    <?php echo e(price_format($simple_pro->price * $conversion_rate)); ?>

                                </s>

                            <?php else: ?>

                                <span>
                                    <i class="<?php echo e(session()->get('currency')['value']); ?>"></i>
                                    <?php echo e(price_format($simple_pro->price * $conversion_rate)); ?>

                                </span>

                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\laragon\www\emart_live_preview\emart\resources\views/frontend/product_filter/simple_product.blade.php ENDPATH**/ ?>