
<?php $__env->startSection('title','Emart | Blogs'); ?>
<?php $__env->startSection("content"); ?>   

<!-- Home Start -->
<section id="home" class="home-main-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <nav aria-label="breadcrumb" class="breadcrumb-main-block">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" title="<?php echo e(__('Home')); ?>"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item"><a href="<?php echo e(url('blog')); ?>" title="<?php echo e(__('Blog')); ?>"><?php echo e(__('Blog')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e($value->heading); ?></li>
                    </ol>
                </nav>
                <div class="about-breadcrumb-block wishlist-breadcrumb" style="background-image: url('<?= URL::to('/'); ?>/frontend/assets/images/wishlist/breadcrum.png');">
                  <div class="breadcrumb-nav">
                      <h3 class="breadcrumb-title"><?php echo e($value->heading); ?></h3>
                  </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Home End -->

    <!-- Blog Detail Start -->
    <section id="blog-detail" class="blog-detail-main-block">
      <div class="container">
        <div class="row">
          <div class="col-lg-8 col-md-7">
            <div class="blog-detail-block">
              <div class="blog-dtl-img">
                <?php if($value->image != '' && file_exists(public_path().'/images/blog/'.$value->image)): ?>
                  <img src="<?php echo e(url('images/blog/'.$value->image)); ?>" title="<?php echo e($value->heading); ?>" class="img-fluid" alt="<?php echo e(__($value->heading)); ?>">
                <?php else: ?>
                  <img class="img-fluid" title="<?php echo e($value->heading); ?>" src="<?php echo e(url('images/no-image.png')); ?>" alt="No Image" />
                <?php endif; ?>
                <div class="blog-badge mt-2">
                  <span class="badge text-bg-primary"><?php echo e(date('d/m/Y | h:i A',strtotime($value->created_at))); ?></span>
                </div>
                <div class="blog-badge blog-comment-badge mt-2 mb-2">
                  <span class="badge text-bg-warning"><?php echo e($value->comments->count()); ?> <?php echo e(__('Comments')); ?></span>
                </div>
              </div>
              <div class="blog-detail-dtl">
                <h2 class="blog-title"><?php echo e($value->heading); ?></h2>
                <div class="blog-dtl-cat"><?php echo e(__('By')); ?> <?php echo e($value->user); ?></div>
                <p><?php echo $value->des; ?></p>
                <div class="row mb-20">
                  <div class="col-lg-6 col-md-6">
                    <img src="frontend/assets/images/blog/blog_06.png" class="img-fluid" alt="">
                  </div>
                  <div class="col-lg-6 col-md-6">
                    <img src="frontend/assets/images/blog/blog_07.png" class="img-fluid" alt="">
                  </div>
                </div>
              </div>
              <div class="blog-dtl-tag">
                <h3 class="section-title">Share</h3>
                <ul>
                  <?php
                    echo Share::currentPage(null,[],'<div class="row">', '</div>')
                    ->facebook()
                    ->twitter()
                    ->telegram()
                    ->whatsapp();
                  ?>
                </ul>
              </div>
              <div class="blog-dtl-btn d-none">
                <div class="row">
                  <div class="col-lg-6 col-md-6">
                    <div class="previous-btn">
                      <a href="#" title="Previous Post" type="button" class="btn btn-info"><i data-feather="arrow-left"></i>Previous Post</a>
                    </div>
                  </div>
                  <div class="col-lg-6 col-md-6">
                    <div class="next-btn">
                      <a href="#" title="Next Post" type="button" class="btn btn-info">Next Post<i data-feather="arrow-right"></i></a>
                    </div>
                  </div>
                </div>
              </div>
              <div class="reviews-block mt-4">
                <h3 class="section-title">(<?php echo e($value->comments->count()); ?>) <?php echo e(__('Comment')); ?></h3>
                <form class="register-form" role="form" action="<?php echo e(route('blog.comment.store',$value->id)); ?>" method="POST">
                           <?php echo csrf_field(); ?>
                  <div class="row">
                    <div class="col-lg-6">
                      <div class="form-group">
                        <input type="text" class="form-control" name="name" placeholder="<?php echo e(__('Write Name')); ?>">
                      </div>
                    </div>
                    <div class="col-lg-6">
                      <div class="form-group">
                        <input type="email" class="form-control" name="email" placeholder="<?php echo e(__('Write Email')); ?>">
                      </div>
                    </div>
                    <div class="col=lg-12">
                      <div class="mb-3">
                        <div class="form-group">
                          <textarea class="form-control" id="exampleFormControlTextarea1" name="comment" placeholder="<?php echo e(__('Write Reviews')); ?>" rows="3"></textarea>
                          <button type="submit" title="<?php echo e(__('Send')); ?>" class="btn btn-info"><i data-feather="send"></i></button>
                        </div>
                      </div>
                    </div>
                  </div>
                </form>
                <?php if(count($value->comments)>0): ?>
                  <?php $__currentLoopData = $value->comments->sortByDesc('id')->where('status','1')->take(5); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <div class="customer-reviews-block">
                    <div class="row">
                      <div class="col-lg-2 col-md-3">
                        <div class="customer-reviews-img">
                          <img title="<?php echo e($comment->name); ?>" src="<?php echo e(Avatar::create($comment->name)->toBase64()); ?>" class="img-fluid" alt="">
                        </div>
                      </div>
                      <div class="col-lg-10 col-md-9">
                        <div class="customer-review-dtl">
                          <div class="row mb-3">
                            <div class="col-lg-6 col-md-6 col-6">
                              <h5 class="customer-title"><?php echo e($comment->name); ?></h5>
                            </div>
                            <div class="col-lg-6 col-md-6 col-6">
                              <div class="stars stars-example-css">
                                <i data-feather="star" style="color:#FDBC00; fill: #FDBC00;"></i>
                                <i data-feather="star" style="color:#FDBC00; fill: #FDBC00;"></i>
                                <i data-feather="star" style="color:#FDBC00; fill: #FDBC00;"></i>
                                <i data-feather="star" style="color:#FDBC00; fill: #FDBC00;"></i>
                                <i data-feather="star" style="color:#FDBC00; fill: #FDBC00;"></i>
                              </div>
                            </div>
                          </div>
                          <p><?php echo $comment->comment; ?></p>
                          <p class="pull-right"><?php echo e(\Carbon\Carbon::parse($comment->created_at)->diffForHumans()); ?></p>
                        </div>
                      </div>
                    </div>
                  </div>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                <?php else: ?> 
                  <div class="text-center">
                    <h6><?php echo e(__('No Comments')); ?></h6>
                  </div>
                <?php endif; ?>
              </div>
            </div>
          </div>
          <div class="col-lg-4 col-md-5">
            <div class="order-block">
              <form action="" method="Get" class="search-form">
                <div class="input-group">                        
                  <div class="form-group">
                    <div class="input-group mb-3">
                      <input type="text" class="form-control" id="search" name="search" placeholder="<?php echo e(__('Search')); ?>" aria-label="<?php echo e(__('Search')); ?>" value="<?php echo e(request()->get('search')); ?>" aria-describedby="button-addon2">
                      <button class="btn btn-outline-primary" type="submit" id="button-addon2"><i data-feather="search"></i></button>
                    </div>
                  </div>
                </div>
              </form>
            </div>
            <div class="new-post-blog">
              <h3 class="section-title"><?php echo e(__('Recent Posts')); ?></h3>
              
              <?php if(count($blogs)>0): ?>
                <?php $__currentLoopData = $blogs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $post): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="blog-block">
                  <div class="blog-img">
                    <a href="<?php echo e(route('front.blog.show',$post->slug)); ?>" title="<?php echo e($post->heading); ?>">
                      <?php if($post->image != '' && file_exists(public_path().'/images/blog/'.$post->image)): ?>
                        <img src="<?php echo e(url('images/blog/'.$post->image)); ?>" title="<?php echo e($post->heading); ?>" class="img-fluid" alt="<?php echo e($post->heading); ?>">
                      <?php else: ?>
                        <img class="img-fluid" title="<?php echo e($post->heading); ?>" src="<?php echo e(url('images/no-image.png')); ?>" alt="No Image" />
                      <?php endif; ?>
                    </a>
                  </div>
                  <div class="blog-post">
                    <div class="row">
                      <div class="col-lg-8 col-8">
                        <div class="blog-date">
                          <ul>
                            <li><a href="<?php echo e(route('front.blog.show',$post->slug)); ?>" title="<?php echo e(__('Date')); ?>"><?php echo e(date('d/m/Y', strtotime($post->created_at))); ?></a></li>
                            <li><span><a href="<?php echo e(route('front.blog.show',$post->slug)); ?>" title="<?php echo e(__('User')); ?>"><?php echo e(__('By')); ?> <?php echo e($value->user); ?></a></span></li>
                          </ul>
                        </div>
                      </div>
                      <div class="col-lg-4 col-4">
                        <p><a href="<?php echo e(route('front.blog.show',$post->slug)); ?>" title="<?php echo e(\Carbon\Carbon::parse($post->created_at)->diffForHumans()); ?>"><?php echo e(\Carbon\Carbon::parse($post->created_at)->diffForHumans()); ?></a></p>
                      </div>
                    </div>
                  </div>
                  <div class="blog-dtl">
                    <h4 class="blog-title"><a href="<?php echo e(route('front.blog.show',$post->slug)); ?>" title="<?php echo e(__('Card Heading')); ?>"><?php echo e(__($post->heading)); ?></a></h4>
                  </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              <?php else: ?>
              <div class="blog-block">
                <h6 class="blog-title"><?php echo e(__('No Blog')); ?></h6>
              </div>
              <?php endif; ?>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Blog Detail End -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make("frontend.layout.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\xampp\htdocs\khushbu\resources\views/frontend/blog/detail.blade.php ENDPATH**/ ?>