
<?php $__env->startSection('title','Emart | Checkout'); ?>
<?php $__env->startSection("content"); ?>   
<link href="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/css/select2.min.css" rel="stylesheet" />
<!-- Home Start -->
<section id="home" class="home-main-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <nav aria-label="breadcrumb" class="breadcrumb-main-block">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="#" title="Home"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Checkout')); ?></li>
                    </ol>
                </nav>
                <div class="about-breadcrumb-block wishlist-breadcrumb" style="background-image: url('frontend/assets/images/checkout/breadcrumb.png');">
                    <div class="breadcrumb-nav">
                        <h3 class="breadcrumb-title"><?php echo e(__('Checkout')); ?></h3>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Home End -->

    <!-- Checkout Start -->
    <section id="checkout" class="checkout-main-block">
      <div class="container">
        <div class="row">
          <div class="col-lg-8 col-md-7">
            <div class="accordion" id="accordionExample">

              <div class="checkout-login checkout-block accordion-item">
                <div class="accordion-header">
                  <h3 class="section-title accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseOne" aria-expanded="true" aria-controls="collapseOne">A. <?php if(auth()->guard()->guest()): ?> <span>1</span> <?php echo e(__('Login')); ?> <?php else: ?> <?php echo e(__('Logged In')); ?> <?php endif; ?></h3>
                  <div id="collapseOne" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                    <div class="accordion-body">
                      <div class="social-login-block">
                      <?php if(auth()->guard()->check()): ?>
        							  <p>
                          <div class="verified-icon">
                            <i data-feather="check-circle"></i>
                            <b><?php echo e(Auth::user()->name); ?></b>
                          </div>
                          
                        </p>
                        <p>
                          <div class="verified-icon">
                            <i data-feather="check-circle"></i>
                            <?php echo e(Auth::user()->email); ?>

                          </div>
                            
                        </p>
              	    	<?php endif; ?>
                      </div>
                    </div>
                  </div>
                </div>
              </div>

              <div class="checkout-block accordion-item">
                <div class="checkout-address accordion-header">
                  <h3 class="section-title accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseThree" aria-expanded="true" aria-controls="collapseThree">
                    <div class="row">
                      <div class="col-lg-12">
                        B. <?php echo e(__('Shipping Address')); ?>

                      </div>
                    </div>
                  </h3>
                  <div id="collapseThree" class="accordion-collapse collapse show" data-bs-parent="#accordionExample">
                    <div class="accordion-body">
                      <div class="py-30">
                        <div class="row">
                          <div class="col-lg-12">
                            <div class="view-all-btn">
                              <a class="btn btn-primary btn-sm" data-bs-toggle="modal" href="#exampleModalToggle" role="button"><i data-feather="plus"></i><?php echo e(__('Add New Address')); ?></a>
                            </div>
                          </div>
                        </div>
                        <form action="<?php echo e(route('choose.address')); ?>" method="post">
                          <?php echo csrf_field(); ?>
                          <input type="hidden" name="total" value="<?php echo e($total); ?>">

                          <?php if(count($addresses)): ?>
                            <?php $__currentLoopData = $addresses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $address): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <label class="address-checkbox mb-30">
                              <?php if($address->defaddress == 1): ?>
                              <span>(Default)</span>
                              <?php endif; ?>
                              <div class="address-dtl">
                                <div class="row">
                                  <div class="col-lg-4 col-md-4">
                                    <h6 class="address-name"><?php echo e($address->name); ?></h6>
                                  </div>
                                  <div class="col-lg-8 col-md-8">
                                    <ul>
                                      <li><?php echo e($address->phone); ?></li>
                                      <li><?php echo e(strip_tags($address->address)); ?>, </li>
                                      <li><?php echo e($address->getcity ? $address->getcity->name : ''); ?>,<?php echo e($address->getstate->name); ?>,<?php echo e($address->getCountry->nicename); ?> <?php echo e($address->pin_code); ?></li>
                                    </ul>
                                  </div>
                                </div>
                              </div>
                              <?php if($address->defaddress == 1): ?>
                              <input type="checkbox" id="add<?php echo e($key); ?>" name="seladd" checked="checked" value="<?php echo e($address->id); ?>">
                              <span class="checkmark checkmark-one"></span>
                              <?php else: ?> 
                              <input type="checkbox" name="seladd" id="add<?php echo e($key); ?>" value="<?php echo e($address->id); ?>">
                              <span class="checkmark"></span>
                              <?php endif; ?>
                              
                            </label>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          <?php else: ?>
                            <h3><?php echo e(__('No Address')); ?></h3>
                          <?php endif; ?>
                          <input type="hidden" name="shipping" value="<?php echo e($shippingcharge); ?>">

                          <?php if(Auth::user()->addresses->count()>0): ?>
                          <button type="submit" class="btn btn-primary"><?php echo e(__('Deliver Here')); ?></button>
                          <?php endif; ?>
                        </form>

                        <div class="modal fade" id="exampleModalToggle" aria-hidden="true" aria-labelledby="exampleModalToggleLabel" tabindex="-1">
                          <div class="modal-dialog modal-dialog-centered">
                            <div class="modal-content">
                              <div class="modal-header">
                                <h5 class="modal-title" id="exampleModalToggleLabel">Add New Address</h5>
                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                              </div>
                              <?php
                                $ifadd = count(Auth::user()->addresses);
                              ?>
                              <form action="<?php echo e(route('address.store2')); ?>" role="form" method="POST">
                                <div class="modal-body">
                                  <div class="row">

                                    <div class="col-lg-6">
                                      <div class="form-group">
                                        <label><?php echo e(__('Name')); ?>: <span class="required">*</span></label>
                                        <input required="" type="text" placeholder="Enter name" name="name" <?php if($ifadd<1): ?> value="<?php echo e(Auth::user()->name); ?>" <?php else: ?> value="" <?php endif; ?> class="form-control">
                                      </div>
                                    </div>

                                    <div class="col-lg-6">
                                      <div class="form-group">
                                        <label><?php echo e(__('PhoneNo')); ?>: <span class="required">*</span></label>
                                        <input pattern="[0-9]+" required="" type="text" name="phone" <?php if($ifadd<1): ?> value="<?php echo e(Auth::user()->mobile); ?>" <?php else: ?> value="" <?php endif; ?> placeholder="Enter phone no" class="form-control">
                                      </div>
                                    </div>

                                    <div class="col-lg-6 mt-4">
                                      <div class="form-group">
                                        <label><?php echo e(__('Email')); ?>: <span class="required">*</span></label>
                                        <input required="" <?php if($ifadd<1): ?> value="<?php echo e(Auth::user()->email); ?>" <?php else: ?> value="" <?php endif; ?> type="email" name="email" placeholder="Enter email" class="form-control">
                                      </div>
                                    </div>

                                    <div class="col-lg-6 mt-4">
                                      <label><?php echo e(__('Address')); ?>: <span class="required">*</span></label>
                                      <textarea required="" name="address" id="address" cols="20" rows="1" class="form-control"></textarea>
                                    </div>

                                    <?php if($pincodesystem == 1): ?>
                                    <div class="col-lg-6 mt-4">
                                      <label><?php echo e(__('Pincode')); ?>: <span class="required">*</span></label>
                                      <input pattern="[0-9]+" required="" placeholder="<?php echo e(__('Enter pin code')); ?>" type="text" id="pincode" class="form-control z-index99" name="pin_code">
                                    </div>
                                    <?php endif; ?>
                                    
                                    <div class="col-lg-6 mt-4">
                                      <label for="select_city" class="form-label">City: <span class="required">*</span></label>
                                      <select id="select_location" class="form-select select2" name="city_id" onchange="selectCity(this.value)">
                                          <option value=""><?php echo e(__('Select City')); ?></option>                
                                          <?php $__currentLoopData = App\Allcity::get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $city): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                          <option value="<?php echo e($city->id); ?>"><?php echo e($city->name); ?></option>
                                          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>                
                                      </select>
                                    </div>
                                    <div class="col-lg-6 mt-4">
                                      <label for="select_state" class="form-label"><?php echo e(__('State')); ?>: <span class="required">*</span></label>
                                      <select id="select_state" name="state_id" class="form-select" aria-label="Default select example"></select>
                                    </div>
                                    <div class="col-lg-6 mt-4">
                                      <label for="select_country" class="form-label"><?php echo e(__('Country')); ?>: <span class="required">*</span></label>
                                      <select id="select_country" class="form-select" aria-label="Default select example" name="country_id"></select>
                                    </div>

                                  </div>
                                </div>
                                <div class="modal-footer">
                                  <button class="btn btn-primary" type="submit"><?php echo e(__('Submit')); ?></button>
                                </div>
                              </form>

                            </div>
                          </div>
                        </div>
                        
                      </div>
                    </div>
                  </div>
                </div>
              </div>  

              <div class="checkout-block accordion-item">
                <div class="checkout-shipping-method accordion-header">
                  <h3 class="section-title accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFour" aria-expanded="true" aria-controls="collapseFour"><?php echo e(__('C.')); ?> <?php echo e(__('Billing Information')); ?></h3>
                </div>
              </div>

              <div class="checkout-block accordion-item">
                <div class="checkout-shipping-method accordion-header">
                  <h3 class="section-title accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseFive" aria-expanded="true" aria-controls="collapseFive"><?php echo e(__('D. Order Review')); ?></h3>
                </div>
              </div>

              <div class="checkout-block accordion-item">
                <div class="checkout-shipping-method accordion-header">
                  <h3 class="section-title accordion-button" type="button" data-bs-toggle="collapse" data-bs-target="#collapseSix" aria-expanded="true" aria-controls="collapseSix"><?php echo e(__('E. Payment Info')); ?></h3>
                </div>
              </div>
              
            </div>
          </div>
          <div class="col-lg-4 col-md-5">
            <div class="cart-block">
              <h4 class="section-title"><?php echo e(__('Payment Details')); ?></h4>
              <table class="table">
                <tbody>
                  <tr>
                    <td style="width: 70%;"><?php echo e(__('Subtotal')); ?></td>
                    <td><i class="<?php echo e(session()->get('currency')['value']); ?>"></i> <?php echo e(price_format($total*$conversion_rate,2)); ?></td>
                  </tr>
                  <?php if(Session::get('gift')): ?>
                  <tr>
                    <td style="width: 70%;"><?php echo e(__('Gift Discount')); ?></td>
                    <td class="wishlist-out-stock"><i class="<?php echo e(session()->get('currency')['value']); ?>"></i> <?php echo e(Session::get('gift')['discount']); ?></td>
                  </tr>
                  <?php endif; ?>
                  <?php if(Auth::check() && App\Cart::isCoupanApplied() == 1): ?>
                  <tr>
                    <td style="width: 70%;"><?php echo e(__('Discount')); ?></td>
                    <td class="wishlist-out-stock"><i class="<?php echo e(session()->get('currency')['value']); ?>"></i> <?php echo e(price_format(App\Cart::getDiscount()*$conversion_rate,2)); ?></td>
                  </tr>
                  <?php endif; ?>
                </tbody>
              </table>
              <table class="table total-amount-table">
                <tbody>
                  <tr>
                    <td style="width: 70%;"><?php echo e(__('Total')); ?></td>
                    <td>
                    <i class="<?php echo e(session()->get('currency')['value']); ?>"></i>
                    <?php if(!App\Cart::isCoupanApplied() == 1): ?>
                      <?php if(Session::get('gift')): ?>
                        <?php echo e(price_format($grandtotal*$conversion_rate,2) - Session::get('gift')['discount']); ?>

                      <?php else: ?>
                        <?php echo e(price_format($grandtotal*$conversion_rate,2)); ?>

                      <?php endif; ?>
                    <?php else: ?>
                      <?php if(Session::get('gift')): ?>
                        <?php echo e(price_format(($grandtotal-App\Cart::getDiscount())*$conversion_rate,2) - Session::get('gift')['discount']); ?>

                      <?php else: ?>
                        <?php echo e(price_format(($grandtotal-App\Cart::getDiscount())*$conversion_rate,2)); ?>

                      <?php endif; ?>
                    <?php endif; ?>
                    </td>
                  </tr>
                </tbody>
              </table>
            </div>
          </div>
        </div>
      </div>
    </section>
    <!-- Checkout End -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
    <!-- jQuery -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.2.1/jquery.min.js"></script>
    <!-- Select2 -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/select2/4.0.6-rc.0/js/select2.min.js"></script>
    <script>
     $("#select_location").select2({
          placeholder: "Select a programming language",
          allowClear: true
      });
      $("#select_location").select2({
          minimumInputLength: 2
      });
    </script>
    <script>
      function selectCity(city_id) {
        var up = $('#select_state').empty();
        var up1 = $('#select_country').empty();
        var cat_id = city_id;

        if (cat_id) {
          $.ajax({
            headers: {
              'X-CSRF-TOKEN': $('meta[name="csrf-token"]').attr('content')
            },
            type: "GET",
            url: baseUrl + '/admin/select_state_country',
            data: {
              catId: cat_id
            },
            success: function (data) {
              console.log(data);
              // $('#country_id').append('<option value="">Please Choose</option>');
              // up.append('<option value="">Please Choose</option>');
              $.each(data.states, function (id, title) {
                up.append($('<option>', {
                  value: id,
                  text: title
                }));
              });

              $.each(data.country, function (id, title) {
                up1.append($('<option>', {
                  value: id,
                  text: title
                }));
              });
            },
            error: function (XMLHttpRequest, textStatus, errorThrown) {
              console.log(XMLHttpRequest);
            }
          });
        }
      }
    </script>
    <?php $__env->stopSection(); ?>
<?php echo $__env->make("frontend.layout.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\wetransfer_khushbu-zip_2023-10-03_0759\khushbu\resources\views/frontend/checkout.blade.php ENDPATH**/ ?>