<h5><?php echo e(__("Cashback Settings")); ?></h5>
<hr>
<form action="<?php echo e(route("cashback.save",$products->id)); ?>" method="POST">
    <?php echo csrf_field(); ?>
    <input type="hidden" name="product_type" value="variant_product">
    <div class="row">

        <div class="col-md-12">
            <div class="form-group">
                <label class="text-dark">
                    <?php echo e(__("Enable Cashback system :")); ?>

                </label>
                <br>
                <label class="switch">
                  <input id="enable" type="checkbox" name="enable"
                    <?php echo e(isset($cashback_settings) && $cashback_settings->enable =='1' ? "checked" : ""); ?>>
                  <span class="knob"></span>
                </label>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="text-dark" for="cashback_type"><?php echo e(__("Select cashback type:")); ?> <span class="text-danger">*</span> </label>
                <select data-placeholder="<?php echo e(__("Select cashback type")); ?>" name="cashback_type" class="form-control select2">
                    <option value=""><?php echo e(__("Select cashback type")); ?></option>
                    <option <?php echo e(isset($cashback_settings) && $cashback_settings->cashback_type == 'fix' ? "selected" : ""); ?> value="fix"><?php echo e(__("Fix")); ?></option>
                    <option <?php echo e(isset($cashback_settings) && $cashback_settings->cashback_type == 'per' ? "selected" : ""); ?> value="per"><?php echo e(__("Percent")); ?></option>
                </select>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="text-dark" for="discount_type"><?php echo e(__("Discount type:")); ?> <span class="text-danger">*</span> </label>
                <select data-placeholder="<?php echo e(__("Select discount type")); ?>" name="discount_type" class="form-control select2">
                    <option value=""><?php echo e(__("Select cashback type")); ?></option>
                    <option <?php echo e(isset($cashback_settings) && $cashback_settings->discount_type == 'flat' ? "selected" : ""); ?> value="flat"><?php echo e(__("Flat")); ?></option>
                    <option <?php echo e(isset($cashback_settings) && $cashback_settings->discount_type == 'upto' ? "selected" : ""); ?> value="upto"><?php echo e(__("Upto")); ?></option>
                </select>
            </div>
        </div>

        <div class="col-md-4">
            <div class="form-group">
                <label class="text-dark"for="discount"><?php echo e(__("Discount:")); ?> <span class="text-danger">*</span> </label>
                <input value="<?php echo e(isset($cashback_settings) ? $cashback_settings->discount : 0); ?>" step="0.001" type="number" min="0" class="form-control" required name="discount">
            </div>
        </div>

        <div class="col-md-12">
        <button type="reset" class="btn btn-danger mr-1"><i class="fa fa-ban"></i> <?php echo e(__("Reset")); ?></button>
        <button type="submit" class="btn btn-primary"><i class="fa fa-check-circle"></i> <?php echo e(__("Save")); ?></button>
        </div>

    </div>

</form><?php /**PATH C:\laragon\www\wetransfer_khushbu-zip_2023-10-03_0759\khushbu\resources\views/admin/product/tab/edit/cashback_settings.blade.php ENDPATH**/ ?>