
<?php $__env->startSection('title',__('Edit Brand | ')); ?>
<?php $__env->startSection('body'); ?>
<?php
  $data['heading'] = 'Edit Brand';
  $data['title0'] = 'Product Management';
  $data['title1'] = 'All Brand';
  $data['title2'] = 'Edit Brand';
?>
<?php echo $__env->make('admin.layouts.topbar',$data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="contentbar bardashboard-card">

<div class="contentbar">
  <div class="row">
    
    <div class="col-lg-12">
      <?php if($errors->any()): ?>
      <div class="alert alert-danger" role="alert">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <p><?php echo e($error); ?><button type="button" class="close" data-dismiss="alert" aria-label="Close">
            <span aria-hidden="true">&times;</span></button></p>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
      <?php endif; ?>
      <div class="card m-b-30">
        <div class="card-header">
          <div class="row">
            <div class="col-lg-10">
                <h5 class="card-title"> <?php echo e(__("Edit Brand")); ?></h5>
            </div>
            <div class="col-md-2">
              <div class="widgetbar">
                <a href="<?php echo e(url('admin/brand')); ?>" class="btn btn-primary-rgba"><i class="feather icon-arrow-left mr-2"></i><?php echo e(__("Back")); ?></a>
              </div>
            </div>
          </div>
        </div>
        <div class="card-body ml-2">
          <form id="demo-form2" method="post" enctype="multipart/form-data" action="<?php echo e(url('admin/brand/'.$brand->id)); ?>"
            data-parsley-validate class="form-horizontal form-label-left">
            <?php echo e(csrf_field()); ?>

            <?php echo e(method_field('PUT')); ?>

            
            <div class="row">
              <div class="form-group col-lg-6">
                <label class="control-label text-dark" for="first-name">
                  <?php echo e(__("Brand Name")); ?>: <span class="required">*</span>
                </label>

                <input placeholder="<?php echo e(__("Please enter brand name")); ?>" type="text" id="first-name" name="name"
                  value=" <?php echo e($brand->name); ?> " class="form-control col-md-12">


              </div>
              
              <div class="form-group col-lg-6">
                <label class="control-label text-dark" for="first-name">
                  <?php echo e(__("Select Category")); ?>: <span class="required">*</span>
                </label>



                <select multiple="multiple" class="form-control select2" name="category_id[]">
                  <?php $__currentLoopData = App\Category::where('status','1')->get();; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>

                    <?php if(isset($brand->category_id) && in_array( $item->id, $brand->category_id)): ?>
                    <option value="<?php echo e($item->id); ?>" selected><?php echo e($item->title); ?></option>
                    <?php else: ?>
                    <option value="<?php echo e($item->id); ?>"><?php echo e($item->title); ?></option>
                    <?php endif; ?>

                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>


              </div>

              <div class="form-group col-lg-6">
                <label class="control-label text-dark" for="first-name">
                  <?php echo e(__("Brand Logo")); ?> <span class="required">*</span>
                </label>
                <!-- <div class="input-group">
                  <input required readonly id="image" name="image" type="text" class="form-control">
                  <div class="input-group-append">
                      <span data-input="image" class="bg-primary text-light midia-toggle input-group-text"><?php echo e(__("Browse")); ?></span>
                  </div>
                </div>
                <small class="txt-desc">(<?php echo e(__("Please Choose Brand Logo")); ?>)</small> -->
                <div class="input-group">
                  <div class="custom-file">
                    <input type="file" id="img_upload_input" name="image" class="custom-file-input" id="inputGroupFile01" aria-describedby="inputGroupFileAddon01" onchange="readURL(this);" />
                    <label class="custom-file-label" for="inputGroupFile01"><?php echo e(__("Choose Profile")); ?> </label>
                  </div>
                </div> 
              </div>

              <div class="col-lg-6">
                <div class="mb-3">
                  <?php if($image = @file_get_contents('images/brands/'.$brand->image)): ?>
                    <img src=" <?php echo e(url('images/brands/'.$brand->image)); ?> " id="image-pre" width="100px" class="rounded p-3 bg-primary-rgba img-fluid">
                  <?php else: ?>
                    <img width="100px" src="<?php echo e(Avatar::create($brand->name)->toBase64()); ?>" id="image-pre" class="rounded p-3 bg-primary-rgba img-fluid">
                  <?php endif; ?>
                </div>
              </div>

              <div class="form-group col-lg-6">
                <label class="control-label text-dark" for="first-name">
                  Show Image Footer <span class="required">*</span>
                </label>
                <br>
                <label class="switch">
                  <input class="slider tgl tgl-skewed" type="checkbox"
                    <?php echo ($brand->show_image=='1')?'checked':'' ?> name="show_image">
                  <span class="knob"></span>
                </label>
                <br>
                <small class="text-info"> <i class="text-dark feather icon-help-circle"></i>(<?php echo e(__("If You Choose Active Then Image Show In Footer Brand Logo")); ?>)</small>
              </div>

              <div class="form-group col-lg-6">
                <label class="control-label text-dark" for="first-name">
                  <?php echo e(__("Status")); ?>

                </label>
                <br>
                <label class="switch">
                  <input class="slider tgl tgl-skewed" type="checkbox" <?php echo ($brand->status=='1')?'checked':'' ?>
                    name="status">
                  <span class="knob"></span>
                </label>
                <br>
                <small class="text-info"> <i class="text-dark feather icon-help-circle"></i>(<?php echo e(__("Choose status for your brand")); ?>)</small>

              </div>
            </div>

            <div class="box-footer">
              <div class="form-group col-lg-6">
                <button <?php if(env('DEMO_LOCK')==0): ?> type="reset" <?php else: ?> disabled
                  title="<?php echo e(__('This operation is disabled is demo !')); ?>" <?php endif; ?> class="btn btn-danger"><i class="fa fa-ban"></i>
                  <?php echo e(__("Reset")); ?></button>
                <button <?php if(env('DEMO_LOCK')==0): ?> type="submit" <?php else: ?> disabled
                  title="<?php echo e(__('This operation is disabled is demo !')); ?>" <?php endif; ?> class="btn btn-primary"><i
                    class="fa fa-check-circle"></i>
                  <?php echo e(__("Update")); ?></button>
              </div>
              <div class="clear-both"></div>
          </form>
        </div>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-script'); ?>
  <script>
      $(".midia-toggle").midia({
          base_url: '<?php echo e(url('')); ?>',
          directory_name: 'brand',
          dropzone : {
            acceptedFiles: '.jpg,.png,.jpeg,.webp,.bmp,.gif'
          }
      });
  </script>
  <script>
    function readURL(input) {

      if (input.files && input.files[0]) {
        var reader = new FileReader();

        reader.onload = function (e) {
          $('.thumbnail-img-block').show();
          $('#image-pre').attr('src', e.target.result);
        }
        
        reader.readAsDataURL(input.files[0]);
      }
    }
  </script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master-soyuz', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\wetransfer_khushbu-zip_2023-10-03_0759\khushbu\resources\views/admin/brand/edit.blade.php ENDPATH**/ ?>