
<?php $__env->startSection('title',"Emart | Featured Products"); ?>
<?php $__env->startSection('content'); ?>


<!-- Home Start -->
<section id="home" class="home-main-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <nav aria-label="breadcrumb" class="breadcrumb-main-block">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" title="Home"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('Featured Product')); ?></li>
                    </ol>
                </nav>
                <div class="about-breadcrumb-block wishlist-breadcrumb" style="background-image: url('<?= URL::to('/') ?>/frontend/assets/images/wishlist/breadcrum.png');">
                  <div class="breadcrumb-nav">
                      <h3 class="breadcrumb-title"><?php echo e(__('Featured Product')); ?></h3>
                  </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Home End -->
<!-- Home End --> 
<section id="product" class="product-main-block">
    <div class="container">
        <div class="row">
            <?php $__currentLoopData = $products; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $featured_pro): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="col-lg-4 col-md-4 col-6">
                    <div class="featured-product-block">
                        <div class="featured-product-img">
                            <a href="javascript:" title="">
                                <?php if($featured_pro->thumbnail != '' && file_exists(public_path().'/images/simple_products/'.$featured_pro->thumbnail)): ?>
                                <img src="<?php echo e(url('images/simple_products/'.$featured_pro->thumbnail)); ?>" class="img-fluid" alt="<?php echo e(__($featured_pro->product_name)); ?>">
                                <?php else: ?>
                                <img class="img-fluid" title="<?php echo e($featured_pro->product_name); ?>" src="<?php echo e(url('images/no-image.png')); ?>" alt="No Image" />
                                <?php endif; ?>
                            </a>
                            <div class="overlay-bg"></div>
                            <div class="featured-product-icon">
                                <ul>
                                    <li><a href="<?php echo e(route('show.product',['id' => $featured_pro->id, 'slug' => $featured_pro->slug])); ?>" title="eye"><i data-feather="eye"></i></a></li>
                                    <?php if(auth()->guard()->check()): ?>

                                        <?php if($featured_pro->type != 'ex_product'): ?>
                                            
                                            <li>
                                                <a class="add_in_wish_simple" data-proid="<?php echo e($featured_pro->id); ?>" data-status="<?php echo e(inwishlist($featured_pro->id)); ?>" data-toggle="tooltip" data-placement="right" title="<?php echo e(__('Wishlist')); ?>" href="javascript:void(0)">
                                                    <i data-feather="heart"></i>
                                                </a>
                                            </li>

                                        <?php endif; ?>

                                    <?php endif; ?>
                                    <li>
                                        <form method="POST" action="<?php echo e($featured_pro->type == 'ex_product' ? $featured_pro->external_product_link : route('add.cart.simple',['pro_id' => $featured_pro->id, 'price' => $featured_pro->price, 'offerprice' => $featured_pro->offer_price])); ?>" class="addSimpleCardFrom<?php echo e($featured_pro->id); ?>">
                                            <?php echo csrf_field(); ?>

                                            <input name="qty" type="hidden" value="<?php echo e($featured_pro->min_order_qty); ?>" max="<?php echo e($featured_pro->max_order_qty); ?>" class="qty-section">

                                            <a href="javascript:" onclick="addSimpleProCard(<?php echo e($featured_pro->id); ?>)" title="<?php echo e(__('Add To Card')); ?>"><i data-feather="briefcase"></i></a>

                                        </form>
                                    </li>
                                </ul>
                            </div>
                            <div class="featured-product-badge">
                                <?php if($featured_pro->offer_price != 0): ?>
                                    <?php
                                        $conversion_rate = 1;
                                        $getdisprice = ($featured_pro->price*$conversion_rate) - ($featured_pro->offer_price * $conversion_rate);
                                        $gotdis = $getdisprice/($featured_pro->price * $conversion_rate);
                                        $offamount = round($gotdis*100);

                                    ?>
                                    <span class="badge text-bg-warning"><?php echo e($offamount); ?>% <?php echo e(__("off")); ?></span>
                                <?php endif; ?>
                            </div>
                        </div>
                        <div class="featured-product-dtl">
                            <div class="row">
                                <div class="col-lg-7">
                                    <h6 class="featured-product-title truncate"><a href="<?php echo e(route('show.product',['id' => $featured_pro->id, 'slug' => $featured_pro->slug])); ?>" title="<?php echo e(__($featured_pro->product_name)); ?>"><?php echo e(__($featured_pro->product_name)); ?></a></h6>
                                    <p>By <span><?php echo e(__($featured_pro->store?$featured_pro->store->name:'')); ?></span></p>
                                </div>
                                <div class="col-lg-5">
                                    <div class="featured-product-price">
                                        <i class="<?php echo e(session()->get('currency')?session()->get('currency')['value']:''); ?>"></i>
                                        <?php echo e($featured_pro->offer_price != 0 && $featured_pro->offer_price != '' ? price_format($featured_pro->offer_price) :  price_format($featured_pro->price)); ?>

                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
    </div>
</section>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('frontend.layout.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\wetransfer_khushbu-zip_2023-10-03_0759\khushbu\resources\views/frontend/product_list.blade.php ENDPATH**/ ?>