
/******/ (() => { // webpackBootstrap
/******/ 	var __webpack_modules__ = ({

/***/ "./node_modules/axios/index.js":
/*!*************************************!*\
  !*** ./node_modules/axios/index.js ***!
  \*************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

module.exports = __webpack_require__(/*! ./lib/axios */ "./node_modules/axios/lib/axios.js");

/***/ }),

/***/ "./node_modules/axios/lib/adapters/xhr.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/adapters/xhr.js ***!
  \************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var settle = __webpack_require__(/*! ./../core/settle */ "./node_modules/axios/lib/core/settle.js");
var cookies = __webpack_require__(/*! ./../helpers/cookies */ "./node_modules/axios/lib/helpers/cookies.js");
var buildURL = __webpack_require__(/*! ./../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var buildFullPath = __webpack_require__(/*! ../core/buildFullPath */ "./node_modules/axios/lib/core/buildFullPath.js");
var parseHeaders = __webpack_require__(/*! ./../helpers/parseHeaders */ "./node_modules/axios/lib/helpers/parseHeaders.js");
var isURLSameOrigin = __webpack_require__(/*! ./../helpers/isURLSameOrigin */ "./node_modules/axios/lib/helpers/isURLSameOrigin.js");
var createError = __webpack_require__(/*! ../core/createError */ "./node_modules/axios/lib/core/createError.js");

module.exports = function xhrAdapter(config) {
  return new Promise(function dispatchXhrRequest(resolve, reject) {
    var requestData = config.data;
    var requestHeaders = config.headers;
    var responseType = config.responseType;

    if (utils.isFormData(requestData)) {
      delete requestHeaders['Content-Type']; // Let the browser set it
    }

    var request = new XMLHttpRequest();

    // HTTP basic authentication
    if (config.auth) {
      var username = config.auth.username || '';
      var password = config.auth.password ? unescape(encodeURIComponent(config.auth.password)) : '';
      requestHeaders.Authorization = 'Basic ' + btoa(username + ':' + password);
    }

    var fullPath = buildFullPath(config.baseURL, config.url);
    request.open(config.method.toUpperCase(), buildURL(fullPath, config.params, config.paramsSerializer), true);

    // Set the request timeout in MS
    request.timeout = config.timeout;

    function onloadend() {
      if (!request) {
        return;
      }
      // Prepare the response
      var responseHeaders = 'getAllResponseHeaders' in request ? parseHeaders(request.getAllResponseHeaders()) : null;
      var responseData = !responseType || responseType === 'text' ||  responseType === 'json' ?
        request.responseText : request.response;
      var response = {
        data: responseData,
        status: request.status,
        statusText: request.statusText,
        headers: responseHeaders,
        config: config,
        request: request
      };

      settle(resolve, reject, response);

      // Clean up request
      request = null;
    }

    if ('onloadend' in request) {
      // Use onloadend if available
      request.onloadend = onloadend;
    } else {
      // Listen for ready state to emulate onloadend
      request.onreadystatechange = function handleLoad() {
        if (!request || request.readyState !== 4) {
          return;
        }

        // The request errored out and we didn't get a response, this will be
        // handled by onerror instead
        // With one exception: request that using file: protocol, most browsers
        // will return status as 0 even though it's a successful request
        if (request.status === 0 && !(request.responseURL && request.responseURL.indexOf('file:') === 0)) {
          return;
        }
        // readystate handler is calling before onerror or ontimeout handlers,
        // so we should call onloadend on the next 'tick'
        setTimeout(onloadend);
      };
    }

    // Handle browser request cancellation (as opposed to a manual cancellation)
    request.onabort = function handleAbort() {
      if (!request) {
        return;
      }

      reject(createError('Request aborted', config, 'ECONNABORTED', request));

      // Clean up request
      request = null;
    };

    // Handle low level network errors
    request.onerror = function handleError() {
      // Real errors are hidden from us by the browser
      // onerror should only fire if it's a network error
      reject(createError('Network Error', config, null, request));

      // Clean up request
      request = null;
    };

    // Handle timeout
    request.ontimeout = function handleTimeout() {
      var timeoutErrorMessage = 'timeout of ' + config.timeout + 'ms exceeded';
      if (config.timeoutErrorMessage) {
        timeoutErrorMessage = config.timeoutErrorMessage;
      }
      reject(createError(
        timeoutErrorMessage,
        config,
        config.transitional && config.transitional.clarifyTimeoutError ? 'ETIMEDOUT' : 'ECONNABORTED',
        request));

      // Clean up request
      request = null;
    };

    // Add xsrf header
    // This is only done if running in a standard browser environment.
    // Specifically not if we're in a web worker, or react-native.
    if (utils.isStandardBrowserEnv()) {
      // Add xsrf header
      var xsrfValue = (config.withCredentials || isURLSameOrigin(fullPath)) && config.xsrfCookieName ?
        cookies.read(config.xsrfCookieName) :
        undefined;

      if (xsrfValue) {
        requestHeaders[config.xsrfHeaderName] = xsrfValue;
      }
    }

    // Add headers to the request
    if ('setRequestHeader' in request) {
      utils.forEach(requestHeaders, function setRequestHeader(val, key) {
        if (typeof requestData === 'undefined' && key.toLowerCase() === 'content-type') {
          // Remove Content-Type if data is undefined
          delete requestHeaders[key];
        } else {
          // Otherwise add header to the request
          request.setRequestHeader(key, val);
        }
      });
    }

    // Add withCredentials to request if needed
    if (!utils.isUndefined(config.withCredentials)) {
      request.withCredentials = !!config.withCredentials;
    }

    // Add responseType to request if needed
    if (responseType && responseType !== 'json') {
      request.responseType = config.responseType;
    }

    // Handle progress if needed
    if (typeof config.onDownloadProgress === 'function') {
      request.addEventListener('progress', config.onDownloadProgress);
    }

    // Not all browsers support upload events
    if (typeof config.onUploadProgress === 'function' && request.upload) {
      request.upload.addEventListener('progress', config.onUploadProgress);
    }

    if (config.cancelToken) {
      // Handle cancellation
      config.cancelToken.promise.then(function onCanceled(cancel) {
        if (!request) {
          return;
        }

        request.abort();
        reject(cancel);
        // Clean up request
        request = null;
      });
    }

    if (!requestData) {
      requestData = null;
    }

    // Send the request
    request.send(requestData);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/axios.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/axios.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");
var Axios = __webpack_require__(/*! ./core/Axios */ "./node_modules/axios/lib/core/Axios.js");
var mergeConfig = __webpack_require__(/*! ./core/mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");
var defaults = __webpack_require__(/*! ./defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Create an instance of Axios
 *
 * @param {Object} defaultConfig The default config for the instance
 * @return {Axios} A new instance of Axios
 */
function createInstance(defaultConfig) {
  var context = new Axios(defaultConfig);
  var instance = bind(Axios.prototype.request, context);

  // Copy axios.prototype to instance
  utils.extend(instance, Axios.prototype, context);

  // Copy context to instance
  utils.extend(instance, context);

  return instance;
}

// Create the default instance to be exported
var axios = createInstance(defaults);

// Expose Axios class to allow class inheritance
axios.Axios = Axios;

// Factory for creating new instances
axios.create = function create(instanceConfig) {
  return createInstance(mergeConfig(axios.defaults, instanceConfig));
};

// Expose Cancel & CancelToken
axios.Cancel = __webpack_require__(/*! ./cancel/Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");
axios.CancelToken = __webpack_require__(/*! ./cancel/CancelToken */ "./node_modules/axios/lib/cancel/CancelToken.js");
axios.isCancel = __webpack_require__(/*! ./cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");

// Expose all/spread
axios.all = function all(promises) {
  return Promise.all(promises);
};
axios.spread = __webpack_require__(/*! ./helpers/spread */ "./node_modules/axios/lib/helpers/spread.js");

// Expose isAxiosError
axios.isAxiosError = __webpack_require__(/*! ./helpers/isAxiosError */ "./node_modules/axios/lib/helpers/isAxiosError.js");

module.exports = axios;

// Allow use of default import syntax in TypeScript
module.exports["default"] = axios;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/Cancel.js":
/*!*************************************************!*\
  !*** ./node_modules/axios/lib/cancel/Cancel.js ***!
  \*************************************************/
/***/ ((module) => {

"use strict";


/**
 * A `Cancel` is an object that is thrown when an operation is canceled.
 *
 * @class
 * @param {string=} message The message.
 */
function Cancel(message) {
  this.message = message;
}

Cancel.prototype.toString = function toString() {
  return 'Cancel' + (this.message ? ': ' + this.message : '');
};

Cancel.prototype.__CANCEL__ = true;

module.exports = Cancel;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/CancelToken.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/cancel/CancelToken.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var Cancel = __webpack_require__(/*! ./Cancel */ "./node_modules/axios/lib/cancel/Cancel.js");

/**
 * A `CancelToken` is an object that can be used to request cancellation of an operation.
 *
 * @class
 * @param {Function} executor The executor function.
 */
function CancelToken(executor) {
  if (typeof executor !== 'function') {
    throw new TypeError('executor must be a function.');
  }

  var resolvePromise;
  this.promise = new Promise(function promiseExecutor(resolve) {
    resolvePromise = resolve;
  });

  var token = this;
  executor(function cancel(message) {
    if (token.reason) {
      // Cancellation has already been requested
      return;
    }

    token.reason = new Cancel(message);
    resolvePromise(token.reason);
  });
}

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
CancelToken.prototype.throwIfRequested = function throwIfRequested() {
  if (this.reason) {
    throw this.reason;
  }
};

/**
 * Returns an object that contains a new `CancelToken` and a function that, when called,
 * cancels the `CancelToken`.
 */
CancelToken.source = function source() {
  var cancel;
  var token = new CancelToken(function executor(c) {
    cancel = c;
  });
  return {
    token: token,
    cancel: cancel
  };
};

module.exports = CancelToken;


/***/ }),

/***/ "./node_modules/axios/lib/cancel/isCancel.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/cancel/isCancel.js ***!
  \***************************************************/
/***/ ((module) => {

"use strict";


module.exports = function isCancel(value) {
  return !!(value && value.__CANCEL__);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/Axios.js":
/*!**********************************************!*\
  !*** ./node_modules/axios/lib/core/Axios.js ***!
  \**********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var buildURL = __webpack_require__(/*! ../helpers/buildURL */ "./node_modules/axios/lib/helpers/buildURL.js");
var InterceptorManager = __webpack_require__(/*! ./InterceptorManager */ "./node_modules/axios/lib/core/InterceptorManager.js");
var dispatchRequest = __webpack_require__(/*! ./dispatchRequest */ "./node_modules/axios/lib/core/dispatchRequest.js");
var mergeConfig = __webpack_require__(/*! ./mergeConfig */ "./node_modules/axios/lib/core/mergeConfig.js");
var validator = __webpack_require__(/*! ../helpers/validator */ "./node_modules/axios/lib/helpers/validator.js");

var validators = validator.validators;
/**
 * Create a new instance of Axios
 *
 * @param {Object} instanceConfig The default config for the instance
 */
function Axios(instanceConfig) {
  this.defaults = instanceConfig;
  this.interceptors = {
    request: new InterceptorManager(),
    response: new InterceptorManager()
  };
}

/**
 * Dispatch a request
 *
 * @param {Object} config The config specific for this request (merged with this.defaults)
 */
Axios.prototype.request = function request(config) {
  /*eslint no-param-reassign:0*/
  // Allow for axios('example/url'[, config]) a la fetch API
  if (typeof config === 'string') {
    config = arguments[1] || {};
    config.url = arguments[0];
  } else {
    config = config || {};
  }

  config = mergeConfig(this.defaults, config);

  // Set config.method
  if (config.method) {
    config.method = config.method.toLowerCase();
  } else if (this.defaults.method) {
    config.method = this.defaults.method.toLowerCase();
  } else {
    config.method = 'get';
  }

  var transitional = config.transitional;

  if (transitional !== undefined) {
    validator.assertOptions(transitional, {
      silentJSONParsing: validators.transitional(validators.boolean, '1.0.0'),
      forcedJSONParsing: validators.transitional(validators.boolean, '1.0.0'),
      clarifyTimeoutError: validators.transitional(validators.boolean, '1.0.0')
    }, false);
  }

  // filter out skipped interceptors
  var requestInterceptorChain = [];
  var synchronousRequestInterceptors = true;
  this.interceptors.request.forEach(function unshiftRequestInterceptors(interceptor) {
    if (typeof interceptor.runWhen === 'function' && interceptor.runWhen(config) === false) {
      return;
    }

    synchronousRequestInterceptors = synchronousRequestInterceptors && interceptor.synchronous;

    requestInterceptorChain.unshift(interceptor.fulfilled, interceptor.rejected);
  });

  var responseInterceptorChain = [];
  this.interceptors.response.forEach(function pushResponseInterceptors(interceptor) {
    responseInterceptorChain.push(interceptor.fulfilled, interceptor.rejected);
  });

  var promise;

  if (!synchronousRequestInterceptors) {
    var chain = [dispatchRequest, undefined];

    Array.prototype.unshift.apply(chain, requestInterceptorChain);
    chain = chain.concat(responseInterceptorChain);

    promise = Promise.resolve(config);
    while (chain.length) {
      promise = promise.then(chain.shift(), chain.shift());
    }

    return promise;
  }


  var newConfig = config;
  while (requestInterceptorChain.length) {
    var onFulfilled = requestInterceptorChain.shift();
    var onRejected = requestInterceptorChain.shift();
    try {
      newConfig = onFulfilled(newConfig);
    } catch (error) {
      onRejected(error);
      break;
    }
  }

  try {
    promise = dispatchRequest(newConfig);
  } catch (error) {
    return Promise.reject(error);
  }

  while (responseInterceptorChain.length) {
    promise = promise.then(responseInterceptorChain.shift(), responseInterceptorChain.shift());
  }

  return promise;
};

Axios.prototype.getUri = function getUri(config) {
  config = mergeConfig(this.defaults, config);
  return buildURL(config.url, config.params, config.paramsSerializer).replace(/^\?/, '');
};

// Provide aliases for supported request methods
utils.forEach(['delete', 'get', 'head', 'options'], function forEachMethodNoData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, config) {
    return this.request(mergeConfig(config || {}, {
      method: method,
      url: url,
      data: (config || {}).data
    }));
  };
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  /*eslint func-names:0*/
  Axios.prototype[method] = function(url, data, config) {
    return this.request(mergeConfig(config || {}, {
      method: method,
      url: url,
      data: data
    }));
  };
});

module.exports = Axios;


/***/ }),

/***/ "./node_modules/axios/lib/core/InterceptorManager.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/core/InterceptorManager.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function InterceptorManager() {
  this.handlers = [];
}

/**
 * Add a new interceptor to the stack
 *
 * @param {Function} fulfilled The function to handle `then` for a `Promise`
 * @param {Function} rejected The function to handle `reject` for a `Promise`
 *
 * @return {Number} An ID used to remove interceptor later
 */
InterceptorManager.prototype.use = function use(fulfilled, rejected, options) {
  this.handlers.push({
    fulfilled: fulfilled,
    rejected: rejected,
    synchronous: options ? options.synchronous : false,
    runWhen: options ? options.runWhen : null
  });
  return this.handlers.length - 1;
};

/**
 * Remove an interceptor from the stack
 *
 * @param {Number} id The ID that was returned by `use`
 */
InterceptorManager.prototype.eject = function eject(id) {
  if (this.handlers[id]) {
    this.handlers[id] = null;
  }
};

/**
 * Iterate over all the registered interceptors
 *
 * This method is particularly useful for skipping over any
 * interceptors that may have become `null` calling `eject`.
 *
 * @param {Function} fn The function to call for each interceptor
 */
InterceptorManager.prototype.forEach = function forEach(fn) {
  utils.forEach(this.handlers, function forEachHandler(h) {
    if (h !== null) {
      fn(h);
    }
  });
};

module.exports = InterceptorManager;


/***/ }),

/***/ "./node_modules/axios/lib/core/buildFullPath.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/buildFullPath.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var isAbsoluteURL = __webpack_require__(/*! ../helpers/isAbsoluteURL */ "./node_modules/axios/lib/helpers/isAbsoluteURL.js");
var combineURLs = __webpack_require__(/*! ../helpers/combineURLs */ "./node_modules/axios/lib/helpers/combineURLs.js");

/**
 * Creates a new URL by combining the baseURL with the requestedURL,
 * only when the requestedURL is not already an absolute URL.
 * If the requestURL is absolute, this function returns the requestedURL untouched.
 *
 * @param {string} baseURL The base URL
 * @param {string} requestedURL Absolute or relative URL to combine
 * @returns {string} The combined full path
 */
module.exports = function buildFullPath(baseURL, requestedURL) {
  if (baseURL && !isAbsoluteURL(requestedURL)) {
    return combineURLs(baseURL, requestedURL);
  }
  return requestedURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/createError.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/createError.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var enhanceError = __webpack_require__(/*! ./enhanceError */ "./node_modules/axios/lib/core/enhanceError.js");

/**
 * Create an Error with the specified message, config, error code, request and response.
 *
 * @param {string} message The error message.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The created error.
 */
module.exports = function createError(message, config, code, request, response) {
  var error = new Error(message);
  return enhanceError(error, config, code, request, response);
};


/***/ }),

/***/ "./node_modules/axios/lib/core/dispatchRequest.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/core/dispatchRequest.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var transformData = __webpack_require__(/*! ./transformData */ "./node_modules/axios/lib/core/transformData.js");
var isCancel = __webpack_require__(/*! ../cancel/isCancel */ "./node_modules/axios/lib/cancel/isCancel.js");
var defaults = __webpack_require__(/*! ../defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Throws a `Cancel` if cancellation has been requested.
 */
function throwIfCancellationRequested(config) {
  if (config.cancelToken) {
    config.cancelToken.throwIfRequested();
  }
}

/**
 * Dispatch a request to the server using the configured adapter.
 *
 * @param {object} config The config that is to be used for the request
 * @returns {Promise} The Promise to be fulfilled
 */
module.exports = function dispatchRequest(config) {
  throwIfCancellationRequested(config);

  // Ensure headers exist
  config.headers = config.headers || {};

  // Transform request data
  config.data = transformData.call(
    config,
    config.data,
    config.headers,
    config.transformRequest
  );

  // Flatten headers
  config.headers = utils.merge(
    config.headers.common || {},
    config.headers[config.method] || {},
    config.headers
  );

  utils.forEach(
    ['delete', 'get', 'head', 'post', 'put', 'patch', 'common'],
    function cleanHeaderConfig(method) {
      delete config.headers[method];
    }
  );

  var adapter = config.adapter || defaults.adapter;

  return adapter(config).then(function onAdapterResolution(response) {
    throwIfCancellationRequested(config);

    // Transform response data
    response.data = transformData.call(
      config,
      response.data,
      response.headers,
      config.transformResponse
    );

    return response;
  }, function onAdapterRejection(reason) {
    if (!isCancel(reason)) {
      throwIfCancellationRequested(config);

      // Transform response data
      if (reason && reason.response) {
        reason.response.data = transformData.call(
          config,
          reason.response.data,
          reason.response.headers,
          config.transformResponse
        );
      }
    }

    return Promise.reject(reason);
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/core/enhanceError.js":
/*!*****************************************************!*\
  !*** ./node_modules/axios/lib/core/enhanceError.js ***!
  \*****************************************************/
/***/ ((module) => {

"use strict";


/**
 * Update an Error with the specified config, error code, and response.
 *
 * @param {Error} error The error to update.
 * @param {Object} config The config.
 * @param {string} [code] The error code (for example, 'ECONNABORTED').
 * @param {Object} [request] The request.
 * @param {Object} [response] The response.
 * @returns {Error} The error.
 */
module.exports = function enhanceError(error, config, code, request, response) {
  error.config = config;
  if (code) {
    error.code = code;
  }

  error.request = request;
  error.response = response;
  error.isAxiosError = true;

  error.toJSON = function toJSON() {
    return {
      // Standard
      message: this.message,
      name: this.name,
      // Microsoft
      description: this.description,
      number: this.number,
      // Mozilla
      fileName: this.fileName,
      lineNumber: this.lineNumber,
      columnNumber: this.columnNumber,
      stack: this.stack,
      // Axios
      config: this.config,
      code: this.code
    };
  };
  return error;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/mergeConfig.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/core/mergeConfig.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

/**
 * Config-specific merge-function which creates a new config-object
 * by merging two configuration objects together.
 *
 * @param {Object} config1
 * @param {Object} config2
 * @returns {Object} New object resulting from merging config2 to config1
 */
module.exports = function mergeConfig(config1, config2) {
  // eslint-disable-next-line no-param-reassign
  config2 = config2 || {};
  var config = {};

  var valueFromConfig2Keys = ['url', 'method', 'data'];
  var mergeDeepPropertiesKeys = ['headers', 'auth', 'proxy', 'params'];
  var defaultToConfig2Keys = [
    'baseURL', 'transformRequest', 'transformResponse', 'paramsSerializer',
    'timeout', 'timeoutMessage', 'withCredentials', 'adapter', 'responseType', 'xsrfCookieName',
    'xsrfHeaderName', 'onUploadProgress', 'onDownloadProgress', 'decompress',
    'maxContentLength', 'maxBodyLength', 'maxRedirects', 'transport', 'httpAgent',
    'httpsAgent', 'cancelToken', 'socketPath', 'responseEncoding'
  ];
  var directMergeKeys = ['validateStatus'];

  function getMergedValue(target, source) {
    if (utils.isPlainObject(target) && utils.isPlainObject(source)) {
      return utils.merge(target, source);
    } else if (utils.isPlainObject(source)) {
      return utils.merge({}, source);
    } else if (utils.isArray(source)) {
      return source.slice();
    }
    return source;
  }

  function mergeDeepProperties(prop) {
    if (!utils.isUndefined(config2[prop])) {
      config[prop] = getMergedValue(config1[prop], config2[prop]);
    } else if (!utils.isUndefined(config1[prop])) {
      config[prop] = getMergedValue(undefined, config1[prop]);
    }
  }

  utils.forEach(valueFromConfig2Keys, function valueFromConfig2(prop) {
    if (!utils.isUndefined(config2[prop])) {
      config[prop] = getMergedValue(undefined, config2[prop]);
    }
  });

  utils.forEach(mergeDeepPropertiesKeys, mergeDeepProperties);

  utils.forEach(defaultToConfig2Keys, function defaultToConfig2(prop) {
    if (!utils.isUndefined(config2[prop])) {
      config[prop] = getMergedValue(undefined, config2[prop]);
    } else if (!utils.isUndefined(config1[prop])) {
      config[prop] = getMergedValue(undefined, config1[prop]);
    }
  });

  utils.forEach(directMergeKeys, function merge(prop) {
    if (prop in config2) {
      config[prop] = getMergedValue(config1[prop], config2[prop]);
    } else if (prop in config1) {
      config[prop] = getMergedValue(undefined, config1[prop]);
    }
  });

  var axiosKeys = valueFromConfig2Keys
    .concat(mergeDeepPropertiesKeys)
    .concat(defaultToConfig2Keys)
    .concat(directMergeKeys);

  var otherKeys = Object
    .keys(config1)
    .concat(Object.keys(config2))
    .filter(function filterAxiosKeys(key) {
      return axiosKeys.indexOf(key) === -1;
    });

  utils.forEach(otherKeys, mergeDeepProperties);

  return config;
};


/***/ }),

/***/ "./node_modules/axios/lib/core/settle.js":
/*!***********************************************!*\
  !*** ./node_modules/axios/lib/core/settle.js ***!
  \***********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var createError = __webpack_require__(/*! ./createError */ "./node_modules/axios/lib/core/createError.js");

/**
 * Resolve or reject a Promise based on response status.
 *
 * @param {Function} resolve A function that resolves the promise.
 * @param {Function} reject A function that rejects the promise.
 * @param {object} response The response.
 */
module.exports = function settle(resolve, reject, response) {
  var validateStatus = response.config.validateStatus;
  if (!response.status || !validateStatus || validateStatus(response.status)) {
    resolve(response);
  } else {
    reject(createError(
      'Request failed with status code ' + response.status,
      response.config,
      null,
      response.request,
      response
    ));
  }
};


/***/ }),

/***/ "./node_modules/axios/lib/core/transformData.js":
/*!******************************************************!*\
  !*** ./node_modules/axios/lib/core/transformData.js ***!
  \******************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");
var defaults = __webpack_require__(/*! ./../defaults */ "./node_modules/axios/lib/defaults.js");

/**
 * Transform the data for a request or a response
 *
 * @param {Object|String} data The data to be transformed
 * @param {Array} headers The headers for the request or response
 * @param {Array|Function} fns A single function or Array of functions
 * @returns {*} The resulting transformed data
 */
module.exports = function transformData(data, headers, fns) {
  var context = this || defaults;
  /*eslint no-param-reassign:0*/
  utils.forEach(fns, function transform(fn) {
    data = fn.call(context, data, headers);
  });

  return data;
};


/***/ }),

/***/ "./node_modules/axios/lib/defaults.js":
/*!********************************************!*\
  !*** ./node_modules/axios/lib/defaults.js ***!
  \********************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";
/* provided dependency */ var process = __webpack_require__(/*! process/browser.js */ "./node_modules/process/browser.js");


var utils = __webpack_require__(/*! ./utils */ "./node_modules/axios/lib/utils.js");
var normalizeHeaderName = __webpack_require__(/*! ./helpers/normalizeHeaderName */ "./node_modules/axios/lib/helpers/normalizeHeaderName.js");
var enhanceError = __webpack_require__(/*! ./core/enhanceError */ "./node_modules/axios/lib/core/enhanceError.js");

var DEFAULT_CONTENT_TYPE = {
  'Content-Type': 'application/x-www-form-urlencoded'
};

function setContentTypeIfUnset(headers, value) {
  if (!utils.isUndefined(headers) && utils.isUndefined(headers['Content-Type'])) {
    headers['Content-Type'] = value;
  }
}

function getDefaultAdapter() {
  var adapter;
  if (typeof XMLHttpRequest !== 'undefined') {
    // For browsers use XHR adapter
    adapter = __webpack_require__(/*! ./adapters/xhr */ "./node_modules/axios/lib/adapters/xhr.js");
  } else if (typeof process !== 'undefined' && Object.prototype.toString.call(process) === '[object process]') {
    // For node use HTTP adapter
    adapter = __webpack_require__(/*! ./adapters/http */ "./node_modules/axios/lib/adapters/xhr.js");
  }
  return adapter;
}

function stringifySafely(rawValue, parser, encoder) {
  if (utils.isString(rawValue)) {
    try {
      (parser || JSON.parse)(rawValue);
      return utils.trim(rawValue);
    } catch (e) {
      if (e.name !== 'SyntaxError') {
        throw e;
      }
    }
  }

  return (encoder || JSON.stringify)(rawValue);
}

var defaults = {

  transitional: {
    silentJSONParsing: true,
    forcedJSONParsing: true,
    clarifyTimeoutError: false
  },

  adapter: getDefaultAdapter(),

  transformRequest: [function transformRequest(data, headers) {
    normalizeHeaderName(headers, 'Accept');
    normalizeHeaderName(headers, 'Content-Type');

    if (utils.isFormData(data) ||
      utils.isArrayBuffer(data) ||
      utils.isBuffer(data) ||
      utils.isStream(data) ||
      utils.isFile(data) ||
      utils.isBlob(data)
    ) {
      return data;
    }
    if (utils.isArrayBufferView(data)) {
      return data.buffer;
    }
    if (utils.isURLSearchParams(data)) {
      setContentTypeIfUnset(headers, 'application/x-www-form-urlencoded;charset=utf-8');
      return data.toString();
    }
    if (utils.isObject(data) || (headers && headers['Content-Type'] === 'application/json')) {
      setContentTypeIfUnset(headers, 'application/json');
      return stringifySafely(data);
    }
    return data;
  }],

  transformResponse: [function transformResponse(data) {
    var transitional = this.transitional;
    var silentJSONParsing = transitional && transitional.silentJSONParsing;
    var forcedJSONParsing = transitional && transitional.forcedJSONParsing;
    var strictJSONParsing = !silentJSONParsing && this.responseType === 'json';

    if (strictJSONParsing || (forcedJSONParsing && utils.isString(data) && data.length)) {
      try {
        return JSON.parse(data);
      } catch (e) {
        if (strictJSONParsing) {
          if (e.name === 'SyntaxError') {
            throw enhanceError(e, this, 'E_JSON_PARSE');
          }
          throw e;
        }
      }
    }

    return data;
  }],

  /**
   * A timeout in milliseconds to abort a request. If set to 0 (default) a
   * timeout is not created.
   */
  timeout: 0,

  xsrfCookieName: 'XSRF-TOKEN',
  xsrfHeaderName: 'X-XSRF-TOKEN',

  maxContentLength: -1,
  maxBodyLength: -1,

  validateStatus: function validateStatus(status) {
    return status >= 200 && status < 300;
  }
};

defaults.headers = {
  common: {
    'Accept': 'application/json, text/plain, */*'
  }
};

utils.forEach(['delete', 'get', 'head'], function forEachMethodNoData(method) {
  defaults.headers[method] = {};
});

utils.forEach(['post', 'put', 'patch'], function forEachMethodWithData(method) {
  defaults.headers[method] = utils.merge(DEFAULT_CONTENT_TYPE);
});

module.exports = defaults;


/***/ }),

/***/ "./node_modules/axios/lib/helpers/bind.js":
/*!************************************************!*\
  !*** ./node_modules/axios/lib/helpers/bind.js ***!
  \************************************************/
/***/ ((module) => {

"use strict";


module.exports = function bind(fn, thisArg) {
  return function wrap() {
    var args = new Array(arguments.length);
    for (var i = 0; i < args.length; i++) {
      args[i] = arguments[i];
    }
    return fn.apply(thisArg, args);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/buildURL.js":
/*!****************************************************!*\
  !*** ./node_modules/axios/lib/helpers/buildURL.js ***!
  \****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

function encode(val) {
  return encodeURIComponent(val).
    replace(/%3A/gi, ':').
    replace(/%24/g, '$').
    replace(/%2C/gi, ',').
    replace(/%20/g, '+').
    replace(/%5B/gi, '[').
    replace(/%5D/gi, ']');
}

/**
 * Build a URL by appending params to the end
 *
 * @param {string} url The base of the url (e.g., http://www.google.com)
 * @param {object} [params] The params to be appended
 * @returns {string} The formatted url
 */
module.exports = function buildURL(url, params, paramsSerializer) {
  /*eslint no-param-reassign:0*/
  if (!params) {
    return url;
  }

  var serializedParams;
  if (paramsSerializer) {
    serializedParams = paramsSerializer(params);
  } else if (utils.isURLSearchParams(params)) {
    serializedParams = params.toString();
  } else {
    var parts = [];

    utils.forEach(params, function serialize(val, key) {
      if (val === null || typeof val === 'undefined') {
        return;
      }

      if (utils.isArray(val)) {
        key = key + '[]';
      } else {
        val = [val];
      }

      utils.forEach(val, function parseValue(v) {
        if (utils.isDate(v)) {
          v = v.toISOString();
        } else if (utils.isObject(v)) {
          v = JSON.stringify(v);
        }
        parts.push(encode(key) + '=' + encode(v));
      });
    });

    serializedParams = parts.join('&');
  }

  if (serializedParams) {
    var hashmarkIndex = url.indexOf('#');
    if (hashmarkIndex !== -1) {
      url = url.slice(0, hashmarkIndex);
    }

    url += (url.indexOf('?') === -1 ? '?' : '&') + serializedParams;
  }

  return url;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/combineURLs.js":
/*!*******************************************************!*\
  !*** ./node_modules/axios/lib/helpers/combineURLs.js ***!
  \*******************************************************/
/***/ ((module) => {

"use strict";


/**
 * Creates a new URL by combining the specified URLs
 *
 * @param {string} baseURL The base URL
 * @param {string} relativeURL The relative URL
 * @returns {string} The combined URL
 */
module.exports = function combineURLs(baseURL, relativeURL) {
  return relativeURL
    ? baseURL.replace(/\/+$/, '') + '/' + relativeURL.replace(/^\/+/, '')
    : baseURL;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/cookies.js":
/*!***************************************************!*\
  !*** ./node_modules/axios/lib/helpers/cookies.js ***!
  \***************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs support document.cookie
    (function standardBrowserEnv() {
      return {
        write: function write(name, value, expires, path, domain, secure) {
          var cookie = [];
          cookie.push(name + '=' + encodeURIComponent(value));

          if (utils.isNumber(expires)) {
            cookie.push('expires=' + new Date(expires).toGMTString());
          }

          if (utils.isString(path)) {
            cookie.push('path=' + path);
          }

          if (utils.isString(domain)) {
            cookie.push('domain=' + domain);
          }

          if (secure === true) {
            cookie.push('secure');
          }

          document.cookie = cookie.join('; ');
        },

        read: function read(name) {
          var match = document.cookie.match(new RegExp('(^|;\\s*)(' + name + ')=([^;]*)'));
          return (match ? decodeURIComponent(match[3]) : null);
        },

        remove: function remove(name) {
          this.write(name, '', Date.now() - 86400000);
        }
      };
    })() :

  // Non standard browser env (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return {
        write: function write() {},
        read: function read() { return null; },
        remove: function remove() {}
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isAbsoluteURL.js":
/*!*********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isAbsoluteURL.js ***!
  \*********************************************************/
/***/ ((module) => {

"use strict";


/**
 * Determines whether the specified URL is absolute
 *
 * @param {string} url The URL to test
 * @returns {boolean} True if the specified URL is absolute, otherwise false
 */
module.exports = function isAbsoluteURL(url) {
  // A URL is considered absolute if it begins with "<scheme>://" or "//" (protocol-relative URL).
  // RFC 3986 defines scheme name as a sequence of characters beginning with a letter and followed
  // by any combination of letters, digits, plus, period, or hyphen.
  return /^([a-z][a-z\d\+\-\.]*:)?\/\//i.test(url);
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isAxiosError.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isAxiosError.js ***!
  \********************************************************/
/***/ ((module) => {

"use strict";


/**
 * Determines whether the payload is an error thrown by Axios
 *
 * @param {*} payload The value to test
 * @returns {boolean} True if the payload is an error thrown by Axios, otherwise false
 */
module.exports = function isAxiosError(payload) {
  return (typeof payload === 'object') && (payload.isAxiosError === true);
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/isURLSameOrigin.js":
/*!***********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/isURLSameOrigin.js ***!
  \***********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

module.exports = (
  utils.isStandardBrowserEnv() ?

  // Standard browser envs have full support of the APIs needed to test
  // whether the request URL is of the same origin as current location.
    (function standardBrowserEnv() {
      var msie = /(msie|trident)/i.test(navigator.userAgent);
      var urlParsingNode = document.createElement('a');
      var originURL;

      /**
    * Parse a URL to discover it's components
    *
    * @param {String} url The URL to be parsed
    * @returns {Object}
    */
      function resolveURL(url) {
        var href = url;

        if (msie) {
        // IE needs attribute set twice to normalize properties
          urlParsingNode.setAttribute('href', href);
          href = urlParsingNode.href;
        }

        urlParsingNode.setAttribute('href', href);

        // urlParsingNode provides the UrlUtils interface - http://url.spec.whatwg.org/#urlutils
        return {
          href: urlParsingNode.href,
          protocol: urlParsingNode.protocol ? urlParsingNode.protocol.replace(/:$/, '') : '',
          host: urlParsingNode.host,
          search: urlParsingNode.search ? urlParsingNode.search.replace(/^\?/, '') : '',
          hash: urlParsingNode.hash ? urlParsingNode.hash.replace(/^#/, '') : '',
          hostname: urlParsingNode.hostname,
          port: urlParsingNode.port,
          pathname: (urlParsingNode.pathname.charAt(0) === '/') ?
            urlParsingNode.pathname :
            '/' + urlParsingNode.pathname
        };
      }

      originURL = resolveURL(window.location.href);

      /**
    * Determine if a URL shares the same origin as the current location
    *
    * @param {String} requestURL The URL to test
    * @returns {boolean} True if URL shares the same origin, otherwise false
    */
      return function isURLSameOrigin(requestURL) {
        var parsed = (utils.isString(requestURL)) ? resolveURL(requestURL) : requestURL;
        return (parsed.protocol === originURL.protocol &&
            parsed.host === originURL.host);
      };
    })() :

  // Non standard browser envs (web workers, react-native) lack needed support.
    (function nonStandardBrowserEnv() {
      return function isURLSameOrigin() {
        return true;
      };
    })()
);


/***/ }),

/***/ "./node_modules/axios/lib/helpers/normalizeHeaderName.js":
/*!***************************************************************!*\
  !*** ./node_modules/axios/lib/helpers/normalizeHeaderName.js ***!
  \***************************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ../utils */ "./node_modules/axios/lib/utils.js");

module.exports = function normalizeHeaderName(headers, normalizedName) {
  utils.forEach(headers, function processHeader(value, name) {
    if (name !== normalizedName && name.toUpperCase() === normalizedName.toUpperCase()) {
      headers[normalizedName] = value;
      delete headers[name];
    }
  });
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/parseHeaders.js":
/*!********************************************************!*\
  !*** ./node_modules/axios/lib/helpers/parseHeaders.js ***!
  \********************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var utils = __webpack_require__(/*! ./../utils */ "./node_modules/axios/lib/utils.js");

// Headers whose duplicates are ignored by node
// c.f. https://nodejs.org/api/http.html#http_message_headers
var ignoreDuplicateOf = [
  'age', 'authorization', 'content-length', 'content-type', 'etag',
  'expires', 'from', 'host', 'if-modified-since', 'if-unmodified-since',
  'last-modified', 'location', 'max-forwards', 'proxy-authorization',
  'referer', 'retry-after', 'user-agent'
];

/**
 * Parse headers into an object
 *
 * ```
 * Date: Wed, 27 Aug 2014 08:58:49 GMT
 * Content-Type: application/json
 * Connection: keep-alive
 * Transfer-Encoding: chunked
 * ```
 *
 * @param {String} headers Headers needing to be parsed
 * @returns {Object} Headers parsed into an object
 */
module.exports = function parseHeaders(headers) {
  var parsed = {};
  var key;
  var val;
  var i;

  if (!headers) { return parsed; }

  utils.forEach(headers.split('\n'), function parser(line) {
    i = line.indexOf(':');
    key = utils.trim(line.substr(0, i)).toLowerCase();
    val = utils.trim(line.substr(i + 1));

    if (key) {
      if (parsed[key] && ignoreDuplicateOf.indexOf(key) >= 0) {
        return;
      }
      if (key === 'set-cookie') {
        parsed[key] = (parsed[key] ? parsed[key] : []).concat([val]);
      } else {
        parsed[key] = parsed[key] ? parsed[key] + ', ' + val : val;
      }
    }
  });

  return parsed;
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/spread.js":
/*!**************************************************!*\
  !*** ./node_modules/axios/lib/helpers/spread.js ***!
  \**************************************************/
/***/ ((module) => {

"use strict";


/**
 * Syntactic sugar for invoking a function and expanding an array for arguments.
 *
 * Common use case would be to use `Function.prototype.apply`.
 *
 *  ```js
 *  function f(x, y, z) {}
 *  var args = [1, 2, 3];
 *  f.apply(null, args);
 *  ```
 *
 * With `spread` this example can be re-written.
 *
 *  ```js
 *  spread(function(x, y, z) {})([1, 2, 3]);
 *  ```
 *
 * @param {Function} callback
 * @returns {Function}
 */
module.exports = function spread(callback) {
  return function wrap(arr) {
    return callback.apply(null, arr);
  };
};


/***/ }),

/***/ "./node_modules/axios/lib/helpers/validator.js":
/*!*****************************************************!*\
  !*** ./node_modules/axios/lib/helpers/validator.js ***!
  \*****************************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var pkg = __webpack_require__(/*! ./../../package.json */ "./node_modules/axios/package.json");

var validators = {};

// eslint-disable-next-line func-names
['object', 'boolean', 'number', 'function', 'string', 'symbol'].forEach(function(type, i) {
  validators[type] = function validator(thing) {
    return typeof thing === type || 'a' + (i < 1 ? 'n ' : ' ') + type;
  };
});

var deprecatedWarnings = {};
var currentVerArr = pkg.version.split('.');

/**
 * Compare package versions
 * @param {string} version
 * @param {string?} thanVersion
 * @returns {boolean}
 */
function isOlderVersion(version, thanVersion) {
  var pkgVersionArr = thanVersion ? thanVersion.split('.') : currentVerArr;
  var destVer = version.split('.');
  for (var i = 0; i < 3; i++) {
    if (pkgVersionArr[i] > destVer[i]) {
      return true;
    } else if (pkgVersionArr[i] < destVer[i]) {
      return false;
    }
  }
  return false;
}

/**
 * Transitional option validator
 * @param {function|boolean?} validator
 * @param {string?} version
 * @param {string} message
 * @returns {function}
 */
validators.transitional = function transitional(validator, version, message) {
  var isDeprecated = version && isOlderVersion(version);

  function formatMessage(opt, desc) {
    return '[Axios v' + pkg.version + '] Transitional option \'' + opt + '\'' + desc + (message ? '. ' + message : '');
  }

  // eslint-disable-next-line func-names
  return function(value, opt, opts) {
    if (validator === false) {
      throw new Error(formatMessage(opt, ' has been removed in ' + version));
    }

    if (isDeprecated && !deprecatedWarnings[opt]) {
      deprecatedWarnings[opt] = true;
      // eslint-disable-next-line no-console
      console.warn(
        formatMessage(
          opt,
          ' has been deprecated since v' + version + ' and will be removed in the near future'
        )
      );
    }

    return validator ? validator(value, opt, opts) : true;
  };
};

/**
 * Assert object's properties type
 * @param {object} options
 * @param {object} schema
 * @param {boolean?} allowUnknown
 */

function assertOptions(options, schema, allowUnknown) {
  if (typeof options !== 'object') {
    throw new TypeError('options must be an object');
  }
  var keys = Object.keys(options);
  var i = keys.length;
  while (i-- > 0) {
    var opt = keys[i];
    var validator = schema[opt];
    if (validator) {
      var value = options[opt];
      var result = value === undefined || validator(value, opt, options);
      if (result !== true) {
        throw new TypeError('option ' + opt + ' must be ' + result);
      }
      continue;
    }
    if (allowUnknown !== true) {
      throw Error('Unknown option ' + opt);
    }
  }
}

module.exports = {
  isOlderVersion: isOlderVersion,
  assertOptions: assertOptions,
  validators: validators
};


/***/ }),

/***/ "./node_modules/axios/lib/utils.js":
/*!*****************************************!*\
  !*** ./node_modules/axios/lib/utils.js ***!
  \*****************************************/
/***/ ((module, __unused_webpack_exports, __webpack_require__) => {

"use strict";


var bind = __webpack_require__(/*! ./helpers/bind */ "./node_modules/axios/lib/helpers/bind.js");

// utils is a library of generic helper functions non-specific to axios

var toString = Object.prototype.toString;

/**
 * Determine if a value is an Array
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Array, otherwise false
 */
function isArray(val) {
  return toString.call(val) === '[object Array]';
}

/**
 * Determine if a value is undefined
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if the value is undefined, otherwise false
 */
function isUndefined(val) {
  return typeof val === 'undefined';
}

/**
 * Determine if a value is a Buffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Buffer, otherwise false
 */
function isBuffer(val) {
  return val !== null && !isUndefined(val) && val.constructor !== null && !isUndefined(val.constructor)
    && typeof val.constructor.isBuffer === 'function' && val.constructor.isBuffer(val);
}

/**
 * Determine if a value is an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an ArrayBuffer, otherwise false
 */
function isArrayBuffer(val) {
  return toString.call(val) === '[object ArrayBuffer]';
}

/**
 * Determine if a value is a FormData
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an FormData, otherwise false
 */
function isFormData(val) {
  return (typeof FormData !== 'undefined') && (val instanceof FormData);
}

/**
 * Determine if a value is a view on an ArrayBuffer
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a view on an ArrayBuffer, otherwise false
 */
function isArrayBufferView(val) {
  var result;
  if ((typeof ArrayBuffer !== 'undefined') && (ArrayBuffer.isView)) {
    result = ArrayBuffer.isView(val);
  } else {
    result = (val) && (val.buffer) && (val.buffer instanceof ArrayBuffer);
  }
  return result;
}

/**
 * Determine if a value is a String
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a String, otherwise false
 */
function isString(val) {
  return typeof val === 'string';
}

/**
 * Determine if a value is a Number
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Number, otherwise false
 */
function isNumber(val) {
  return typeof val === 'number';
}

/**
 * Determine if a value is an Object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is an Object, otherwise false
 */
function isObject(val) {
  return val !== null && typeof val === 'object';
}

/**
 * Determine if a value is a plain Object
 *
 * @param {Object} val The value to test
 * @return {boolean} True if value is a plain Object, otherwise false
 */
function isPlainObject(val) {
  if (toString.call(val) !== '[object Object]') {
    return false;
  }

  var prototype = Object.getPrototypeOf(val);
  return prototype === null || prototype === Object.prototype;
}

/**
 * Determine if a value is a Date
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Date, otherwise false
 */
function isDate(val) {
  return toString.call(val) === '[object Date]';
}

/**
 * Determine if a value is a File
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a File, otherwise false
 */
function isFile(val) {
  return toString.call(val) === '[object File]';
}

/**
 * Determine if a value is a Blob
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Blob, otherwise false
 */
function isBlob(val) {
  return toString.call(val) === '[object Blob]';
}

/**
 * Determine if a value is a Function
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Function, otherwise false
 */
function isFunction(val) {
  return toString.call(val) === '[object Function]';
}

/**
 * Determine if a value is a Stream
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a Stream, otherwise false
 */
function isStream(val) {
  return isObject(val) && isFunction(val.pipe);
}

/**
 * Determine if a value is a URLSearchParams object
 *
 * @param {Object} val The value to test
 * @returns {boolean} True if value is a URLSearchParams object, otherwise false
 */
function isURLSearchParams(val) {
  return typeof URLSearchParams !== 'undefined' && val instanceof URLSearchParams;
}

/**
 * Trim excess whitespace off the beginning and end of a string
 *
 * @param {String} str The String to trim
 * @returns {String} The String freed of excess whitespace
 */
function trim(str) {
  return str.trim ? str.trim() : str.replace(/^\s+|\s+$/g, '');
}

/**
 * Determine if we're running in a standard browser environment
 *
 * This allows axios to run in a web worker, and react-native.
 * Both environments support XMLHttpRequest, but not fully standard globals.
 *
 * web workers:
 *  typeof window -> undefined
 *  typeof document -> undefined
 *
 * react-native:
 *  navigator.product -> 'ReactNative'
 * nativescript
 *  navigator.product -> 'NativeScript' or 'NS'
 */
function isStandardBrowserEnv() {
  if (typeof navigator !== 'undefined' && (navigator.product === 'ReactNative' ||
                                           navigator.product === 'NativeScript' ||
                                           navigator.product === 'NS')) {
    return false;
  }
  return (
    typeof window !== 'undefined' &&
    typeof document !== 'undefined'
  );
}

/**
 * Iterate over an Array or an Object invoking a function for each item.
 *
 * If `obj` is an Array callback will be called passing
 * the value, index, and complete array for each item.
 *
 * If 'obj' is an Object callback will be called passing
 * the value, key, and complete object for each property.
 *
 * @param {Object|Array} obj The object to iterate
 * @param {Function} fn The callback to invoke for each item
 */
function forEach(obj, fn) {
  // Don't bother if no value provided
  if (obj === null || typeof obj === 'undefined') {
    return;
  }

  // Force an array if not already something iterable
  if (typeof obj !== 'object') {
    /*eslint no-param-reassign:0*/
    obj = [obj];
  }

  if (isArray(obj)) {
    // Iterate over array values
    for (var i = 0, l = obj.length; i < l; i++) {
      fn.call(null, obj[i], i, obj);
    }
  } else {
    // Iterate over object keys
    for (var key in obj) {
      if (Object.prototype.hasOwnProperty.call(obj, key)) {
        fn.call(null, obj[key], key, obj);
      }
    }
  }
}

/**
 * Accepts varargs expecting each argument to be an object, then
 * immutably merges the properties of each object and returns result.
 *
 * When multiple objects contain the same key the later object in
 * the arguments list will take precedence.
 *
 * Example:
 *
 * ```js
 * var result = merge({foo: 123}, {foo: 456});
 * console.log(result.foo); // outputs 456
 * ```
 *
 * @param {Object} obj1 Object to merge
 * @returns {Object} Result of all merge properties
 */
function merge(/* obj1, obj2, obj3, ... */) {
  var result = {};
  function assignValue(val, key) {
    if (isPlainObject(result[key]) && isPlainObject(val)) {
      result[key] = merge(result[key], val);
    } else if (isPlainObject(val)) {
      result[key] = merge({}, val);
    } else if (isArray(val)) {
      result[key] = val.slice();
    } else {
      result[key] = val;
    }
  }

  for (var i = 0, l = arguments.length; i < l; i++) {
    forEach(arguments[i], assignValue);
  }
  return result;
}

/**
 * Extends object a by mutably adding to it the properties of object b.
 *
 * @param {Object} a The object to be extended
 * @param {Object} b The object to copy properties from
 * @param {Object} thisArg The object to bind function to
 * @return {Object} The resulting value of object a
 */
function extend(a, b, thisArg) {
  forEach(b, function assignValue(val, key) {
    if (thisArg && typeof val === 'function') {
      a[key] = bind(val, thisArg);
    } else {
      a[key] = val;
    }
  });
  return a;
}

/**
 * Remove byte order marker. This catches EF BB BF (the UTF-8 BOM)
 *
 * @param {string} content with BOM
 * @return {string} content value without BOM
 */
function stripBOM(content) {
  if (content.charCodeAt(0) === 0xFEFF) {
    content = content.slice(1);
  }
  return content;
}

module.exports = {
  isArray: isArray,
  isArrayBuffer: isArrayBuffer,
  isBuffer: isBuffer,
  isFormData: isFormData,
  isArrayBufferView: isArrayBufferView,
  isString: isString,
  isNumber: isNumber,
  isObject: isObject,
  isPlainObject: isPlainObject,
  isUndefined: isUndefined,
  isDate: isDate,
  isFile: isFile,
  isBlob: isBlob,
  isFunction: isFunction,
  isStream: isStream,
  isURLSearchParams: isURLSearchParams,
  isStandardBrowserEnv: isStandardBrowserEnv,
  forEach: forEach,
  merge: merge,
  extend: extend,
  trim: trim,
  stripBOM: stripBOM
};


/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Advertise/Advertise.vue?vue&type=script&lang=js&":
/*!**************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Advertise/Advertise.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      advertise: []
    };
  },
  props: ["position"],
  methods: {
    lazyLoad: function lazyLoad() {
      $('.lazy').lazy({
        effect: "fadeIn",
        effectTime: 1000,
        scrollDirection: 'both',
        threshold: 0
      });
    }
  },
  created: function created() {
    var _this = this;

    axios.get('/vue/ads/beforeslider', {
      params: {
        position: this.position
      }
    }).then(function (res) {
      _this.advertise = res.data;

      _this.$nextTick(function () {
        _this.lazyLoad();
      });
    })["catch"](function (err) {
      return console.log(err);
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/CartTotal.vue?vue&type=script&lang=js&":
/*!****************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/CartTotal.vue?vue&type=script&lang=js& ***!
  \****************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      currency: {},
      totalitem: 0,
      subtotal: 0,
      total: 0,
      baseUrl: baseUrl,
      rtl: rtl,
      cartitems: [],
      lang: '',
      fallbacklang: '',
      shipping: '',
      login: ''
    };
  },
  methods: {
    loadcart: function loadcart() {
      var _this = this;

      axios.get('/cart/total').then(function (res) {
        _this.total = res.data.total;
        _this.totalitem = res.data.count;
        _this.currency = res.data.currency;
        _this.cartitems = res.data.items;
        _this.fallbacklang = res.data.fallback_local;
        _this.lang = res.data.lang;
        _this.subtotal = res.data.subtotal;
        _this.shipping = res.data.shipping;
        _this.login = res.data.login;
      })["catch"](function (err) {
        return console.log(err);
      });
    } // removelogincart(id){
    // },
    // removeguestcart(variantid){
    //     alert('x');
    //     axios.post(`/vue/remove/cart/guest/${variantid}`).then(res => {
    //         console.log(res.data);
    //     }).catch(err => {
    //         console.log(err);
    //     })
    // }   

  },
  created: function created() {
    var _this2 = this;

    this.loadcart();
    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('re-loadcart', function (payload) {
      _this2.loadcart();
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Comparedesktop.vue?vue&type=script&lang=js&":
/*!*********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Comparedesktop.vue?vue&type=script&lang=js& ***!
  \*********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      total: 0,
      baseUrl: baseUrl
    };
  },
  methods: {
    loadcomparison: function loadcomparison() {
      var _this = this;

      axios.get('/vue/compare/count').then(function (res) {
        _this.total = res.data;
        _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('compare-data', _this.total);
      })["catch"](function (err) {
        return console.log(err);
      });
    }
  },
  created: function created() {
    var _this2 = this;

    this.loadcomparison();
    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('re-load-comparison', function (payload) {
      _this2.loadcomparison();
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/BlogSkelton.vue?vue&type=script&lang=js&":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/BlogSkelton.vue?vue&type=script&lang=js& ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  methods: {
    installOwlCarousel: function installOwlCarousel(rtl) {
      $(".blog-slider").owlCarousel({
        items: 3,
        itemsTablet: [978, 1],
        itemsDesktopSmall: [979, 2],
        itemsDesktop: [1199, 1],
        nav: true,
        rtl: rtl,
        slideSpeed: 300,
        pagination: false,
        lazyLoad: true,
        navText: ["<i class='icon fa fa-angle-left'></i>", "<i class='icon fa fa-angle-right'></i>"],
        responsiveClass: true,
        responsive: {
          0: {
            items: 1,
            nav: false,
            dots: false
          },
          600: {
            items: 1,
            nav: false,
            dots: false
          },
          768: {
            items: 1,
            nav: false
          },
          1100: {
            items: 3,
            nav: true,
            dots: true
          }
        }
      });
    }
  },
  data: function data() {
    return {
      rtl: rtl
    };
  },
  created: function created() {
    var vm = this;
    this.$nextTick(function () {
      vm.installOwlCarousel(rtl);
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/CategorySidebar.vue?vue&type=script&lang=js&":
/*!*******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/CategorySidebar.vue?vue&type=script&lang=js& ***!
  \*******************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['fallbacklang', 'lang', 'categories', 'guest_price', 'login'],
  data: function data() {
    return {
      collpase: true
    };
  },
  methods: {
    hideCategoryBar: function hideCategoryBar() {
      var status = $('#collapseExample').is(':hidden');
      $('#collapseExample').slideToggle();

      if (status == false) {
        this.collpase = false;
      } else {
        this.collpase = true;
      }
    },
    redirectMe: function redirectMe(id, type) {
      var _this = this;

      if (type == 'p') {
        axios.get('/vue/get/category/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else if (type == 's') {
        axios.get('/vue/get/subcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else {
        axios.get('/vue/get/childcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Featuredproducts.vue?vue&type=script&lang=js&":
/*!********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Featuredproducts.vue?vue&type=script&lang=js& ***!
  \********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['products', 'date', 'lang', 'fallbacklang', 'login', 'guest_price']
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Hotdeal.vue?vue&type=script&lang=js&":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Hotdeal.vue?vue&type=script&lang=js& ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['hotdeals', 'lang', 'fallbacklang', 'login', 'guest_price', 'date'],
  data: function data() {
    return {
      rtl: rtl,
      dealincart: 0,
      loading: true,
      baseurl: baseUrl
    };
  },
  methods: {
    redirectMe: function redirectMe() {
      window.location.href = "".concat(this.baseurl, "/cart");
    },
    addToCart: function addToCart(cartURL) {
      var _this = this;

      axios.post(cartURL).then(function (res) {
        if (res.data.status == 'success') {
          var config = {
            text: res.data.msg,
            button: 'CLOSE'
          };
          _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('re-loadcart', 1);

          _this.$snack['success'](config);

          _this.dealincart = 1;
        } else {
          var _config = {
            text: res.data.msg,
            button: 'CLOSE'
          };

          _this.$snack['danger'](_config);
        }
      })["catch"](function (err) {
        var config = {
          text: 'Something went wrong !',
          button: 'CLOSE'
        };

        _this.$snack['danger'](config);

        console.log(err);
      });
    },
    timer: function timer() {
      var d = new Date();
      var datestring = d.getFullYear() + "-" + ("0" + (d.getMonth() + 1)).slice(-2) + "-" + ("0" + d.getDate()).slice(-2) + " " + ("0" + d.getHours()).slice(-2) + ":" + ("0" + d.getMinutes()).slice(-2) + ":" + ("0" + d.getSeconds()).slice(-2);
      var pausecontent = new Array();
      $.each(this.hotdeals, function (key, value) {
        var start = value.start_date;
        var end = value.end_date;

        if (start <= datestring && end >= datestring) {
          pausecontent.push(value);
        }
      });

      if ($('.timing-wrapper').length) {
        $('.timing-wrapper').each(function () {
          var $this = $(this);
          var finalDate = $(this).data('countdown');
          var finalDate1 = $(this).data('startat');

          if (datestring >= finalDate1) {
            $this.countdown(finalDate, function (event) {
              var $this = $(this).html(event.strftime('' + '<div class="box-wrapper"><div class="date box"> <span class="key">%D</span> <span class="value">DAYS</span> </div> </div> ' + '<div class="box-wrapper"><div class="hour box"> <span class="key">%H</span> <span class="value">HRS</span> </div> </div> ' + '<div class="box-wrapper"><div class="minutes box"> <span class="key">%M</span> <span class="value">MINS</span> </div> </div> ' + '<div class="box-wrapper"><div class="seconds box"> <span class="key">%S</span> <span class="value">SEC</span> </div> </div> '));
            });
          }
        });
      }

      if (pausecontent.length == 0) {
        $('.hot-deals').remove();
      }
    }
  },
  created: function created() {
    var _this2 = this;

    this.loading = false;
    this.$nextTick(function () {
      _this2.hotdeals = _this2.hotdeals;
      $(".hot-deal-carousel").owlCarousel({
        items: 1,
        itemsTablet: [978, 1],
        itemsDesktopSmall: [979, 2],
        itemsDesktop: [1199, 1],
        nav: true,
        slideSpeed: 300,
        pagination: false,
        lazyLoad: true,
        paginationSpeed: 400,
        responsiveClass: true,
        responsive: {
          0: {
            items: 1,
            nav: false,
            dots: false
          },
          600: {
            items: 1,
            nav: false,
            dots: false
          },
          768: {
            items: 1,
            nav: false
          },
          1100: {
            items: 1,
            nav: true,
            dots: true
          }
        },
        navText: ["<i class='icon fa fa-angle-left'></i>", "<i class='icon fa fa-angle-right'></i>"],
        rtl: rtl
      });

      _this2.timer();
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Menubar.vue?vue&type=script&lang=js&":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Menubar.vue?vue&type=script&lang=js& ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../EventBus */ "./resources/js/EventBus.js");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      menus: [],
      lang: '',
      fallback_local: '',
      rtl: rtl,
      baseUrl: baseUrl
    };
  },
  methods: {
    redirectMe: function redirectMe(id, type) {
      var _this = this;

      if (type == 'p') {
        axios.get('/vue/get/category/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else if (type == 's') {
        axios.get('/vue/get/subcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else {
        axios.get('/vue/get/childcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      }
    }
  },
  created: function created() {
    var _this2 = this;

    return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return axios.get('/vue/top/menus').then(function (res) {
                _this2.menus = res.data.menus;
                _this2.lang = res.data.lang;
                _this2.fallback_local = res.data.fallback_local;
                /** Fire a emit to load same menu on mobile menu sidebar */

                _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('loadmenu', _this2.menus, _this2.lang, _this2.fallback_local);
              })["catch"](function (err) {
                return console.log(err);
              });

            case 2:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/CompareCount.vue?vue&type=script&lang=js&":
/*!***********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/CompareCount.vue?vue&type=script&lang=js& ***!
  \***********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      total: 0,
      baseUrl: baseUrl
    };
  },
  created: function created() {
    var _this = this;

    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('compare-data', function (payload) {
      _this.total = payload;
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileCategorySidebar.vue?vue&type=script&lang=js&":
/*!********************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileCategorySidebar.vue?vue&type=script&lang=js& ***!
  \********************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      categories: [],
      lang: '',
      fallback_lang: '',
      guest_price: '',
      login: ''
    };
  },
  methods: {
    redirectMe: function redirectMe(id, type) {
      var _this = this;

      if (type == 'p') {
        axios.get('/vue/get/category/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else if (type == 's') {
        axios.get('/vue/get/subcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else {
        axios.get('/vue/get/childcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      }
    }
  },
  created: function created() {
    var _this2 = this;

    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('loadmobilecategorysidebar', function (payload, l, fl, lgn, gl) {
      _this2.categories = payload;
      _this2.lang = l;
      _this2.fallback_lang = fl;
      _this2.login = lgn;
      _this2.guest_price = gl;
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileMenuSidebar.vue?vue&type=script&lang=js&":
/*!****************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileMenuSidebar.vue?vue&type=script&lang=js& ***!
  \****************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      menus: [],
      lang: '',
      fallback_lang: ''
    };
  },
  methods: {
    redirectMe: function redirectMe(id, type) {
      var _this = this;

      if (type == 'p') {
        axios.get('/vue/get/category/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else if (type == 's') {
        axios.get('/vue/get/subcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      } else {
        axios.get('/vue/get/childcategory/url', {
          params: {
            id: id
          }
        }).then(function (res) {
          if (res.data.status && res.data.status == 'fail') {
            var config = {
              text: res.data.message,
              button: 'CLOSE'
            };

            _this.$snack['danger'](config);
          } else {
            location.href = res.data;
          }
        })["catch"](function (err) {
          return console.log(err);
        });
      }
    }
  },
  created: function created() {
    var _this2 = this;

    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('loadmenu', function (payload, l, fl) {
      _this2.menus = payload;
      _this2.lang = l;
      _this2.fallback_lang = fl;
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileProduct.vue?vue&type=script&lang=js&":
/*!************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileProduct.vue?vue&type=script&lang=js& ***!
  \************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ["products", "guest_price", "login", "fallbacklang", "lang", "date", 'new_simple_products'],
  methods: {
    fireLazyLoad: function fireLazyLoad() {
      $('.lazy').lazy({
        effect: "fadeIn",
        effectTime: 1000,
        scrollDirection: 'both',
        threshold: 0
      });
    },
    discountedPrice: function discountedPrice(product) {
      return Math.round(100 * (product.mainprice - product.offerprice) / product.mainprice) + '%';
    }
  },
  created: function created() {
    var _this = this;

    setTimeout(function () {
      _this.$nextTick(function () {
        _this.fireLazyLoad();
      });
    }, 2500);
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileSkelton.vue?vue&type=script&lang=js&":
/*!************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileSkelton.vue?vue&type=script&lang=js& ***!
  \************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileTopProducts.vue?vue&type=script&lang=js&":
/*!****************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileTopProducts.vue?vue&type=script&lang=js& ***!
  \****************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ["products", "guest_price", "login", "fallbacklang", "lang", "date"],
  methods: {
    fireLazyLoad: function fireLazyLoad() {
      $('.lazy').lazy({
        effect: "fadeIn",
        effectTime: 1000,
        scrollDirection: 'both',
        threshold: 0
      });
    },
    discountedPrice: function discountedPrice(product) {
      return Math.round(100 * (product.mainprice - product.offerprice) / product.mainprice) + '%';
    }
  },
  created: function created() {
    var vm = this;
    this.$nextTick(function () {
      vm.fireLazyLoad();
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileView.vue?vue&type=script&lang=js&":
/*!*********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileView.vue?vue&type=script&lang=js& ***!
  \*********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _MobileTopProducts_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./MobileTopProducts.vue */ "./resources/js/components/Homepage/Mobile/MobileTopProducts.vue");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ["products", "guest_price", "login", "fallbacklang", "lang", "date", "featuredproducts", "top_products"],
  components: {
    MobileTopProductsVue: _MobileTopProducts_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  data: function data() {
    return {
      loading: true
    };
  },
  created: function created() {
    var _this = this;

    setTimeout(function () {
      _this.loading = false;
    }, 1800);
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileVoice.vue?vue&type=script&lang=js&":
/*!**********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileVoice.vue?vue&type=script&lang=js& ***!
  \**********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ["voice_lang"],
  data: function data() {
    return {
      lang: this.voice_lang,
      runtimeTranscription: '',
      transcription: [],
      recognition: null,
      word: 'Click on Mic to begin search'
    };
  },
  methods: {
    showAlert: function showAlert() {
      this.$swal({
        showConfirmButton: false,
        html: '<div class="mb-5"><div class="circle_ripple"></div>' + '<div class="circle_ripple-2"></div>' + '<div class="circle">' + '<div class="circle-2">' + '<i class="fa fa-microphone"></i>' + '</div>' + '</div>' + '<div class="progress blue">' + '<span class="progress-left">' + '<span class="progress-bar"></span>' + '</span>' + '<span class="progress-right">' + '<span class="progress-bar"></span>' + '</span>' + '</div></div>' + '<p class="mt-6">' + this.word + '</p>'
      });
    },
    startRecognition: function startRecognition() {
      this.word = 'Listening...';
      this.showAlert();
      this.checkApi();
      this.recognition.start();
    },
    stopRecognition: function stopRecognition() {
      this.recognition.stop();
      this.$swal.close();
      this.recognition = null;
    },
    checkApi: function checkApi() {
      var _this = this;

      window.SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;

      if (!SpeechRecognition && "development" !== 'production') {
        throw new Error('Speech Recognition does not exist on this browser. Use Chrome or Firefox');
      }

      if (!SpeechRecognition) {
        console.log("No Speech Recognition");
        return;
      }

      this.recognition = new SpeechRecognition();
      this.recognition.lang = this.lang;
      this.recognition.interimResults = true;
      this.recognition.addEventListener('result', function (event) {
        var text = Array.from(event.results).map(function (result) {
          return result[0];
        }).map(function (result) {
          return result.transcript;
        }).join('');
        _this.runtimeTranscription = text;
      });
      this.recognition.addEventListener('end', function () {
        if (_this.runtimeTranscription !== '') {
          _this.transcription.push(_this.runtimeTranscription);

          _this.word = _this.runtimeTranscription;

          _this.$swal.close();

          $("#m_search").autocomplete("search", _this.word);

          _this.stopRecognition();
        } else {
          _this.word = 'Please try again !';

          _this.$swal.close();

          _this.stopRecognition();
        }

        _this.runtimeTranscription = '';
      });

      this.recognition.onresult = function (event) {
        var color = event.results[0][0].transcript; // console.log(color);
      };
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileWishlist.vue?vue&type=script&lang=js&":
/*!*************************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/MobileWishlist.vue?vue&type=script&lang=js& ***!
  \*************************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
//
//
//

axios.defaults.baseURL = baseUrl;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      wishcount: 0,
      baseUrl: baseUrl
    };
  },
  created: function created() {
    var _this = this;

    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('wishlist-count', function (payload) {
      _this.wishcount = payload;
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/iPadVoice.vue?vue&type=script&lang=js&":
/*!********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Mobile/iPadVoice.vue?vue&type=script&lang=js& ***!
  \********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ["voice_lang"],
  data: function data() {
    return {
      lang: this.voice_lang,
      runtimeTranscription: '',
      transcription: [],
      recognition: null,
      word: 'Click on Mic to begin search'
    };
  },
  methods: {
    showAlert: function showAlert() {
      this.$swal({
        showConfirmButton: false,
        html: '<div class="mb-5"><div class="circle_ripple"></div>' + '<div class="circle_ripple-2"></div>' + '<div class="circle">' + '<div class="circle-2">' + '<i class="fa fa-microphone"></i>' + '</div>' + '</div>' + '<div class="progress blue">' + '<span class="progress-left">' + '<span class="progress-bar"></span>' + '</span>' + '<span class="progress-right">' + '<span class="progress-bar"></span>' + '</span>' + '</div></div>' + '<p class="mt-6">' + this.word + '</p>'
      });
    },
    startRecognition: function startRecognition() {
      this.word = 'Listening...';
      this.showAlert();
      this.checkApi();
      this.recognition.start();
    },
    stopRecognition: function stopRecognition() {
      this.recognition.stop();
      this.$swal.close();
      this.recognition = null;
    },
    checkApi: function checkApi() {
      var _this = this;

      window.SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;

      if (!SpeechRecognition && "development" !== 'production') {
        throw new Error('Speech Recognition does not exist on this browser. Use Chrome or Firefox');
      }

      if (!SpeechRecognition) {
        console.log("No Speech Recognition");
        return;
      }

      this.recognition = new SpeechRecognition();
      this.recognition.lang = this.lang;
      this.recognition.interimResults = true;
      this.recognition.addEventListener('result', function (event) {
        var text = Array.from(event.results).map(function (result) {
          return result[0];
        }).map(function (result) {
          return result.transcript;
        }).join('');
        _this.runtimeTranscription = text;
      });
      this.recognition.addEventListener('end', function () {
        if (_this.runtimeTranscription !== '') {
          _this.transcription.push(_this.runtimeTranscription);

          _this.word = _this.runtimeTranscription;

          _this.$swal.close();

          $("#ipad_vsearch").autocomplete("search", _this.word);

          _this.stopRecognition();
        } else {
          _this.word = 'Please try again !';

          _this.$swal.close();

          _this.stopRecognition();
        }

        _this.runtimeTranscription = '';
      });

      this.recognition.onresult = function (event) {
        var color = event.results[0][0].transcript; // console.log(color);
      };
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/NewProducts.vue?vue&type=script&lang=js&":
/*!***************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/NewProducts.vue?vue&type=script&lang=js& ***!
  \***************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['lang', 'date', 'fallbacklang', 'login', 'guest_price', 'tabbed_products', 'tabbed_cats'],
  data: function data() {
    return {
      allproducts: [],
      loading: true
    };
  },
  methods: {
    loadTab: function loadTab(cat) {
      var _this = this;

      return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _this.loading = true;
                $('.home-owl-carousel').trigger('destroy.owl.carousel');
                _context.next = 4;
                return axios.get("/vue/click-tabbed-products/".concat(cat)).then(function (res) {
                  _this.allproducts = res.data;
                })["catch"](function (err) {
                  return console.log(err);
                });

              case 4:
                _this.loading = false;

              case 5:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }))();
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/ProductSlider.vue?vue&type=script&lang=js&":
/*!*****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/ProductSlider.vue?vue&type=script&lang=js& ***!
  \*****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

axios.defaults.baseURL = baseUrl;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['products', 'date', 'lang', 'fallbacklang', 'login', 'guest_price', 'simple_products', 'starbadge'],
  data: function data() {
    return {
      rtl: rtl,
      baseUrl: baseUrl
    };
  },
  methods: {
    installOwlCarousel: function installOwlCarousel(rtl) {
      $('.home-owl-carousel').each(function () {
        var owl = $(this);
        var itemPerLine = owl.data('item');

        if (!itemPerLine) {
          itemPerLine = 4;
        }

        owl.owlCarousel({
          items: 3,
          itemsTablet: [978, 1],
          itemsDesktopSmall: [979, 2],
          itemsDesktop: [1199, 1],
          nav: true,
          rtl: rtl,
          slideSpeed: 300,
          margin: 10,
          pagination: false,
          lazyLoad: true,
          navText: ["<i class='icon fa fa-angle-left'></i>", "<i class='icon fa fa-angle-right'></i>"],
          responsiveClass: true,
          responsive: {
            0: {
              items: 3,
              nav: false,
              dots: false
            },
            600: {
              items: 3,
              nav: false,
              dots: false
            },
            768: {
              items: 4,
              nav: false
            },
            1100: {
              items: 5,
              nav: true,
              dots: true
            }
          }
        });
      });
    },
    addToCart: function addToCart(cartURL) {
      var _this = this;

      axios.post(cartURL).then(function (res) {
        if (res.data.status == 'success') {
          var config = {
            text: res.data.msg,
            button: 'CLOSE'
          };
          _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('re-loadcart', 1);

          _this.$snack['success'](config);
        } else {
          var _config = {
            text: res.data.msg,
            button: 'CLOSE'
          };

          _this.$snack['danger'](_config);
        }
      })["catch"](function (err) {
        var config = {
          text: 'Something went wrong !',
          button: 'CLOSE'
        };

        _this.$snack['danger'](config);

        console.log(err);
      });
    },
    discountedPrice: function discountedPrice(product) {
      return Math.round(100 * (product.mainprice - product.offerprice) / product.mainprice) + '%';
    },
    addToCompare: function addToCompare(id) {
      var _this2 = this;

      axios.post("".concat(baseUrl, "/vue/add/to/comparison"), {
        id: id
      }).then(function (res) {
        if (res.data.status == 'success') {
          var config = {
            text: res.data.message,
            button: 'CLOSE'
          };

          _this2.$snack['success'](config);

          _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('re-load-comparison', 1);
        } else {
          var _config2 = {
            text: res.data.message,
            button: 'CLOSE'
          };

          _this2.$snack['danger'](_config2);
        }
      })["catch"](function (err) {
        var config = {
          text: "Something went wrong !",
          button: 'CLOSE'
        };

        _this2.$snack['danger'](config);
      });
    },
    addtowish: function addtowish(id) {
      var _this3 = this;

      axios.get('/vue/add_or_removewishlist/', {
        params: {
          variantid: id
        }
      }).then(function (res) {
        var config = {
          text: res.data.message,
          button: 'CLOSE'
        };

        if (res.data.status == 'fail') {
          _this3.$snack['danger'](config);
        } else {
          _this3.$snack['success'](config);

          _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('re-load-wish', 1);
        }
      })["catch"](function (err) {
        var config = {
          text: 'Something went wrong !',
          button: 'CLOSE'
        };

        _this3.$snack['danger'](config);

        console.log(err);
      });
    },
    addtowishsimple: function addtowishsimple(id) {
      var _this4 = this;

      axios.get('add/simple_pro/', {
        params: {
          proid: id
        }
      }).then(function (res) {
        var config = {
          text: res.data.msg,
          button: 'CLOSE'
        };

        if (res.data.status == 'fail') {
          _this4.$snack['danger'](config);
        } else {
          _this4.$snack['success'](config);

          _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('re-load-wish', 1);
        }
      })["catch"](function (err) {
        var config = {
          text: 'Something went wrong !',
          button: 'CLOSE'
        };

        _this4.$snack['danger'](config);

        console.log(err);
      });
    },
    createOwl: function createOwl() {
      var _this5 = this;

      var vm = this;
      this.$nextTick(function () {
        vm.installOwlCarousel(_this5.rtl);
      });
    }
  },
  created: function created() {
    this.createOwl();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/SidebarDesktop.vue?vue&type=script&lang=js&":
/*!******************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/SidebarDesktop.vue?vue&type=script&lang=js& ***!
  \******************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      categories: [],
      lang: '',
      fallbacklang: '',
      testimonials: [],
      specialoffers: [],
      hotdeals: [],
      guest_price: '',
      login: '',
      date: '',
      config: []
    };
  },
  created: function created() {
    var _this = this;

    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('sidebarconfig', function (payload) {
      _this.config = payload;
    });
    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('loaddesktopcategorysidebar', function (categories, lang, fallbacklang, login, guest_price, date, testimonials, specialoffers, hotdeals) {
      _this.categories = categories;
      _this.lang = lang;
      _this.hotdeals = hotdeals;
      _this.fallbacklang = fallbacklang;
      _this.testimonials = testimonials;
      _this.specialoffers = specialoffers;
      _this.login = login;
      _this.guest_price = guest_price;
      _this.date = date;
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Slider.vue?vue&type=script&lang=js&":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Slider.vue?vue&type=script&lang=js& ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SliderSkelton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SliderSkelton */ "./resources/js/components/Homepage/SliderSkelton.vue");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      loading: true,
      rtl: rtl,
      lang: '',
      fallbacklang: '',
      sliders: [],
      enable: ''
    };
  },
  components: {
    SliderSkelton: _SliderSkelton__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  methods: {
    installOwlCarousel: function installOwlCarousel(rtl) {
      $('.mainslider').each(function () {
        var owl = $(this);
        var itemPerLine = owl.data('item');

        if (!itemPerLine) {
          itemPerLine = 4;
        }

        $(owl).owlCarousel({
          responsive: {
            0: {
              items: 1
            },
            600: {
              items: 1
            },
            1100: {
              items: 1
            }
          },
          slideSpeed: 1500,
          smartSpeed: 1500,
          loop: true,
          margin: 10,
          nav: true,
          lazyLoad: true,
          autoplay: true,
          autoplayTimeout: 3000,
          autoplayHoverPause: true,
          rtl: rtl
        });
      });
    }
  },
  created: function created() {
    var _this = this;

    return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return axios.get('/vue/get/slider').then(function (res) {
                _this.sliders = res.data.sliders;
                _this.lang = res.data.lang;
                _this.fallbacklang = res.data.fallbacklang;
                _this.enable = res.data.enable;
                _this.loading = false;

                _this.$nextTick(function () {
                  _this.installOwlCarousel(rtl);
                });
              });

            case 2:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Slider2.vue?vue&type=script&lang=js&":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Slider2.vue?vue&type=script&lang=js& ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SliderSkelton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SliderSkelton */ "./resources/js/components/Homepage/SliderSkelton.vue");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      loading: true,
      rtl: rtl,
      lang: '',
      fallbacklang: '',
      sliders: [],
      enable: ''
    };
  },
  components: {
    SliderSkelton: _SliderSkelton__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  methods: {
    installOwlCarousel: function installOwlCarousel(rtl) {
      $('.mainslider').each(function () {
        var owl = $(this);
        var itemPerLine = owl.data('item');

        if (!itemPerLine) {
          itemPerLine = 4;
        }

        $(owl).owlCarousel({
          responsive: {
            0: {
              items: 1
            },
            600: {
              items: 1
            },
            1100: {
              items: 1
            }
          },
          slideSpeed: 1500,
          smartSpeed: 1500,
          loop: true,
          margin: 10,
          nav: true,
          lazyLoad: true,
          autoplay: true,
          autoplayTimeout: 3000,
          autoplayHoverPause: true,
          rtl: rtl
        });
      });
    }
  },
  created: function created() {
    var _this = this;

    return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return axios.get('/vue/get/slider2').then(function (res) {
                _this.sliders = res.data.sliders;
                _this.lang = res.data.lang;
                _this.fallbacklang = res.data.fallbacklang;
                _this.enable = res.data.enable;
                _this.loading = false;

                _this.$nextTick(function () {
                  _this.installOwlCarousel(rtl);
                });
              });

            case 2:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Slider3.vue?vue&type=script&lang=js&":
/*!***********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Slider3.vue?vue&type=script&lang=js& ***!
  \***********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _SliderSkelton__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./SliderSkelton */ "./resources/js/components/Homepage/SliderSkelton.vue");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      loading: true,
      rtl: rtl,
      lang: '',
      fallbacklang: '',
      sliders: [],
      enable: ''
    };
  },
  components: {
    SliderSkelton: _SliderSkelton__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  methods: {
    installOwlCarousel: function installOwlCarousel(rtl) {
      $('.mainslider').each(function () {
        var owl = $(this);
        var itemPerLine = owl.data('item');

        if (!itemPerLine) {
          itemPerLine = 4;
        }

        $(owl).owlCarousel({
          responsive: {
            0: {
              items: 1
            },
            600: {
              items: 1
            },
            1100: {
              items: 1
            }
          },
          slideSpeed: 1500,
          smartSpeed: 1500,
          loop: true,
          margin: 10,
          nav: true,
          lazyLoad: true,
          autoplay: true,
          autoplayTimeout: 3000,
          autoplayHoverPause: true,
          rtl: rtl
        });
      });
    }
  },
  created: function created() {
    var _this = this;

    return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return axios.get('/vue/get/slider3').then(function (res) {
                _this.sliders = res.data.sliders;
                _this.lang = res.data.lang;
                _this.fallbacklang = res.data.fallbacklang;
                _this.enable = res.data.enable;
                _this.loading = false;

                _this.$nextTick(function () {
                  _this.installOwlCarousel(rtl);
                });
              });

            case 2:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/SliderSkelton.vue?vue&type=script&lang=js&":
/*!*****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/SliderSkelton.vue?vue&type=script&lang=js& ***!
  \*****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['item'],
  data: function data() {
    return {
      rtl: rtl
    };
  },
  methods: {
    installOwlCarousel: function installOwlCarousel(rtl) {
      $('.skelton-owl-carousel').each(function () {
        var owl = $(this);
        var itemPerLine = owl.data('item');

        if (!itemPerLine) {
          itemPerLine = 4;
        }

        owl.owlCarousel({
          items: 6,
          itemsTablet: [978, 1],
          itemsDesktopSmall: [979, 2],
          itemsDesktop: [1199, 1],
          nav: true,
          margin: 10,
          rtl: rtl,
          slideSpeed: 300,
          pagination: false,
          lazyLoad: true,
          navText: ["<i class='icon fa fa-angle-left'></i>", "<i class='icon fa fa-angle-right'></i>"],
          responsiveClass: true,
          responsive: {
            0: {
              items: this.item,
              nav: false,
              dots: false
            },
            600: {
              items: this.item,
              nav: false,
              dots: false
            },
            768: {
              items: this.item,
              nav: false
            },
            1100: {
              items: this.item,
              nav: true,
              dots: true
            }
          }
        });
      });
    }
  },
  mounted: function mounted() {
    var _this = this;

    var vm = this;
    this.$nextTick(function () {
      vm.installOwlCarousel(_this.rtl);
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/SpecialOffer.vue?vue&type=script&lang=js&":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/SpecialOffer.vue?vue&type=script&lang=js& ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['specialoffers', 'lang', 'fallbacklang', 'guest_price', 'login'],
  data: function data() {
    return {
      rtl: rtl,
      loading: true
    };
  },
  created: function created() {
    // setTimeout(() => {
    var vm = this;
    this.$nextTick(function () {
      $(".special-offer-carousel").owlCarousel({
        items: 1,
        itemsTablet: [978, 1],
        itemsDesktopSmall: [979, 2],
        itemsDesktop: [1199, 1],
        nav: true,
        slideSpeed: 300,
        pagination: false,
        lazyLoad: true,
        paginationSpeed: 400,
        navText: ["<i class='icon fa fa-angle-left'></i>", "<i class='icon fa fa-angle-right'></i>"],
        rtl: rtl
      });
    });
    this.loading = false; // }, 3000);
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Testimonials.vue?vue&type=script&lang=js&":
/*!****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Testimonials.vue?vue&type=script&lang=js& ***!
  \****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['testimonial', 'lang', 'fallback_lang'],
  data: function data() {
    return {
      rtl: rtl,
      baseurl: baseUrl,
      loading: true
    };
  },
  created: function created() {
    var _this = this;

    //    setTimeout(() => {
    var vm = this;
    this.$nextTick(function () {
      $(".advertisement").owlCarousel({
        items: 1,
        itemsTablet: [978, 1],
        itemsDesktopSmall: [979, 1],
        itemsDesktop: [1199, 1],
        slideSpeed: 300,
        nav: true,
        navText: ["<i class='icon fa fa-angle-left'></i>", "<i class='icon fa fa-angle-right'></i>"],
        lazyLoad: true,
        pagination: true,
        rtl: rtl
      });
      _this.loading = false;
    }); //    }, 3000);
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/TopProductDesktop.vue?vue&type=script&lang=js&":
/*!*********************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/TopProductDesktop.vue?vue&type=script&lang=js& ***!
  \*********************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ['lang', 'fallbacklang', 'login', 'guest_price', 'date', 'top_products', 'rtl', 'top_simple_products'],
  data: function data() {
    return {
      loading: true
    };
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Wishlistcount.vue?vue&type=script&lang=js&":
/*!*****************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/Wishlistcount.vue?vue&type=script&lang=js& ***!
  \*****************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../EventBus */ "./resources/js/EventBus.js");
//
//
//
//
//
//

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      wishcount: 0,
      baseUrl: baseUrl
    };
  },
  methods: {
    loadcount: function loadcount() {
      var _this = this;

      axios.get('/vue/wishlist/count').then(function (res) {
        _this.wishcount = res.data;
        _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$emit('wishlist-count', _this.wishcount);
      })["catch"](function (err) {
        return console.log(err);
      });
    }
  },
  created: function created() {
    var _this2 = this;

    this.loadcount();
    _EventBus__WEBPACK_IMPORTED_MODULE_0__["default"].$on('re-load-wish', function (payload) {
      _this2.loadcount();
    });
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/blogslider.vue?vue&type=script&lang=js&":
/*!**************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/blogslider.vue?vue&type=script&lang=js& ***!
  \**************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _BlogSkelton_vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./BlogSkelton.vue */ "./resources/js/components/Homepage/BlogSkelton.vue");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//

axios.defaults.baseURL = baseUrl;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  components: {
    BlogSkelton: _BlogSkelton_vue__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  methods: {
    installOwlCarousel: function installOwlCarousel(rtl) {
      $('.blog-slider').each(function () {
        var owl = $(this);
        var itemPerLine = owl.data('item');

        if (!itemPerLine) {
          itemPerLine = 4;
        }

        $(owl).owlCarousel({
          items: 3,
          itemsTablet: [978, 1],
          itemsDesktopSmall: [979, 2],
          itemsDesktop: [1199, 1],
          nav: true,
          rtl: rtl,
          slideSpeed: 300,
          pagination: false,
          lazyLoad: false,
          navText: ["<i class='icon fa fa-angle-left'></i>", "<i class='icon fa fa-angle-right'></i>"],
          responsiveClass: true,
          responsive: {
            0: {
              items: 1,
              nav: false,
              dots: false
            },
            600: {
              items: 1,
              nav: false,
              dots: false
            },
            768: {
              items: 1,
              nav: false
            },
            1100: {
              items: 3,
              nav: true,
              dots: true
            }
          }
        });
      });
    }
  },
  data: function data() {
    return {
      loading: true,
      rtl: rtl,
      lang: '',
      fallbacklang: '',
      blogs: [],
      baseUrl: baseUrl
    };
  },
  created: function created() {
    var _this = this;

    return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
      return _regeneratorRuntime().wrap(function _callee$(_context) {
        while (1) {
          switch (_context.prev = _context.next) {
            case 0:
              _context.next = 2;
              return axios.get('/vue/blogs').then(function (res) {
                _this.blogs = res.data.blogs;
                _this.lang = res.data.lang;
                _this.fallbacklang = res.data.fallbacklang;
                _this.loading = false;

                _this.$nextTick(function () {
                  _this.installOwlCarousel(rtl);
                });
              })["catch"](function (err) {
                return console.log(err);
              });

            case 2:
            case "end":
              return _context.stop();
          }
        }
      }, _callee);
    }))();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/homepage.vue?vue&type=script&lang=js&":
/*!************************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/homepage.vue?vue&type=script&lang=js& ***!
  \************************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var _Advertise_Advertise__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../Advertise/Advertise */ "./resources/js/components/Advertise/Advertise.vue");
function _typeof(obj) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (obj) { return typeof obj; } : function (obj) { return obj && "function" == typeof Symbol && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }, _typeof(obj); }

function _regeneratorRuntime() { "use strict"; /*! regenerator-runtime -- Copyright (c) 2014-present, Facebook, Inc. -- license (MIT): https://github.com/facebook/regenerator/blob/main/LICENSE */ _regeneratorRuntime = function _regeneratorRuntime() { return exports; }; var exports = {}, Op = Object.prototype, hasOwn = Op.hasOwnProperty, $Symbol = "function" == typeof Symbol ? Symbol : {}, iteratorSymbol = $Symbol.iterator || "@@iterator", asyncIteratorSymbol = $Symbol.asyncIterator || "@@asyncIterator", toStringTagSymbol = $Symbol.toStringTag || "@@toStringTag"; function define(obj, key, value) { return Object.defineProperty(obj, key, { value: value, enumerable: !0, configurable: !0, writable: !0 }), obj[key]; } try { define({}, ""); } catch (err) { define = function define(obj, key, value) { return obj[key] = value; }; } function wrap(innerFn, outerFn, self, tryLocsList) { var protoGenerator = outerFn && outerFn.prototype instanceof Generator ? outerFn : Generator, generator = Object.create(protoGenerator.prototype), context = new Context(tryLocsList || []); return generator._invoke = function (innerFn, self, context) { var state = "suspendedStart"; return function (method, arg) { if ("executing" === state) throw new Error("Generator is already running"); if ("completed" === state) { if ("throw" === method) throw arg; return doneResult(); } for (context.method = method, context.arg = arg;;) { var delegate = context.delegate; if (delegate) { var delegateResult = maybeInvokeDelegate(delegate, context); if (delegateResult) { if (delegateResult === ContinueSentinel) continue; return delegateResult; } } if ("next" === context.method) context.sent = context._sent = context.arg;else if ("throw" === context.method) { if ("suspendedStart" === state) throw state = "completed", context.arg; context.dispatchException(context.arg); } else "return" === context.method && context.abrupt("return", context.arg); state = "executing"; var record = tryCatch(innerFn, self, context); if ("normal" === record.type) { if (state = context.done ? "completed" : "suspendedYield", record.arg === ContinueSentinel) continue; return { value: record.arg, done: context.done }; } "throw" === record.type && (state = "completed", context.method = "throw", context.arg = record.arg); } }; }(innerFn, self, context), generator; } function tryCatch(fn, obj, arg) { try { return { type: "normal", arg: fn.call(obj, arg) }; } catch (err) { return { type: "throw", arg: err }; } } exports.wrap = wrap; var ContinueSentinel = {}; function Generator() {} function GeneratorFunction() {} function GeneratorFunctionPrototype() {} var IteratorPrototype = {}; define(IteratorPrototype, iteratorSymbol, function () { return this; }); var getProto = Object.getPrototypeOf, NativeIteratorPrototype = getProto && getProto(getProto(values([]))); NativeIteratorPrototype && NativeIteratorPrototype !== Op && hasOwn.call(NativeIteratorPrototype, iteratorSymbol) && (IteratorPrototype = NativeIteratorPrototype); var Gp = GeneratorFunctionPrototype.prototype = Generator.prototype = Object.create(IteratorPrototype); function defineIteratorMethods(prototype) { ["next", "throw", "return"].forEach(function (method) { define(prototype, method, function (arg) { return this._invoke(method, arg); }); }); } function AsyncIterator(generator, PromiseImpl) { function invoke(method, arg, resolve, reject) { var record = tryCatch(generator[method], generator, arg); if ("throw" !== record.type) { var result = record.arg, value = result.value; return value && "object" == _typeof(value) && hasOwn.call(value, "__await") ? PromiseImpl.resolve(value.__await).then(function (value) { invoke("next", value, resolve, reject); }, function (err) { invoke("throw", err, resolve, reject); }) : PromiseImpl.resolve(value).then(function (unwrapped) { result.value = unwrapped, resolve(result); }, function (error) { return invoke("throw", error, resolve, reject); }); } reject(record.arg); } var previousPromise; this._invoke = function (method, arg) { function callInvokeWithMethodAndArg() { return new PromiseImpl(function (resolve, reject) { invoke(method, arg, resolve, reject); }); } return previousPromise = previousPromise ? previousPromise.then(callInvokeWithMethodAndArg, callInvokeWithMethodAndArg) : callInvokeWithMethodAndArg(); }; } function maybeInvokeDelegate(delegate, context) { var method = delegate.iterator[context.method]; if (undefined === method) { if (context.delegate = null, "throw" === context.method) { if (delegate.iterator["return"] && (context.method = "return", context.arg = undefined, maybeInvokeDelegate(delegate, context), "throw" === context.method)) return ContinueSentinel; context.method = "throw", context.arg = new TypeError("The iterator does not provide a 'throw' method"); } return ContinueSentinel; } var record = tryCatch(method, delegate.iterator, context.arg); if ("throw" === record.type) return context.method = "throw", context.arg = record.arg, context.delegate = null, ContinueSentinel; var info = record.arg; return info ? info.done ? (context[delegate.resultName] = info.value, context.next = delegate.nextLoc, "return" !== context.method && (context.method = "next", context.arg = undefined), context.delegate = null, ContinueSentinel) : info : (context.method = "throw", context.arg = new TypeError("iterator result is not an object"), context.delegate = null, ContinueSentinel); } function pushTryEntry(locs) { var entry = { tryLoc: locs[0] }; 1 in locs && (entry.catchLoc = locs[1]), 2 in locs && (entry.finallyLoc = locs[2], entry.afterLoc = locs[3]), this.tryEntries.push(entry); } function resetTryEntry(entry) { var record = entry.completion || {}; record.type = "normal", delete record.arg, entry.completion = record; } function Context(tryLocsList) { this.tryEntries = [{ tryLoc: "root" }], tryLocsList.forEach(pushTryEntry, this), this.reset(!0); } function values(iterable) { if (iterable) { var iteratorMethod = iterable[iteratorSymbol]; if (iteratorMethod) return iteratorMethod.call(iterable); if ("function" == typeof iterable.next) return iterable; if (!isNaN(iterable.length)) { var i = -1, next = function next() { for (; ++i < iterable.length;) { if (hasOwn.call(iterable, i)) return next.value = iterable[i], next.done = !1, next; } return next.value = undefined, next.done = !0, next; }; return next.next = next; } } return { next: doneResult }; } function doneResult() { return { value: undefined, done: !0 }; } return GeneratorFunction.prototype = GeneratorFunctionPrototype, define(Gp, "constructor", GeneratorFunctionPrototype), define(GeneratorFunctionPrototype, "constructor", GeneratorFunction), GeneratorFunction.displayName = define(GeneratorFunctionPrototype, toStringTagSymbol, "GeneratorFunction"), exports.isGeneratorFunction = function (genFun) { var ctor = "function" == typeof genFun && genFun.constructor; return !!ctor && (ctor === GeneratorFunction || "GeneratorFunction" === (ctor.displayName || ctor.name)); }, exports.mark = function (genFun) { return Object.setPrototypeOf ? Object.setPrototypeOf(genFun, GeneratorFunctionPrototype) : (genFun.__proto__ = GeneratorFunctionPrototype, define(genFun, toStringTagSymbol, "GeneratorFunction")), genFun.prototype = Object.create(Gp), genFun; }, exports.awrap = function (arg) { return { __await: arg }; }, defineIteratorMethods(AsyncIterator.prototype), define(AsyncIterator.prototype, asyncIteratorSymbol, function () { return this; }), exports.AsyncIterator = AsyncIterator, exports.async = function (innerFn, outerFn, self, tryLocsList, PromiseImpl) { void 0 === PromiseImpl && (PromiseImpl = Promise); var iter = new AsyncIterator(wrap(innerFn, outerFn, self, tryLocsList), PromiseImpl); return exports.isGeneratorFunction(outerFn) ? iter : iter.next().then(function (result) { return result.done ? result.value : iter.next(); }); }, defineIteratorMethods(Gp), define(Gp, toStringTagSymbol, "Generator"), define(Gp, iteratorSymbol, function () { return this; }), define(Gp, "toString", function () { return "[object Generator]"; }), exports.keys = function (object) { var keys = []; for (var key in object) { keys.push(key); } return keys.reverse(), function next() { for (; keys.length;) { var key = keys.pop(); if (key in object) return next.value = key, next.done = !1, next; } return next.done = !0, next; }; }, exports.values = values, Context.prototype = { constructor: Context, reset: function reset(skipTempReset) { if (this.prev = 0, this.next = 0, this.sent = this._sent = undefined, this.done = !1, this.delegate = null, this.method = "next", this.arg = undefined, this.tryEntries.forEach(resetTryEntry), !skipTempReset) for (var name in this) { "t" === name.charAt(0) && hasOwn.call(this, name) && !isNaN(+name.slice(1)) && (this[name] = undefined); } }, stop: function stop() { this.done = !0; var rootRecord = this.tryEntries[0].completion; if ("throw" === rootRecord.type) throw rootRecord.arg; return this.rval; }, dispatchException: function dispatchException(exception) { if (this.done) throw exception; var context = this; function handle(loc, caught) { return record.type = "throw", record.arg = exception, context.next = loc, caught && (context.method = "next", context.arg = undefined), !!caught; } for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i], record = entry.completion; if ("root" === entry.tryLoc) return handle("end"); if (entry.tryLoc <= this.prev) { var hasCatch = hasOwn.call(entry, "catchLoc"), hasFinally = hasOwn.call(entry, "finallyLoc"); if (hasCatch && hasFinally) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } else if (hasCatch) { if (this.prev < entry.catchLoc) return handle(entry.catchLoc, !0); } else { if (!hasFinally) throw new Error("try statement without catch or finally"); if (this.prev < entry.finallyLoc) return handle(entry.finallyLoc); } } } }, abrupt: function abrupt(type, arg) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc <= this.prev && hasOwn.call(entry, "finallyLoc") && this.prev < entry.finallyLoc) { var finallyEntry = entry; break; } } finallyEntry && ("break" === type || "continue" === type) && finallyEntry.tryLoc <= arg && arg <= finallyEntry.finallyLoc && (finallyEntry = null); var record = finallyEntry ? finallyEntry.completion : {}; return record.type = type, record.arg = arg, finallyEntry ? (this.method = "next", this.next = finallyEntry.finallyLoc, ContinueSentinel) : this.complete(record); }, complete: function complete(record, afterLoc) { if ("throw" === record.type) throw record.arg; return "break" === record.type || "continue" === record.type ? this.next = record.arg : "return" === record.type ? (this.rval = this.arg = record.arg, this.method = "return", this.next = "end") : "normal" === record.type && afterLoc && (this.next = afterLoc), ContinueSentinel; }, finish: function finish(finallyLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.finallyLoc === finallyLoc) return this.complete(entry.completion, entry.afterLoc), resetTryEntry(entry), ContinueSentinel; } }, "catch": function _catch(tryLoc) { for (var i = this.tryEntries.length - 1; i >= 0; --i) { var entry = this.tryEntries[i]; if (entry.tryLoc === tryLoc) { var record = entry.completion; if ("throw" === record.type) { var thrown = record.arg; resetTryEntry(entry); } return thrown; } } throw new Error("illegal catch attempt"); }, delegateYield: function delegateYield(iterable, resultName, nextLoc) { return this.delegate = { iterator: values(iterable), resultName: resultName, nextLoc: nextLoc }, "next" === this.method && (this.arg = undefined), ContinueSentinel; } }, exports; }

function asyncGeneratorStep(gen, resolve, reject, _next, _throw, key, arg) { try { var info = gen[key](arg); var value = info.value; } catch (error) { reject(error); return; } if (info.done) { resolve(value); } else { Promise.resolve(value).then(_next, _throw); } }

function _asyncToGenerator(fn) { return function () { var self = this, args = arguments; return new Promise(function (resolve, reject) { var gen = fn.apply(self, args); function _next(value) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "next", value); } function _throw(err) { asyncGeneratorStep(gen, resolve, reject, _next, _throw, "throw", err); } _next(undefined); }); }; }

//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  components: {
    Ads: _Advertise_Advertise__WEBPACK_IMPORTED_MODULE_0__["default"]
  },
  data: function data() {
    return {
      featuredproducts: [],
      // bestseller : [],
      lang: '',
      fallbacklang: '',
      date: '',
      rtl: rtl,
      guest_price: '',
      logged_in: '',
      tabbed_products: [],
      tabbed_cats: [],
      top_products: [],
      loadingforfeatured: true,
      loadingfortopproducts: true,
      loading: true
    };
  },
  methods: {
    getHomepage: function getHomepage() {
      var _this = this;

      return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee() {
        return _regeneratorRuntime().wrap(function _callee$(_context) {
          while (1) {
            switch (_context.prev = _context.next) {
              case 0:
                _context.next = 2;
                return axios.get('/homepage').then(function (res) {
                  _this.lang = res.data.lang;
                  _this.fallbacklang = res.data.fallback_local;
                  _this.featuredproducts = res.data.featuredproducts;
                  _this.guest_price = res.data.guest_price;
                  _this.date = res.data.date;
                  _this.logged_in = res.data.logged_in;
                  _this.loadingforfeatured = false;
                })["catch"](function (err) {
                  return console.log(err);
                });

              case 2:
              case "end":
                return _context.stop();
            }
          }
        }, _callee);
      }))();
    },
    loadtopcategoryproducts: function loadtopcategoryproducts() {
      var _this2 = this;

      return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee2() {
        return _regeneratorRuntime().wrap(function _callee2$(_context2) {
          while (1) {
            switch (_context2.prev = _context2.next) {
              case 0:
                _context2.next = 2;
                return axios.get('/vue/top/category/products').then(function (res) {
                  _this2.top_products = res.data;
                  _this2.loadingfortopproducts = false;
                })["catch"](function (err) {
                  return console.log(err);
                });

              case 2:
              case "end":
                return _context2.stop();
            }
          }
        }, _callee2);
      }))();
    },
    // async getbestsellers(){
    //       await axios.get('/bestseller').then(res => {
    //         this.bestseller = res.data;
    //       }).catch(err => console.log(err));
    //   },
    loadtabbedproducts: function loadtabbedproducts() {
      var _this3 = this;

      return _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime().mark(function _callee3() {
        return _regeneratorRuntime().wrap(function _callee3$(_context3) {
          while (1) {
            switch (_context3.prev = _context3.next) {
              case 0:
                _context3.next = 2;
                return axios.get('/vue/tabbed/products').then(function (res) {
                  _this3.tabbed_products = res.data.all.products;
                  _this3.tabbed_cats = res.data.cats;
                  _this3.loading = false;
                })["catch"](function (err) {
                  return console.log(err);
                });

              case 2:
              case "end":
                return _context3.stop();
            }
          }
        }, _callee3);
      }))();
    }
  },
  created: function created() {
    this.getHomepage();
    this.loadtabbedproducts();
    this.loadtopcategoryproducts(); // this.getbestsellers();
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/voice.vue?vue&type=script&lang=js&":
/*!*********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Homepage/voice.vue?vue&type=script&lang=js& ***!
  \*********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  props: ["voice_lang"],
  data: function data() {
    return {
      lang: this.voice_lang,
      runtimeTranscription: '',
      transcription: [],
      recognition: null,
      word: 'Click on Mic to begin search'
    };
  },
  methods: {
    showAlert: function showAlert() {
      this.$swal({
        showConfirmButton: false,
        html: '<div class="mb-5"><div class="circle_ripple"></div>' + '<div class="circle_ripple-2"></div>' + '<div class="circle">' + '<div class="circle-2">' + '<i class="fa fa-microphone"></i>' + '</div>' + '</div>' + '<div class="progress blue">' + '<span class="progress-left">' + '<span class="progress-bar"></span>' + '</span>' + '<span class="progress-right">' + '<span class="progress-bar"></span>' + '</span>' + '</div></div>' + '<p class="mt-6">' + this.word + '</p>'
      });
    },
    startRecognition: function startRecognition() {
      this.word = 'Listening...';
      this.showAlert();
      this.checkApi();
      this.recognition.start();
    },
    stopRecognition: function stopRecognition() {
      this.recognition.stop();
      this.$swal.close();
      this.recognition = null;
    },
    checkApi: function checkApi() {
      var _this = this;

      window.SpeechRecognition = window.SpeechRecognition || window.webkitSpeechRecognition;

      if (!SpeechRecognition && "development" !== 'production') {
        throw new Error('Speech Recognition does not exist on this browser. Use Chrome or Firefox');
      }

      if (!SpeechRecognition) {
        console.log("No Speech Recognition");
        return;
      }

      this.recognition = new SpeechRecognition();
      this.recognition.lang = this.lang;
      this.recognition.interimResults = true;
      this.recognition.addEventListener('result', function (event) {
        var text = Array.from(event.results).map(function (result) {
          return result[0];
        }).map(function (result) {
          return result.transcript;
        }).join('');
        _this.runtimeTranscription = text;
      });
      this.recognition.addEventListener('end', function () {
        if (_this.runtimeTranscription !== '') {
          _this.transcription.push(_this.runtimeTranscription);

          _this.word = _this.runtimeTranscription;

          _this.$swal.close();

          $("#v_search").autocomplete("search", _this.word);

          _this.stopRecognition();
        } else {
          _this.word = 'Please try again !';

          _this.$swal.close();

          _this.stopRecognition();
        }

        _this.runtimeTranscription = '';
      });

      this.recognition.onresult = function (event) {
        var color = event.results[0][0].transcript; // console.log(color);
      };
    }
  }
});

/***/ }),

/***/ "./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Notifications-d.vue?vue&type=script&lang=js&":
/*!**********************************************************************************************************************************************************************************************************************!*\
  !*** ./node_modules/babel-loader/lib/index.js??clonedRuleSet-5[0].rules[0].use[0]!./node_modules/vue-loader/lib/index.js??vue-loader-options!./resources/js/components/Notifications-d.vue?vue&type=script&lang=js& ***!
  \**********************************************************************************************************************************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
//
axios.defaults.baseURL = baseUrl;
/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  data: function data() {
    return {
      count: 0,
      notifications: [],
      baseUrl: baseUrl
    };
  },
  methods: {
    loadnotifications: function loadnotifications() {
      var _this = this;

      axios.get('/vue/user/notifications').then(function (res) {
        _this.count = res.data.count;
        _this.notifications = res.data.notifications;
      });
    },
    markread: function markread(id) {
      var _this2 = this;

      axios.get('/usermarkreadsingle', {
        params: {
          id1: id
        }
      }).then(function (res) {
        _this2.loadnotifications();
      })["catch"](function (err) {
        return console.log(err);
      });
    }
  },
  created: function created() {
    this.loadnotifications();
  }
});

/***/ }),

/***/ "./resources/js/EventBus.js":
/*!**********************************!*\
  !*** ./resources/js/EventBus.js ***!
  \**********************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = (new vue__WEBPACK_IMPORTED_MODULE_0__["default"]());

/***/ }),

/***/ "./resources/js/VueTranslation/Translation.js":
/*!****************************************************!*\
  !*** ./resources/js/VueTranslation/Translation.js ***!
  \****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "default": () => (__WEBPACK_DEFAULT_EXPORT__)
/* harmony export */ });
var translations = __webpack_require__(/*! ./translations */ "./resources/js/VueTranslation/translations.json");

/* harmony default export */ const __WEBPACK_DEFAULT_EXPORT__ = ({
  translate: function translate(key) {
    var replacements = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};
    var lang = document.documentElement.lang;
    var word = translations[lang];
    var keys = key.split('.');

    for (var i in keys) {
      try {
        word = word[keys[i]];

        if (word === undefined) {
          word = key;
          break;
        }
      } catch (e) {
        word = key;
        break;
      }
    }

    for (var _i in replacements) {
      word = word.replace(":".concat(_i), replacements[_i]);
    }

    return word;
  }
});

/***/ }),

/***/ "./resources/js/app.js":
/*!*****************************!*\
  !*** ./resources/js/app.js ***!
  \*****************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var vue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var vue_snack__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! vue-snack */ "./node_modules/vue-snack/dist/vue-snack.min.js");
/* harmony import */ var vue_snack__WEBPACK_IMPORTED_MODULE_2___default = /*#__PURE__*/__webpack_require__.n(vue_snack__WEBPACK_IMPORTED_MODULE_2__);
/* harmony import */ var vue_speech__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! vue-speech */ "./node_modules/vue-speech/dist/vue-speech.js");
/* harmony import */ var vue_speech__WEBPACK_IMPORTED_MODULE_3___default = /*#__PURE__*/__webpack_require__.n(vue_speech__WEBPACK_IMPORTED_MODULE_3__);
/* harmony import */ var vue_sweetalert2__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! vue-sweetalert2 */ "./node_modules/vue-sweetalert2/dist/vue-sweetalert.umd.js");
/* harmony import */ var vue_sweetalert2__WEBPACK_IMPORTED_MODULE_4___default = /*#__PURE__*/__webpack_require__.n(vue_sweetalert2__WEBPACK_IMPORTED_MODULE_4__);
/* harmony import */ var sweetalert2_dist_sweetalert2_min_css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! sweetalert2/dist/sweetalert2.min.css */ "./node_modules/sweetalert2/dist/sweetalert2.min.css");
/* harmony import */ var bootstrap_vue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! bootstrap-vue */ "./node_modules/bootstrap-vue/esm/index.js");
/* harmony import */ var _EventBus__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./EventBus */ "./resources/js/EventBus.js");
// require('./bootstrap');


__webpack_require__(/*! jquery-countdown */ "./node_modules/jquery-countdown/dist/jquery.countdown.js");

window.Vue = __webpack_require__(/*! vue */ "./node_modules/vue/dist/vue.esm.js");
window.axios = __webpack_require__(/*! axios */ "./node_modules/axios/index.js");
vue__WEBPACK_IMPORTED_MODULE_0__["default"].use(bootstrap_vue__WEBPACK_IMPORTED_MODULE_1__["default"]);


vue__WEBPACK_IMPORTED_MODULE_0__["default"].use((vue_speech__WEBPACK_IMPORTED_MODULE_3___default()));


vue__WEBPACK_IMPORTED_MODULE_0__["default"].use((vue_sweetalert2__WEBPACK_IMPORTED_MODULE_4___default()));
 //Importing

vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('homepage', (__webpack_require__(/*! ./components/Homepage/homepage.vue */ "./resources/js/components/Homepage/homepage.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('slider', (__webpack_require__(/*! ./components/Homepage/Slider.vue */ "./resources/js/components/Homepage/Slider.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('slider2', (__webpack_require__(/*! ./components/Homepage/Slider2.vue */ "./resources/js/components/Homepage/Slider2.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('slider3', (__webpack_require__(/*! ./components/Homepage/Slider3.vue */ "./resources/js/components/Homepage/Slider3.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('blogslider', (__webpack_require__(/*! ./components/Homepage/blogslider.vue */ "./resources/js/components/Homepage/blogslider.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('featured-products', (__webpack_require__(/*! ./components/Homepage/Featuredproducts.vue */ "./resources/js/components/Homepage/Featuredproducts.vue")["default"])); // Vue.component('best-sellers', require('./components/Homepage/BestSellers.vue').default);
// Vue.component('best-sellers-slider', require('./components/Homepage/BestSellerSlider.vue').default);

vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('top-products-d', (__webpack_require__(/*! ./components/Homepage/TopProductDesktop.vue */ "./resources/js/components/Homepage/TopProductDesktop.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('new-products-d', (__webpack_require__(/*! ./components/Homepage/NewProducts.vue */ "./resources/js/components/Homepage/NewProducts.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('product-slider', (__webpack_require__(/*! ./components/Homepage/ProductSlider.vue */ "./resources/js/components/Homepage/ProductSlider.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('slider-skelton', (__webpack_require__(/*! ./components/Homepage/SliderSkelton.vue */ "./resources/js/components/Homepage/SliderSkelton.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('mobile-view', (__webpack_require__(/*! ./components/Homepage/Mobile/MobileView.vue */ "./resources/js/components/Homepage/Mobile/MobileView.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('mobile-product', (__webpack_require__(/*! ./components/Homepage/Mobile/MobileProduct.vue */ "./resources/js/components/Homepage/Mobile/MobileProduct.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('mobile-skelton', (__webpack_require__(/*! ./components/Homepage/Mobile/MobileSkelton.vue */ "./resources/js/components/Homepage/Mobile/MobileSkelton.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('category-sidebar', (__webpack_require__(/*! ./components/Homepage/CategorySidebar.vue */ "./resources/js/components/Homepage/CategorySidebar.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('sidebar-desktop', (__webpack_require__(/*! ./components/Homepage/SidebarDesktop.vue */ "./resources/js/components/Homepage/SidebarDesktop.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('testimonials', (__webpack_require__(/*! ./components/Homepage/Testimonials.vue */ "./resources/js/components/Homepage/Testimonials.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('special-offer', (__webpack_require__(/*! ./components/Homepage/SpecialOffer.vue */ "./resources/js/components/Homepage/SpecialOffer.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('hot-deal', (__webpack_require__(/*! ./components/Homepage/Hotdeal.vue */ "./resources/js/components/Homepage/Hotdeal.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('top-menu-d', (__webpack_require__(/*! ./components/Homepage/Menubar.vue */ "./resources/js/components/Homepage/Menubar.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('mobile-menu-sidebar', (__webpack_require__(/*! ./components/Homepage/Mobile/MobileMenuSidebar.vue */ "./resources/js/components/Homepage/Mobile/MobileMenuSidebar.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('mobile-category-sidebar', (__webpack_require__(/*! ./components/Homepage/Mobile/MobileCategorySidebar.vue */ "./resources/js/components/Homepage/Mobile/MobileCategorySidebar.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('cart-total-d', (__webpack_require__(/*! ./components/CartTotal.vue */ "./resources/js/components/CartTotal.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('noti-d', (__webpack_require__(/*! ./components/Notifications-d.vue */ "./resources/js/components/Notifications-d.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('mobile-wish-count', (__webpack_require__(/*! ./components/Homepage/Mobile/MobileWishlist.vue */ "./resources/js/components/Homepage/Mobile/MobileWishlist.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('main-wish-count', (__webpack_require__(/*! ./components/Homepage/Wishlistcount.vue */ "./resources/js/components/Homepage/Wishlistcount.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('compare-m-count', (__webpack_require__(/*! ./components/Homepage/Mobile/CompareCount.vue */ "./resources/js/components/Homepage/Mobile/CompareCount.vue")["default"]));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('compare-c-count', (__webpack_require__(/*! ./components/Comparedesktop.vue */ "./resources/js/components/Comparedesktop.vue")["default"]));
/* Show in desktop mode */

vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('voice-search', (__webpack_require__(/*! ./components/Homepage/voice.vue */ "./resources/js/components/Homepage/voice.vue")["default"]));
/** Show in iPad view */

vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('ipad-voice-search', (__webpack_require__(/*! ./components/Homepage/Mobile/iPadVoice.vue */ "./resources/js/components/Homepage/Mobile/iPadVoice.vue")["default"]));
/* Show in Mobile View */

vue__WEBPACK_IMPORTED_MODULE_0__["default"].component('mobile-voice-search', (__webpack_require__(/*! ./components/Homepage/Mobile/MobileVoice.vue */ "./resources/js/components/Homepage/Mobile/MobileVoice.vue")["default"]));
/** End */

vue__WEBPACK_IMPORTED_MODULE_0__["default"].prototype.translate = (__webpack_require__(/*! ./VueTranslation/Translation */ "./resources/js/VueTranslation/Translation.js")["default"].translate);
vue__WEBPACK_IMPORTED_MODULE_0__["default"].use((vue_snack__WEBPACK_IMPORTED_MODULE_2___default()));
vue__WEBPACK_IMPORTED_MODULE_0__["default"].config.productionTip = false;
var app = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#app'
});
var search_area = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#search-area'
});
var ipad_search_area = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#search-xs'
});
var mobile_search_area = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#search-sm'
});
var menubar = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#menubar'
});
var mobilesidebar = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#mobilesidebar'
});
var mobilemenubar = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#mobilemenubar'
});
var carttotald = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#cart-total-d'
});

try {
  var notifications = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
    el: '#notifications'
  });
  var mobilewishlist = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
    el: '#mobilewishlist'
  });
  var dwishlistcount = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
    el: '#desktop-wis-count'
  });
} catch (err) {}

var comparecountd = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#comparedesktop'
});
var comparecountm = new vue__WEBPACK_IMPORTED_MODULE_0__["default"]({
  el: '#comparemobile'
});

axios.get('/vue/sidebar/categories').then(function (res) {
  var categories = res.data.categories;
  var hotdeals = res.data.hotdeals;
  var testimonials = res.data.testimonials;
  var specialoffers = res.data.specialoffers;
  var guest_price = res.data.guest_price;
  var login = res.data.logged_in;
  var date = res.data.date;
  var lang = res.data.lang;
  var fallbacklang = res.data.fallback_local;
  _EventBus__WEBPACK_IMPORTED_MODULE_6__["default"].$emit('loadmobilecategorysidebar', categories, lang, fallbacklang, login, guest_price);
  _EventBus__WEBPACK_IMPORTED_MODULE_6__["default"].$emit('loaddesktopcategorysidebar', categories, lang, fallbacklang, login, guest_price, date, testimonials, specialoffers, hotdeals);
})["catch"](function (err) {
  return console.log(err);
});
axios.get('/vue/sidebarconfigs').then(function (res) {
  _EventBus__WEBPACK_IMPORTED_MODULE_6__["default"].$emit('sidebarconfig', res.data);
})["catch"](function (err) {
  return console.log(err);
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/bv-config.js":
/*!*****************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/bv-config.js ***!
  \*****************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BVConfigPlugin": () => (/* binding */ BVConfigPlugin)
/* harmony export */ });
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");
//
// Utility Plugin for setting the configuration
//

var BVConfigPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)();

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/alert/alert.js":
/*!******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/alert/alert.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BAlert": () => (/* binding */ BAlert),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../vue */ "./node_modules/bootstrap-vue/esm/vue.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _button_button_close__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../button/button-close */ "./node_modules/bootstrap-vue/esm/components/button/button-close.js");
/* harmony import */ var _transition_bv_transition__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../transition/bv-transition */ "./node_modules/bootstrap-vue/esm/components/transition/bv-transition.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }














 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('show', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN_NUMBER_STRING,
  defaultValue: false
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // --- Helper methods ---
// Convert `show` value to a number


var parseCountDown = function parseCountDown(show) {
  if (show === '' || (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_2__.isBoolean)(show)) {
    return 0;
  }

  show = (0,_utils_number__WEBPACK_IMPORTED_MODULE_3__.toInteger)(show, 0);
  return show > 0 ? show : 0;
}; // Convert `show` value to a boolean


var parseShow = function parseShow(show) {
  if (show === '' || show === true) {
    return true;
  }

  if ((0,_utils_number__WEBPACK_IMPORTED_MODULE_3__.toInteger)(show, 0) < 1) {
    // Boolean will always return false for the above comparison
    return false;
  }

  return !!show;
}; // --- Props ---


var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_5__.sortKeys)(_objectSpread(_objectSpread({}, modelProps), {}, {
  dismissLabel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Close'),
  dismissible: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  fade: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'info')
})), _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_ALERT); // --- Main component ---
// @vue/component

var BAlert = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_7__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_ALERT,
  mixins: [modelMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__.normalizeSlotMixin],
  props: props,
  data: function data() {
    return {
      countDown: 0,
      // If initially shown, we need to set these for SSR
      localShow: parseShow(this[MODEL_PROP_NAME])
    };
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue) {
    this.countDown = parseCountDown(newValue);
    this.localShow = parseShow(newValue);
  }), _defineProperty(_watch, "countDown", function countDown(newValue) {
    var _this = this;

    this.clearCountDownInterval();
    var show = this[MODEL_PROP_NAME]; // Ignore if `show` transitions to a boolean value

    if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_2__.isNumeric)(show)) {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_9__.EVENT_NAME_DISMISS_COUNT_DOWN, newValue); // Update the v-model if needed

      if (show !== newValue) {
        this.$emit(MODEL_EVENT_NAME, newValue);
      }

      if (newValue > 0) {
        this.localShow = true;
        this.$_countDownTimeout = setTimeout(function () {
          _this.countDown--;
        }, 1000);
      } else {
        // Slightly delay the hide to allow any UI updates
        this.$nextTick(function () {
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_10__.requestAF)(function () {
            _this.localShow = false;
          });
        });
      }
    }
  }), _defineProperty(_watch, "localShow", function localShow(newValue) {
    var show = this[MODEL_PROP_NAME]; // Only emit dismissed events for dismissible or auto-dismissing alerts

    if (!newValue && (this.dismissible || (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_2__.isNumeric)(show))) {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_9__.EVENT_NAME_DISMISSED);
    } // Only emit booleans if we weren't passed a number via v-model


    if (!(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_2__.isNumeric)(show) && show !== newValue) {
      this.$emit(MODEL_EVENT_NAME, newValue);
    }
  }), _watch),
  created: function created() {
    // Create private non-reactive props
    this.$_filterTimer = null;
    var show = this[MODEL_PROP_NAME];
    this.countDown = parseCountDown(show);
    this.localShow = parseShow(show);
  },
  beforeDestroy: function beforeDestroy() {
    this.clearCountDownInterval();
  },
  methods: {
    dismiss: function dismiss() {
      this.clearCountDownInterval();
      this.countDown = 0;
      this.localShow = false;
    },
    clearCountDownInterval: function clearCountDownInterval() {
      clearTimeout(this.$_countDownTimeout);
      this.$_countDownTimeout = null;
    }
  },
  render: function render(h) {
    var $alert = h();

    if (this.localShow) {
      var dismissible = this.dismissible,
          variant = this.variant;
      var $dismissButton = h();

      if (dismissible) {
        // Add dismiss button
        $dismissButton = h(_button_button_close__WEBPACK_IMPORTED_MODULE_11__.BButtonClose, {
          attrs: {
            'aria-label': this.dismissLabel
          },
          on: {
            click: this.dismiss
          }
        }, [this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_12__.SLOT_NAME_DISMISS)]);
      }

      $alert = h('div', {
        staticClass: 'alert',
        class: _defineProperty({
          'alert-dismissible': dismissible
        }, "alert-".concat(variant), variant),
        attrs: {
          role: 'alert',
          'aria-live': 'polite',
          'aria-atomic': true
        },
        key: this[_vue__WEBPACK_IMPORTED_MODULE_13__.COMPONENT_UID_KEY]
      }, [$dismissButton, this.normalizeSlot()]);
    }

    return h(_transition_bv_transition__WEBPACK_IMPORTED_MODULE_14__.BVTransition, {
      props: {
        noFade: !this.fade
      }
    }, [$alert]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/alert/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/alert/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AlertPlugin": () => (/* binding */ AlertPlugin),
/* harmony export */   "BAlert": () => (/* reexport safe */ _alert__WEBPACK_IMPORTED_MODULE_1__.BAlert)
/* harmony export */ });
/* harmony import */ var _alert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./alert */ "./node_modules/bootstrap-vue/esm/components/alert/alert.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var AlertPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BAlert: _alert__WEBPACK_IMPORTED_MODULE_1__.BAlert
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/aspect/aspect.js":
/*!********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/aspect/aspect.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BAspect": () => (/* binding */ BAspect),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_regex__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/regex */ "./node_modules/bootstrap-vue/esm/constants/regex.js");
/* harmony import */ var _utils_math__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/math */ "./node_modules/bootstrap-vue/esm/utils/math.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }








 // --- Constants ---

var CLASS_NAME = 'b-aspect'; // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  // Accepts a number (i.e. `16 / 9`, `1`, `4 / 3`)
  // Or a string (i.e. '16/9', '16:9', '4:3' '1:1')
  aspect: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, '1:1'),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_ASPECT); // --- Main component ---
// @vue/component

var BAspect = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_ASPECT,
  mixins: [_mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlotMixin],
  props: props,
  computed: {
    padding: function padding() {
      var aspect = this.aspect;
      var ratio = 1;

      if (_constants_regex__WEBPACK_IMPORTED_MODULE_5__.RX_ASPECT.test(aspect)) {
        // Width and/or Height can be a decimal value below `1`, so
        // we only fallback to `1` if the value is `0` or `NaN`
        var _aspect$split$map = aspect.split(_constants_regex__WEBPACK_IMPORTED_MODULE_5__.RX_ASPECT_SEPARATOR).map(function (v) {
          return (0,_utils_number__WEBPACK_IMPORTED_MODULE_6__.toFloat)(v) || 1;
        }),
            _aspect$split$map2 = _slicedToArray(_aspect$split$map, 2),
            width = _aspect$split$map2[0],
            height = _aspect$split$map2[1];

        ratio = width / height;
      } else {
        ratio = (0,_utils_number__WEBPACK_IMPORTED_MODULE_6__.toFloat)(aspect) || 1;
      }

      return "".concat(100 / (0,_utils_math__WEBPACK_IMPORTED_MODULE_7__.mathAbs)(ratio), "%");
    }
  },
  render: function render(h) {
    var $sizer = h('div', {
      staticClass: "".concat(CLASS_NAME, "-sizer flex-grow-1"),
      style: {
        paddingBottom: this.padding,
        height: 0
      }
    });
    var $content = h('div', {
      staticClass: "".concat(CLASS_NAME, "-content flex-grow-1 w-100 mw-100"),
      style: {
        marginLeft: '-100%'
      }
    }, this.normalizeSlot());
    return h(this.tag, {
      staticClass: "".concat(CLASS_NAME, " d-flex")
    }, [$sizer, $content]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/aspect/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/aspect/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AspectPlugin": () => (/* binding */ AspectPlugin),
/* harmony export */   "BAspect": () => (/* reexport safe */ _aspect__WEBPACK_IMPORTED_MODULE_1__.BAspect)
/* harmony export */ });
/* harmony import */ var _aspect__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./aspect */ "./node_modules/bootstrap-vue/esm/components/aspect/aspect.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var AspectPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BAspect: _aspect__WEBPACK_IMPORTED_MODULE_1__.BAspect
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/avatar/avatar-group.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/avatar/avatar-group.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BAvatarGroup": () => (/* binding */ BAvatarGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_math__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/math */ "./node_modules/bootstrap-vue/esm/utils/math.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./avatar */ "./node_modules/bootstrap-vue/esm/components/avatar/avatar.js");







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  overlap: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, 0.3),
  // Child avatars will prefer this prop (if set) over their own
  rounded: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN_STRING, false),
  // Child avatars will always use this over their own size
  size: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  // Child avatars will prefer this prop (if set) over their own
  square: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div'),
  // Child avatars will prefer this variant over their own
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_AVATAR_GROUP); // --- Main component ---
// @vue/component

var BAvatarGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_AVATAR_GROUP,
  mixins: [_mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlotMixin],
  provide: function provide() {
    return {
      bvAvatarGroup: this
    };
  },
  props: props,
  computed: {
    computedSize: function computedSize() {
      return (0,_avatar__WEBPACK_IMPORTED_MODULE_5__.computeSize)(this.size);
    },
    overlapScale: function overlapScale() {
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_6__.mathMin)((0,_utils_math__WEBPACK_IMPORTED_MODULE_6__.mathMax)((0,_utils_number__WEBPACK_IMPORTED_MODULE_7__.toFloat)(this.overlap, 0), 0), 1) / 2;
    },
    paddingStyle: function paddingStyle() {
      var value = this.computedSize;
      value = value ? "calc(".concat(value, " * ").concat(this.overlapScale, ")") : null;
      return value ? {
        paddingLeft: value,
        paddingRight: value
      } : {};
    }
  },
  render: function render(h) {
    var $inner = h('div', {
      staticClass: 'b-avatar-group-inner',
      style: this.paddingStyle
    }, this.normalizeSlot());
    return h(this.tag, {
      staticClass: 'b-avatar-group',
      attrs: {
        role: 'group'
      }
    }, [$inner]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/avatar/avatar.js":
/*!********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/avatar/avatar.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BAvatar": () => (/* binding */ BAvatar),
/* harmony export */   "computeSize": () => (/* binding */ computeSize),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_router__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/router */ "./node_modules/bootstrap-vue/esm/utils/router.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _icons_icon__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../icons/icon */ "./node_modules/bootstrap-vue/esm/icons/icon.js");
/* harmony import */ var _icons_icons__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../icons/icons */ "./node_modules/bootstrap-vue/esm/icons/icons.js");
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../button/button */ "./node_modules/bootstrap-vue/esm/components/button/button.js");
/* harmony import */ var _link_link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../link/link */ "./node_modules/bootstrap-vue/esm/components/link/link.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }















 // --- Constants ---

var CLASS_NAME = 'b-avatar';
var SIZES = ['sm', null, 'lg'];
var FONT_SIZE_SCALE = 0.4;
var BADGE_FONT_SIZE_SCALE = FONT_SIZE_SCALE * 0.7; // --- Helper methods ---

var computeSize = function computeSize(value) {
  // Parse to number when value is a float-like string
  value = (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_0__.isString)(value) && (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_0__.isNumeric)(value) ? (0,_utils_number__WEBPACK_IMPORTED_MODULE_1__.toFloat)(value, 0) : value; // Convert all numbers to pixel values

  return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_0__.isNumber)(value) ? "".concat(value, "px") : value || null;
}; // --- Props ---

var linkProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.omit)(_link_link__WEBPACK_IMPORTED_MODULE_3__.props, ['active', 'event', 'routerTag']);
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.sortKeys)(_objectSpread(_objectSpread({}, linkProps), {}, {
  alt: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, 'avatar'),
  ariaLabel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
  badge: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN_STRING, false),
  badgeLeft: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
  badgeOffset: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
  badgeTop: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
  badgeVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, 'primary'),
  button: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
  buttonType: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, 'button'),
  icon: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
  rounded: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN_STRING, false),
  size: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_NUMBER_STRING),
  square: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
  src: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
  text: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, 'secondary')
})), _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_AVATAR); // --- Main component ---
// @vue/component

var BAvatar = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_7__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_AVATAR,
  mixins: [_mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__.normalizeSlotMixin],
  inject: {
    bvAvatarGroup: {
      default: null
    }
  },
  props: props,
  data: function data() {
    return {
      localSrc: this.src || null
    };
  },
  computed: {
    computedSize: function computedSize() {
      // Always use the avatar group size
      var bvAvatarGroup = this.bvAvatarGroup;
      return computeSize(bvAvatarGroup ? bvAvatarGroup.size : this.size);
    },
    computedVariant: function computedVariant() {
      var bvAvatarGroup = this.bvAvatarGroup;
      return bvAvatarGroup && bvAvatarGroup.variant ? bvAvatarGroup.variant : this.variant;
    },
    computedRounded: function computedRounded() {
      var bvAvatarGroup = this.bvAvatarGroup;
      var square = bvAvatarGroup && bvAvatarGroup.square ? true : this.square;
      var rounded = bvAvatarGroup && bvAvatarGroup.rounded ? bvAvatarGroup.rounded : this.rounded;
      return square ? '0' : rounded === '' ? true : rounded || 'circle';
    },
    fontStyle: function fontStyle() {
      var size = this.computedSize;
      var fontSize = SIZES.indexOf(size) === -1 ? "calc(".concat(size, " * ").concat(FONT_SIZE_SCALE, ")") : null;
      return fontSize ? {
        fontSize: fontSize
      } : {};
    },
    marginStyle: function marginStyle() {
      var size = this.computedSize,
          bvAvatarGroup = this.bvAvatarGroup;
      var overlapScale = bvAvatarGroup ? bvAvatarGroup.overlapScale : 0;
      var value = size && overlapScale ? "calc(".concat(size, " * -").concat(overlapScale, ")") : null;
      return value ? {
        marginLeft: value,
        marginRight: value
      } : {};
    },
    badgeStyle: function badgeStyle() {
      var size = this.computedSize,
          badgeTop = this.badgeTop,
          badgeLeft = this.badgeLeft,
          badgeOffset = this.badgeOffset;
      var offset = badgeOffset || '0px';
      return {
        fontSize: SIZES.indexOf(size) === -1 ? "calc(".concat(size, " * ").concat(BADGE_FONT_SIZE_SCALE, " )") : null,
        top: badgeTop ? offset : null,
        bottom: badgeTop ? null : offset,
        left: badgeLeft ? offset : null,
        right: badgeLeft ? null : offset
      };
    }
  },
  watch: {
    src: function src(newValue, oldValue) {
      if (newValue !== oldValue) {
        this.localSrc = newValue || null;
      }
    }
  },
  methods: {
    onImgError: function onImgError(event) {
      this.localSrc = null;
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_9__.EVENT_NAME_IMG_ERROR, event);
    },
    onClick: function onClick(event) {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_9__.EVENT_NAME_CLICK, event);
    }
  },
  render: function render(h) {
    var _class2;

    var variant = this.computedVariant,
        disabled = this.disabled,
        rounded = this.computedRounded,
        icon = this.icon,
        src = this.localSrc,
        text = this.text,
        fontStyle = this.fontStyle,
        marginStyle = this.marginStyle,
        size = this.computedSize,
        button = this.button,
        type = this.buttonType,
        badge = this.badge,
        badgeVariant = this.badgeVariant,
        badgeStyle = this.badgeStyle;
    var link = !button && (0,_utils_router__WEBPACK_IMPORTED_MODULE_10__.isLink)(this);
    var tag = button ? _button_button__WEBPACK_IMPORTED_MODULE_11__.BButton : link ? _link_link__WEBPACK_IMPORTED_MODULE_3__.BLink : 'span';
    var alt = this.alt;
    var ariaLabel = this.ariaLabel || null;
    var $content = null;

    if (this.hasNormalizedSlot()) {
      // Default slot overrides props
      $content = h('span', {
        staticClass: 'b-avatar-custom'
      }, [this.normalizeSlot()]);
    } else if (src) {
      $content = h('img', {
        style: variant ? {} : {
          width: '100%',
          height: '100%'
        },
        attrs: {
          src: src,
          alt: alt
        },
        on: {
          error: this.onImgError
        }
      });
      $content = h('span', {
        staticClass: 'b-avatar-img'
      }, [$content]);
    } else if (icon) {
      $content = h(_icons_icon__WEBPACK_IMPORTED_MODULE_12__.BIcon, {
        props: {
          icon: icon
        },
        attrs: {
          'aria-hidden': 'true',
          alt: alt
        }
      });
    } else if (text) {
      $content = h('span', {
        staticClass: 'b-avatar-text',
        style: fontStyle
      }, [h('span', text)]);
    } else {
      // Fallback default avatar content
      $content = h(_icons_icons__WEBPACK_IMPORTED_MODULE_13__.BIconPersonFill, {
        attrs: {
          'aria-hidden': 'true',
          alt: alt
        }
      });
    }

    var $badge = h();
    var hasBadgeSlot = this.hasNormalizedSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_BADGE);

    if (badge || badge === '' || hasBadgeSlot) {
      var badgeText = badge === true ? '' : badge;
      $badge = h('span', {
        staticClass: 'b-avatar-badge',
        class: _defineProperty({}, "badge-".concat(badgeVariant), badgeVariant),
        style: badgeStyle
      }, [hasBadgeSlot ? this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_BADGE) : badgeText]);
    }

    var componentData = {
      staticClass: CLASS_NAME,
      class: (_class2 = {}, _defineProperty(_class2, "".concat(CLASS_NAME, "-").concat(size), size && SIZES.indexOf(size) !== -1), _defineProperty(_class2, "badge-".concat(variant), !button && variant), _defineProperty(_class2, "rounded", rounded === true), _defineProperty(_class2, "rounded-".concat(rounded), rounded && rounded !== true), _defineProperty(_class2, "disabled", disabled), _class2),
      style: _objectSpread(_objectSpread({}, marginStyle), {}, {
        width: size,
        height: size
      }),
      attrs: {
        'aria-label': ariaLabel || null
      },
      props: button ? {
        variant: variant,
        disabled: disabled,
        type: type
      } : link ? (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.pluckProps)(linkProps, this) : {},
      on: button || link ? {
        click: this.onClick
      } : {}
    };
    return h(tag, componentData, [$content, $badge]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/avatar/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/avatar/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "AvatarPlugin": () => (/* binding */ AvatarPlugin),
/* harmony export */   "BAvatar": () => (/* reexport safe */ _avatar__WEBPACK_IMPORTED_MODULE_1__.BAvatar),
/* harmony export */   "BAvatarGroup": () => (/* reexport safe */ _avatar_group__WEBPACK_IMPORTED_MODULE_2__.BAvatarGroup)
/* harmony export */ });
/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./avatar */ "./node_modules/bootstrap-vue/esm/components/avatar/avatar.js");
/* harmony import */ var _avatar_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./avatar-group */ "./node_modules/bootstrap-vue/esm/components/avatar/avatar-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var AvatarPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BAvatar: _avatar__WEBPACK_IMPORTED_MODULE_1__.BAvatar,
    BAvatarGroup: _avatar_group__WEBPACK_IMPORTED_MODULE_2__.BAvatarGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/badge/badge.js":
/*!******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/badge/badge.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BBadge": () => (/* binding */ BBadge),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/router */ "./node_modules/bootstrap-vue/esm/utils/router.js");
/* harmony import */ var _link_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../link/link */ "./node_modules/bootstrap-vue/esm/components/link/link.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var linkProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.omit)(_link_link__WEBPACK_IMPORTED_MODULE_1__.props, ['event', 'routerTag']);
delete linkProps.href.default;
delete linkProps.to.default;
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.sortKeys)(_objectSpread(_objectSpread({}, linkProps), {}, {
  pill: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'span'),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'secondary')
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BADGE); // --- Main component ---
// @vue/component

var BBadge = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BADGE,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var active = props.active,
        disabled = props.disabled;
    var link = (0,_utils_router__WEBPACK_IMPORTED_MODULE_6__.isLink)(props);
    var tag = link ? _link_link__WEBPACK_IMPORTED_MODULE_1__.BLink : props.tag;
    var variant = props.variant || 'secondary';
    return h(tag, (0,_vue__WEBPACK_IMPORTED_MODULE_7__.mergeData)(data, {
      staticClass: 'badge',
      class: ["badge-".concat(variant), {
        'badge-pill': props.pill,
        active: active,
        disabled: disabled
      }],
      props: link ? (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.pluckProps)(linkProps, props) : {}
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/badge/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/badge/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BBadge": () => (/* reexport safe */ _badge__WEBPACK_IMPORTED_MODULE_1__.BBadge),
/* harmony export */   "BadgePlugin": () => (/* binding */ BadgePlugin)
/* harmony export */ });
/* harmony import */ var _badge__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./badge */ "./node_modules/bootstrap-vue/esm/components/badge/badge.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var BadgePlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BBadge: _badge__WEBPACK_IMPORTED_MODULE_1__.BBadge
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-item.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-item.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BBreadcrumbItem": () => (/* binding */ BBreadcrumbItem),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _breadcrumb_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./breadcrumb-link */ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-link.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)(_breadcrumb_link__WEBPACK_IMPORTED_MODULE_1__.props, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BREADCRUMB_ITEM); // --- Main component ---
// @vue/component

var BBreadcrumbItem = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BREADCRUMB_ITEM,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h('li', (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      staticClass: 'breadcrumb-item',
      class: {
        active: props.active
      }
    }), [h(_breadcrumb_link__WEBPACK_IMPORTED_MODULE_1__.BBreadcrumbLink, {
      props: props
    }, children)]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-link.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-link.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BBreadcrumbLink": () => (/* binding */ BBreadcrumbLink),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _link_link__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../link/link */ "./node_modules/bootstrap-vue/esm/components/link/link.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(_link_link__WEBPACK_IMPORTED_MODULE_2__.props, ['event', 'routerTag'])), {}, {
  ariaCurrent: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'location'),
  html: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  text: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING)
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BREADCRUMB_LINK); // --- Main component ---
// @vue/component

var BBreadcrumbLink = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BREADCRUMB_LINK,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var suppliedProps = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var active = suppliedProps.active;
    var tag = active ? 'span' : _link_link__WEBPACK_IMPORTED_MODULE_2__.BLink;
    var componentData = {
      attrs: {
        'aria-current': active ? suppliedProps.ariaCurrent : null
      },
      props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(props, suppliedProps)
    };

    if (!children) {
      componentData.domProps = (0,_utils_html__WEBPACK_IMPORTED_MODULE_6__.htmlOrText)(suppliedProps.html, suppliedProps.text);
    }

    return h(tag, (0,_vue__WEBPACK_IMPORTED_MODULE_7__.mergeData)(data, componentData), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb.js":
/*!****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BBreadcrumb": () => (/* binding */ BBreadcrumb),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _breadcrumb_item__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./breadcrumb-item */ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-item.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  items: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BREADCRUMB); // --- Main component ---
// @vue/component

var BBreadcrumb = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BREADCRUMB,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var items = props.items; // Build child nodes from items, if given

    var childNodes = children;

    if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_4__.isArray)(items)) {
      var activeDefined = false;
      childNodes = items.map(function (item, idx) {
        if (!(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_4__.isObject)(item)) {
          item = {
            text: (0,_utils_string__WEBPACK_IMPORTED_MODULE_5__.toString)(item)
          };
        } // Copy the value here so we can normalize it


        var _item = item,
            active = _item.active;

        if (active) {
          activeDefined = true;
        } // Auto-detect active by position in list


        if (!active && !activeDefined) {
          active = idx + 1 === items.length;
        }

        return h(_breadcrumb_item__WEBPACK_IMPORTED_MODULE_6__.BBreadcrumbItem, {
          props: _objectSpread(_objectSpread({}, item), {}, {
            active: active
          })
        });
      });
    }

    return h('ol', (0,_vue__WEBPACK_IMPORTED_MODULE_7__.mergeData)(data, {
      staticClass: 'breadcrumb'
    }), childNodes);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/breadcrumb/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/breadcrumb/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BBreadcrumb": () => (/* reexport safe */ _breadcrumb__WEBPACK_IMPORTED_MODULE_1__.BBreadcrumb),
/* harmony export */   "BBreadcrumbItem": () => (/* reexport safe */ _breadcrumb_item__WEBPACK_IMPORTED_MODULE_2__.BBreadcrumbItem),
/* harmony export */   "BBreadcrumbLink": () => (/* reexport safe */ _breadcrumb_link__WEBPACK_IMPORTED_MODULE_3__.BBreadcrumbLink),
/* harmony export */   "BreadcrumbPlugin": () => (/* binding */ BreadcrumbPlugin)
/* harmony export */ });
/* harmony import */ var _breadcrumb__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./breadcrumb */ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb.js");
/* harmony import */ var _breadcrumb_item__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./breadcrumb-item */ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-item.js");
/* harmony import */ var _breadcrumb_link__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./breadcrumb-link */ "./node_modules/bootstrap-vue/esm/components/breadcrumb/breadcrumb-link.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");




var BreadcrumbPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BBreadcrumb: _breadcrumb__WEBPACK_IMPORTED_MODULE_1__.BBreadcrumb,
    BBreadcrumbItem: _breadcrumb_item__WEBPACK_IMPORTED_MODULE_2__.BBreadcrumbItem,
    BBreadcrumbLink: _breadcrumb_link__WEBPACK_IMPORTED_MODULE_3__.BBreadcrumbLink
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/button-group/button-group.js":
/*!********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/button-group/button-group.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BButtonGroup": () => (/* binding */ BButtonGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../button/button */ "./node_modules/bootstrap-vue/esm/components/button/button.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.pick)(_button_button__WEBPACK_IMPORTED_MODULE_2__.props, ['size'])), {}, {
  ariaRole: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'group'),
  size: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'div'),
  vertical: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false)
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BUTTON_GROUP); // --- Main component ---
// @vue/component

var BButtonGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BUTTON_GROUP,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_6__.mergeData)(data, {
      class: _defineProperty({
        'btn-group': !props.vertical,
        'btn-group-vertical': props.vertical
      }, "btn-group-".concat(props.size), props.size),
      attrs: {
        role: props.ariaRole
      }
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/button-group/index.js":
/*!*************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/button-group/index.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BButtonGroup": () => (/* reexport safe */ _button_group__WEBPACK_IMPORTED_MODULE_1__.BButtonGroup),
/* harmony export */   "ButtonGroupPlugin": () => (/* binding */ ButtonGroupPlugin)
/* harmony export */ });
/* harmony import */ var _button_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./button-group */ "./node_modules/bootstrap-vue/esm/components/button-group/button-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var ButtonGroupPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BButtonGroup: _button_group__WEBPACK_IMPORTED_MODULE_1__.BButtonGroup,
    BBtnGroup: _button_group__WEBPACK_IMPORTED_MODULE_1__.BButtonGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/button-toolbar/button-toolbar.js":
/*!************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/button-toolbar/button-toolbar.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BButtonToolbar": () => (/* binding */ BButtonToolbar),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");







 // --- Constants ---

var ITEM_SELECTOR = ['.btn:not(.disabled):not([disabled]):not(.dropdown-item)', '.form-control:not(.disabled):not([disabled])', 'select:not(.disabled):not([disabled])', 'input[type="checkbox"]:not(.disabled)', 'input[type="radio"]:not(.disabled)'].join(','); // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  justify: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  keyNav: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BUTTON_TOOLBAR); // --- Main component ---
// @vue/component

var BButtonToolbar = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BUTTON_TOOLBAR,
  mixins: [_mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlotMixin],
  props: props,
  mounted: function mounted() {
    // Pre-set the tabindexes if the markup does not include
    // `tabindex="-1"` on the toolbar items
    if (this.keyNav) {
      this.getItems();
    }
  },
  methods: {
    getItems: function getItems() {
      var items = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.selectAll)(ITEM_SELECTOR, this.$el); // Ensure `tabindex="-1"` is set on every item

      items.forEach(function (item) {
        item.tabIndex = -1;
      });
      return items.filter(function (el) {
        return (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.isVisible)(el);
      });
    },
    focusFirst: function focusFirst() {
      var items = this.getItems();
      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.attemptFocus)(items[0]);
    },
    focusPrev: function focusPrev(event) {
      var items = this.getItems();
      var index = items.indexOf(event.target);

      if (index > -1) {
        items = items.slice(0, index).reverse();
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.attemptFocus)(items[0]);
      }
    },
    focusNext: function focusNext(event) {
      var items = this.getItems();
      var index = items.indexOf(event.target);

      if (index > -1) {
        items = items.slice(index + 1);
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.attemptFocus)(items[0]);
      }
    },
    focusLast: function focusLast() {
      var items = this.getItems().reverse();
      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.attemptFocus)(items[0]);
    },
    onFocusin: function onFocusin(event) {
      var $el = this.$el;

      if (event.target === $el && !(0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.contains)($el, event.relatedTarget)) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_6__.stopEvent)(event);
        this.focusFirst(event);
      }
    },
    onKeydown: function onKeydown(event) {
      var keyCode = event.keyCode,
          shiftKey = event.shiftKey;

      if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_7__.CODE_UP || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_7__.CODE_LEFT) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_6__.stopEvent)(event);
        shiftKey ? this.focusFirst(event) : this.focusPrev(event);
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_7__.CODE_DOWN || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_7__.CODE_RIGHT) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_6__.stopEvent)(event);
        shiftKey ? this.focusLast(event) : this.focusNext(event);
      }
    }
  },
  render: function render(h) {
    var keyNav = this.keyNav;
    return h('div', {
      staticClass: 'btn-toolbar',
      class: {
        'justify-content-between': this.justify
      },
      attrs: {
        role: 'toolbar',
        tabindex: keyNav ? '0' : null
      },
      on: keyNav ? {
        focusin: this.onFocusin,
        keydown: this.onKeydown
      } : {}
    }, [this.normalizeSlot()]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/button-toolbar/index.js":
/*!***************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/button-toolbar/index.js ***!
  \***************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BButtonToolbar": () => (/* reexport safe */ _button_toolbar__WEBPACK_IMPORTED_MODULE_1__.BButtonToolbar),
/* harmony export */   "ButtonToolbarPlugin": () => (/* binding */ ButtonToolbarPlugin)
/* harmony export */ });
/* harmony import */ var _button_toolbar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./button-toolbar */ "./node_modules/bootstrap-vue/esm/components/button-toolbar/button-toolbar.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var ButtonToolbarPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BButtonToolbar: _button_toolbar__WEBPACK_IMPORTED_MODULE_1__.BButtonToolbar,
    BBtnToolbar: _button_toolbar__WEBPACK_IMPORTED_MODULE_1__.BButtonToolbar
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/button/button-close.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/button/button-close.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BButtonClose": () => (/* binding */ BButtonClose),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_normalize_slot__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/normalize-slot */ "./node_modules/bootstrap-vue/esm/utils/normalize-slot.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }








 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  ariaLabel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Close'),
  content: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, '&times;'),
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  textVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BUTTON_CLOSE); // --- Main component ---
// @vue/component

var BButtonClose = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_BUTTON_CLOSE,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        slots = _ref.slots,
        scopedSlots = _ref.scopedSlots;
    var $slots = slots();
    var $scopedSlots = scopedSlots || {};
    var componentData = {
      staticClass: 'close',
      class: _defineProperty({}, "text-".concat(props.textVariant), props.textVariant),
      attrs: {
        type: 'button',
        disabled: props.disabled,
        'aria-label': props.ariaLabel ? String(props.ariaLabel) : null
      },
      on: {
        click: function click(event) {
          // Ensure click on button HTML content is also disabled

          /* istanbul ignore if: bug in JSDOM still emits click on inner element */
          if (props.disabled && (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_4__.isEvent)(event)) {
            (0,_utils_events__WEBPACK_IMPORTED_MODULE_5__.stopEvent)(event);
          }
        }
      }
    }; // Careful not to override the default slot with innerHTML

    if (!(0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_6__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_7__.SLOT_NAME_DEFAULT, $scopedSlots, $slots)) {
      componentData.domProps = {
        innerHTML: props.content
      };
    }

    return h('button', (0,_vue__WEBPACK_IMPORTED_MODULE_8__.mergeData)(data, componentData), (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_6__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_7__.SLOT_NAME_DEFAULT, {}, $scopedSlots, $slots));
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/button/button.js":
/*!********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/button/button.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BButton": () => (/* binding */ BButton),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_router__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/router */ "./node_modules/bootstrap-vue/esm/utils/router.js");
/* harmony import */ var _link_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../link/link */ "./node_modules/bootstrap-vue/esm/components/link/link.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }












 // --- Props ---

var linkProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.omit)(_link_link__WEBPACK_IMPORTED_MODULE_1__.props, ['event', 'routerTag']);
delete linkProps.href.default;
delete linkProps.to.default;
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.sortKeys)(_objectSpread(_objectSpread({}, linkProps), {}, {
  block: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  pill: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  // Tri-state: `true`, `false` or `null`
  // => On, off, not a toggle
  pressed: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, null),
  size: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  squared: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'button'),
  type: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'button'),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'secondary')
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BUTTON); // --- Helper methods ---
// Focus handler for toggle buttons
// Needs class of 'focus' when focused

var handleFocus = function handleFocus(event) {
  if (event.type === 'focusin') {
    (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.addClass)(event.target, 'focus');
  } else if (event.type === 'focusout') {
    (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.removeClass)(event.target, 'focus');
  }
}; // Is the requested button a link?
// If tag prop is set to `a`, we use a <b-link> to get proper disabled handling


var isLink = function isLink(props) {
  return (0,_utils_router__WEBPACK_IMPORTED_MODULE_6__.isLink)(props) || (0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.isTag)(props.tag, 'a');
}; // Is the button to be a toggle button?


var isToggle = function isToggle(props) {
  return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_7__.isBoolean)(props.pressed);
}; // Is the button "really" a button?


var isButton = function isButton(props) {
  return !(isLink(props) || props.tag && !(0,_utils_dom__WEBPACK_IMPORTED_MODULE_5__.isTag)(props.tag, 'button'));
}; // Is the requested tag not a button or link?


var isNonStandardTag = function isNonStandardTag(props) {
  return !isLink(props) && !isButton(props);
}; // Compute required classes (non static classes)


var computeClass = function computeClass(props) {
  var _ref;

  return ["btn-".concat(props.variant || 'secondary'), (_ref = {}, _defineProperty(_ref, "btn-".concat(props.size), props.size), _defineProperty(_ref, 'btn-block', props.block), _defineProperty(_ref, 'rounded-pill', props.pill), _defineProperty(_ref, 'rounded-0', props.squared && !props.pill), _defineProperty(_ref, "disabled", props.disabled), _defineProperty(_ref, "active", props.pressed), _ref)];
}; // Compute the link props to pass to b-link (if required)


var computeLinkProps = function computeLinkProps(props) {
  return isLink(props) ? (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.pluckProps)(linkProps, props) : {};
}; // Compute the attributes for a button


var computeAttrs = function computeAttrs(props, data) {
  var button = isButton(props);
  var link = isLink(props);
  var toggle = isToggle(props);
  var nonStandardTag = isNonStandardTag(props);
  var hashLink = link && props.href === '#';
  var role = data.attrs && data.attrs.role ? data.attrs.role : null;
  var tabindex = data.attrs ? data.attrs.tabindex : null;

  if (nonStandardTag || hashLink) {
    tabindex = '0';
  }

  return {
    // Type only used for "real" buttons
    type: button && !link ? props.type : null,
    // Disabled only set on "real" buttons
    disabled: button ? props.disabled : null,
    // We add a role of button when the tag is not a link or button for ARIA
    // Don't bork any role provided in `data.attrs` when `isLink` or `isButton`
    // Except when link has `href` of `#`
    role: nonStandardTag || hashLink ? 'button' : role,
    // We set the `aria-disabled` state for non-standard tags
    'aria-disabled': nonStandardTag ? String(props.disabled) : null,
    // For toggles, we need to set the pressed state for ARIA
    'aria-pressed': toggle ? String(props.pressed) : null,
    // `autocomplete="off"` is needed in toggle mode to prevent some browsers
    // from remembering the previous setting when using the back button
    autocomplete: toggle ? 'off' : null,
    // `tabindex` is used when the component is not a button
    // Links are tabbable, but don't allow disabled, while non buttons or links
    // are not tabbable, so we mimic that functionality by disabling tabbing
    // when disabled, and adding a `tabindex="0"` to non buttons or non links
    tabindex: props.disabled && !button ? '-1' : tabindex
  };
}; // --- Main component ---
// @vue/component


var BButton = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_8__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_BUTTON,
  functional: true,
  props: props,
  render: function render(h, _ref2) {
    var props = _ref2.props,
        data = _ref2.data,
        listeners = _ref2.listeners,
        children = _ref2.children;
    var toggle = isToggle(props);
    var link = isLink(props);
    var nonStandardTag = isNonStandardTag(props);
    var hashLink = link && props.href === '#';
    var on = {
      keydown: function keydown(event) {
        // When the link is a `href="#"` or a non-standard tag (has `role="button"`),
        // we add a keydown handlers for CODE_SPACE/CODE_ENTER

        /* istanbul ignore next */
        if (props.disabled || !(nonStandardTag || hashLink)) {
          return;
        }

        var keyCode = event.keyCode; // Add CODE_SPACE handler for `href="#"` and CODE_ENTER handler for non-standard tags

        if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_9__.CODE_SPACE || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_9__.CODE_ENTER && nonStandardTag) {
          var target = event.currentTarget || event.target;
          (0,_utils_events__WEBPACK_IMPORTED_MODULE_10__.stopEvent)(event, {
            propagation: false
          });
          target.click();
        }
      },
      click: function click(event) {
        /* istanbul ignore if: blink/button disabled should handle this */
        if (props.disabled && (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_7__.isEvent)(event)) {
          (0,_utils_events__WEBPACK_IMPORTED_MODULE_10__.stopEvent)(event);
        } else if (toggle && listeners && listeners['update:pressed']) {
          // Send `.sync` updates to any "pressed" prop (if `.sync` listeners)
          // `concat()` will normalize the value to an array without
          // double wrapping an array value in an array
          (0,_utils_array__WEBPACK_IMPORTED_MODULE_11__.concat)(listeners['update:pressed']).forEach(function (fn) {
            if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_7__.isFunction)(fn)) {
              fn(!props.pressed);
            }
          });
        }
      }
    };

    if (toggle) {
      on.focusin = handleFocus;
      on.focusout = handleFocus;
    }

    var componentData = {
      staticClass: 'btn',
      class: computeClass(props),
      props: computeLinkProps(props),
      attrs: computeAttrs(props, data),
      on: on
    };
    return h(link ? _link_link__WEBPACK_IMPORTED_MODULE_1__.BLink : props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_12__.mergeData)(data, componentData), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/button/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/button/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BButton": () => (/* reexport safe */ _button__WEBPACK_IMPORTED_MODULE_1__.BButton),
/* harmony export */   "BButtonClose": () => (/* reexport safe */ _button_close__WEBPACK_IMPORTED_MODULE_2__.BButtonClose),
/* harmony export */   "ButtonPlugin": () => (/* binding */ ButtonPlugin)
/* harmony export */ });
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./button */ "./node_modules/bootstrap-vue/esm/components/button/button.js");
/* harmony import */ var _button_close__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./button-close */ "./node_modules/bootstrap-vue/esm/components/button/button-close.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var ButtonPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BButton: _button__WEBPACK_IMPORTED_MODULE_1__.BButton,
    BBtn: _button__WEBPACK_IMPORTED_MODULE_1__.BButton,
    BButtonClose: _button_close__WEBPACK_IMPORTED_MODULE_2__.BButtonClose,
    BBtnClose: _button_close__WEBPACK_IMPORTED_MODULE_2__.BButtonClose
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/calendar/calendar.js":
/*!************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/calendar/calendar.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCalendar": () => (/* binding */ BCalendar),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_date__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/date */ "./node_modules/bootstrap-vue/esm/constants/date.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_date__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/date */ "./node_modules/bootstrap-vue/esm/utils/date.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_locale__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/locale */ "./node_modules/bootstrap-vue/esm/utils/locale.js");
/* harmony import */ var _utils_loose_equal__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../utils/loose-equal */ "./node_modules/bootstrap-vue/esm/utils/loose-equal.js");
/* harmony import */ var _utils_math__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/math */ "./node_modules/bootstrap-vue/esm/utils/math.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _mixins_attrs__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../mixins/attrs */ "./node_modules/bootstrap-vue/esm/mixins/attrs.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _icons_icons__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../icons/icons */ "./node_modules/bootstrap-vue/esm/icons/icons.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

























 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_DATE_STRING
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // --- Props ---


var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.sortKeys)(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_4__.props), modelProps), {}, {
  ariaControls: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  // Makes calendar the full width of its parent container
  block: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  dateDisabledFn: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_FUNCTION),
  // `Intl.DateTimeFormat` object
  dateFormatOptions: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_OBJECT, {
    year: _constants_date__WEBPACK_IMPORTED_MODULE_5__.DATE_FORMAT_NUMERIC,
    month: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_LONG,
    day: _constants_date__WEBPACK_IMPORTED_MODULE_5__.DATE_FORMAT_NUMERIC,
    weekday: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_LONG
  }),
  // Function to set a class of (classes) on the date cell
  // if passed a string or an array
  // TODO:
  //   If the function returns an object, look for class prop for classes,
  //   and other props for handling events/details/descriptions
  dateInfoFn: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_FUNCTION),
  // 'ltr', 'rtl', or `null` (for auto detect)
  direction: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // When `true`, renders a comment node, but keeps the component instance active
  // Mainly for <b-form-date>, so that we can get the component's value and locale
  // But we might just use separate date formatters, using the resolved locale
  // (adjusted for the gregorian calendar)
  hidden: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // When `true` makes the selected date header `sr-only`
  hideHeader: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // This specifies the calendar year/month/day that will be shown when
  // first opening the datepicker if no v-model value is provided
  // Default is the current date (or `min`/`max`)
  initialDate: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_DATE_STRING),
  // Labels for buttons and keyboard shortcuts
  labelCalendar: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Calendar'),
  labelCurrentMonth: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Current month'),
  labelHelp: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Use cursor keys to navigate calendar dates'),
  labelNav: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Calendar navigation'),
  labelNextDecade: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Next decade'),
  labelNextMonth: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Next month'),
  labelNextYear: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Next year'),
  labelNoDateSelected: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'No date selected'),
  labelPrevDecade: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Previous decade'),
  labelPrevMonth: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Previous month'),
  labelPrevYear: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Previous year'),
  labelSelected: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Selected date'),
  labelToday: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Today'),
  // Locale(s) to use
  // Default is to use page/browser default setting
  locale: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_STRING),
  max: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_DATE_STRING),
  min: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_DATE_STRING),
  // Variant color to use for the navigation buttons
  navButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'secondary'),
  // Disable highlighting today's date
  noHighlightToday: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  noKeyNav: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  readonly: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  roleDescription: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  // Variant color to use for the selected date
  selectedVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'primary'),
  // When `true` enables the decade navigation buttons
  showDecadeNav: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Day of week to start calendar on
  // `0` (Sunday), `1` (Monday), ... `6` (Saturday)
  startWeekday: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, 0),
  // Variant color to use for today's date (defaults to `selectedVariant`)
  todayVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  // Always return the `v-model` value as a date object
  valueAsDate: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Format of the weekday names at the top of the calendar
  // `short` is typically a 3 letter abbreviation,
  // `narrow` is typically a single letter
  // `long` is the full week day name
  // Although some locales may override this (i.e `ar`, etc.)
  weekdayHeaderFormat: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_SHORT, function (value) {
    return (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.arrayIncludes)([_constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_LONG, _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_SHORT, _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_NARROW], value);
  }),
  // Has no effect if prop `block` is set
  width: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, '270px')
})), _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_CALENDAR); // --- Main component ---
// @vue/component

var BCalendar = _vue__WEBPACK_IMPORTED_MODULE_8__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_CALENDAR,
  // Mixin order is important!
  mixins: [_mixins_attrs__WEBPACK_IMPORTED_MODULE_9__.attrsMixin, _mixins_id__WEBPACK_IMPORTED_MODULE_4__.idMixin, modelMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_10__.normalizeSlotMixin],
  props: props,
  data: function data() {
    var selected = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this[MODEL_PROP_NAME]) || '';
    return {
      // Selected date
      selectedYMD: selected,
      // Date in calendar grid that has `tabindex` of `0`
      activeYMD: selected || (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.constrainDate)(this.initialDate || this.getToday()), this.min, this.max),
      // Will be true if the calendar grid has/contains focus
      gridHasFocus: false,
      // Flag to enable the `aria-live` region(s) after mount
      // to prevent screen reader "outbursts" when mounting
      isLive: false
    };
  },
  computed: {
    valueId: function valueId() {
      return this.safeId();
    },
    widgetId: function widgetId() {
      return this.safeId('_calendar-wrapper_');
    },
    navId: function navId() {
      return this.safeId('_calendar-nav_');
    },
    gridId: function gridId() {
      return this.safeId('_calendar-grid_');
    },
    gridCaptionId: function gridCaptionId() {
      return this.safeId('_calendar-grid-caption_');
    },
    gridHelpId: function gridHelpId() {
      return this.safeId('_calendar-grid-help_');
    },
    activeId: function activeId() {
      return this.activeYMD ? this.safeId("_cell-".concat(this.activeYMD, "_")) : null;
    },
    // TODO: Use computed props to convert `YYYY-MM-DD` to `Date` object
    selectedDate: function selectedDate() {
      // Selected as a `Date` object
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(this.selectedYMD);
    },
    activeDate: function activeDate() {
      // Active as a `Date` object
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(this.activeYMD);
    },
    computedMin: function computedMin() {
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(this.min);
    },
    computedMax: function computedMax() {
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(this.max);
    },
    computedWeekStarts: function computedWeekStarts() {
      // `startWeekday` is a prop (constrained to `0` through `6`)
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_12__.mathMax)((0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toInteger)(this.startWeekday, 0), 0) % 7;
    },
    computedLocale: function computedLocale() {
      // Returns the resolved locale used by the calendar
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.resolveLocale)((0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.concat)(this.locale).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_14__.identity), _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_GREGORY);
    },
    computedDateDisabledFn: function computedDateDisabledFn() {
      var dateDisabledFn = this.dateDisabledFn;
      return (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.hasPropFunction)(dateDisabledFn) ? dateDisabledFn : function () {
        return false;
      };
    },
    // TODO: Change `dateInfoFn` to handle events and notes as well as classes
    computedDateInfoFn: function computedDateInfoFn() {
      var dateInfoFn = this.dateInfoFn;
      return (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.hasPropFunction)(dateInfoFn) ? dateInfoFn : function () {
        return {};
      };
    },
    calendarLocale: function calendarLocale() {
      // This locale enforces the gregorian calendar (for use in formatter functions)
      // Needed because IE 11 resolves `ar-IR` as islamic-civil calendar
      // and IE 11 (and some other browsers) do not support the `calendar` option
      // And we currently only support the gregorian calendar
      var fmt = new Intl.DateTimeFormat(this.computedLocale, {
        calendar: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_GREGORY
      });
      var calendar = fmt.resolvedOptions().calendar;
      var locale = fmt.resolvedOptions().locale;
      /* istanbul ignore if: mainly for IE 11 and a few other browsers, hard to test in JSDOM */

      if (calendar !== _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_GREGORY) {
        // Ensure the locale requests the gregorian calendar
        // Mainly for IE 11, and currently we can't handle non-gregorian calendars
        // TODO: Should we always return this value?
        locale = locale.replace(/-u-.+$/i, '').concat('-u-ca-gregory');
      }

      return locale;
    },
    calendarYear: function calendarYear() {
      return this.activeDate.getFullYear();
    },
    calendarMonth: function calendarMonth() {
      return this.activeDate.getMonth();
    },
    calendarFirstDay: function calendarFirstDay() {
      // We set the time for this date to 12pm to work around
      // date formatting issues in Firefox and Safari
      // See: https://github.com/bootstrap-vue/bootstrap-vue/issues/5818
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(this.calendarYear, this.calendarMonth, 1, 12);
    },
    calendarDaysInMonth: function calendarDaysInMonth() {
      // We create a new date as to not mutate the original
      var date = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(this.calendarFirstDay);
      date.setMonth(date.getMonth() + 1, 0);
      return date.getDate();
    },
    computedVariant: function computedVariant() {
      return "btn-".concat(this.selectedVariant || 'primary');
    },
    computedTodayVariant: function computedTodayVariant() {
      return "btn-outline-".concat(this.todayVariant || this.selectedVariant || 'primary');
    },
    computedNavButtonVariant: function computedNavButtonVariant() {
      return "btn-outline-".concat(this.navButtonVariant || 'primary');
    },
    isRTL: function isRTL() {
      // `true` if the language requested is RTL
      var dir = (0,_utils_string__WEBPACK_IMPORTED_MODULE_15__.toString)(this.direction).toLowerCase();

      if (dir === 'rtl') {
        /* istanbul ignore next */
        return true;
      } else if (dir === 'ltr') {
        /* istanbul ignore next */
        return false;
      }

      return (0,_utils_locale__WEBPACK_IMPORTED_MODULE_16__.isLocaleRTL)(this.computedLocale);
    },
    context: function context() {
      var selectedYMD = this.selectedYMD,
          activeYMD = this.activeYMD;
      var selectedDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(selectedYMD);
      var activeDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(activeYMD);
      return {
        // The current value of the `v-model`
        selectedYMD: selectedYMD,
        selectedDate: selectedDate,
        selectedFormatted: selectedDate ? this.formatDateString(selectedDate) : this.labelNoDateSelected,
        // Which date cell is considered active due to navigation
        activeYMD: activeYMD,
        activeDate: activeDate,
        activeFormatted: activeDate ? this.formatDateString(activeDate) : '',
        // `true` if the date is disabled (when using keyboard navigation)
        disabled: this.dateDisabled(activeDate),
        // Locales used in formatting dates
        locale: this.computedLocale,
        calendarLocale: this.calendarLocale,
        rtl: this.isRTL
      };
    },
    // Computed props that return a function reference
    dateOutOfRange: function dateOutOfRange() {
      // Check whether a date is within the min/max range
      // Returns a new function ref if the pops change
      // We do this as we need to trigger the calendar computed prop
      // to update when these props update
      var min = this.computedMin,
          max = this.computedMax;
      return function (date) {
        // Handle both `YYYY-MM-DD` and `Date` objects
        date = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(date);
        return min && date < min || max && date > max;
      };
    },
    dateDisabled: function dateDisabled() {
      var _this = this;

      // Returns a function for validating if a date is within range
      // We grab this variables first to ensure a new function ref
      // is generated when the props value changes
      // We do this as we need to trigger the calendar computed prop
      // to update when these props update
      var rangeFn = this.dateOutOfRange; // Return the function ref

      return function (date) {
        // Handle both `YYYY-MM-DD` and `Date` objects
        date = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(date);
        var ymd = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(date);
        return !!(rangeFn(date) || _this.computedDateDisabledFn(ymd, date));
      };
    },
    // Computed props that return date formatter functions
    formatDateString: function formatDateString() {
      // Returns a date formatter function
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDateFormatter)(this.calendarLocale, _objectSpread(_objectSpread({
        // Ensure we have year, month, day shown for screen readers/ARIA
        // If users really want to leave one of these out, they can
        // pass `undefined` for the property value
        year: _constants_date__WEBPACK_IMPORTED_MODULE_5__.DATE_FORMAT_NUMERIC,
        month: _constants_date__WEBPACK_IMPORTED_MODULE_5__.DATE_FORMAT_2_DIGIT,
        day: _constants_date__WEBPACK_IMPORTED_MODULE_5__.DATE_FORMAT_2_DIGIT
      }, this.dateFormatOptions), {}, {
        // Ensure hours/minutes/seconds are not shown
        // As we do not support the time portion (yet)
        hour: undefined,
        minute: undefined,
        second: undefined,
        // Ensure calendar is gregorian
        calendar: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_GREGORY
      }));
    },
    formatYearMonth: function formatYearMonth() {
      // Returns a date formatter function
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDateFormatter)(this.calendarLocale, {
        year: _constants_date__WEBPACK_IMPORTED_MODULE_5__.DATE_FORMAT_NUMERIC,
        month: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_LONG,
        calendar: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_GREGORY
      });
    },
    formatWeekdayName: function formatWeekdayName() {
      // Long weekday name for weekday header aria-label
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDateFormatter)(this.calendarLocale, {
        weekday: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_LONG,
        calendar: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_GREGORY
      });
    },
    formatWeekdayNameShort: function formatWeekdayNameShort() {
      // Weekday header cell format
      // defaults to 'short' 3 letter days, where possible
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDateFormatter)(this.calendarLocale, {
        weekday: this.weekdayHeaderFormat || _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_SHORT,
        calendar: _constants_date__WEBPACK_IMPORTED_MODULE_5__.CALENDAR_GREGORY
      });
    },
    formatDay: function formatDay() {
      // Calendar grid day number formatter
      // We don't use DateTimeFormatter here as it can place extra
      // character(s) after the number (i.e the `zh` locale)
      var nf = new Intl.NumberFormat([this.computedLocale], {
        style: 'decimal',
        minimumIntegerDigits: 1,
        minimumFractionDigits: 0,
        maximumFractionDigits: 0,
        notation: 'standard'
      }); // Return a formatter function instance

      return function (date) {
        return nf.format(date.getDate());
      };
    },
    // Disabled states for the nav buttons
    prevDecadeDisabled: function prevDecadeDisabled() {
      var min = this.computedMin;
      return this.disabled || min && (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.lastDateOfMonth)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneDecadeAgo)(this.activeDate)) < min;
    },
    prevYearDisabled: function prevYearDisabled() {
      var min = this.computedMin;
      return this.disabled || min && (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.lastDateOfMonth)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneYearAgo)(this.activeDate)) < min;
    },
    prevMonthDisabled: function prevMonthDisabled() {
      var min = this.computedMin;
      return this.disabled || min && (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.lastDateOfMonth)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneMonthAgo)(this.activeDate)) < min;
    },
    thisMonthDisabled: function thisMonthDisabled() {
      // TODO: We could/should check if today is out of range
      return this.disabled;
    },
    nextMonthDisabled: function nextMonthDisabled() {
      var max = this.computedMax;
      return this.disabled || max && (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.firstDateOfMonth)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneMonthAhead)(this.activeDate)) > max;
    },
    nextYearDisabled: function nextYearDisabled() {
      var max = this.computedMax;
      return this.disabled || max && (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.firstDateOfMonth)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneYearAhead)(this.activeDate)) > max;
    },
    nextDecadeDisabled: function nextDecadeDisabled() {
      var max = this.computedMax;
      return this.disabled || max && (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.firstDateOfMonth)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneDecadeAhead)(this.activeDate)) > max;
    },
    // Calendar dates generation
    calendar: function calendar() {
      var matrix = [];
      var firstDay = this.calendarFirstDay;
      var calendarYear = firstDay.getFullYear();
      var calendarMonth = firstDay.getMonth();
      var daysInMonth = this.calendarDaysInMonth;
      var startIndex = firstDay.getDay(); // `0`..`6`

      var weekOffset = (this.computedWeekStarts > startIndex ? 7 : 0) - this.computedWeekStarts; // Build the calendar matrix

      var currentDay = 0 - weekOffset - startIndex;

      for (var week = 0; week < 6 && currentDay < daysInMonth; week++) {
        // For each week
        matrix[week] = []; // The following could be a map function

        for (var j = 0; j < 7; j++) {
          // For each day in week
          currentDay++;
          var date = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(calendarYear, calendarMonth, currentDay);
          var month = date.getMonth();
          var dayYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(date);
          var dayDisabled = this.dateDisabled(date); // TODO: This could be a normalizer method

          var dateInfo = this.computedDateInfoFn(dayYMD, (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(dayYMD));
          dateInfo = (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_17__.isString)(dateInfo) || (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_17__.isArray)(dateInfo) ?
          /* istanbul ignore next */
          {
            class: dateInfo
          } : (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_17__.isPlainObject)(dateInfo) ? _objectSpread({
            class: ''
          }, dateInfo) :
          /* istanbul ignore next */
          {
            class: ''
          };
          matrix[week].push({
            ymd: dayYMD,
            // Cell content
            day: this.formatDay(date),
            label: this.formatDateString(date),
            // Flags for styling
            isThisMonth: month === calendarMonth,
            isDisabled: dayDisabled,
            // TODO: Handle other dateInfo properties such as notes/events
            info: dateInfo
          });
        }
      }

      return matrix;
    },
    calendarHeadings: function calendarHeadings() {
      var _this2 = this;

      return this.calendar[0].map(function (d) {
        return {
          text: _this2.formatWeekdayNameShort((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(d.ymd)),
          label: _this2.formatWeekdayName((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(d.ymd))
        };
      });
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue, oldValue) {
    var selected = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(newValue) || '';
    var old = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(oldValue) || '';

    if (!(0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.datesEqual)(selected, old)) {
      this.activeYMD = selected || this.activeYMD;
      this.selectedYMD = selected;
    }
  }), _defineProperty(_watch, "selectedYMD", function selectedYMD(newYMD, oldYMD) {
    // TODO:
    //   Should we compare to `formatYMD(this.value)` and emit
    //   only if they are different?
    if (newYMD !== oldYMD) {
      this.$emit(MODEL_EVENT_NAME, this.valueAsDate ? (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(newYMD) || null : newYMD || '');
    }
  }), _defineProperty(_watch, "context", function context(newValue, oldValue) {
    if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_18__.looseEqual)(newValue, oldValue)) {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_19__.EVENT_NAME_CONTEXT, newValue);
    }
  }), _defineProperty(_watch, "hidden", function hidden(newValue) {
    // Reset the active focused day when hidden
    this.activeYMD = this.selectedYMD || (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this[MODEL_PROP_NAME] || this.constrainDate(this.initialDate || this.getToday())); // Enable/disable the live regions

    this.setLive(!newValue);
  }), _watch),
  created: function created() {
    var _this3 = this;

    this.$nextTick(function () {
      _this3.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_19__.EVENT_NAME_CONTEXT, _this3.context);
    });
  },
  mounted: function mounted() {
    this.setLive(true);
  },

  /* istanbul ignore next */
  activated: function activated() {
    this.setLive(true);
  },

  /* istanbul ignore next */
  deactivated: function deactivated() {
    this.setLive(false);
  },
  beforeDestroy: function beforeDestroy() {
    this.setLive(false);
  },
  methods: {
    // Public method(s)
    focus: function focus() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_20__.attemptFocus)(this.$refs.grid);
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_20__.attemptBlur)(this.$refs.grid);
      }
    },
    // Private methods
    setLive: function setLive(on) {
      var _this4 = this;

      if (on) {
        this.$nextTick(function () {
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_20__.requestAF)(function () {
            _this4.isLive = true;
          });
        });
      } else {
        this.isLive = false;
      }
    },
    getToday: function getToday() {
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)());
    },
    constrainDate: function constrainDate(date) {
      // Constrains a date between min and max
      // returns a new `Date` object instance
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.constrainDate)(date, this.computedMin, this.computedMax);
    },
    emitSelected: function emitSelected(date) {
      var _this5 = this;

      // Performed in a `$nextTick()` to (probably) ensure
      // the input event has emitted first
      this.$nextTick(function () {
        _this5.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_19__.EVENT_NAME_SELECTED, (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(date) || '', (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(date) || null);
      });
    },
    // Event handlers
    setGridFocusFlag: function setGridFocusFlag(event) {
      // Sets the gridHasFocus flag to make date "button" look focused
      this.gridHasFocus = !this.disabled && event.type === 'focus';
    },
    onKeydownWrapper: function onKeydownWrapper(event) {
      // Calendar keyboard navigation
      // Handles PAGEUP/PAGEDOWN/END/HOME/LEFT/UP/RIGHT/DOWN
      // Focuses grid after updating
      if (this.noKeyNav) {
        /* istanbul ignore next */
        return;
      }

      var altKey = event.altKey,
          ctrlKey = event.ctrlKey,
          keyCode = event.keyCode;

      if (!(0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.arrayIncludes)([_constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_PAGEUP, _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_PAGEDOWN, _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_END, _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_HOME, _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_LEFT, _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_UP, _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_RIGHT, _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_DOWN], keyCode)) {
        /* istanbul ignore next */
        return;
      }

      (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.stopEvent)(event);
      var activeDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(this.activeDate);
      var checkDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(this.activeDate);
      var day = activeDate.getDate();
      var constrainedToday = this.constrainDate(this.getToday());
      var isRTL = this.isRTL;

      if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_PAGEUP) {
        // PAGEUP - Previous month/year
        activeDate = (altKey ? ctrlKey ? _utils_date__WEBPACK_IMPORTED_MODULE_11__.oneDecadeAgo : _utils_date__WEBPACK_IMPORTED_MODULE_11__.oneYearAgo : _utils_date__WEBPACK_IMPORTED_MODULE_11__.oneMonthAgo)(activeDate); // We check the first day of month to be in rage

        checkDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(activeDate);
        checkDate.setDate(1);
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_PAGEDOWN) {
        // PAGEDOWN - Next month/year
        activeDate = (altKey ? ctrlKey ? _utils_date__WEBPACK_IMPORTED_MODULE_11__.oneDecadeAhead : _utils_date__WEBPACK_IMPORTED_MODULE_11__.oneYearAhead : _utils_date__WEBPACK_IMPORTED_MODULE_11__.oneMonthAhead)(activeDate); // We check the last day of month to be in rage

        checkDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(activeDate);
        checkDate.setMonth(checkDate.getMonth() + 1);
        checkDate.setDate(0);
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_LEFT) {
        // LEFT - Previous day (or next day for RTL)
        activeDate.setDate(day + (isRTL ? 1 : -1));
        activeDate = this.constrainDate(activeDate);
        checkDate = activeDate;
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_RIGHT) {
        // RIGHT - Next day (or previous day for RTL)
        activeDate.setDate(day + (isRTL ? -1 : 1));
        activeDate = this.constrainDate(activeDate);
        checkDate = activeDate;
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_UP) {
        // UP - Previous week
        activeDate.setDate(day - 7);
        activeDate = this.constrainDate(activeDate);
        checkDate = activeDate;
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_DOWN) {
        // DOWN - Next week
        activeDate.setDate(day + 7);
        activeDate = this.constrainDate(activeDate);
        checkDate = activeDate;
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_HOME) {
        // HOME - Today
        activeDate = constrainedToday;
        checkDate = activeDate;
      } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_END) {
        // END - Selected date, or today if no selected date
        activeDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(this.selectedDate) || constrainedToday;
        checkDate = activeDate;
      }

      if (!this.dateOutOfRange(checkDate) && !(0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.datesEqual)(activeDate, this.activeDate)) {
        // We only jump to date if within min/max
        // We don't check for individual disabled dates though (via user function)
        this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(activeDate);
      } // Ensure grid is focused


      this.focus();
    },
    onKeydownGrid: function onKeydownGrid(event) {
      // Pressing enter/space on grid to select active date
      var keyCode = event.keyCode;
      var activeDate = this.activeDate;

      if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_ENTER || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_21__.CODE_SPACE) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.stopEvent)(event);

        if (!this.disabled && !this.readonly && !this.dateDisabled(activeDate)) {
          this.selectedYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(activeDate);
          this.emitSelected(activeDate);
        } // Ensure grid is focused


        this.focus();
      }
    },
    onClickDay: function onClickDay(day) {
      // Clicking on a date "button" to select it
      var selectedDate = this.selectedDate,
          activeDate = this.activeDate;
      var clickedDate = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.parseYMD)(day.ymd);

      if (!this.disabled && !day.isDisabled && !this.dateDisabled(clickedDate)) {
        if (!this.readonly) {
          // If readonly mode, we don't set the selected date, just the active date
          // If the clicked date is equal to the already selected date, we don't update the model
          this.selectedYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.datesEqual)(clickedDate, selectedDate) ? selectedDate : clickedDate);
          this.emitSelected(clickedDate);
        }

        this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.datesEqual)(clickedDate, activeDate) ? activeDate : (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.createDate)(clickedDate)); // Ensure grid is focused

        this.focus();
      }
    },
    gotoPrevDecade: function gotoPrevDecade() {
      this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.constrainDate((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneDecadeAgo)(this.activeDate)));
    },
    gotoPrevYear: function gotoPrevYear() {
      this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.constrainDate((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneYearAgo)(this.activeDate)));
    },
    gotoPrevMonth: function gotoPrevMonth() {
      this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.constrainDate((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneMonthAgo)(this.activeDate)));
    },
    gotoCurrentMonth: function gotoCurrentMonth() {
      // TODO: Maybe this goto date should be configurable?
      this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.constrainDate(this.getToday()));
    },
    gotoNextMonth: function gotoNextMonth() {
      this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.constrainDate((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneMonthAhead)(this.activeDate)));
    },
    gotoNextYear: function gotoNextYear() {
      this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.constrainDate((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneYearAhead)(this.activeDate)));
    },
    gotoNextDecade: function gotoNextDecade() {
      this.activeYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.constrainDate((0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.oneDecadeAhead)(this.activeDate)));
    },
    onHeaderClick: function onHeaderClick() {
      if (!this.disabled) {
        this.activeYMD = this.selectedYMD || (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.getToday());
        this.focus();
      }
    }
  },
  render: function render(h) {
    var _this6 = this;

    // If `hidden` prop is set, render just a placeholder node
    if (this.hidden) {
      return h();
    }

    var valueId = this.valueId,
        widgetId = this.widgetId,
        navId = this.navId,
        gridId = this.gridId,
        gridCaptionId = this.gridCaptionId,
        gridHelpId = this.gridHelpId,
        activeId = this.activeId,
        disabled = this.disabled,
        noKeyNav = this.noKeyNav,
        isLive = this.isLive,
        isRTL = this.isRTL,
        activeYMD = this.activeYMD,
        selectedYMD = this.selectedYMD,
        safeId = this.safeId;
    var hideDecadeNav = !this.showDecadeNav;
    var todayYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_11__.formatYMD)(this.getToday());
    var highlightToday = !this.noHighlightToday; // Header showing current selected date

    var $header = h('output', {
      staticClass: 'form-control form-control-sm text-center',
      class: {
        'text-muted': disabled,
        readonly: this.readonly || disabled
      },
      attrs: {
        id: valueId,
        for: gridId,
        role: 'status',
        tabindex: disabled ? null : '-1',
        // Mainly for testing purposes, as we do not know
        // the exact format `Intl` will format the date string
        'data-selected': (0,_utils_string__WEBPACK_IMPORTED_MODULE_15__.toString)(selectedYMD),
        // We wait until after mount to enable `aria-live`
        // to prevent initial announcement on page render
        'aria-live': isLive ? 'polite' : 'off',
        'aria-atomic': isLive ? 'true' : null
      },
      on: {
        // Transfer focus/click to focus grid
        // and focus active date (or today if no selection)
        click: this.onHeaderClick,
        focus: this.onHeaderClick
      }
    }, this.selectedDate ? [// We use `bdi` elements here in case the label doesn't match the locale
    // Although IE 11 does not deal with <BDI> at all (equivalent to a span)
    h('bdi', {
      staticClass: 'sr-only'
    }, " (".concat((0,_utils_string__WEBPACK_IMPORTED_MODULE_15__.toString)(this.labelSelected), ") ")), h('bdi', this.formatDateString(this.selectedDate))] : this.labelNoDateSelected || "\xA0" // '&nbsp;'
    );
    $header = h('header', {
      staticClass: 'b-calendar-header',
      class: {
        'sr-only': this.hideHeader
      },
      attrs: {
        title: this.selectedDate ? this.labelSelectedDate || null : null
      }
    }, [$header]); // Content for the date navigation buttons

    var navScope = {
      isRTL: isRTL
    };
    var navProps = {
      shiftV: 0.5
    };

    var navPrevProps = _objectSpread(_objectSpread({}, navProps), {}, {
      flipH: isRTL
    });

    var navNextProps = _objectSpread(_objectSpread({}, navProps), {}, {
      flipH: !isRTL
    });

    var $prevDecadeIcon = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_23__.SLOT_NAME_NAV_PEV_DECADE, navScope) || h(_icons_icons__WEBPACK_IMPORTED_MODULE_24__.BIconChevronBarLeft, {
      props: navPrevProps
    });
    var $prevYearIcon = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_23__.SLOT_NAME_NAV_PEV_YEAR, navScope) || h(_icons_icons__WEBPACK_IMPORTED_MODULE_24__.BIconChevronDoubleLeft, {
      props: navPrevProps
    });
    var $prevMonthIcon = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_23__.SLOT_NAME_NAV_PEV_MONTH, navScope) || h(_icons_icons__WEBPACK_IMPORTED_MODULE_24__.BIconChevronLeft, {
      props: navPrevProps
    });
    var $thisMonthIcon = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_23__.SLOT_NAME_NAV_THIS_MONTH, navScope) || h(_icons_icons__WEBPACK_IMPORTED_MODULE_24__.BIconCircleFill, {
      props: navProps
    });
    var $nextMonthIcon = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_23__.SLOT_NAME_NAV_NEXT_MONTH, navScope) || h(_icons_icons__WEBPACK_IMPORTED_MODULE_24__.BIconChevronLeft, {
      props: navNextProps
    });
    var $nextYearIcon = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_23__.SLOT_NAME_NAV_NEXT_YEAR, navScope) || h(_icons_icons__WEBPACK_IMPORTED_MODULE_24__.BIconChevronDoubleLeft, {
      props: navNextProps
    });
    var $nextDecadeIcon = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_23__.SLOT_NAME_NAV_NEXT_DECADE, navScope) || h(_icons_icons__WEBPACK_IMPORTED_MODULE_24__.BIconChevronBarLeft, {
      props: navNextProps
    }); // Utility to create the date navigation buttons

    var makeNavBtn = function makeNavBtn(content, label, handler, btnDisabled, shortcut) {
      return h('button', {
        staticClass: 'btn btn-sm border-0 flex-fill',
        class: [_this6.computedNavButtonVariant, {
          disabled: btnDisabled
        }],
        attrs: {
          title: label || null,
          type: 'button',
          tabindex: noKeyNav ? '-1' : null,
          'aria-label': label || null,
          'aria-disabled': btnDisabled ? 'true' : null,
          'aria-keyshortcuts': shortcut || null
        },
        on: btnDisabled ? {} : {
          click: handler
        }
      }, [h('div', {
        attrs: {
          'aria-hidden': 'true'
        }
      }, [content])]);
    }; // Generate the date navigation buttons


    var $nav = h('div', {
      staticClass: 'b-calendar-nav d-flex',
      attrs: {
        id: navId,
        role: 'group',
        tabindex: noKeyNav ? '-1' : null,
        'aria-hidden': disabled ? 'true' : null,
        'aria-label': this.labelNav || null,
        'aria-controls': gridId
      }
    }, [hideDecadeNav ? h() : makeNavBtn($prevDecadeIcon, this.labelPrevDecade, this.gotoPrevDecade, this.prevDecadeDisabled, 'Ctrl+Alt+PageDown'), makeNavBtn($prevYearIcon, this.labelPrevYear, this.gotoPrevYear, this.prevYearDisabled, 'Alt+PageDown'), makeNavBtn($prevMonthIcon, this.labelPrevMonth, this.gotoPrevMonth, this.prevMonthDisabled, 'PageDown'), makeNavBtn($thisMonthIcon, this.labelCurrentMonth, this.gotoCurrentMonth, this.thisMonthDisabled, 'Home'), makeNavBtn($nextMonthIcon, this.labelNextMonth, this.gotoNextMonth, this.nextMonthDisabled, 'PageUp'), makeNavBtn($nextYearIcon, this.labelNextYear, this.gotoNextYear, this.nextYearDisabled, 'Alt+PageUp'), hideDecadeNav ? h() : makeNavBtn($nextDecadeIcon, this.labelNextDecade, this.gotoNextDecade, this.nextDecadeDisabled, 'Ctrl+Alt+PageUp')]); // Caption for calendar grid

    var $gridCaption = h('header', {
      staticClass: 'b-calendar-grid-caption text-center font-weight-bold',
      class: {
        'text-muted': disabled
      },
      attrs: {
        id: gridCaptionId,
        'aria-live': isLive ? 'polite' : null,
        'aria-atomic': isLive ? 'true' : null
      },
      key: 'grid-caption'
    }, this.formatYearMonth(this.calendarFirstDay)); // Calendar weekday headings

    var $gridWeekDays = h('div', {
      staticClass: 'b-calendar-grid-weekdays row no-gutters border-bottom',
      attrs: {
        'aria-hidden': 'true'
      }
    }, this.calendarHeadings.map(function (d, idx) {
      return h('small', {
        staticClass: 'col text-truncate',
        class: {
          'text-muted': disabled
        },
        attrs: {
          title: d.label === d.text ? null : d.label,
          'aria-label': d.label
        },
        key: idx
      }, d.text);
    })); // Calendar day grid

    var $gridBody = this.calendar.map(function (week) {
      var $cells = week.map(function (day, dIndex) {
        var _class;

        var isSelected = day.ymd === selectedYMD;
        var isActive = day.ymd === activeYMD;
        var isToday = day.ymd === todayYMD;
        var idCell = safeId("_cell-".concat(day.ymd, "_")); // "fake" button

        var $btn = h('span', {
          staticClass: 'btn border-0 rounded-circle text-nowrap',
          // Should we add some classes to signify if today/selected/etc?
          class: (_class = {
            // Give the fake button a focus ring
            focus: isActive && _this6.gridHasFocus,
            // Styling
            disabled: day.isDisabled || disabled,
            active: isSelected
          }, _defineProperty(_class, _this6.computedVariant, isSelected), _defineProperty(_class, _this6.computedTodayVariant, isToday && highlightToday && !isSelected && day.isThisMonth), _defineProperty(_class, 'btn-outline-light', !(isToday && highlightToday) && !isSelected && !isActive), _defineProperty(_class, 'btn-light', !(isToday && highlightToday) && !isSelected && isActive), _defineProperty(_class, 'text-muted', !day.isThisMonth && !isSelected), _defineProperty(_class, 'text-dark', !(isToday && highlightToday) && !isSelected && !isActive && day.isThisMonth), _defineProperty(_class, 'font-weight-bold', (isSelected || day.isThisMonth) && !day.isDisabled), _class),
          on: {
            click: function click() {
              return _this6.onClickDay(day);
            }
          }
        }, day.day);
        return h('div', // Cell with button
        {
          staticClass: 'col p-0',
          class: day.isDisabled ? 'bg-light' : day.info.class || '',
          attrs: {
            id: idCell,
            role: 'button',
            'data-date': day.ymd,
            // Primarily for testing purposes
            // Only days in the month are presented as buttons to screen readers
            'aria-hidden': day.isThisMonth ? null : 'true',
            'aria-disabled': day.isDisabled || disabled ? 'true' : null,
            'aria-label': [day.label, isSelected ? "(".concat(_this6.labelSelected, ")") : null, isToday ? "(".concat(_this6.labelToday, ")") : null].filter(_utils_identity__WEBPACK_IMPORTED_MODULE_14__.identity).join(' '),
            // NVDA doesn't convey `aria-selected`, but does `aria-current`,
            // ChromeVox doesn't convey `aria-current`, but does `aria-selected`,
            // so we set both attributes for robustness
            'aria-selected': isSelected ? 'true' : null,
            'aria-current': isSelected ? 'date' : null
          },
          key: dIndex
        }, [$btn]);
      }); // Return the week "row"
      // We use the first day of the weeks YMD value as a
      // key for efficient DOM patching / element re-use

      return h('div', {
        staticClass: 'row no-gutters',
        key: week[0].ymd
      }, $cells);
    });
    $gridBody = h('div', {
      // A key is only required on the body if we add in transition support
      staticClass: 'b-calendar-grid-body',
      style: disabled ? {
        pointerEvents: 'none'
      } : {} // key: this.activeYMD.slice(0, -3)

    }, $gridBody);
    var $gridHelp = h('footer', {
      staticClass: 'b-calendar-grid-help border-top small text-muted text-center bg-light',
      attrs: {
        id: gridHelpId
      }
    }, [h('div', {
      staticClass: 'small'
    }, this.labelHelp)]);
    var $grid = h('div', {
      staticClass: 'b-calendar-grid form-control h-auto text-center',
      attrs: {
        id: gridId,
        role: 'application',
        tabindex: noKeyNav ? '-1' : disabled ? null : '0',
        'data-month': activeYMD.slice(0, -3),
        // `YYYY-MM`, mainly for testing
        'aria-roledescription': this.labelCalendar || null,
        'aria-labelledby': gridCaptionId,
        'aria-describedby': gridHelpId,
        // `aria-readonly` is not considered valid on `role="application"`
        // https://www.w3.org/TR/wai-aria-1.1/#aria-readonly
        // 'aria-readonly': this.readonly && !disabled ? 'true' : null,
        'aria-disabled': disabled ? 'true' : null,
        'aria-activedescendant': activeId
      },
      on: {
        keydown: this.onKeydownGrid,
        focus: this.setGridFocusFlag,
        blur: this.setGridFocusFlag
      },
      ref: 'grid'
    }, [$gridCaption, $gridWeekDays, $gridBody, $gridHelp]); // Optional bottom slot

    var $slot = this.normalizeSlot();
    $slot = $slot ? h('footer', {
      staticClass: 'b-calendar-footer'
    }, $slot) : h();
    var $widget = h('div', {
      staticClass: 'b-calendar-inner',
      style: this.block ? {} : {
        width: this.width
      },
      attrs: {
        id: widgetId,
        dir: isRTL ? 'rtl' : 'ltr',
        lang: this.computedLocale || null,
        role: 'group',
        'aria-disabled': disabled ? 'true' : null,
        // If datepicker controls an input, this will specify the ID of the input
        'aria-controls': this.ariaControls || null,
        // This should be a prop (so it can be changed to Date picker, etc, localized
        'aria-roledescription': this.roleDescription || null,
        'aria-describedby': [// Should the attr (if present) go last?
        // Or should this attr be a prop?
        this.bvAttrs['aria-describedby'], valueId, gridHelpId].filter(_utils_identity__WEBPACK_IMPORTED_MODULE_14__.identity).join(' ')
      },
      on: {
        keydown: this.onKeydownWrapper
      }
    }, [$header, $nav, $grid, $slot]); // Wrap in an outer div that can be styled

    return h('div', {
      staticClass: 'b-calendar',
      class: {
        'd-block': this.block
      }
    }, [$widget]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/calendar/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/calendar/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCalendar": () => (/* reexport safe */ _calendar__WEBPACK_IMPORTED_MODULE_1__.BCalendar),
/* harmony export */   "CalendarPlugin": () => (/* binding */ CalendarPlugin)
/* harmony export */ });
/* harmony import */ var _calendar__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./calendar */ "./node_modules/bootstrap-vue/esm/components/calendar/calendar.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var CalendarPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BCalendar: _calendar__WEBPACK_IMPORTED_MODULE_1__.BCalendar
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-body.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-body.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardBody": () => (/* binding */ BCardBody),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_card__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/card */ "./node_modules/bootstrap-vue/esm/mixins/card.js");
/* harmony import */ var _card_title__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./card-title */ "./node_modules/bootstrap-vue/esm/components/card/card-title.js");
/* harmony import */ var _card_sub_title__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./card-sub-title */ "./node_modules/bootstrap-vue/esm/components/card/card-sub-title.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }








 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _card_title__WEBPACK_IMPORTED_MODULE_2__.props), _card_sub_title__WEBPACK_IMPORTED_MODULE_3__.props), (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.copyProps)(_mixins_card__WEBPACK_IMPORTED_MODULE_4__.props, _utils_props__WEBPACK_IMPORTED_MODULE_0__.prefixPropName.bind(null, 'body'))), {}, {
  bodyClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_ARRAY_OBJECT_STRING),
  overlay: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false)
})), _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_CARD_BODY); // --- Main component ---
// @vue/component

var BCardBody = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_7__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_CARD_BODY,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var _ref2;

    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var bodyBgVariant = props.bodyBgVariant,
        bodyBorderVariant = props.bodyBorderVariant,
        bodyTextVariant = props.bodyTextVariant;
    var $title = h();

    if (props.title) {
      $title = h(_card_title__WEBPACK_IMPORTED_MODULE_2__.BCardTitle, {
        props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(_card_title__WEBPACK_IMPORTED_MODULE_2__.props, props)
      });
    }

    var $subTitle = h();

    if (props.subTitle) {
      $subTitle = h(_card_sub_title__WEBPACK_IMPORTED_MODULE_3__.BCardSubTitle, {
        props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(_card_sub_title__WEBPACK_IMPORTED_MODULE_3__.props, props),
        class: ['mb-2']
      });
    }

    return h(props.bodyTag, (0,_vue__WEBPACK_IMPORTED_MODULE_8__.mergeData)(data, {
      staticClass: 'card-body',
      class: [(_ref2 = {
        'card-img-overlay': props.overlay
      }, _defineProperty(_ref2, "bg-".concat(bodyBgVariant), bodyBgVariant), _defineProperty(_ref2, "border-".concat(bodyBorderVariant), bodyBorderVariant), _defineProperty(_ref2, "text-".concat(bodyTextVariant), bodyTextVariant), _ref2), props.bodyClass]
    }), [$title, $subTitle, children]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-footer.js":
/*!***********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-footer.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardFooter": () => (/* binding */ BCardFooter),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/card */ "./node_modules/bootstrap-vue/esm/mixins/card.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.copyProps)(_mixins_card__WEBPACK_IMPORTED_MODULE_2__.props, _utils_props__WEBPACK_IMPORTED_MODULE_0__.prefixPropName.bind(null, 'footer'))), {}, {
  footer: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  footerClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_ARRAY_OBJECT_STRING),
  footerHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING)
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CARD_FOOTER); // --- Main component ---
// @vue/component

var BCardFooter = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CARD_FOOTER,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var _ref2;

    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var footerBgVariant = props.footerBgVariant,
        footerBorderVariant = props.footerBorderVariant,
        footerTextVariant = props.footerTextVariant;
    return h(props.footerTag, (0,_vue__WEBPACK_IMPORTED_MODULE_6__.mergeData)(data, {
      staticClass: 'card-footer',
      class: [props.footerClass, (_ref2 = {}, _defineProperty(_ref2, "bg-".concat(footerBgVariant), footerBgVariant), _defineProperty(_ref2, "border-".concat(footerBorderVariant), footerBorderVariant), _defineProperty(_ref2, "text-".concat(footerTextVariant), footerTextVariant), _ref2)],
      domProps: children ? {} : (0,_utils_html__WEBPACK_IMPORTED_MODULE_7__.htmlOrText)(props.footerHtml, props.footer)
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-group.js":
/*!**********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-group.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardGroup": () => (/* binding */ BCardGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  columns: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  deck: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_GROUP); // --- Main component ---
// @vue/component

var BCardGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_GROUP,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      class: props.deck ? 'card-deck' : props.columns ? 'card-columns' : 'card-group'
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-header.js":
/*!***********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-header.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardHeader": () => (/* binding */ BCardHeader),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_card__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/card */ "./node_modules/bootstrap-vue/esm/mixins/card.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.copyProps)(_mixins_card__WEBPACK_IMPORTED_MODULE_2__.props, _utils_props__WEBPACK_IMPORTED_MODULE_0__.prefixPropName.bind(null, 'header'))), {}, {
  header: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  headerClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_ARRAY_OBJECT_STRING),
  headerHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING)
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CARD_HEADER); // --- Main component ---
// @vue/component

var BCardHeader = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CARD_HEADER,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var _ref2;

    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var headerBgVariant = props.headerBgVariant,
        headerBorderVariant = props.headerBorderVariant,
        headerTextVariant = props.headerTextVariant;
    return h(props.headerTag, (0,_vue__WEBPACK_IMPORTED_MODULE_6__.mergeData)(data, {
      staticClass: 'card-header',
      class: [props.headerClass, (_ref2 = {}, _defineProperty(_ref2, "bg-".concat(headerBgVariant), headerBgVariant), _defineProperty(_ref2, "border-".concat(headerBorderVariant), headerBorderVariant), _defineProperty(_ref2, "text-".concat(headerTextVariant), headerTextVariant), _ref2)],
      domProps: children ? {} : (0,_utils_html__WEBPACK_IMPORTED_MODULE_7__.htmlOrText)(props.headerHtml, props.header)
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-img-lazy.js":
/*!*************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-img-lazy.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardImgLazy": () => (/* binding */ BCardImgLazy),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _image_img__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../image/img */ "./node_modules/bootstrap-vue/esm/components/image/img.js");
/* harmony import */ var _image_img_lazy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../image/img-lazy */ "./node_modules/bootstrap-vue/esm/components/image/img-lazy.js");
/* harmony import */ var _card_img__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./card-img */ "./node_modules/bootstrap-vue/esm/components/card/card-img.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(_image_img_lazy__WEBPACK_IMPORTED_MODULE_2__.props, (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.keys)(_image_img__WEBPACK_IMPORTED_MODULE_3__.props))), (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(_card_img__WEBPACK_IMPORTED_MODULE_4__.props, ['src', 'alt', 'width', 'height']))), _constants_components__WEBPACK_IMPORTED_MODULE_5__.NAME_CARD_IMG_LAZY); // --- Main component ---
// @vue/component

var BCardImgLazy = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_6__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_5__.NAME_CARD_IMG_LAZY,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data;
    var baseClass = 'card-img';

    if (props.top) {
      baseClass += '-top';
    } else if (props.right || props.end) {
      baseClass += '-right';
    } else if (props.bottom) {
      baseClass += '-bottom';
    } else if (props.left || props.start) {
      baseClass += '-left';
    }

    return h(_image_img_lazy__WEBPACK_IMPORTED_MODULE_2__.BImgLazy, (0,_vue__WEBPACK_IMPORTED_MODULE_7__.mergeData)(data, {
      class: [baseClass],
      // Exclude `left` and `right` props before passing to `<b-img-lazy>`
      props: (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(props, ['left', 'right'])
    }));
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-img.js":
/*!********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-img.js ***!
  \********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardImg": () => (/* binding */ BCardImg),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _image_img__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../image/img */ "./node_modules/bootstrap-vue/esm/components/image/img.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.pick)(_image_img__WEBPACK_IMPORTED_MODULE_2__.props, ['src', 'alt', 'width', 'height', 'left', 'right'])), {}, {
  bottom: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  end: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  start: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  top: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false)
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CARD_IMG); // --- Main component ---
// @vue/component

var BCardImg = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CARD_IMG,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data;
    var src = props.src,
        alt = props.alt,
        width = props.width,
        height = props.height;
    var baseClass = 'card-img';

    if (props.top) {
      baseClass += '-top';
    } else if (props.right || props.end) {
      baseClass += '-right';
    } else if (props.bottom) {
      baseClass += '-bottom';
    } else if (props.left || props.start) {
      baseClass += '-left';
    }

    return h('img', (0,_vue__WEBPACK_IMPORTED_MODULE_6__.mergeData)(data, {
      class: baseClass,
      attrs: {
        src: src,
        alt: alt,
        width: width,
        height: height
      }
    }));
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-sub-title.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-sub-title.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardSubTitle": () => (/* binding */ BCardSubTitle),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");




 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  subTitle: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  subTitleTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'h6'),
  subTitleTextVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'muted')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_SUB_TITLE); // --- Main component ---
// @vue/component

var BCardSubTitle = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_SUB_TITLE,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.subTitleTag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      staticClass: 'card-subtitle',
      class: [props.subTitleTextVariant ? "text-".concat(props.subTitleTextVariant) : null]
    }), children || (0,_utils_string__WEBPACK_IMPORTED_MODULE_5__.toString)(props.subTitle));
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-text.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-text.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardText": () => (/* binding */ BCardText),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  textTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'p')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_TEXT); // --- Main component ---
// @vue/component

var BCardText = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_TEXT,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.textTag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      staticClass: 'card-text'
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card-title.js":
/*!**********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card-title.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCardTitle": () => (/* binding */ BCardTitle),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");




 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  title: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  titleTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'h4')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_TITLE); // --- Main component ---
// @vue/component

var BCardTitle = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CARD_TITLE,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.titleTag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      staticClass: 'card-title'
    }), children || (0,_utils_string__WEBPACK_IMPORTED_MODULE_5__.toString)(props.title));
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/card.js":
/*!****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/card.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCard": () => (/* binding */ BCard),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_normalize_slot__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/normalize-slot */ "./node_modules/bootstrap-vue/esm/utils/normalize-slot.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_card__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/card */ "./node_modules/bootstrap-vue/esm/mixins/card.js");
/* harmony import */ var _card_body__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./card-body */ "./node_modules/bootstrap-vue/esm/components/card/card-body.js");
/* harmony import */ var _card_header__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./card-header */ "./node_modules/bootstrap-vue/esm/components/card/card-header.js");
/* harmony import */ var _card_footer__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./card-footer */ "./node_modules/bootstrap-vue/esm/components/card/card-footer.js");
/* harmony import */ var _card_img__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./card-img */ "./node_modules/bootstrap-vue/esm/components/card/card-img.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }













 // --- Props ---

var cardImgProps = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.copyProps)(_card_img__WEBPACK_IMPORTED_MODULE_1__.props, _utils_props__WEBPACK_IMPORTED_MODULE_0__.prefixPropName.bind(null, 'img'));
cardImgProps.imgSrc.required = false;
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _card_body__WEBPACK_IMPORTED_MODULE_3__.props), _card_header__WEBPACK_IMPORTED_MODULE_4__.props), _card_footer__WEBPACK_IMPORTED_MODULE_5__.props), cardImgProps), _mixins_card__WEBPACK_IMPORTED_MODULE_6__.props), {}, {
  align: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING),
  noBody: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, false)
})), _constants_components__WEBPACK_IMPORTED_MODULE_8__.NAME_CARD); // --- Main component ---
// @vue/component

var BCard = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_9__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_8__.NAME_CARD,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var _class;

    var props = _ref.props,
        data = _ref.data,
        slots = _ref.slots,
        scopedSlots = _ref.scopedSlots;
    var imgSrc = props.imgSrc,
        imgLeft = props.imgLeft,
        imgRight = props.imgRight,
        imgStart = props.imgStart,
        imgEnd = props.imgEnd,
        imgBottom = props.imgBottom,
        header = props.header,
        headerHtml = props.headerHtml,
        footer = props.footer,
        footerHtml = props.footerHtml,
        align = props.align,
        textVariant = props.textVariant,
        bgVariant = props.bgVariant,
        borderVariant = props.borderVariant;
    var $scopedSlots = scopedSlots || {};
    var $slots = slots();
    var slotScope = {};
    var $imgFirst = h();
    var $imgLast = h();

    if (imgSrc) {
      var $img = h(_card_img__WEBPACK_IMPORTED_MODULE_1__.BCardImg, {
        props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(cardImgProps, props, _utils_props__WEBPACK_IMPORTED_MODULE_0__.unprefixPropName.bind(null, 'img'))
      });

      if (imgBottom) {
        $imgLast = $img;
      } else {
        $imgFirst = $img;
      }
    }

    var $header = h();
    var hasHeaderSlot = (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_10__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_11__.SLOT_NAME_HEADER, $scopedSlots, $slots);

    if (hasHeaderSlot || header || headerHtml) {
      $header = h(_card_header__WEBPACK_IMPORTED_MODULE_4__.BCardHeader, {
        props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(_card_header__WEBPACK_IMPORTED_MODULE_4__.props, props),
        domProps: hasHeaderSlot ? {} : (0,_utils_html__WEBPACK_IMPORTED_MODULE_12__.htmlOrText)(headerHtml, header)
      }, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_10__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_11__.SLOT_NAME_HEADER, slotScope, $scopedSlots, $slots));
    }

    var $content = (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_10__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_11__.SLOT_NAME_DEFAULT, slotScope, $scopedSlots, $slots); // Wrap content in `<card-body>` when `noBody` prop set

    if (!props.noBody) {
      $content = h(_card_body__WEBPACK_IMPORTED_MODULE_3__.BCardBody, {
        props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(_card_body__WEBPACK_IMPORTED_MODULE_3__.props, props)
      }, $content); // When the `overlap` prop is set we need to wrap the `<b-card-img>` and `<b-card-body>`
      // into a relative positioned wrapper to don't distract a potential header or footer

      if (props.overlay && imgSrc) {
        $content = h('div', {
          staticClass: 'position-relative'
        }, [$imgFirst, $content, $imgLast]); // Reset image variables since they are already in the wrapper

        $imgFirst = h();
        $imgLast = h();
      }
    }

    var $footer = h();
    var hasFooterSlot = (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_10__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_11__.SLOT_NAME_FOOTER, $scopedSlots, $slots);

    if (hasFooterSlot || footer || footerHtml) {
      $footer = h(_card_footer__WEBPACK_IMPORTED_MODULE_5__.BCardFooter, {
        props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(_card_footer__WEBPACK_IMPORTED_MODULE_5__.props, props),
        domProps: hasHeaderSlot ? {} : (0,_utils_html__WEBPACK_IMPORTED_MODULE_12__.htmlOrText)(footerHtml, footer)
      }, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_10__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_11__.SLOT_NAME_FOOTER, slotScope, $scopedSlots, $slots));
    }

    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_13__.mergeData)(data, {
      staticClass: 'card',
      class: (_class = {
        'flex-row': imgLeft || imgStart,
        'flex-row-reverse': (imgRight || imgEnd) && !(imgLeft || imgStart)
      }, _defineProperty(_class, "text-".concat(align), align), _defineProperty(_class, "bg-".concat(bgVariant), bgVariant), _defineProperty(_class, "border-".concat(borderVariant), borderVariant), _defineProperty(_class, "text-".concat(textVariant), textVariant), _class)
    }), [$imgFirst, $header, $content, $footer, $imgLast]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/card/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/card/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCard": () => (/* reexport safe */ _card__WEBPACK_IMPORTED_MODULE_1__.BCard),
/* harmony export */   "BCardBody": () => (/* reexport safe */ _card_body__WEBPACK_IMPORTED_MODULE_3__.BCardBody),
/* harmony export */   "BCardFooter": () => (/* reexport safe */ _card_footer__WEBPACK_IMPORTED_MODULE_6__.BCardFooter),
/* harmony export */   "BCardGroup": () => (/* reexport safe */ _card_group__WEBPACK_IMPORTED_MODULE_10__.BCardGroup),
/* harmony export */   "BCardHeader": () => (/* reexport safe */ _card_header__WEBPACK_IMPORTED_MODULE_2__.BCardHeader),
/* harmony export */   "BCardImg": () => (/* reexport safe */ _card_img__WEBPACK_IMPORTED_MODULE_7__.BCardImg),
/* harmony export */   "BCardImgLazy": () => (/* reexport safe */ _card_img_lazy__WEBPACK_IMPORTED_MODULE_8__.BCardImgLazy),
/* harmony export */   "BCardSubTitle": () => (/* reexport safe */ _card_sub_title__WEBPACK_IMPORTED_MODULE_5__.BCardSubTitle),
/* harmony export */   "BCardText": () => (/* reexport safe */ _card_text__WEBPACK_IMPORTED_MODULE_9__.BCardText),
/* harmony export */   "BCardTitle": () => (/* reexport safe */ _card_title__WEBPACK_IMPORTED_MODULE_4__.BCardTitle),
/* harmony export */   "CardPlugin": () => (/* binding */ CardPlugin)
/* harmony export */ });
/* harmony import */ var _card__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./card */ "./node_modules/bootstrap-vue/esm/components/card/card.js");
/* harmony import */ var _card_header__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./card-header */ "./node_modules/bootstrap-vue/esm/components/card/card-header.js");
/* harmony import */ var _card_body__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./card-body */ "./node_modules/bootstrap-vue/esm/components/card/card-body.js");
/* harmony import */ var _card_title__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./card-title */ "./node_modules/bootstrap-vue/esm/components/card/card-title.js");
/* harmony import */ var _card_sub_title__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./card-sub-title */ "./node_modules/bootstrap-vue/esm/components/card/card-sub-title.js");
/* harmony import */ var _card_footer__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./card-footer */ "./node_modules/bootstrap-vue/esm/components/card/card-footer.js");
/* harmony import */ var _card_img__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./card-img */ "./node_modules/bootstrap-vue/esm/components/card/card-img.js");
/* harmony import */ var _card_img_lazy__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./card-img-lazy */ "./node_modules/bootstrap-vue/esm/components/card/card-img-lazy.js");
/* harmony import */ var _card_text__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./card-text */ "./node_modules/bootstrap-vue/esm/components/card/card-text.js");
/* harmony import */ var _card_group__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./card-group */ "./node_modules/bootstrap-vue/esm/components/card/card-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");











var CardPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BCard: _card__WEBPACK_IMPORTED_MODULE_1__.BCard,
    BCardHeader: _card_header__WEBPACK_IMPORTED_MODULE_2__.BCardHeader,
    BCardBody: _card_body__WEBPACK_IMPORTED_MODULE_3__.BCardBody,
    BCardTitle: _card_title__WEBPACK_IMPORTED_MODULE_4__.BCardTitle,
    BCardSubTitle: _card_sub_title__WEBPACK_IMPORTED_MODULE_5__.BCardSubTitle,
    BCardFooter: _card_footer__WEBPACK_IMPORTED_MODULE_6__.BCardFooter,
    BCardImg: _card_img__WEBPACK_IMPORTED_MODULE_7__.BCardImg,
    BCardImgLazy: _card_img_lazy__WEBPACK_IMPORTED_MODULE_8__.BCardImgLazy,
    BCardText: _card_text__WEBPACK_IMPORTED_MODULE_9__.BCardText,
    BCardGroup: _card_group__WEBPACK_IMPORTED_MODULE_10__.BCardGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/carousel/carousel-slide.js":
/*!******************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/carousel/carousel-slide.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCarouselSlide": () => (/* binding */ BCarouselSlide),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_env__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/env */ "./node_modules/bootstrap-vue/esm/constants/env.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _image_img__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../image/img */ "./node_modules/bootstrap-vue/esm/components/image/img.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }













 // --- Props ---

var imgProps = {
  imgAlt: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  imgBlank: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  imgBlankColor: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'transparent'),
  imgHeight: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING),
  imgSrc: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  imgWidth: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING)
};
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.sortKeys)(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_3__.props), imgProps), {}, {
  background: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  caption: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  captionHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  captionTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'h3'),
  contentTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div'),
  contentVisibleUp: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  text: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  textHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  textTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'p')
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CAROUSEL_SLIDE); // --- Main component ---
// @vue/component

var BCarouselSlide = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_CAROUSEL_SLIDE,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_3__.idMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__.normalizeSlotMixin],
  inject: {
    bvCarousel: {
      // Explicitly disable touch if not a child of carousel
      default: function _default() {
        return {
          noTouch: true
        };
      }
    }
  },
  props: props,
  computed: {
    contentClasses: function contentClasses() {
      return [this.contentVisibleUp ? 'd-none' : '', this.contentVisibleUp ? "d-".concat(this.contentVisibleUp, "-block") : ''];
    },
    computedWidth: function computedWidth() {
      // Use local width, or try parent width
      return this.imgWidth || this.bvCarousel.imgWidth || null;
    },
    computedHeight: function computedHeight() {
      // Use local height, or try parent height
      return this.imgHeight || this.bvCarousel.imgHeight || null;
    }
  },
  render: function render(h) {
    var $img = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_7__.SLOT_NAME_IMG);

    if (!$img && (this.imgSrc || this.imgBlank)) {
      var on = {}; // Touch support event handler

      /* istanbul ignore if: difficult to test in JSDOM */

      if (!this.bvCarousel.noTouch && _constants_env__WEBPACK_IMPORTED_MODULE_8__.HAS_TOUCH_SUPPORT) {
        on.dragstart = function (event) {
          return (0,_utils_events__WEBPACK_IMPORTED_MODULE_9__.stopEvent)(event, {
            propagation: false
          });
        };
      }

      $img = h(_image_img__WEBPACK_IMPORTED_MODULE_10__.BImg, {
        props: _objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.pluckProps)(imgProps, this.$props, _utils_props__WEBPACK_IMPORTED_MODULE_0__.unprefixPropName.bind(null, 'img'))), {}, {
          width: this.computedWidth,
          height: this.computedHeight,
          fluidGrow: true,
          block: true
        }),
        on: on
      });
    }

    var $contentChildren = [// Caption
    this.caption || this.captionHtml ? h(this.captionTag, {
      domProps: (0,_utils_html__WEBPACK_IMPORTED_MODULE_11__.htmlOrText)(this.captionHtml, this.caption)
    }) : false, // Text
    this.text || this.textHtml ? h(this.textTag, {
      domProps: (0,_utils_html__WEBPACK_IMPORTED_MODULE_11__.htmlOrText)(this.textHtml, this.text)
    }) : false, // Children
    this.normalizeSlot() || false];
    var $content = h();

    if ($contentChildren.some(_utils_identity__WEBPACK_IMPORTED_MODULE_12__.identity)) {
      $content = h(this.contentTag, {
        staticClass: 'carousel-caption',
        class: this.contentClasses
      }, $contentChildren.map(function ($child) {
        return $child || h();
      }));
    }

    return h('div', {
      staticClass: 'carousel-item',
      style: {
        background: this.background || this.bvCarousel.background || null
      },
      attrs: {
        id: this.safeId(),
        role: 'listitem'
      }
    }, [$img, $content]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/carousel/carousel.js":
/*!************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/carousel/carousel.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCarousel": () => (/* binding */ BCarousel),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_env__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../constants/env */ "./node_modules/bootstrap-vue/esm/constants/env.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_math__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/math */ "./node_modules/bootstrap-vue/esm/utils/math.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_noop__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../utils/noop */ "./node_modules/bootstrap-vue/esm/utils/noop.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_observe_dom__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/observe-dom */ "./node_modules/bootstrap-vue/esm/utils/observe-dom.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }


















 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER,
  defaultValue: 0
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // Slide directional classes


var DIRECTION = {
  next: {
    dirClass: 'carousel-item-left',
    overlayClass: 'carousel-item-next'
  },
  prev: {
    dirClass: 'carousel-item-right',
    overlayClass: 'carousel-item-prev'
  }
}; // Fallback Transition duration (with a little buffer) in ms

var TRANS_DURATION = 600 + 50; // Time for mouse compat events to fire after touch

var TOUCH_EVENT_COMPAT_WAIT = 500; // Number of pixels to consider touch move a swipe

var SWIPE_THRESHOLD = 40; // PointerEvent pointer types

var PointerType = {
  TOUCH: 'touch',
  PEN: 'pen'
}; // Transition Event names

var TransitionEndEvents = {
  WebkitTransition: 'webkitTransitionEnd',
  MozTransition: 'transitionend',
  OTransition: 'otransitionend oTransitionEnd',
  transition: 'transitionend'
}; // --- Helper methods ---
// Return the browser specific transitionEnd event name

var getTransitionEndEvent = function getTransitionEndEvent(el) {
  for (var name in TransitionEndEvents) {
    if (!(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_2__.isUndefined)(el.style[name])) {
      return TransitionEndEvents[name];
    }
  } // Fallback

  /* istanbul ignore next */


  return null;
}; // --- Props ---


var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_4__.sortKeys)(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_5__.props), modelProps), {}, {
  background: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  controls: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Enable cross-fade animation instead of slide animation
  fade: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Sniffed by carousel-slide
  imgHeight: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING),
  // Sniffed by carousel-slide
  imgWidth: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING),
  indicators: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  interval: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER, 5000),
  labelGotoSlide: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Goto slide'),
  labelIndicators: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Select a slide to display'),
  labelNext: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Next slide'),
  labelPrev: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Previous slide'),
  // Disable slide/fade animation
  noAnimation: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Disable pause on hover
  noHoverPause: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Sniffed by carousel-slide
  noTouch: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Disable wrapping/looping when start/end is reached
  noWrap: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false)
})), _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_CAROUSEL); // --- Main component ---
// @vue/component

var BCarousel = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_7__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_CAROUSEL,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_5__.idMixin, modelMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__.normalizeSlotMixin],
  provide: function provide() {
    return {
      bvCarousel: this
    };
  },
  props: props,
  data: function data() {
    return {
      index: this[MODEL_PROP_NAME] || 0,
      isSliding: false,
      transitionEndEvent: null,
      slides: [],
      direction: null,
      isPaused: !((0,_utils_number__WEBPACK_IMPORTED_MODULE_9__.toInteger)(this.interval, 0) > 0),
      // Touch event handling values
      touchStartX: 0,
      touchDeltaX: 0
    };
  },
  computed: {
    numSlides: function numSlides() {
      return this.slides.length;
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue, oldValue) {
    if (newValue !== oldValue) {
      this.setSlide((0,_utils_number__WEBPACK_IMPORTED_MODULE_9__.toInteger)(newValue, 0));
    }
  }), _defineProperty(_watch, "interval", function interval(newValue, oldValue) {
    /* istanbul ignore next */
    if (newValue === oldValue) {
      return;
    }

    if (!newValue) {
      // Pausing slide show
      this.pause(false);
    } else {
      // Restarting or Changing interval
      this.pause(true);
      this.start(false);
    }
  }), _defineProperty(_watch, "isPaused", function isPaused(newValue, oldValue) {
    if (newValue !== oldValue) {
      this.$emit(newValue ? _constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_PAUSED : _constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_UNPAUSED);
    }
  }), _defineProperty(_watch, "index", function index(to, from) {
    /* istanbul ignore next */
    if (to === from || this.isSliding) {
      return;
    }

    this.doSlide(to, from);
  }), _watch),
  created: function created() {
    // Create private non-reactive props
    this.$_interval = null;
    this.$_animationTimeout = null;
    this.$_touchTimeout = null;
    this.$_observer = null; // Set initial paused state

    this.isPaused = !((0,_utils_number__WEBPACK_IMPORTED_MODULE_9__.toInteger)(this.interval, 0) > 0);
  },
  mounted: function mounted() {
    // Cache current browser transitionend event name
    this.transitionEndEvent = getTransitionEndEvent(this.$el) || null; // Get all slides

    this.updateSlides(); // Observe child changes so we can update slide list

    this.setObserver(true);
  },
  beforeDestroy: function beforeDestroy() {
    this.clearInterval();
    this.clearAnimationTimeout();
    this.clearTouchTimeout();
    this.setObserver(false);
  },
  methods: {
    clearInterval: function (_clearInterval) {
      function clearInterval() {
        return _clearInterval.apply(this, arguments);
      }

      clearInterval.toString = function () {
        return _clearInterval.toString();
      };

      return clearInterval;
    }(function () {
      clearInterval(this.$_interval);
      this.$_interval = null;
    }),
    clearAnimationTimeout: function clearAnimationTimeout() {
      clearTimeout(this.$_animationTimeout);
      this.$_animationTimeout = null;
    },
    clearTouchTimeout: function clearTouchTimeout() {
      clearTimeout(this.$_touchTimeout);
      this.$_touchTimeout = null;
    },
    setObserver: function setObserver() {
      var on = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : false;
      this.$_observer && this.$_observer.disconnect();
      this.$_observer = null;

      if (on) {
        this.$_observer = (0,_utils_observe_dom__WEBPACK_IMPORTED_MODULE_11__.observeDom)(this.$refs.inner, this.updateSlides.bind(this), {
          subtree: false,
          childList: true,
          attributes: true,
          attributeFilter: ['id']
        });
      }
    },
    // Set slide
    setSlide: function setSlide(slide) {
      var _this = this;

      var direction = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

      // Don't animate when page is not visible

      /* istanbul ignore if: difficult to test */
      if (_constants_env__WEBPACK_IMPORTED_MODULE_12__.IS_BROWSER && document.visibilityState && document.hidden) {
        return;
      }

      var noWrap = this.noWrap;
      var numSlides = this.numSlides; // Make sure we have an integer (you never know!)

      slide = (0,_utils_math__WEBPACK_IMPORTED_MODULE_13__.mathFloor)(slide); // Don't do anything if nothing to slide to

      if (numSlides === 0) {
        return;
      } // Don't change slide while transitioning, wait until transition is done


      if (this.isSliding) {
        // Schedule slide after sliding complete
        this.$once(_constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_SLIDING_END, function () {
          // Wrap in `requestAF()` to allow the slide to properly finish to avoid glitching
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.requestAF)(function () {
            return _this.setSlide(slide, direction);
          });
        });
        return;
      }

      this.direction = direction; // Set new slide index
      // Wrap around if necessary (if no-wrap not enabled)

      this.index = slide >= numSlides ? noWrap ? numSlides - 1 : 0 : slide < 0 ? noWrap ? 0 : numSlides - 1 : slide; // Ensure the v-model is synched up if no-wrap is enabled
      // and user tried to slide pass either ends

      if (noWrap && this.index !== slide && this.index !== this[MODEL_PROP_NAME]) {
        this.$emit(MODEL_EVENT_NAME, this.index);
      }
    },
    // Previous slide
    prev: function prev() {
      this.setSlide(this.index - 1, 'prev');
    },
    // Next slide
    next: function next() {
      this.setSlide(this.index + 1, 'next');
    },
    // Pause auto rotation
    pause: function pause(event) {
      if (!event) {
        this.isPaused = true;
      }

      this.clearInterval();
    },
    // Start auto rotate slides
    start: function start(event) {
      if (!event) {
        this.isPaused = false;
      }
      /* istanbul ignore next: most likely will never happen, but just in case */


      this.clearInterval(); // Don't start if no interval, or less than 2 slides

      if (this.interval && this.numSlides > 1) {
        this.$_interval = setInterval(this.next, (0,_utils_math__WEBPACK_IMPORTED_MODULE_13__.mathMax)(1000, this.interval));
      }
    },
    // Restart auto rotate slides when focus/hover leaves the carousel

    /* istanbul ignore next */
    restart: function restart() {
      if (!this.$el.contains((0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.getActiveElement)())) {
        this.start();
      }
    },
    doSlide: function doSlide(to, from) {
      var _this2 = this;

      var isCycling = Boolean(this.interval); // Determine sliding direction

      var direction = this.calcDirection(this.direction, from, to);
      var overlayClass = direction.overlayClass;
      var dirClass = direction.dirClass; // Determine current and next slides

      var currentSlide = this.slides[from];
      var nextSlide = this.slides[to]; // Don't do anything if there aren't any slides to slide to

      if (!currentSlide || !nextSlide) {
        /* istanbul ignore next */
        return;
      } // Start animating


      this.isSliding = true;

      if (isCycling) {
        this.pause(false);
      }

      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_SLIDING_START, to); // Update v-model

      this.$emit(MODEL_EVENT_NAME, this.index);

      if (this.noAnimation) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.addClass)(nextSlide, 'active');
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.removeClass)(currentSlide, 'active');
        this.isSliding = false; // Notify ourselves that we're done sliding (slid)

        this.$nextTick(function () {
          return _this2.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_SLIDING_END, to);
        });
      } else {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.addClass)(nextSlide, overlayClass); // Trigger a reflow of next slide

        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.reflow)(nextSlide);
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.addClass)(currentSlide, dirClass);
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.addClass)(nextSlide, dirClass); // Transition End handler

        var called = false;
        /* istanbul ignore next: difficult to test */

        var onceTransEnd = function onceTransEnd() {
          if (called) {
            return;
          }

          called = true;
          /* istanbul ignore if: transition events cant be tested in JSDOM */

          if (_this2.transitionEndEvent) {
            var events = _this2.transitionEndEvent.split(/\s+/);

            events.forEach(function (event) {
              return (0,_utils_events__WEBPACK_IMPORTED_MODULE_15__.eventOff)(nextSlide, event, onceTransEnd, _constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_OPTIONS_NO_CAPTURE);
            });
          }

          _this2.clearAnimationTimeout();

          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.removeClass)(nextSlide, dirClass);
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.removeClass)(nextSlide, overlayClass);
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.addClass)(nextSlide, 'active');
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.removeClass)(currentSlide, 'active');
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.removeClass)(currentSlide, dirClass);
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.removeClass)(currentSlide, overlayClass);
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(currentSlide, 'aria-current', 'false');
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(nextSlide, 'aria-current', 'true');
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(currentSlide, 'aria-hidden', 'true');
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(nextSlide, 'aria-hidden', 'false');
          _this2.isSliding = false;
          _this2.direction = null; // Notify ourselves that we're done sliding (slid)

          _this2.$nextTick(function () {
            return _this2.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_SLIDING_END, to);
          });
        }; // Set up transitionend handler

        /* istanbul ignore if: transition events cant be tested in JSDOM */


        if (this.transitionEndEvent) {
          var events = this.transitionEndEvent.split(/\s+/);
          events.forEach(function (event) {
            return (0,_utils_events__WEBPACK_IMPORTED_MODULE_15__.eventOn)(nextSlide, event, onceTransEnd, _constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_OPTIONS_NO_CAPTURE);
          });
        } // Fallback to setTimeout()


        this.$_animationTimeout = setTimeout(onceTransEnd, TRANS_DURATION);
      }

      if (isCycling) {
        this.start(false);
      }
    },
    // Update slide list
    updateSlides: function updateSlides() {
      this.pause(true); // Get all slides as DOM elements

      this.slides = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.selectAll)('.carousel-item', this.$refs.inner);
      var numSlides = this.slides.length; // Keep slide number in range

      var index = (0,_utils_math__WEBPACK_IMPORTED_MODULE_13__.mathMax)(0, (0,_utils_math__WEBPACK_IMPORTED_MODULE_13__.mathMin)((0,_utils_math__WEBPACK_IMPORTED_MODULE_13__.mathFloor)(this.index), numSlides - 1));
      this.slides.forEach(function (slide, idx) {
        var n = idx + 1;

        if (idx === index) {
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.addClass)(slide, 'active');
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(slide, 'aria-current', 'true');
        } else {
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.removeClass)(slide, 'active');
          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(slide, 'aria-current', 'false');
        }

        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(slide, 'aria-posinset', String(n));
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_14__.setAttr)(slide, 'aria-setsize', String(numSlides));
      }); // Set slide as active

      this.setSlide(index);
      this.start(this.isPaused);
    },
    calcDirection: function calcDirection() {
      var direction = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : null;
      var curIndex = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;
      var nextIndex = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 0;

      if (!direction) {
        return nextIndex > curIndex ? DIRECTION.next : DIRECTION.prev;
      }

      return DIRECTION[direction];
    },
    handleClick: function handleClick(event, fn) {
      var keyCode = event.keyCode;

      if (event.type === 'click' || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_16__.CODE_SPACE || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_16__.CODE_ENTER) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_15__.stopEvent)(event);
        fn();
      }
    },

    /* istanbul ignore next: JSDOM doesn't support touch events */
    handleSwipe: function handleSwipe() {
      var absDeltaX = (0,_utils_math__WEBPACK_IMPORTED_MODULE_13__.mathAbs)(this.touchDeltaX);

      if (absDeltaX <= SWIPE_THRESHOLD) {
        return;
      }

      var direction = absDeltaX / this.touchDeltaX; // Reset touch delta X
      // https://github.com/twbs/bootstrap/pull/28558

      this.touchDeltaX = 0;

      if (direction > 0) {
        // Swipe left
        this.prev();
      } else if (direction < 0) {
        // Swipe right
        this.next();
      }
    },

    /* istanbul ignore next: JSDOM doesn't support touch events */
    touchStart: function touchStart(event) {
      if (_constants_env__WEBPACK_IMPORTED_MODULE_12__.HAS_POINTER_EVENT_SUPPORT && PointerType[event.pointerType.toUpperCase()]) {
        this.touchStartX = event.clientX;
      } else if (!_constants_env__WEBPACK_IMPORTED_MODULE_12__.HAS_POINTER_EVENT_SUPPORT) {
        this.touchStartX = event.touches[0].clientX;
      }
    },

    /* istanbul ignore next: JSDOM doesn't support touch events */
    touchMove: function touchMove(event) {
      // Ensure swiping with one touch and not pinching
      if (event.touches && event.touches.length > 1) {
        this.touchDeltaX = 0;
      } else {
        this.touchDeltaX = event.touches[0].clientX - this.touchStartX;
      }
    },

    /* istanbul ignore next: JSDOM doesn't support touch events */
    touchEnd: function touchEnd(event) {
      if (_constants_env__WEBPACK_IMPORTED_MODULE_12__.HAS_POINTER_EVENT_SUPPORT && PointerType[event.pointerType.toUpperCase()]) {
        this.touchDeltaX = event.clientX - this.touchStartX;
      }

      this.handleSwipe(); // If it's a touch-enabled device, mouseenter/leave are fired as
      // part of the mouse compatibility events on first tap - the carousel
      // would stop cycling until user tapped out of it;
      // here, we listen for touchend, explicitly pause the carousel
      // (as if it's the second time we tap on it, mouseenter compat event
      // is NOT fired) and after a timeout (to allow for mouse compatibility
      // events to fire) we explicitly restart cycling

      this.pause(false);
      this.clearTouchTimeout();
      this.$_touchTimeout = setTimeout(this.start, TOUCH_EVENT_COMPAT_WAIT + (0,_utils_math__WEBPACK_IMPORTED_MODULE_13__.mathMax)(1000, this.interval));
    }
  },
  render: function render(h) {
    var _this3 = this;

    var indicators = this.indicators,
        background = this.background,
        noAnimation = this.noAnimation,
        noHoverPause = this.noHoverPause,
        noTouch = this.noTouch,
        index = this.index,
        isSliding = this.isSliding,
        pause = this.pause,
        restart = this.restart,
        touchStart = this.touchStart,
        touchEnd = this.touchEnd;
    var idInner = this.safeId('__BV_inner_'); // Wrapper for slides

    var $inner = h('div', {
      staticClass: 'carousel-inner',
      attrs: {
        id: idInner,
        role: 'list'
      },
      ref: 'inner'
    }, [this.normalizeSlot()]); // Prev and next controls

    var $controls = h();

    if (this.controls) {
      var makeControl = function makeControl(direction, label, handler) {
        var handlerWrapper = function handlerWrapper(event) {
          /* istanbul ignore next */
          if (!isSliding) {
            _this3.handleClick(event, handler);
          } else {
            (0,_utils_events__WEBPACK_IMPORTED_MODULE_15__.stopEvent)(event, {
              propagation: false
            });
          }
        };

        return h('a', {
          staticClass: "carousel-control-".concat(direction),
          attrs: {
            href: '#',
            role: 'button',
            'aria-controls': idInner,
            'aria-disabled': isSliding ? 'true' : null
          },
          on: {
            click: handlerWrapper,
            keydown: handlerWrapper
          }
        }, [h('span', {
          staticClass: "carousel-control-".concat(direction, "-icon"),
          attrs: {
            'aria-hidden': 'true'
          }
        }), h('span', {
          class: 'sr-only'
        }, [label])]);
      };

      $controls = [makeControl('prev', this.labelPrev, this.prev), makeControl('next', this.labelNext, this.next)];
    } // Indicators


    var $indicators = h('ol', {
      staticClass: 'carousel-indicators',
      directives: [{
        name: 'show',
        value: indicators
      }],
      attrs: {
        id: this.safeId('__BV_indicators_'),
        'aria-hidden': indicators ? 'false' : 'true',
        'aria-label': this.labelIndicators,
        'aria-owns': idInner
      }
    }, this.slides.map(function (slide, i) {
      var handler = function handler(event) {
        _this3.handleClick(event, function () {
          _this3.setSlide(i);
        });
      };

      return h('li', {
        class: {
          active: i === index
        },
        attrs: {
          role: 'button',
          id: _this3.safeId("__BV_indicator_".concat(i + 1, "_")),
          tabindex: indicators ? '0' : '-1',
          'aria-current': i === index ? 'true' : 'false',
          'aria-label': "".concat(_this3.labelGotoSlide, " ").concat(i + 1),
          'aria-describedby': slide.id || null,
          'aria-controls': idInner
        },
        on: {
          click: handler,
          keydown: handler
        },
        key: "slide_".concat(i)
      });
    }));
    var on = {
      mouseenter: noHoverPause ? _utils_noop__WEBPACK_IMPORTED_MODULE_17__.noop : pause,
      mouseleave: noHoverPause ? _utils_noop__WEBPACK_IMPORTED_MODULE_17__.noop : restart,
      focusin: pause,
      focusout: restart,
      keydown: function keydown(event) {
        /* istanbul ignore next */
        if (/input|textarea/i.test(event.target.tagName)) {
          return;
        }

        var keyCode = event.keyCode;

        if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_16__.CODE_LEFT || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_16__.CODE_RIGHT) {
          (0,_utils_events__WEBPACK_IMPORTED_MODULE_15__.stopEvent)(event);

          _this3[keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_16__.CODE_LEFT ? 'prev' : 'next']();
        }
      }
    }; // Touch support event handlers for environment

    if (_constants_env__WEBPACK_IMPORTED_MODULE_12__.HAS_TOUCH_SUPPORT && !noTouch) {
      // Attach appropriate listeners (prepend event name with '&' for passive mode)

      /* istanbul ignore next: JSDOM doesn't support touch events */
      if (_constants_env__WEBPACK_IMPORTED_MODULE_12__.HAS_POINTER_EVENT_SUPPORT) {
        on['&pointerdown'] = touchStart;
        on['&pointerup'] = touchEnd;
      } else {
        on['&touchstart'] = touchStart;
        on['&touchmove'] = this.touchMove;
        on['&touchend'] = touchEnd;
      }
    } // Return the carousel


    return h('div', {
      staticClass: 'carousel',
      class: {
        slide: !noAnimation,
        'carousel-fade': !noAnimation && this.fade,
        'pointer-event': _constants_env__WEBPACK_IMPORTED_MODULE_12__.HAS_TOUCH_SUPPORT && _constants_env__WEBPACK_IMPORTED_MODULE_12__.HAS_POINTER_EVENT_SUPPORT && !noTouch
      },
      style: {
        background: background
      },
      attrs: {
        role: 'region',
        id: this.safeId(),
        'aria-busy': isSliding ? 'true' : 'false'
      },
      on: on
    }, [$inner, $controls, $indicators]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/carousel/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/carousel/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCarousel": () => (/* reexport safe */ _carousel__WEBPACK_IMPORTED_MODULE_1__.BCarousel),
/* harmony export */   "BCarouselSlide": () => (/* reexport safe */ _carousel_slide__WEBPACK_IMPORTED_MODULE_2__.BCarouselSlide),
/* harmony export */   "CarouselPlugin": () => (/* binding */ CarouselPlugin)
/* harmony export */ });
/* harmony import */ var _carousel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./carousel */ "./node_modules/bootstrap-vue/esm/components/carousel/carousel.js");
/* harmony import */ var _carousel_slide__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./carousel-slide */ "./node_modules/bootstrap-vue/esm/components/carousel/carousel-slide.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var CarouselPlugin =
/*#__PURE*/
(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BCarousel: _carousel__WEBPACK_IMPORTED_MODULE_1__.BCarousel,
    BCarouselSlide: _carousel_slide__WEBPACK_IMPORTED_MODULE_2__.BCarouselSlide
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/collapse/collapse.js":
/*!************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/collapse/collapse.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCollapse": () => (/* binding */ BCollapse),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_classes__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../constants/classes */ "./node_modules/bootstrap-vue/esm/constants/classes.js");
/* harmony import */ var _constants_env__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/env */ "./node_modules/bootstrap-vue/esm/constants/env.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_listen_on_root__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../mixins/listen-on-root */ "./node_modules/bootstrap-vue/esm/mixins/listen-on-root.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _helpers_bv_collapse__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./helpers/bv-collapse */ "./node_modules/bootstrap-vue/esm/components/collapse/helpers/bv-collapse.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
















 // --- Constants ---

var ROOT_ACTION_EVENT_NAME_TOGGLE = (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.getRootActionEventName)(_constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_COLLAPSE, 'toggle');
var ROOT_ACTION_EVENT_NAME_REQUEST_STATE = (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.getRootActionEventName)(_constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_COLLAPSE, 'request-state');
var ROOT_EVENT_NAME_ACCORDION = (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.getRootEventName)(_constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_COLLAPSE, 'accordion');
var ROOT_EVENT_NAME_STATE = (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.getRootEventName)(_constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_COLLAPSE, 'state');
var ROOT_EVENT_NAME_SYNC_STATE = (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.getRootEventName)(_constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_COLLAPSE, 'sync-state');

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_2__.makeModelMixin)('visible', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN,
  defaultValue: false
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // --- Props ---


var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_5__.sortKeys)(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_6__.props), modelProps), {}, {
  // If `true` (and `visible` is `true` on mount), animate initially visible
  accordion: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  appear: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  isNav: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'div')
})), _constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_COLLAPSE); // --- Main component ---
// @vue/component

var BCollapse = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_7__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_COLLAPSE,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_6__.idMixin, modelMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__.normalizeSlotMixin, _mixins_listen_on_root__WEBPACK_IMPORTED_MODULE_9__.listenOnRootMixin],
  props: props,
  data: function data() {
    return {
      show: this[MODEL_PROP_NAME],
      transitioning: false
    };
  },
  computed: {
    classObject: function classObject() {
      var transitioning = this.transitioning;
      return {
        'navbar-collapse': this.isNav,
        collapse: !transitioning,
        show: this.show && !transitioning
      };
    },
    slotScope: function slotScope() {
      var _this = this;

      return {
        visible: this.show,
        close: function close() {
          _this.show = false;
        }
      };
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue) {
    if (newValue !== this.show) {
      this.show = newValue;
    }
  }), _defineProperty(_watch, "show", function show(newValue, oldValue) {
    if (newValue !== oldValue) {
      this.emitState();
    }
  }), _watch),
  created: function created() {
    this.show = this[MODEL_PROP_NAME];
  },
  mounted: function mounted() {
    var _this2 = this;

    this.show = this[MODEL_PROP_NAME]; // Listen for toggle events to open/close us

    this.listenOnRoot(ROOT_ACTION_EVENT_NAME_TOGGLE, this.handleToggleEvt); // Listen to other collapses for accordion events

    this.listenOnRoot(ROOT_EVENT_NAME_ACCORDION, this.handleAccordionEvt);

    if (this.isNav) {
      // Set up handlers
      this.setWindowEvents(true);
      this.handleResize();
    }

    this.$nextTick(function () {
      _this2.emitState();
    }); // Listen for "Sync state" requests from `v-b-toggle`

    this.listenOnRoot(ROOT_ACTION_EVENT_NAME_REQUEST_STATE, function (id) {
      if (id === _this2.safeId()) {
        _this2.$nextTick(_this2.emitSync);
      }
    });
  },
  updated: function updated() {
    // Emit a private event every time this component updates to ensure
    // the toggle button is in sync with the collapse's state
    // It is emitted regardless if the visible state changes
    this.emitSync();
  },

  /* istanbul ignore next */
  deactivated: function deactivated() {
    if (this.isNav) {
      this.setWindowEvents(false);
    }
  },

  /* istanbul ignore next */
  activated: function activated() {
    if (this.isNav) {
      this.setWindowEvents(true);
    }

    this.emitSync();
  },
  beforeDestroy: function beforeDestroy() {
    // Trigger state emit if needed
    this.show = false;

    if (this.isNav && _constants_env__WEBPACK_IMPORTED_MODULE_10__.IS_BROWSER) {
      this.setWindowEvents(false);
    }
  },
  methods: {
    setWindowEvents: function setWindowEvents(on) {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.eventOnOff)(on, window, 'resize', this.handleResize, _constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_OPTIONS_NO_CAPTURE);
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.eventOnOff)(on, window, 'orientationchange', this.handleResize, _constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_OPTIONS_NO_CAPTURE);
    },
    toggle: function toggle() {
      this.show = !this.show;
    },
    onEnter: function onEnter() {
      this.transitioning = true; // This should be moved out so we can add cancellable events

      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_NAME_SHOW);
    },
    onAfterEnter: function onAfterEnter() {
      this.transitioning = false;
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_NAME_SHOWN);
    },
    onLeave: function onLeave() {
      this.transitioning = true; // This should be moved out so we can add cancellable events

      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_NAME_HIDE);
    },
    onAfterLeave: function onAfterLeave() {
      this.transitioning = false;
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_NAME_HIDDEN);
    },
    emitState: function emitState() {
      var show = this.show,
          accordion = this.accordion;
      var id = this.safeId();
      this.$emit(MODEL_EVENT_NAME, show); // Let `v-b-toggle` know the state of this collapse

      this.emitOnRoot(ROOT_EVENT_NAME_STATE, id, show);

      if (accordion && show) {
        // Tell the other collapses in this accordion to close
        this.emitOnRoot(ROOT_EVENT_NAME_ACCORDION, id, accordion);
      }
    },
    emitSync: function emitSync() {
      // Emit a private event every time this component updates to ensure
      // the toggle button is in sync with the collapse's state
      // It is emitted regardless if the visible state changes
      this.emitOnRoot(ROOT_EVENT_NAME_SYNC_STATE, this.safeId(), this.show);
    },
    checkDisplayBlock: function checkDisplayBlock() {
      // Check to see if the collapse has `display: block !important` set
      // We can't set `display: none` directly on `this.$el`, as it would
      // trigger a new transition to start (or cancel a current one)
      var $el = this.$el;
      var restore = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.hasClass)($el, _constants_classes__WEBPACK_IMPORTED_MODULE_13__.CLASS_NAME_SHOW);
      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.removeClass)($el, _constants_classes__WEBPACK_IMPORTED_MODULE_13__.CLASS_NAME_SHOW);
      var isBlock = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.getCS)($el).display === 'block';

      if (restore) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.addClass)($el, _constants_classes__WEBPACK_IMPORTED_MODULE_13__.CLASS_NAME_SHOW);
      }

      return isBlock;
    },
    clickHandler: function clickHandler(event) {
      var el = event.target; // If we are in a nav/navbar, close the collapse when non-disabled link clicked

      /* istanbul ignore next: can't test `getComputedStyle()` in JSDOM */

      if (!this.isNav || !el || (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.getCS)(this.$el).display !== 'block') {
        return;
      } // Only close the collapse if it is not forced to be `display: block !important`


      if (((0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.matches)(el, '.nav-link,.dropdown-item') || (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.closest)('.nav-link,.dropdown-item', el)) && !this.checkDisplayBlock()) {
        this.show = false;
      }
    },
    handleToggleEvt: function handleToggleEvt(id) {
      if (id === this.safeId()) {
        this.toggle();
      }
    },
    handleAccordionEvt: function handleAccordionEvt(openedId, openAccordion) {
      var accordion = this.accordion,
          show = this.show;

      if (!accordion || accordion !== openAccordion) {
        return;
      }

      var isThis = openedId === this.safeId(); // Open this collapse if not shown or
      // close this collapse if shown

      if (isThis && !show || !isThis && show) {
        this.toggle();
      }
    },
    handleResize: function handleResize() {
      // Handler for orientation/resize to set collapsed state in nav/navbar
      this.show = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.getCS)(this.$el).display === 'block';
    }
  },
  render: function render(h) {
    var appear = this.appear;
    var $content = h(this.tag, {
      class: this.classObject,
      directives: [{
        name: 'show',
        value: this.show
      }],
      attrs: {
        id: this.safeId()
      },
      on: {
        click: this.clickHandler
      }
    }, this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_DEFAULT, this.slotScope));
    return h(_helpers_bv_collapse__WEBPACK_IMPORTED_MODULE_15__.BVCollapse, {
      props: {
        appear: appear
      },
      on: {
        enter: this.onEnter,
        afterEnter: this.onAfterEnter,
        leave: this.onLeave,
        afterLeave: this.onAfterLeave
      }
    }, [$content]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/collapse/helpers/bv-collapse.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/collapse/helpers/bv-collapse.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BVCollapse": () => (/* binding */ BVCollapse),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
// Generic collapse transion helper component
//
// Note:
//   Applies the classes `collapse`, `show` and `collapsing`
//   during the enter/leave transition phases only
//   Although it appears that Vue may be leaving the classes
//   in-place after the transition completes




 // --- Helper methods ---
// Transition event handler helpers

var onEnter = function onEnter(el) {
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.setStyle)(el, 'height', 0); // In a `requestAF()` for `appear` to work

  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.requestAF)(function () {
    (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.reflow)(el);
    (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.setStyle)(el, 'height', "".concat(el.scrollHeight, "px"));
  });
};

var onAfterEnter = function onAfterEnter(el) {
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.removeStyle)(el, 'height');
};

var onLeave = function onLeave(el) {
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.setStyle)(el, 'height', 'auto');
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.setStyle)(el, 'display', 'block');
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.setStyle)(el, 'height', "".concat((0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.getBCR)(el).height, "px"));
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.reflow)(el);
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.setStyle)(el, 'height', 0);
};

var onAfterLeave = function onAfterLeave(el) {
  (0,_utils_dom__WEBPACK_IMPORTED_MODULE_0__.removeStyle)(el, 'height');
}; // --- Constants ---
// Default transition props
// `appear` will use the enter classes


var TRANSITION_PROPS = {
  css: true,
  enterClass: '',
  enterActiveClass: 'collapsing',
  enterToClass: 'collapse show',
  leaveClass: 'collapse show',
  leaveActiveClass: 'collapsing',
  leaveToClass: 'collapse'
}; // Default transition handlers
// `appear` will use the enter handlers

var TRANSITION_HANDLERS = {
  enter: onEnter,
  afterEnter: onAfterEnter,
  leave: onLeave,
  afterLeave: onAfterLeave
}; // --- Main component ---

var props = {
  // // If `true` (and `visible` is `true` on mount), animate initially visible
  appear: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false)
}; // --- Main component ---
// @vue/component

var BVCollapse = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_COLLAPSE_HELPER,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h('transition', // We merge in the `appear` prop last
    (0,_vue__WEBPACK_IMPORTED_MODULE_5__.mergeData)(data, {
      props: TRANSITION_PROPS,
      on: TRANSITION_HANDLERS
    }, {
      props: props
    }), // Note: `<transition>` supports a single root element only
    children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/collapse/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/collapse/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCollapse": () => (/* reexport safe */ _collapse__WEBPACK_IMPORTED_MODULE_1__.BCollapse),
/* harmony export */   "CollapsePlugin": () => (/* binding */ CollapsePlugin)
/* harmony export */ });
/* harmony import */ var _collapse__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./collapse */ "./node_modules/bootstrap-vue/esm/components/collapse/collapse.js");
/* harmony import */ var _directives_toggle__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../directives/toggle */ "./node_modules/bootstrap-vue/esm/directives/toggle/index.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var CollapsePlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BCollapse: _collapse__WEBPACK_IMPORTED_MODULE_1__.BCollapse
  },
  plugins: {
    VBTogglePlugin: _directives_toggle__WEBPACK_IMPORTED_MODULE_2__.VBTogglePlugin
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-divider.js":
/*!********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-divider.js ***!
  \********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdownDivider": () => (/* binding */ BDropdownDivider),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'hr')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_DIVIDER); // --- Main component ---
// @vue/component

var BDropdownDivider = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_DIVIDER,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data;
    return h('li', (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)((0,_utils_object__WEBPACK_IMPORTED_MODULE_5__.omit)(data, ['attrs']), {
      attrs: {
        role: 'presentation'
      }
    }), [h(props.tag, {
      staticClass: 'dropdown-divider',
      attrs: _objectSpread(_objectSpread({}, data.attrs || {}), {}, {
        role: 'separator',
        'aria-orientation': 'horizontal'
      }),
      ref: 'divider'
    })]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-form.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-form.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdownForm": () => (/* binding */ BDropdownForm),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _form_form__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../form/form */ "./node_modules/bootstrap-vue/esm/components/form/form.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, _form_form__WEBPACK_IMPORTED_MODULE_2__.props), {}, {
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  formClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_ARRAY_OBJECT_STRING)
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_DROPDOWN_FORM); // --- Main component ---
// @vue/component

var BDropdownForm = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_DROPDOWN_FORM,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        listeners = _ref.listeners,
        children = _ref.children;
    return h('li', (0,_vue__WEBPACK_IMPORTED_MODULE_6__.mergeData)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(data, ['attrs', 'on']), {
      attrs: {
        role: 'presentation'
      }
    }), [h(_form_form__WEBPACK_IMPORTED_MODULE_2__.BForm, {
      staticClass: 'b-dropdown-form',
      class: [props.formClass, {
        disabled: props.disabled
      }],
      props: props,
      attrs: _objectSpread(_objectSpread({}, data.attrs || {}), {}, {
        disabled: props.disabled,
        // Tab index of -1 for keyboard navigation
        tabindex: props.disabled ? null : '-1'
      }),
      on: listeners,
      ref: 'form'
    }, children)]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-group.js":
/*!******************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-group.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdownGroup": () => (/* binding */ BDropdownGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/normalize-slot */ "./node_modules/bootstrap-vue/esm/utils/normalize-slot.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }









 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  ariaDescribedby: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  header: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  headerClasses: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_OBJECT_STRING),
  headerTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'header'),
  headerVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_GROUP); // --- Main component ---
// @vue/component

var BDropdownGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_GROUP,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        slots = _ref.slots,
        scopedSlots = _ref.scopedSlots;
    var id = props.id,
        variant = props.variant,
        header = props.header,
        headerTag = props.headerTag;
    var $slots = slots();
    var $scopedSlots = scopedSlots || {};
    var slotScope = {};
    var headerId = id ? "_bv_".concat(id, "_group_dd_header") : null;
    var $header = h();

    if ((0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_HEADER, $scopedSlots, $slots) || header) {
      $header = h(headerTag, {
        staticClass: 'dropdown-header',
        class: [props.headerClasses, _defineProperty({}, "text-".concat(variant), variant)],
        attrs: {
          id: headerId,
          role: (0,_utils_dom__WEBPACK_IMPORTED_MODULE_6__.isTag)(headerTag, 'header') ? null : 'heading'
        }
      }, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_HEADER, slotScope, $scopedSlots, $slots) || header);
    }

    return h('li', (0,_vue__WEBPACK_IMPORTED_MODULE_7__.mergeData)((0,_utils_object__WEBPACK_IMPORTED_MODULE_8__.omit)(data, ['attrs']), {
      attrs: {
        role: 'presentation'
      }
    }), [$header, h('ul', {
      staticClass: 'list-unstyled',
      attrs: _objectSpread(_objectSpread({}, data.attrs || {}), {}, {
        id: id,
        role: 'group',
        'aria-describedby': [headerId, props.ariaDescribedBy].filter(_utils_identity__WEBPACK_IMPORTED_MODULE_9__.identity).join(' ').trim() || null
      })
    }, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_DEFAULT, slotScope, $scopedSlots, $slots))]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-header.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-header.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdownHeader": () => (/* binding */ BDropdownHeader),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'header'),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_HEADER); // --- Main component ---
// @vue/component

var BDropdownHeader = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_HEADER,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var tag = props.tag,
        variant = props.variant;
    return h('li', (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)((0,_utils_object__WEBPACK_IMPORTED_MODULE_5__.omit)(data, ['attrs']), {
      attrs: {
        role: 'presentation'
      }
    }), [h(tag, {
      staticClass: 'dropdown-header',
      class: _defineProperty({}, "text-".concat(variant), variant),
      attrs: _objectSpread(_objectSpread({}, data.attrs || {}), {}, {
        id: props.id || null,
        role: (0,_utils_dom__WEBPACK_IMPORTED_MODULE_6__.isTag)(tag, 'header') ? null : 'heading'
      }),
      ref: 'header'
    }, children)]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-item-button.js":
/*!************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-item-button.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdownItemButton": () => (/* binding */ BDropdownItemButton),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_attrs__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/attrs */ "./node_modules/bootstrap-vue/esm/mixins/attrs.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  active: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  activeClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'active'),
  buttonClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_OBJECT_STRING),
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_ITEM_BUTTON); // --- Main component ---
// @vue/component

var BDropdownItemButton = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_ITEM_BUTTON,
  mixins: [_mixins_attrs__WEBPACK_IMPORTED_MODULE_4__.attrsMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_5__.normalizeSlotMixin],
  inject: {
    bvDropdown: {
      default: null
    }
  },
  inheritAttrs: false,
  props: props,
  computed: {
    computedAttrs: function computedAttrs() {
      return _objectSpread(_objectSpread({}, this.bvAttrs), {}, {
        role: 'menuitem',
        type: 'button',
        disabled: this.disabled
      });
    }
  },
  methods: {
    closeDropdown: function closeDropdown() {
      if (this.bvDropdown) {
        this.bvDropdown.hide(true);
      }
    },
    onClick: function onClick(event) {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_6__.EVENT_NAME_CLICK, event);
      this.closeDropdown();
    }
  },
  render: function render(h) {
    var _ref;

    var active = this.active,
        variant = this.variant,
        bvAttrs = this.bvAttrs;
    return h('li', {
      class: bvAttrs.class,
      style: bvAttrs.style,
      attrs: {
        role: 'presentation'
      }
    }, [h('button', {
      staticClass: 'dropdown-item',
      class: [this.buttonClass, (_ref = {}, _defineProperty(_ref, this.activeClass, active), _defineProperty(_ref, "text-".concat(variant), variant && !(active || this.disabled)), _ref)],
      attrs: this.computedAttrs,
      on: {
        click: this.onClick
      },
      ref: 'button'
    }, this.normalizeSlot())]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-item.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-item.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdownItem": () => (/* binding */ BDropdownItem),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_attrs__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/attrs */ "./node_modules/bootstrap-vue/esm/mixins/attrs.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _link_link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../link/link */ "./node_modules/bootstrap-vue/esm/components/link/link.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










 // --- Props ---

var linkProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.omit)(_link_link__WEBPACK_IMPORTED_MODULE_1__.props, ['event', 'routerTag']);
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.sortKeys)(_objectSpread(_objectSpread({}, linkProps), {}, {
  linkClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_ARRAY_OBJECT_STRING),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING)
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_DROPDOWN_ITEM); // --- Main component ---
// @vue/component

var BDropdownItem = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_DROPDOWN_ITEM,
  mixins: [_mixins_attrs__WEBPACK_IMPORTED_MODULE_6__.attrsMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_7__.normalizeSlotMixin],
  inject: {
    bvDropdown: {
      default: null
    }
  },
  inheritAttrs: false,
  props: props,
  computed: {
    computedAttrs: function computedAttrs() {
      return _objectSpread(_objectSpread({}, this.bvAttrs), {}, {
        role: 'menuitem'
      });
    }
  },
  methods: {
    closeDropdown: function closeDropdown() {
      var _this = this;

      // Close on next animation frame to allow <b-link> time to process
      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_8__.requestAF)(function () {
        if (_this.bvDropdown) {
          _this.bvDropdown.hide(true);
        }
      });
    },
    onClick: function onClick(event) {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_9__.EVENT_NAME_CLICK, event);
      this.closeDropdown();
    }
  },
  render: function render(h) {
    var linkClass = this.linkClass,
        variant = this.variant,
        active = this.active,
        disabled = this.disabled,
        onClick = this.onClick,
        bvAttrs = this.bvAttrs;
    return h('li', {
      class: bvAttrs.class,
      style: bvAttrs.style,
      attrs: {
        role: 'presentation'
      }
    }, [h(_link_link__WEBPACK_IMPORTED_MODULE_1__.BLink, {
      staticClass: 'dropdown-item',
      class: [linkClass, _defineProperty({}, "text-".concat(variant), variant && !(active || disabled))],
      props: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.pluckProps)(linkProps, this.$props),
      attrs: this.computedAttrs,
      on: {
        click: onClick
      },
      ref: 'item'
    }, this.normalizeSlot())]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-text.js":
/*!*****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-text.js ***!
  \*****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdownText": () => (/* binding */ BDropdownText),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'p'),
  textClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_OBJECT_STRING),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_TEXT); // --- Main component ---
// @vue/component

var BDropdownText = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_DROPDOWN_TEXT,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var tag = props.tag,
        textClass = props.textClass,
        variant = props.variant;
    return h('li', (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)((0,_utils_object__WEBPACK_IMPORTED_MODULE_5__.omit)(data, ['attrs']), {
      attrs: {
        role: 'presentation'
      }
    }), [h(tag, {
      staticClass: 'b-dropdown-text',
      class: [textClass, _defineProperty({}, "text-".concat(variant), variant)],
      props: props,
      attrs: data.attrs || {},
      ref: 'text'
    }, children)]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown.js":
/*!************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/dropdown.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdown": () => (/* binding */ BDropdown),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _mixins_dropdown__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/dropdown */ "./node_modules/bootstrap-vue/esm/mixins/dropdown.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../button/button */ "./node_modules/bootstrap-vue/esm/components/button/button.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }













 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.props), _mixins_dropdown__WEBPACK_IMPORTED_MODULE_3__.props), {}, {
  block: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_BOOLEAN, false),
  html: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING),
  // If `true`, only render menu contents when open
  lazy: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_BOOLEAN, false),
  menuClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_ARRAY_OBJECT_STRING),
  noCaret: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_BOOLEAN, false),
  role: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING, 'menu'),
  size: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING),
  split: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_BOOLEAN, false),
  splitButtonType: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING, 'button', function (value) {
    return (0,_utils_array__WEBPACK_IMPORTED_MODULE_5__.arrayIncludes)(['button', 'submit', 'reset'], value);
  }),
  splitClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_ARRAY_OBJECT_STRING),
  splitHref: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING),
  splitTo: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_OBJECT_STRING),
  splitVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING),
  text: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING),
  toggleClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_ARRAY_OBJECT_STRING),
  toggleTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING, 'button'),
  // TODO: This really should be `toggleLabel`
  toggleText: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING, 'Toggle dropdown'),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING, 'secondary')
})), _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_DROPDOWN); // --- Main component ---
// @vue/component

var BDropdown = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_7__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_DROPDOWN,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_2__.idMixin, _mixins_dropdown__WEBPACK_IMPORTED_MODULE_3__.dropdownMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_8__.normalizeSlotMixin],
  props: props,
  computed: {
    dropdownClasses: function dropdownClasses() {
      var block = this.block,
          split = this.split;
      return [this.directionClass, this.boundaryClass, {
        show: this.visible,
        // The 'btn-group' class is required in `split` mode for button alignment
        // It needs also to be applied when `block` is disabled to allow multiple
        // dropdowns to be aligned one line
        'btn-group': split || !block,
        // When `block` is enabled and we are in `split` mode the 'd-flex' class
        // needs to be applied to allow the buttons to stretch to full width
        'd-flex': block && split
      }];
    },
    menuClasses: function menuClasses() {
      return [this.menuClass, {
        'dropdown-menu-right': this.right,
        show: this.visible
      }];
    },
    toggleClasses: function toggleClasses() {
      var split = this.split;
      return [this.toggleClass, {
        'dropdown-toggle-split': split,
        'dropdown-toggle-no-caret': this.noCaret && !split
      }];
    }
  },
  render: function render(h) {
    var visible = this.visible,
        variant = this.variant,
        size = this.size,
        block = this.block,
        disabled = this.disabled,
        split = this.split,
        role = this.role,
        hide = this.hide,
        toggle = this.toggle;
    var commonProps = {
      variant: variant,
      size: size,
      block: block,
      disabled: disabled
    };
    var $buttonChildren = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_9__.SLOT_NAME_BUTTON_CONTENT);
    var buttonContentDomProps = this.hasNormalizedSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_9__.SLOT_NAME_BUTTON_CONTENT) ? {} : (0,_utils_html__WEBPACK_IMPORTED_MODULE_10__.htmlOrText)(this.html, this.text);
    var $split = h();

    if (split) {
      var splitTo = this.splitTo,
          splitHref = this.splitHref,
          splitButtonType = this.splitButtonType;

      var btnProps = _objectSpread(_objectSpread({}, commonProps), {}, {
        variant: this.splitVariant || variant
      }); // We add these as needed due to <router-link> issues with
      // defined property with `undefined`/`null` values


      if (splitTo) {
        btnProps.to = splitTo;
      } else if (splitHref) {
        btnProps.href = splitHref;
      } else if (splitButtonType) {
        btnProps.type = splitButtonType;
      }

      $split = h(_button_button__WEBPACK_IMPORTED_MODULE_11__.BButton, {
        class: this.splitClass,
        attrs: {
          id: this.safeId('_BV_button_')
        },
        props: btnProps,
        domProps: buttonContentDomProps,
        on: {
          click: this.onSplitClick
        },
        ref: 'button'
      }, $buttonChildren); // Overwrite button content for the toggle when in `split` mode

      $buttonChildren = [h('span', {
        class: ['sr-only']
      }, [this.toggleText])];
      buttonContentDomProps = {};
    }

    var $toggle = h(_button_button__WEBPACK_IMPORTED_MODULE_11__.BButton, {
      staticClass: 'dropdown-toggle',
      class: this.toggleClasses,
      attrs: {
        id: this.safeId('_BV_toggle_'),
        'aria-haspopup': 'true',
        'aria-expanded': (0,_utils_string__WEBPACK_IMPORTED_MODULE_12__.toString)(visible)
      },
      props: _objectSpread(_objectSpread({}, commonProps), {}, {
        tag: this.toggleTag,
        block: block && !split
      }),
      domProps: buttonContentDomProps,
      on: {
        mousedown: this.onMousedown,
        click: toggle,
        keydown: toggle // Handle ENTER, SPACE and DOWN

      },
      ref: 'toggle'
    }, $buttonChildren);
    var $menu = h('ul', {
      staticClass: 'dropdown-menu',
      class: this.menuClasses,
      attrs: {
        role: role,
        tabindex: '-1',
        'aria-labelledby': this.safeId(split ? '_BV_button_' : '_BV_toggle_')
      },
      on: {
        keydown: this.onKeydown // Handle UP, DOWN and ESC

      },
      ref: 'menu'
    }, [!this.lazy || visible ? this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_9__.SLOT_NAME_DEFAULT, {
      hide: hide
    }) : h()]);
    return h('div', {
      staticClass: 'dropdown b-dropdown',
      class: this.dropdownClasses,
      attrs: {
        id: this.safeId()
      }
    }, [$split, $toggle, $menu]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/dropdown/index.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/dropdown/index.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BDropdown": () => (/* reexport safe */ _dropdown__WEBPACK_IMPORTED_MODULE_1__.BDropdown),
/* harmony export */   "BDropdownDivider": () => (/* reexport safe */ _dropdown_divider__WEBPACK_IMPORTED_MODULE_5__.BDropdownDivider),
/* harmony export */   "BDropdownForm": () => (/* reexport safe */ _dropdown_form__WEBPACK_IMPORTED_MODULE_6__.BDropdownForm),
/* harmony export */   "BDropdownGroup": () => (/* reexport safe */ _dropdown_group__WEBPACK_IMPORTED_MODULE_8__.BDropdownGroup),
/* harmony export */   "BDropdownHeader": () => (/* reexport safe */ _dropdown_header__WEBPACK_IMPORTED_MODULE_4__.BDropdownHeader),
/* harmony export */   "BDropdownItem": () => (/* reexport safe */ _dropdown_item__WEBPACK_IMPORTED_MODULE_2__.BDropdownItem),
/* harmony export */   "BDropdownItemButton": () => (/* reexport safe */ _dropdown_item_button__WEBPACK_IMPORTED_MODULE_3__.BDropdownItemButton),
/* harmony export */   "BDropdownText": () => (/* reexport safe */ _dropdown_text__WEBPACK_IMPORTED_MODULE_7__.BDropdownText),
/* harmony export */   "DropdownPlugin": () => (/* binding */ DropdownPlugin)
/* harmony export */ });
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./dropdown */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown.js");
/* harmony import */ var _dropdown_item__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./dropdown-item */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-item.js");
/* harmony import */ var _dropdown_item_button__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./dropdown-item-button */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-item-button.js");
/* harmony import */ var _dropdown_header__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./dropdown-header */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-header.js");
/* harmony import */ var _dropdown_divider__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./dropdown-divider */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-divider.js");
/* harmony import */ var _dropdown_form__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./dropdown-form */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-form.js");
/* harmony import */ var _dropdown_text__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./dropdown-text */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-text.js");
/* harmony import */ var _dropdown_group__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./dropdown-group */ "./node_modules/bootstrap-vue/esm/components/dropdown/dropdown-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");









var DropdownPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BDropdown: _dropdown__WEBPACK_IMPORTED_MODULE_1__.BDropdown,
    BDd: _dropdown__WEBPACK_IMPORTED_MODULE_1__.BDropdown,
    BDropdownItem: _dropdown_item__WEBPACK_IMPORTED_MODULE_2__.BDropdownItem,
    BDdItem: _dropdown_item__WEBPACK_IMPORTED_MODULE_2__.BDropdownItem,
    BDropdownItemButton: _dropdown_item_button__WEBPACK_IMPORTED_MODULE_3__.BDropdownItemButton,
    BDropdownItemBtn: _dropdown_item_button__WEBPACK_IMPORTED_MODULE_3__.BDropdownItemButton,
    BDdItemButton: _dropdown_item_button__WEBPACK_IMPORTED_MODULE_3__.BDropdownItemButton,
    BDdItemBtn: _dropdown_item_button__WEBPACK_IMPORTED_MODULE_3__.BDropdownItemButton,
    BDropdownHeader: _dropdown_header__WEBPACK_IMPORTED_MODULE_4__.BDropdownHeader,
    BDdHeader: _dropdown_header__WEBPACK_IMPORTED_MODULE_4__.BDropdownHeader,
    BDropdownDivider: _dropdown_divider__WEBPACK_IMPORTED_MODULE_5__.BDropdownDivider,
    BDdDivider: _dropdown_divider__WEBPACK_IMPORTED_MODULE_5__.BDropdownDivider,
    BDropdownForm: _dropdown_form__WEBPACK_IMPORTED_MODULE_6__.BDropdownForm,
    BDdForm: _dropdown_form__WEBPACK_IMPORTED_MODULE_6__.BDropdownForm,
    BDropdownText: _dropdown_text__WEBPACK_IMPORTED_MODULE_7__.BDropdownText,
    BDdText: _dropdown_text__WEBPACK_IMPORTED_MODULE_7__.BDropdownText,
    BDropdownGroup: _dropdown_group__WEBPACK_IMPORTED_MODULE_8__.BDropdownGroup,
    BDdGroup: _dropdown_group__WEBPACK_IMPORTED_MODULE_8__.BDropdownGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/embed/embed.js":
/*!******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/embed/embed.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BEmbed": () => (/* binding */ BEmbed),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






 // --- Constants ---

var TYPES = ['iframe', 'embed', 'video', 'object', 'img', 'b-img', 'b-img-lazy']; // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  aspect: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, '16by9'),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div'),
  type: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'iframe', function (value) {
    return (0,_utils_array__WEBPACK_IMPORTED_MODULE_2__.arrayIncludes)(TYPES, value);
  })
}, _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_EMBED); // --- Main component ---
// @vue/component

var BEmbed = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_4__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_EMBED,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var aspect = props.aspect;
    return h(props.tag, {
      staticClass: 'embed-responsive',
      class: _defineProperty({}, "embed-responsive-".concat(aspect), aspect),
      ref: data.ref
    }, [h(props.type, (0,_vue__WEBPACK_IMPORTED_MODULE_5__.mergeData)((0,_utils_object__WEBPACK_IMPORTED_MODULE_6__.omit)(data, ['ref']), {
      staticClass: 'embed-responsive-item'
    }), children)]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/embed/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/embed/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BEmbed": () => (/* reexport safe */ _embed__WEBPACK_IMPORTED_MODULE_1__.BEmbed),
/* harmony export */   "EmbedPlugin": () => (/* binding */ EmbedPlugin)
/* harmony export */ });
/* harmony import */ var _embed__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./embed */ "./node_modules/bootstrap-vue/esm/components/embed/embed.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var EmbedPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BEmbed: _embed__WEBPACK_IMPORTED_MODULE_1__.BEmbed
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-btn-label-control/bv-form-btn-label-control.js":
/*!*******************************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-btn-label-control/bv-form-btn-label-control.js ***!
  \*******************************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BVFormBtnLabelControl": () => (/* binding */ BVFormBtnLabelControl),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _mixins_dropdown__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/dropdown */ "./node_modules/bootstrap-vue/esm/mixins/dropdown.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _directives_hover_hover__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../directives/hover/hover */ "./node_modules/bootstrap-vue/esm/directives/hover/hover.js");
/* harmony import */ var _icons_icons__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../icons/icons */ "./node_modules/bootstrap-vue/esm/icons/icons.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

//
// Private component used by `b-form-datepicker` and `b-form-timepicker`
//
















 // --- Props ---

var props = (0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_1__.props), _mixins_form_size__WEBPACK_IMPORTED_MODULE_2__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_3__.props), (0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.omit)(_mixins_dropdown__WEBPACK_IMPORTED_MODULE_4__.props, ['disabled'])), (0,_utils_object__WEBPACK_IMPORTED_MODULE_0__.omit)(_mixins_form_control__WEBPACK_IMPORTED_MODULE_5__.props, ['autofocus'])), {}, {
  // When `true`, renders a `btn-group` wrapper and visually hides the label
  buttonOnly: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, false),
  // Applicable in button mode only
  buttonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING, 'secondary'),
  // This is the value shown in the label
  // Defaults back to `value`
  formattedValue: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING),
  // Value placed in `.sr-only` span inside label when value is present
  labelSelected: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING),
  lang: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING),
  // Extra classes to apply to the `dropdown-menu` div
  menuClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_ARRAY_OBJECT_STRING),
  // This is the value placed on the hidden input when no value selected
  placeholder: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING),
  readonly: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, false),
  // Tri-state prop: `true`, `false` or `null`
  rtl: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, null),
  value: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING, '')
})); // --- Main component ---
// @vue/component

var BVFormBtnLabelControl = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_8__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_FORM_BUTTON_LABEL_CONTROL,
  directives: {
    'b-hover': _directives_hover_hover__WEBPACK_IMPORTED_MODULE_10__.VBHover
  },
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_1__.idMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_2__.formSizeMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_3__.formStateMixin, _mixins_dropdown__WEBPACK_IMPORTED_MODULE_4__.dropdownMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_11__.normalizeSlotMixin],
  props: props,
  data: function data() {
    return {
      isHovered: false,
      hasFocus: false
    };
  },
  computed: {
    idButton: function idButton() {
      return this.safeId();
    },
    idLabel: function idLabel() {
      return this.safeId('_value_');
    },
    idMenu: function idMenu() {
      return this.safeId('_dialog_');
    },
    idWrapper: function idWrapper() {
      return this.safeId('_outer_');
    },
    computedDir: function computedDir() {
      return this.rtl === true ? 'rtl' : this.rtl === false ? 'ltr' : null;
    }
  },
  methods: {
    focus: function focus() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.attemptFocus)(this.$refs.toggle);
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.attemptBlur)(this.$refs.toggle);
      }
    },
    setFocus: function setFocus(event) {
      this.hasFocus = event.type === 'focus';
    },
    handleHover: function handleHover(hovered) {
      this.isHovered = hovered;
    }
  },
  render: function render(h) {
    var _class;

    var idButton = this.idButton,
        idLabel = this.idLabel,
        idMenu = this.idMenu,
        idWrapper = this.idWrapper,
        disabled = this.disabled,
        readonly = this.readonly,
        required = this.required,
        name = this.name,
        state = this.state,
        visible = this.visible,
        size = this.size,
        isHovered = this.isHovered,
        hasFocus = this.hasFocus,
        labelSelected = this.labelSelected,
        buttonVariant = this.buttonVariant,
        buttonOnly = this.buttonOnly;
    var value = (0,_utils_string__WEBPACK_IMPORTED_MODULE_13__.toString)(this.value) || '';
    var invalid = state === false || required && !value;
    var btnScope = {
      isHovered: isHovered,
      hasFocus: hasFocus,
      state: state,
      opened: visible
    };
    var $button = h('button', {
      staticClass: 'btn',
      class: (_class = {}, _defineProperty(_class, "btn-".concat(buttonVariant), buttonOnly), _defineProperty(_class, "btn-".concat(size), size), _defineProperty(_class, 'h-auto', !buttonOnly), _defineProperty(_class, 'dropdown-toggle', buttonOnly), _defineProperty(_class, 'dropdown-toggle-no-caret', buttonOnly), _class),
      attrs: {
        id: idButton,
        type: 'button',
        disabled: disabled,
        'aria-haspopup': 'dialog',
        'aria-expanded': visible ? 'true' : 'false',
        'aria-invalid': invalid ? 'true' : null,
        'aria-required': required ? 'true' : null
      },
      directives: [{
        name: 'b-hover',
        value: this.handleHover
      }],
      on: {
        mousedown: this.onMousedown,
        click: this.toggle,
        keydown: this.toggle,
        // Handle ENTER, SPACE and DOWN
        '!focus': this.setFocus,
        '!blur': this.setFocus
      },
      ref: 'toggle'
    }, [this.hasNormalizedSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_BUTTON_CONTENT) ? this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_BUTTON_CONTENT, btnScope) :
    /* istanbul ignore next */
    h(_icons_icons__WEBPACK_IMPORTED_MODULE_15__.BIconChevronDown, {
      props: {
        scale: 1.25
      }
    })]); // Hidden input

    var $hidden = h();

    if (name && !disabled) {
      $hidden = h('input', {
        attrs: {
          type: 'hidden',
          name: name || null,
          form: this.form || null,
          value: value
        }
      });
    } // Dropdown content


    var $menu = h('div', {
      staticClass: 'dropdown-menu',
      class: [this.menuClass, {
        show: visible,
        'dropdown-menu-right': this.right
      }],
      attrs: {
        id: idMenu,
        role: 'dialog',
        tabindex: '-1',
        'aria-modal': 'false',
        'aria-labelledby': idLabel
      },
      on: {
        keydown: this.onKeydown // Handle ESC

      },
      ref: 'menu'
    }, [this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_DEFAULT, {
      opened: visible
    })]); // Value label

    var $label = h('label', {
      class: buttonOnly ? 'sr-only' // Hidden in button only mode
      : ['form-control', // Mute the text if showing the placeholder
      {
        'text-muted': !value
      }, this.stateClass, this.sizeFormClass],
      attrs: {
        id: idLabel,
        for: idButton,
        'aria-invalid': invalid ? 'true' : null,
        'aria-required': required ? 'true' : null
      },
      directives: [{
        name: 'b-hover',
        value: this.handleHover
      }],
      on: {
        // Disable bubbling of the click event to
        // prevent menu from closing and re-opening
        '!click':
        /* istanbul ignore next */
        function click(event) {
          (0,_utils_events__WEBPACK_IMPORTED_MODULE_16__.stopEvent)(event, {
            preventDefault: false
          });
        }
      }
    }, [value ? this.formattedValue || value : this.placeholder || '', // Add the selected label for screen readers when a value is provided
    value && labelSelected ? h('bdi', {
      staticClass: 'sr-only'
    }, labelSelected) : '']); // Return the custom form control wrapper

    return h('div', {
      staticClass: 'b-form-btn-label-control dropdown',
      class: [this.directionClass, this.boundaryClass, [{
        'btn-group': buttonOnly,
        'form-control': !buttonOnly,
        focus: hasFocus && !buttonOnly,
        show: visible,
        'is-valid': state === true,
        'is-invalid': state === false
      }, buttonOnly ? null : this.sizeFormClass]],
      attrs: {
        id: idWrapper,
        role: buttonOnly ? null : 'group',
        lang: this.lang || null,
        dir: this.computedDir,
        'aria-disabled': disabled,
        'aria-readonly': readonly && !disabled,
        'aria-labelledby': idLabel,
        'aria-invalid': state === false || required && !value ? 'true' : null,
        'aria-required': required ? 'true' : null
      }
    }, [$button, $hidden, $menu, $label]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-checkbox/form-checkbox-group.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-checkbox/form-checkbox-group.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormCheckboxGroup": () => (/* binding */ BFormCheckboxGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_radio_check_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/form-radio-check-group */ "./node_modules/bootstrap-vue/esm/mixins/form-radio-check-group.js");
var _objectSpread2;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, _mixins_form_radio_check_group__WEBPACK_IMPORTED_MODULE_2__.props), {}, (_objectSpread2 = {}, _defineProperty(_objectSpread2, _mixins_form_radio_check_group__WEBPACK_IMPORTED_MODULE_2__.MODEL_PROP_NAME, (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_ARRAY, [])), _defineProperty(_objectSpread2, "switches", (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false)), _objectSpread2))), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_CHECKBOX_GROUP); // --- Main component ---
// @vue/component

var BFormCheckboxGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_CHECKBOX_GROUP,
  // Includes render function
  mixins: [_mixins_form_radio_check_group__WEBPACK_IMPORTED_MODULE_2__.formRadioCheckGroupMixin],
  provide: function provide() {
    return {
      bvCheckGroup: this
    };
  },
  props: props,
  computed: {
    isRadioGroup: function isRadioGroup() {
      return false;
    }
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-checkbox/form-checkbox.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-checkbox/form-checkbox.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormCheckbox": () => (/* binding */ BFormCheckbox),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_loose_equal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/loose-equal */ "./node_modules/bootstrap-vue/esm/utils/loose-equal.js");
/* harmony import */ var _utils_loose_index_of__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/loose-index-of */ "./node_modules/bootstrap-vue/esm/utils/loose-index-of.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/form-radio-check */ "./node_modules/bootstrap-vue/esm/mixins/form-radio-check.js");
var _objectSpread2;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










 // --- Constants ---

var MODEL_PROP_NAME_INDETERMINATE = 'indeterminate';
var MODEL_EVENT_NAME_INDETERMINATE = _constants_events__WEBPACK_IMPORTED_MODULE_0__.MODEL_EVENT_NAME_PREFIX + MODEL_PROP_NAME_INDETERMINATE; // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.sortKeys)(_objectSpread(_objectSpread({}, _mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_3__.props), {}, (_objectSpread2 = {}, _defineProperty(_objectSpread2, MODEL_PROP_NAME_INDETERMINATE, (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_BOOLEAN, false)), _defineProperty(_objectSpread2, "switch", (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_BOOLEAN, false)), _defineProperty(_objectSpread2, "uncheckedValue", (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_ANY, false)), _defineProperty(_objectSpread2, "value", (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_ANY, true)), _objectSpread2))), _constants_components__WEBPACK_IMPORTED_MODULE_5__.NAME_FORM_CHECKBOX); // --- Main component ---
// @vue/component

var BFormCheckbox = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_6__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_5__.NAME_FORM_CHECKBOX,
  mixins: [_mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_3__.formRadioCheckMixin],
  inject: {
    bvGroup: {
      from: 'bvCheckGroup',
      default: null
    }
  },
  props: props,
  computed: {
    isChecked: function isChecked() {
      var value = this.value,
          checked = this.computedLocalChecked;
      return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_7__.isArray)(checked) ? (0,_utils_loose_index_of__WEBPACK_IMPORTED_MODULE_8__.looseIndexOf)(checked, value) > -1 : (0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_9__.looseEqual)(checked, value);
    },
    isRadio: function isRadio() {
      return false;
    }
  },
  watch: _defineProperty({}, MODEL_PROP_NAME_INDETERMINATE, function (newValue, oldValue) {
    if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_9__.looseEqual)(newValue, oldValue)) {
      this.setIndeterminate(newValue);
    }
  }),
  mounted: function mounted() {
    // Set initial indeterminate state
    this.setIndeterminate(this[MODEL_PROP_NAME_INDETERMINATE]);
  },
  methods: {
    computedLocalCheckedWatcher: function computedLocalCheckedWatcher(newValue, oldValue) {
      if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_9__.looseEqual)(newValue, oldValue)) {
        this.$emit(_mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_3__.MODEL_EVENT_NAME, newValue);
        var $input = this.$refs.input;

        if ($input) {
          this.$emit(MODEL_EVENT_NAME_INDETERMINATE, $input.indeterminate);
        }
      }
    },
    handleChange: function handleChange(_ref) {
      var _this = this;

      var _ref$target = _ref.target,
          checked = _ref$target.checked,
          indeterminate = _ref$target.indeterminate;
      var value = this.value,
          uncheckedValue = this.uncheckedValue; // Update `computedLocalChecked`

      var localChecked = this.computedLocalChecked;

      if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_7__.isArray)(localChecked)) {
        var index = (0,_utils_loose_index_of__WEBPACK_IMPORTED_MODULE_8__.looseIndexOf)(localChecked, value);

        if (checked && index < 0) {
          // Add value to array
          localChecked = localChecked.concat(value);
        } else if (!checked && index > -1) {
          // Remove value from array
          localChecked = localChecked.slice(0, index).concat(localChecked.slice(index + 1));
        }
      } else {
        localChecked = checked ? value : uncheckedValue;
      }

      this.computedLocalChecked = localChecked; // Fire events in a `$nextTick()` to ensure the `v-model` is updated

      this.$nextTick(function () {
        // Change is only emitted on user interaction
        _this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_0__.EVENT_NAME_CHANGE, localChecked); // If this is a child of a group, we emit a change event on it as well


        if (_this.isGroup) {
          _this.bvGroup.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_0__.EVENT_NAME_CHANGE, localChecked);
        }

        _this.$emit(MODEL_EVENT_NAME_INDETERMINATE, indeterminate);
      });
    },
    setIndeterminate: function setIndeterminate(state) {
      // Indeterminate only supported in single checkbox mode
      if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_7__.isArray)(this.computedLocalChecked)) {
        state = false;
      }

      var $input = this.$refs.input;

      if ($input) {
        $input.indeterminate = state; // Emit update event to prop

        this.$emit(MODEL_EVENT_NAME_INDETERMINATE, state);
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-checkbox/index.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-checkbox/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormCheckbox": () => (/* reexport safe */ _form_checkbox__WEBPACK_IMPORTED_MODULE_1__.BFormCheckbox),
/* harmony export */   "BFormCheckboxGroup": () => (/* reexport safe */ _form_checkbox_group__WEBPACK_IMPORTED_MODULE_2__.BFormCheckboxGroup),
/* harmony export */   "FormCheckboxPlugin": () => (/* binding */ FormCheckboxPlugin)
/* harmony export */ });
/* harmony import */ var _form_checkbox__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-checkbox */ "./node_modules/bootstrap-vue/esm/components/form-checkbox/form-checkbox.js");
/* harmony import */ var _form_checkbox_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./form-checkbox-group */ "./node_modules/bootstrap-vue/esm/components/form-checkbox/form-checkbox-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var FormCheckboxPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormCheckbox: _form_checkbox__WEBPACK_IMPORTED_MODULE_1__.BFormCheckbox,
    BCheckbox: _form_checkbox__WEBPACK_IMPORTED_MODULE_1__.BFormCheckbox,
    BCheck: _form_checkbox__WEBPACK_IMPORTED_MODULE_1__.BFormCheckbox,
    BFormCheckboxGroup: _form_checkbox_group__WEBPACK_IMPORTED_MODULE_2__.BFormCheckboxGroup,
    BCheckboxGroup: _form_checkbox_group__WEBPACK_IMPORTED_MODULE_2__.BFormCheckboxGroup,
    BCheckGroup: _form_checkbox_group__WEBPACK_IMPORTED_MODULE_2__.BFormCheckboxGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-datepicker/form-datepicker.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-datepicker/form-datepicker.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormDatepicker": () => (/* binding */ BFormDatepicker),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_date__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/date */ "./node_modules/bootstrap-vue/esm/utils/date.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _icons_icons__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../icons/icons */ "./node_modules/bootstrap-vue/esm/icons/icons.js");
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../button/button */ "./node_modules/bootstrap-vue/esm/components/button/button.js");
/* harmony import */ var _calendar_calendar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../calendar/calendar */ "./node_modules/bootstrap-vue/esm/components/calendar/calendar.js");
/* harmony import */ var _form_btn_label_control_bv_form_btn_label_control__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../form-btn-label-control/bv-form-btn-label-control */ "./node_modules/bootstrap-vue/esm/components/form-btn-label-control/bv-form-btn-label-control.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
















 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_DATE_STRING
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // --- Props ---


var calendarProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.omit)(_calendar_calendar__WEBPACK_IMPORTED_MODULE_3__.props, ['block', 'hidden', 'id', 'noKeyNav', 'roleDescription', 'value', 'width']);
var formBtnLabelControlProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.omit)(_form_btn_label_control_bv_form_btn_label_control__WEBPACK_IMPORTED_MODULE_4__.props, ['formattedValue', 'id', 'lang', 'rtl', 'value']);
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_6__.props), modelProps), calendarProps), formBtnLabelControlProps), {}, {
  // Width of the calendar dropdown
  calendarWidth: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, '270px'),
  closeButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  closeButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'outline-secondary'),
  // Dark mode
  dark: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  labelCloseButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Close'),
  labelResetButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Reset'),
  labelTodayButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Select today'),
  noCloseOnSelect: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  resetButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  resetButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'outline-danger'),
  resetValue: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_DATE_STRING),
  todayButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  todayButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'outline-primary')
})), _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_FORM_DATEPICKER); // --- Main component ---
// @vue/component

var BFormDatepicker = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_8__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_FORM_DATEPICKER,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_6__.idMixin, modelMixin],
  props: props,
  data: function data() {
    return {
      // We always use `YYYY-MM-DD` value internally
      localYMD: (0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.formatYMD)(this[MODEL_PROP_NAME]) || '',
      // If the popup is open
      isVisible: false,
      // Context data from BCalendar
      localLocale: null,
      isRTL: false,
      formattedValue: '',
      activeYMD: ''
    };
  },
  computed: {
    calendarYM: function calendarYM() {
      // Returns the calendar year/month
      // Returns the `YYYY-MM` portion of the active calendar date
      return this.activeYMD.slice(0, -3);
    },
    computedLang: function computedLang() {
      return (this.localLocale || '').replace(/-u-.*$/i, '') || null;
    },
    computedResetValue: function computedResetValue() {
      return (0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.formatYMD)((0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.constrainDate)(this.resetValue)) || '';
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue) {
    this.localYMD = (0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.formatYMD)(newValue) || '';
  }), _defineProperty(_watch, "localYMD", function localYMD(newValue) {
    // We only update the v-model when the datepicker is open
    if (this.isVisible) {
      this.$emit(MODEL_EVENT_NAME, this.valueAsDate ? (0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.parseYMD)(newValue) || null : newValue || '');
    }
  }), _defineProperty(_watch, "calendarYM", function calendarYM(newValue, oldValue) {
    // Displayed calendar month has changed
    // So possibly the calendar height has changed...
    // We need to update popper computed position
    if (newValue !== oldValue && oldValue) {
      try {
        this.$refs.control.updatePopper();
      } catch (_unused) {}
    }
  }), _watch),
  methods: {
    // Public methods
    focus: function focus() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_10__.attemptFocus)(this.$refs.control);
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_10__.attemptBlur)(this.$refs.control);
      }
    },
    // Private methods
    setAndClose: function setAndClose(ymd) {
      var _this = this;

      this.localYMD = ymd; // Close calendar popup, unless `noCloseOnSelect`

      if (!this.noCloseOnSelect) {
        this.$nextTick(function () {
          _this.$refs.control.hide(true);
        });
      }
    },
    onSelected: function onSelected(ymd) {
      var _this2 = this;

      this.$nextTick(function () {
        _this2.setAndClose(ymd);
      });
    },
    onInput: function onInput(ymd) {
      if (this.localYMD !== ymd) {
        this.localYMD = ymd;
      }
    },
    onContext: function onContext(ctx) {
      var activeYMD = ctx.activeYMD,
          isRTL = ctx.isRTL,
          locale = ctx.locale,
          selectedYMD = ctx.selectedYMD,
          selectedFormatted = ctx.selectedFormatted;
      this.isRTL = isRTL;
      this.localLocale = locale;
      this.formattedValue = selectedFormatted;
      this.localYMD = selectedYMD;
      this.activeYMD = activeYMD; // Re-emit the context event

      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_NAME_CONTEXT, ctx);
    },
    onTodayButton: function onTodayButton() {
      // Set to today (or min/max if today is out of range)
      this.setAndClose((0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.formatYMD)((0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.constrainDate)((0,_utils_date__WEBPACK_IMPORTED_MODULE_9__.createDate)(), this.min, this.max)));
    },
    onResetButton: function onResetButton() {
      this.setAndClose(this.computedResetValue);
    },
    onCloseButton: function onCloseButton() {
      this.$refs.control.hide(true);
    },
    // Menu handlers
    onShow: function onShow() {
      this.isVisible = true;
    },
    onShown: function onShown() {
      var _this3 = this;

      this.$nextTick(function () {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_10__.attemptFocus)(_this3.$refs.calendar);

        _this3.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_NAME_SHOWN);
      });
    },
    onHidden: function onHidden() {
      this.isVisible = false;
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_11__.EVENT_NAME_HIDDEN);
    },
    // Render helpers
    defaultButtonFn: function defaultButtonFn(_ref) {
      var isHovered = _ref.isHovered,
          hasFocus = _ref.hasFocus;
      return this.$createElement(isHovered || hasFocus ? _icons_icons__WEBPACK_IMPORTED_MODULE_12__.BIconCalendarFill : _icons_icons__WEBPACK_IMPORTED_MODULE_12__.BIconCalendar, {
        attrs: {
          'aria-hidden': 'true'
        }
      });
    }
  },
  render: function render(h) {
    var localYMD = this.localYMD,
        disabled = this.disabled,
        readonly = this.readonly,
        dark = this.dark,
        $props = this.$props,
        $scopedSlots = this.$scopedSlots;
    var placeholder = (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_13__.isUndefinedOrNull)(this.placeholder) ? this.labelNoDateSelected : this.placeholder; // Optional footer buttons

    var $footer = [];

    if (this.todayButton) {
      var label = this.labelTodayButton;
      $footer.push(h(_button_button__WEBPACK_IMPORTED_MODULE_14__.BButton, {
        props: {
          disabled: disabled || readonly,
          size: 'sm',
          variant: this.todayButtonVariant
        },
        attrs: {
          'aria-label': label || null
        },
        on: {
          click: this.onTodayButton
        }
      }, label));
    }

    if (this.resetButton) {
      var _label = this.labelResetButton;
      $footer.push(h(_button_button__WEBPACK_IMPORTED_MODULE_14__.BButton, {
        props: {
          disabled: disabled || readonly,
          size: 'sm',
          variant: this.resetButtonVariant
        },
        attrs: {
          'aria-label': _label || null
        },
        on: {
          click: this.onResetButton
        }
      }, _label));
    }

    if (this.closeButton) {
      var _label2 = this.labelCloseButton;
      $footer.push(h(_button_button__WEBPACK_IMPORTED_MODULE_14__.BButton, {
        props: {
          disabled: disabled,
          size: 'sm',
          variant: this.closeButtonVariant
        },
        attrs: {
          'aria-label': _label2 || null
        },
        on: {
          click: this.onCloseButton
        }
      }, _label2));
    }

    if ($footer.length > 0) {
      $footer = [h('div', {
        staticClass: 'b-form-date-controls d-flex flex-wrap',
        class: {
          'justify-content-between': $footer.length > 1,
          'justify-content-end': $footer.length < 2
        }
      }, $footer)];
    }

    var $calendar = h(_calendar_calendar__WEBPACK_IMPORTED_MODULE_3__.BCalendar, {
      staticClass: 'b-form-date-calendar w-100',
      props: _objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.pluckProps)(calendarProps, $props)), {}, {
        hidden: !this.isVisible,
        value: localYMD,
        valueAsDate: false,
        width: this.calendarWidth
      }),
      on: {
        selected: this.onSelected,
        input: this.onInput,
        context: this.onContext
      },
      scopedSlots: (0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.pick)($scopedSlots, ['nav-prev-decade', 'nav-prev-year', 'nav-prev-month', 'nav-this-month', 'nav-next-month', 'nav-next-year', 'nav-next-decade']),
      key: 'calendar',
      ref: 'calendar'
    }, $footer);
    return h(_form_btn_label_control_bv_form_btn_label_control__WEBPACK_IMPORTED_MODULE_4__.BVFormBtnLabelControl, {
      staticClass: 'b-form-datepicker',
      props: _objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.pluckProps)(formBtnLabelControlProps, $props)), {}, {
        formattedValue: localYMD ? this.formattedValue : '',
        id: this.safeId(),
        lang: this.computedLang,
        menuClass: [{
          'bg-dark': dark,
          'text-light': dark
        }, this.menuClass],
        placeholder: placeholder,
        rtl: this.isRTL,
        value: localYMD
      }),
      on: {
        show: this.onShow,
        shown: this.onShown,
        hidden: this.onHidden
      },
      scopedSlots: _defineProperty({}, _constants_slots__WEBPACK_IMPORTED_MODULE_15__.SLOT_NAME_BUTTON_CONTENT, $scopedSlots[_constants_slots__WEBPACK_IMPORTED_MODULE_15__.SLOT_NAME_BUTTON_CONTENT] || this.defaultButtonFn),
      ref: 'control'
    }, [$calendar]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-datepicker/index.js":
/*!****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-datepicker/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormDatepicker": () => (/* reexport safe */ _form_datepicker__WEBPACK_IMPORTED_MODULE_1__.BFormDatepicker),
/* harmony export */   "FormDatepickerPlugin": () => (/* binding */ FormDatepickerPlugin)
/* harmony export */ });
/* harmony import */ var _form_datepicker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-datepicker */ "./node_modules/bootstrap-vue/esm/components/form-datepicker/form-datepicker.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormDatepickerPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormDatepicker: _form_datepicker__WEBPACK_IMPORTED_MODULE_1__.BFormDatepicker,
    BDatepicker: _form_datepicker__WEBPACK_IMPORTED_MODULE_1__.BFormDatepicker
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-file/form-file.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-file/form-file.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormFile": () => (/* binding */ BFormFile)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_env__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../constants/env */ "./node_modules/bootstrap-vue/esm/constants/env.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _constants_regex__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../constants/regex */ "./node_modules/bootstrap-vue/esm/constants/regex.js");
/* harmony import */ var _constants_safe_types__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/safe-types */ "./node_modules/bootstrap-vue/esm/constants/safe-types.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_clone_deep__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../utils/clone-deep */ "./node_modules/bootstrap-vue/esm/utils/clone-deep.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_loose_equal__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../utils/loose-equal */ "./node_modules/bootstrap-vue/esm/utils/loose-equal.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _utils_warn__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/warn */ "./node_modules/bootstrap-vue/esm/utils/warn.js");
/* harmony import */ var _mixins_attrs__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../mixins/attrs */ "./node_modules/bootstrap-vue/esm/mixins/attrs.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _mixins_form_custom__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../mixins/form-custom */ "./node_modules/bootstrap-vue/esm/mixins/form-custom.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }



























 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  type: [_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY, _constants_safe_types__WEBPACK_IMPORTED_MODULE_2__.File],
  defaultValue: null,
  validator: function validator(value) {
    /* istanbul ignore next */
    if (value === '') {
      (0,_utils_warn__WEBPACK_IMPORTED_MODULE_3__.warn)(VALUE_EMPTY_DEPRECATED_MSG, _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_FILE);
      return true;
    }

    return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isUndefinedOrNull)(value) || isValidValue(value);
  }
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event;

var VALUE_EMPTY_DEPRECATED_MSG = 'Setting "value"/"v-model" to an empty string for reset is deprecated. Set to "null" instead.'; // --- Helper methods ---

var isValidValue = function isValidValue(value) {
  return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isFile)(value) || (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isArray)(value) && value.every(function (v) {
    return isValidValue(v);
  });
}; // Helper method to "safely" get the entry from a data-transfer item

/* istanbul ignore next: not supported in JSDOM */


var getDataTransferItemEntry = function getDataTransferItemEntry(item) {
  return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isFunction)(item.getAsEntry) ? item.getAsEntry() : (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isFunction)(item.webkitGetAsEntry) ? item.webkitGetAsEntry() : null;
}; // Drop handler function to get all files

/* istanbul ignore next: not supported in JSDOM */


var getAllFileEntries = function getAllFileEntries(dataTransferItemList) {
  var traverseDirectories = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : true;
  return Promise.all((0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.from)(dataTransferItemList).filter(function (item) {
    return item.kind === 'file';
  }).map(function (item) {
    var entry = getDataTransferItemEntry(item);

    if (entry) {
      if (entry.isDirectory && traverseDirectories) {
        return getAllFileEntriesInDirectory(entry.createReader(), "".concat(entry.name, "/"));
      } else if (entry.isFile) {
        return new Promise(function (resolve) {
          entry.file(function (file) {
            file.$path = '';
            resolve(file);
          });
        });
      }
    }

    return null;
  }).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_7__.identity));
}; // Get all the file entries (recursive) in a directory

/* istanbul ignore next: not supported in JSDOM */


var getAllFileEntriesInDirectory = function getAllFileEntriesInDirectory(directoryReader) {
  var path = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : '';
  return new Promise(function (resolve) {
    var entryPromises = [];

    var readDirectoryEntries = function readDirectoryEntries() {
      directoryReader.readEntries(function (entries) {
        if (entries.length === 0) {
          resolve(Promise.all(entryPromises).then(function (entries) {
            return (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.flatten)(entries);
          }));
        } else {
          entryPromises.push(Promise.all(entries.map(function (entry) {
            if (entry) {
              if (entry.isDirectory) {
                return getAllFileEntriesInDirectory(entry.createReader(), "".concat(path).concat(entry.name, "/"));
              } else if (entry.isFile) {
                return new Promise(function (resolve) {
                  entry.file(function (file) {
                    file.$path = "".concat(path).concat(file.name);
                    resolve(file);
                  });
                });
              }
            }

            return null;
          }).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_7__.identity)));
          readDirectoryEntries();
        }
      });
    };

    readDirectoryEntries();
  });
}; // --- Props ---


var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_9__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_10__.props), modelProps), _mixins_form_control__WEBPACK_IMPORTED_MODULE_11__.props), _mixins_form_custom__WEBPACK_IMPORTED_MODULE_12__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_13__.props), _mixins_form_size__WEBPACK_IMPORTED_MODULE_14__.props), {}, {
  accept: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, ''),
  browseText: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Browse'),
  // Instruct input to capture from camera
  capture: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  directory: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  dropPlaceholder: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Drop files here'),
  fileNameFormatter: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_FUNCTION),
  multiple: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  noDrop: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  noDropPlaceholder: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Not allowed'),
  // TODO:
  //   Should we deprecate this and only support flat file structures?
  //   Nested file structures are only supported when files are dropped
  //   A Chromium "bug" prevents `webkitEntries` from being populated
  //   on the file input's `change` event and is marked as "WontFix"
  //   Mozilla implemented the behavior the same way as Chromium
  //   See: https://bugs.chromium.org/p/chromium/issues/detail?id=138987
  //   See: https://bugzilla.mozilla.org/show_bug.cgi?id=1326031
  noTraverse: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  placeholder: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'No file chosen')
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_FILE); // --- Main component ---
// @vue/component

var BFormFile = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_15__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_FILE,
  mixins: [_mixins_attrs__WEBPACK_IMPORTED_MODULE_16__.attrsMixin, _mixins_id__WEBPACK_IMPORTED_MODULE_10__.idMixin, modelMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_17__.normalizeSlotMixin, _mixins_form_control__WEBPACK_IMPORTED_MODULE_11__.formControlMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_13__.formStateMixin, _mixins_form_custom__WEBPACK_IMPORTED_MODULE_12__.formCustomMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_17__.normalizeSlotMixin],
  inheritAttrs: false,
  props: props,
  data: function data() {
    return {
      files: [],
      dragging: false,
      // IE 11 doesn't respect setting `event.dataTransfer.dropEffect`,
      // so we handle it ourselves as well
      // https://stackoverflow.com/a/46915971/2744776
      dropAllowed: !this.noDrop,
      hasFocus: false
    };
  },
  computed: {
    // Convert `accept` to an array of `[{ RegExpr, isMime }, ...]`
    computedAccept: function computedAccept() {
      var accept = this.accept;
      accept = (accept || '').trim().split(/[,\s]+/).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_7__.identity); // Allow any file type/extension

      if (accept.length === 0) {
        return null;
      }

      return accept.map(function (extOrType) {
        var prop = 'name';
        var startMatch = '^';
        var endMatch = '$';

        if (_constants_regex__WEBPACK_IMPORTED_MODULE_18__.RX_EXTENSION.test(extOrType)) {
          // File extension /\.ext$/
          startMatch = '';
        } else {
          // MIME type /^mime\/.+$/ or /^mime\/type$/
          prop = 'type';

          if (_constants_regex__WEBPACK_IMPORTED_MODULE_18__.RX_STAR.test(extOrType)) {
            endMatch = '.+$'; // Remove trailing `*`

            extOrType = extOrType.slice(0, -1);
          }
        } // Escape all RegExp special chars


        extOrType = (0,_utils_string__WEBPACK_IMPORTED_MODULE_19__.escapeRegExp)(extOrType);
        var rx = new RegExp("".concat(startMatch).concat(extOrType).concat(endMatch));
        return {
          rx: rx,
          prop: prop
        };
      });
    },
    computedCapture: function computedCapture() {
      var capture = this.capture;
      return capture === true || capture === '' ? true : capture || null;
    },
    computedAttrs: function computedAttrs() {
      var name = this.name,
          disabled = this.disabled,
          required = this.required,
          form = this.form,
          computedCapture = this.computedCapture,
          accept = this.accept,
          multiple = this.multiple,
          directory = this.directory;
      return _objectSpread(_objectSpread({}, this.bvAttrs), {}, {
        type: 'file',
        id: this.safeId(),
        name: name,
        disabled: disabled,
        required: required,
        form: form || null,
        capture: computedCapture,
        accept: accept || null,
        multiple: multiple,
        directory: directory,
        webkitdirectory: directory,
        'aria-required': required ? 'true' : null
      });
    },
    computedFileNameFormatter: function computedFileNameFormatter() {
      var fileNameFormatter = this.fileNameFormatter;
      return (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.hasPropFunction)(fileNameFormatter) ? fileNameFormatter : this.defaultFileNameFormatter;
    },
    clonedFiles: function clonedFiles() {
      return (0,_utils_clone_deep__WEBPACK_IMPORTED_MODULE_20__.cloneDeep)(this.files);
    },
    flattenedFiles: function flattenedFiles() {
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.flattenDeep)(this.files);
    },
    fileNames: function fileNames() {
      return this.flattenedFiles.map(function (file) {
        return file.name;
      });
    },
    labelContent: function labelContent() {
      // Draging active

      /* istanbul ignore next: used by drag/drop which can't be tested easily */
      if (this.dragging && !this.noDrop) {
        return (// TODO: Add additional scope with file count, and other not-allowed reasons
          this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_21__.SLOT_NAME_DROP_PLACEHOLDER, {
            allowed: this.dropAllowed
          }) || (this.dropAllowed ? this.dropPlaceholder : this.$createElement('span', {
            staticClass: 'text-danger'
          }, this.noDropPlaceholder))
        );
      } // No file chosen


      if (this.files.length === 0) {
        return this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_21__.SLOT_NAME_PLACEHOLDER) || this.placeholder;
      }

      var flattenedFiles = this.flattenedFiles,
          clonedFiles = this.clonedFiles,
          fileNames = this.fileNames,
          computedFileNameFormatter = this.computedFileNameFormatter; // There is a slot for formatting the files/names

      if (this.hasNormalizedSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_21__.SLOT_NAME_FILE_NAME)) {
        return this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_21__.SLOT_NAME_FILE_NAME, {
          files: flattenedFiles,
          filesTraversed: clonedFiles,
          names: fileNames
        });
      }

      return computedFileNameFormatter(flattenedFiles, clonedFiles, fileNames);
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue) {
    if (!newValue || (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isArray)(newValue) && newValue.length === 0) {
      this.reset();
    }
  }), _defineProperty(_watch, "files", function files(newValue, oldValue) {
    if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_22__.looseEqual)(newValue, oldValue)) {
      var multiple = this.multiple,
          noTraverse = this.noTraverse;
      var files = !multiple || noTraverse ? (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.flattenDeep)(newValue) : newValue;
      this.$emit(MODEL_EVENT_NAME, multiple ? files : files[0] || null);
    }
  }), _watch),
  created: function created() {
    // Create private non-reactive props
    this.$_form = null;
  },
  mounted: function mounted() {
    // Listen for form reset events, to reset the file input
    var $form = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_23__.closest)('form', this.$el);

    if ($form) {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_24__.eventOn)($form, 'reset', this.reset, _constants_events__WEBPACK_IMPORTED_MODULE_25__.EVENT_OPTIONS_PASSIVE);
      this.$_form = $form;
    }
  },
  beforeDestroy: function beforeDestroy() {
    var $form = this.$_form;

    if ($form) {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_24__.eventOff)($form, 'reset', this.reset, _constants_events__WEBPACK_IMPORTED_MODULE_25__.EVENT_OPTIONS_PASSIVE);
    }
  },
  methods: {
    isFileValid: function isFileValid(file) {
      if (!file) {
        return false;
      }

      var accept = this.computedAccept;
      return accept ? accept.some(function (a) {
        return a.rx.test(file[a.prop]);
      }) : true;
    },
    isFilesArrayValid: function isFilesArrayValid(files) {
      var _this = this;

      return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isArray)(files) ? files.every(function (file) {
        return _this.isFileValid(file);
      }) : this.isFileValid(files);
    },
    defaultFileNameFormatter: function defaultFileNameFormatter(flattenedFiles, clonedFiles, fileNames) {
      return fileNames.join(', ');
    },
    setFiles: function setFiles(files) {
      // Reset the dragging flags
      this.dropAllowed = !this.noDrop;
      this.dragging = false; // Set the selected files

      this.files = this.multiple ? this.directory ? files : (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.flattenDeep)(files) : (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.flattenDeep)(files).slice(0, 1);
    },

    /* istanbul ignore next: used by Drag/Drop */
    setInputFiles: function setInputFiles(files) {
      // Try an set the file input files array so that `required`
      // constraint works for dropped files (will fail in IE11 though)
      // To be used only when dropping files
      try {
        // Firefox < 62 workaround exploiting https://bugzilla.mozilla.org/show_bug.cgi?id=1422655
        var dataTransfer = new ClipboardEvent('').clipboardData || new DataTransfer(); // Add flattened files to temp `dataTransfer` object to get a true `FileList` array

        (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.flattenDeep)((0,_utils_clone_deep__WEBPACK_IMPORTED_MODULE_20__.cloneDeep)(files)).forEach(function (file) {
          // Make sure to remove the custom `$path` attribute
          delete file.$path;
          dataTransfer.items.add(file);
        });
        this.$refs.input.files = dataTransfer.files;
      } catch (_unused) {}
    },
    reset: function reset() {
      // IE 11 doesn't support setting `$input.value` to `''` or `null`
      // So we use this little extra hack to reset the value, just in case
      // This also appears to work on modern browsers as well
      // Wrapped in try in case IE 11 or mobile Safari crap out
      try {
        var $input = this.$refs.input;
        $input.value = '';
        $input.type = '';
        $input.type = 'file';
      } catch (_unused2) {}

      this.files = [];
    },
    handleFiles: function handleFiles(files) {
      var isDrop = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : false;

      if (isDrop) {
        // When dropped, make sure to filter files with the internal `accept` logic
        var filteredFiles = files.filter(this.isFilesArrayValid); // Only update files when we have any after filtering

        if (filteredFiles.length > 0) {
          this.setFiles(filteredFiles); // Try an set the file input's files array so that `required`
          // constraint works for dropped files (will fail in IE 11 though)

          this.setInputFiles(filteredFiles);
        }
      } else {
        // We always update the files from the `change` event
        this.setFiles(files);
      }
    },
    focusHandler: function focusHandler(event) {
      // Bootstrap v4 doesn't have focus styling for custom file input
      // Firefox has a `[type=file]:focus ~ sibling` selector issue,
      // so we add a `focus` class to get around these bugs
      if (this.plain || event.type === 'focusout') {
        this.hasFocus = false;
      } else {
        // Add focus styling for custom file input
        this.hasFocus = true;
      }
    },
    onChange: function onChange(event) {
      var _this2 = this;

      var type = event.type,
          target = event.target,
          _event$dataTransfer = event.dataTransfer,
          dataTransfer = _event$dataTransfer === void 0 ? {} : _event$dataTransfer;
      var isDrop = type === 'drop'; // Always emit original event

      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_25__.EVENT_NAME_CHANGE, event);
      var items = (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.from)(dataTransfer.items || []);

      if (_constants_env__WEBPACK_IMPORTED_MODULE_26__.HAS_PROMISE_SUPPORT && items.length > 0 && !(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isNull)(getDataTransferItemEntry(items[0]))) {
        // Drop handling for modern browsers
        // Supports nested directory structures in `directory` mode

        /* istanbul ignore next: not supported in JSDOM */
        getAllFileEntries(items, this.directory).then(function (files) {
          return _this2.handleFiles(files, isDrop);
        });
      } else {
        // Standard file input handling (native file input change event),
        // or fallback drop mode (IE 11 / Opera) which don't support `directory` mode
        var files = (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.from)(target.files || dataTransfer.files || []).map(function (file) {
          // Add custom `$path` property to each file (to be consistent with drop mode)
          file.$path = file.webkitRelativePath || '';
          return file;
        });
        this.handleFiles(files, isDrop);
      }
    },
    onDragenter: function onDragenter(event) {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_24__.stopEvent)(event);
      this.dragging = true;
      var _event$dataTransfer2 = event.dataTransfer,
          dataTransfer = _event$dataTransfer2 === void 0 ? {} : _event$dataTransfer2; // Early exit when the input or dropping is disabled

      if (this.noDrop || this.disabled || !this.dropAllowed) {
        // Show deny feedback

        /* istanbul ignore next: not supported in JSDOM */
        dataTransfer.dropEffect = 'none';
        this.dropAllowed = false;
        return;
      }
      /* istanbul ignore next: not supported in JSDOM */


      dataTransfer.dropEffect = 'copy';
    },
    // Note this event fires repeatedly while the mouse is over the dropzone at
    // intervals in the milliseconds, so avoid doing much processing in here
    onDragover: function onDragover(event) {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_24__.stopEvent)(event);
      this.dragging = true;
      var _event$dataTransfer3 = event.dataTransfer,
          dataTransfer = _event$dataTransfer3 === void 0 ? {} : _event$dataTransfer3; // Early exit when the input or dropping is disabled

      if (this.noDrop || this.disabled || !this.dropAllowed) {
        // Show deny feedback

        /* istanbul ignore next: not supported in JSDOM */
        dataTransfer.dropEffect = 'none';
        this.dropAllowed = false;
        return;
      }
      /* istanbul ignore next: not supported in JSDOM */


      dataTransfer.dropEffect = 'copy';
    },
    onDragleave: function onDragleave(event) {
      var _this3 = this;

      (0,_utils_events__WEBPACK_IMPORTED_MODULE_24__.stopEvent)(event);
      this.$nextTick(function () {
        _this3.dragging = false; // Reset `dropAllowed` to default

        _this3.dropAllowed = !_this3.noDrop;
      });
    },
    // Triggered by a file drop onto drop target
    onDrop: function onDrop(event) {
      var _this4 = this;

      (0,_utils_events__WEBPACK_IMPORTED_MODULE_24__.stopEvent)(event);
      this.dragging = false; // Early exit when the input or dropping is disabled

      if (this.noDrop || this.disabled || !this.dropAllowed) {
        this.$nextTick(function () {
          // Reset `dropAllowed` to default
          _this4.dropAllowed = !_this4.noDrop;
        });
        return;
      }

      this.onChange(event);
    }
  },
  render: function render(h) {
    var custom = this.custom,
        plain = this.plain,
        size = this.size,
        dragging = this.dragging,
        stateClass = this.stateClass,
        bvAttrs = this.bvAttrs; // Form Input

    var $input = h('input', {
      class: [{
        'form-control-file': plain,
        'custom-file-input': custom,
        focus: custom && this.hasFocus
      }, stateClass],
      // With IE 11, the input gets in the "way" of the drop events,
      // so we move it out of the way by putting it behind the label
      // Bootstrap v4 has it in front
      style: custom ? {
        zIndex: -5
      } : {},
      attrs: this.computedAttrs,
      on: {
        change: this.onChange,
        focusin: this.focusHandler,
        focusout: this.focusHandler,
        reset: this.reset
      },
      ref: 'input'
    });

    if (plain) {
      return $input;
    } // Overlay label


    var $label = h('label', {
      staticClass: 'custom-file-label',
      class: {
        dragging: dragging
      },
      attrs: {
        for: this.safeId(),
        // This goes away in Bootstrap v5
        'data-browse': this.browseText || null
      }
    }, [h('span', {
      staticClass: 'd-block form-file-text',
      // `pointer-events: none` is used to make sure
      // the drag events fire only on the label
      style: {
        pointerEvents: 'none'
      }
    }, [this.labelContent])]); // Return rendered custom file input

    return h('div', {
      staticClass: 'custom-file b-form-file',
      class: [_defineProperty({}, "b-custom-control-".concat(size), size), stateClass, bvAttrs.class],
      style: bvAttrs.style,
      attrs: {
        id: this.safeId('_BV_file_outer_')
      },
      on: {
        dragenter: this.onDragenter,
        dragover: this.onDragover,
        dragleave: this.onDragleave,
        drop: this.onDrop
      }
    }, [$input, $label]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-file/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-file/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormFile": () => (/* reexport safe */ _form_file__WEBPACK_IMPORTED_MODULE_1__.BFormFile),
/* harmony export */   "FormFilePlugin": () => (/* binding */ FormFilePlugin)
/* harmony export */ });
/* harmony import */ var _form_file__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-file */ "./node_modules/bootstrap-vue/esm/components/form-file/form-file.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormFilePlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormFile: _form_file__WEBPACK_IMPORTED_MODULE_1__.BFormFile,
    BFile: _form_file__WEBPACK_IMPORTED_MODULE_1__.BFormFile
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-group/form-group.js":
/*!****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-group/form-group.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormGroup": () => (/* binding */ BFormGroup),
/* harmony export */   "generateProps": () => (/* binding */ generateProps)
/* harmony export */ });
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_env__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../constants/env */ "./node_modules/bootstrap-vue/esm/constants/env.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_regex__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../constants/regex */ "./node_modules/bootstrap-vue/esm/constants/regex.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/config */ "./node_modules/bootstrap-vue/esm/utils/config.js");
/* harmony import */ var _utils_css_escape__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/css-escape */ "./node_modules/bootstrap-vue/esm/utils/css-escape.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _layout_col__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../layout/col */ "./node_modules/bootstrap-vue/esm/components/layout/col.js");
/* harmony import */ var _layout_form_row__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../layout/form-row */ "./node_modules/bootstrap-vue/esm/components/layout/form-row.js");
/* harmony import */ var _form_form_text__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../form/form-text */ "./node_modules/bootstrap-vue/esm/components/form/form-text.js");
/* harmony import */ var _form_form_invalid_feedback__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../form/form-invalid-feedback */ "./node_modules/bootstrap-vue/esm/components/form/form-invalid-feedback.js");
/* harmony import */ var _form_form_valid_feedback__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../form/form-valid-feedback */ "./node_modules/bootstrap-vue/esm/components/form/form-valid-feedback.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }






















 // --- Constants ---

var INPUTS = ['input', 'select', 'textarea']; // Selector for finding first input in the form group

var INPUT_SELECTOR = INPUTS.map(function (v) {
  return "".concat(v, ":not([disabled])");
}).join(); // A list of interactive elements (tag names) inside `<b-form-group>`'s legend

var LEGEND_INTERACTIVE_ELEMENTS = [].concat(INPUTS, ['a', 'button', 'label']); // --- Props ---
// Prop generator for lazy generation of props

var generateProps = function generateProps() {
  return (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_3__.props), (0,_utils_config__WEBPACK_IMPORTED_MODULE_4__.getBreakpointsUpCached)().reduce(function (props, breakpoint) {
    // i.e. 'content-cols', 'content-cols-sm', 'content-cols-md', ...
    props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.suffixPropName)(breakpoint, 'contentCols')] = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN_NUMBER_STRING); // i.e. 'label-align', 'label-align-sm', 'label-align-md', ...

    props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.suffixPropName)(breakpoint, 'labelAlign')] = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING); // i.e. 'label-cols', 'label-cols-sm', 'label-cols-md', ...

    props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.suffixPropName)(breakpoint, 'labelCols')] = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN_NUMBER_STRING);
    return props;
  }, (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.create)(null))), {}, {
    description: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
    disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
    feedbackAriaLive: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, 'assertive'),
    invalidFeedback: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
    label: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
    labelClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_ARRAY_OBJECT_STRING),
    labelFor: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
    labelSize: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
    labelSrOnly: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
    tooltip: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
    validFeedback: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING),
    validated: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false)
  })), _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_FORM_GROUP);
}; // --- Main component ---
// We do not use `Vue.extend()` here as that would evaluate the props
// immediately, which we do not want to happen
// @vue/component

var BFormGroup = {
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_FORM_GROUP,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_2__.idMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_3__.formStateMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_7__.normalizeSlotMixin],

  get props() {
    // Allow props to be lazy evaled on first access and
    // then they become a non-getter afterwards
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get#Smart_self-overwriting_lazy_getters
    delete this.props; // eslint-disable-next-line no-return-assign

    return this.props = generateProps();
  },

  data: function data() {
    return {
      ariaDescribedby: null
    };
  },
  computed: {
    contentColProps: function contentColProps() {
      return this.getColProps(this.$props, 'content');
    },
    labelAlignClasses: function labelAlignClasses() {
      return this.getAlignClasses(this.$props, 'label');
    },
    labelColProps: function labelColProps() {
      return this.getColProps(this.$props, 'label');
    },
    isHorizontal: function isHorizontal() {
      // Determine if the form group will be rendered horizontal
      // based on the existence of 'content-col' or 'label-col' props
      return (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.keys)(this.contentColProps).length > 0 || (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.keys)(this.labelColProps).length > 0;
    }
  },
  watch: {
    ariaDescribedby: function ariaDescribedby(newValue, oldValue) {
      if (newValue !== oldValue) {
        this.updateAriaDescribedby(newValue, oldValue);
      }
    }
  },
  mounted: function mounted() {
    var _this = this;

    this.$nextTick(function () {
      // Set `aria-describedby` on the input specified by `labelFor`
      // We do this in a `$nextTick()` to ensure the children have finished rendering
      _this.updateAriaDescribedby(_this.ariaDescribedby);
    });
  },
  methods: {
    getAlignClasses: function getAlignClasses(props, prefix) {
      return (0,_utils_config__WEBPACK_IMPORTED_MODULE_4__.getBreakpointsUpCached)().reduce(function (result, breakpoint) {
        var propValue = props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.suffixPropName)(breakpoint, "".concat(prefix, "Align"))] || null;

        if (propValue) {
          result.push(['text', breakpoint, propValue].filter(_utils_identity__WEBPACK_IMPORTED_MODULE_8__.identity).join('-'));
        }

        return result;
      }, []);
    },
    getColProps: function getColProps(props, prefix) {
      return (0,_utils_config__WEBPACK_IMPORTED_MODULE_4__.getBreakpointsUpCached)().reduce(function (result, breakpoint) {
        var propValue = props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.suffixPropName)(breakpoint, "".concat(prefix, "Cols"))]; // Handle case where the prop's value is an empty string,
        // which represents `true`

        propValue = propValue === '' ? true : propValue || false;

        if (!(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_9__.isBoolean)(propValue) && propValue !== 'auto') {
          // Convert to column size to number
          propValue = (0,_utils_number__WEBPACK_IMPORTED_MODULE_10__.toInteger)(propValue, 0); // Ensure column size is greater than `0`

          propValue = propValue > 0 ? propValue : false;
        } // Add the prop to the list of props to give to `<b-col>`
        // If breakpoint is '' (`${prefix}Cols` is `true`), then we use
        // the 'col' prop to make equal width at 'xs'


        if (propValue) {
          result[breakpoint || ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_9__.isBoolean)(propValue) ? 'col' : 'cols')] = propValue;
        }

        return result;
      }, {});
    },
    // Sets the `aria-describedby` attribute on the input if `labelFor` is set
    // Optionally accepts a string of IDs to remove as the second parameter
    // Preserves any `aria-describedby` value(s) user may have on input
    updateAriaDescribedby: function updateAriaDescribedby(newValue, oldValue) {
      var labelFor = this.labelFor;

      if (_constants_env__WEBPACK_IMPORTED_MODULE_11__.IS_BROWSER && labelFor) {
        // We need to escape `labelFor` since it can be user-provided
        var $input = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.select)("#".concat((0,_utils_css_escape__WEBPACK_IMPORTED_MODULE_13__.cssEscape)(labelFor)), this.$refs.content);

        if ($input) {
          var attr = 'aria-describedby';
          var newIds = (newValue || '').split(_constants_regex__WEBPACK_IMPORTED_MODULE_14__.RX_SPACE_SPLIT);
          var oldIds = (oldValue || '').split(_constants_regex__WEBPACK_IMPORTED_MODULE_14__.RX_SPACE_SPLIT); // Update ID list, preserving any original IDs
          // and ensuring the ID's are unique

          var ids = ((0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.getAttr)($input, attr) || '').split(_constants_regex__WEBPACK_IMPORTED_MODULE_14__.RX_SPACE_SPLIT).filter(function (id) {
            return !(0,_utils_array__WEBPACK_IMPORTED_MODULE_15__.arrayIncludes)(oldIds, id);
          }).concat(newIds).filter(function (id, index, ids) {
            return ids.indexOf(id) === index;
          }).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_8__.identity).join(' ').trim();

          if (ids) {
            (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.setAttr)($input, attr, ids);
          } else {
            (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.removeAttr)($input, attr);
          }
        }
      }
    },
    onLegendClick: function onLegendClick(event) {
      // Don't do anything if `labelFor` is set

      /* istanbul ignore next: clicking a label will focus the input, so no need to test */
      if (this.labelFor) {
        return;
      }

      var target = event.target;
      var tagName = target ? target.tagName : ''; // If clicked an interactive element inside legend,
      // we just let the default happen

      /* istanbul ignore next */

      if (LEGEND_INTERACTIVE_ELEMENTS.indexOf(tagName) !== -1) {
        return;
      } // If only a single input, focus it, emulating label behaviour


      var inputs = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.selectAll)(INPUT_SELECTOR, this.$refs.content).filter(_utils_dom__WEBPACK_IMPORTED_MODULE_12__.isVisible);

      if (inputs.length === 1) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_12__.attemptFocus)(inputs[0]);
      }
    }
  },
  render: function render(h) {
    var state = this.computedState,
        feedbackAriaLive = this.feedbackAriaLive,
        isHorizontal = this.isHorizontal,
        labelFor = this.labelFor,
        normalizeSlot = this.normalizeSlot,
        safeId = this.safeId,
        tooltip = this.tooltip;
    var id = safeId();
    var isFieldset = !labelFor;
    var $label = h();
    var labelContent = normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_16__.SLOT_NAME_LABEL) || this.label;
    var labelId = labelContent ? safeId('_BV_label_') : null;

    if (labelContent || isHorizontal) {
      var labelSize = this.labelSize,
          labelColProps = this.labelColProps;
      var labelTag = isFieldset ? 'legend' : 'label';

      if (this.labelSrOnly) {
        if (labelContent) {
          $label = h(labelTag, {
            class: 'sr-only',
            attrs: {
              id: labelId,
              for: labelFor || null
            }
          }, [labelContent]);
        }

        $label = h(isHorizontal ? _layout_col__WEBPACK_IMPORTED_MODULE_17__.BCol : 'div', {
          props: isHorizontal ? labelColProps : {}
        }, [$label]);
      } else {
        $label = h(isHorizontal ? _layout_col__WEBPACK_IMPORTED_MODULE_17__.BCol : labelTag, {
          on: isFieldset ? {
            click: this.onLegendClick
          } : {},
          props: isHorizontal ? _objectSpread(_objectSpread({}, labelColProps), {}, {
            tag: labelTag
          }) : {},
          attrs: {
            id: labelId,
            for: labelFor || null,
            // We add a `tabindex` to legend so that screen readers
            // will properly read the `aria-labelledby` in IE
            tabindex: isFieldset ? '-1' : null
          },
          class: [// Hide the focus ring on the legend
          isFieldset ? 'bv-no-focus-ring' : '', // When horizontal or if a legend is rendered, add 'col-form-label' class
          // for correct sizing as Bootstrap has inconsistent font styling for
          // legend in non-horizontal form groups
          // See: https://github.com/twbs/bootstrap/issues/27805
          isHorizontal || isFieldset ? 'col-form-label' : '', // Emulate label padding top of `0` on legend when not horizontal
          !isHorizontal && isFieldset ? 'pt-0' : '', // If not horizontal and not a legend, we add 'd-block' class to label
          // so that label-align works
          !isHorizontal && !isFieldset ? 'd-block' : '', labelSize ? "col-form-label-".concat(labelSize) : '', this.labelAlignClasses, this.labelClass]
        }, [labelContent]);
      }
    }

    var $invalidFeedback = h();
    var invalidFeedbackContent = normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_16__.SLOT_NAME_INVALID_FEEDBACK) || this.invalidFeedback;
    var invalidFeedbackId = invalidFeedbackContent ? safeId('_BV_feedback_invalid_') : null;

    if (invalidFeedbackContent) {
      $invalidFeedback = h(_form_form_invalid_feedback__WEBPACK_IMPORTED_MODULE_18__.BFormInvalidFeedback, {
        props: {
          ariaLive: feedbackAriaLive,
          id: invalidFeedbackId,
          role: feedbackAriaLive ? 'alert' : null,
          // If state is explicitly `false`, always show the feedback
          state: state,
          tooltip: tooltip
        },
        attrs: {
          tabindex: invalidFeedbackContent ? '-1' : null
        }
      }, [invalidFeedbackContent]);
    }

    var $validFeedback = h();
    var validFeedbackContent = normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_16__.SLOT_NAME_VALID_FEEDBACK) || this.validFeedback;
    var validFeedbackId = validFeedbackContent ? safeId('_BV_feedback_valid_') : null;

    if (validFeedbackContent) {
      $validFeedback = h(_form_form_valid_feedback__WEBPACK_IMPORTED_MODULE_19__.BFormValidFeedback, {
        props: {
          ariaLive: feedbackAriaLive,
          id: validFeedbackId,
          role: feedbackAriaLive ? 'alert' : null,
          // If state is explicitly `true`, always show the feedback
          state: state,
          tooltip: tooltip
        },
        attrs: {
          tabindex: validFeedbackContent ? '-1' : null
        }
      }, [validFeedbackContent]);
    }

    var $description = h();
    var descriptionContent = normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_16__.SLOT_NAME_DESCRIPTION) || this.description;
    var descriptionId = descriptionContent ? safeId('_BV_description_') : null;

    if (descriptionContent) {
      $description = h(_form_form_text__WEBPACK_IMPORTED_MODULE_20__.BFormText, {
        attrs: {
          id: descriptionId,
          tabindex: '-1'
        }
      }, [descriptionContent]);
    } // Update `ariaDescribedby`
    // Screen readers will read out any content linked to by `aria-describedby`
    // even if the content is hidden with `display: none;`, hence we only include
    // feedback IDs if the form group's state is explicitly valid or invalid


    var ariaDescribedby = this.ariaDescribedby = [descriptionId, state === false ? invalidFeedbackId : null, state === true ? validFeedbackId : null].filter(_utils_identity__WEBPACK_IMPORTED_MODULE_8__.identity).join(' ') || null;
    var $content = h(isHorizontal ? _layout_col__WEBPACK_IMPORTED_MODULE_17__.BCol : 'div', {
      props: isHorizontal ? this.contentColProps : {},
      ref: 'content'
    }, [normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_16__.SLOT_NAME_DEFAULT, {
      ariaDescribedby: ariaDescribedby,
      descriptionId: descriptionId,
      id: id,
      labelId: labelId
    }) || h(), $invalidFeedback, $validFeedback, $description]); // Return it wrapped in a form group
    // Note: Fieldsets do not support adding `row` or `form-row` directly
    // to them due to browser specific render issues, so we move the `form-row`
    // to an inner wrapper div when horizontal and using a fieldset

    return h(isFieldset ? 'fieldset' : isHorizontal ? _layout_form_row__WEBPACK_IMPORTED_MODULE_21__.BFormRow : 'div', {
      staticClass: 'form-group',
      class: [{
        'was-validated': this.validated
      }, this.stateClass],
      attrs: {
        id: id,
        disabled: isFieldset ? this.disabled : null,
        role: isFieldset ? null : 'group',
        'aria-invalid': this.computedAriaInvalid,
        // Only apply `aria-labelledby` if we are a horizontal fieldset
        // as the legend is no longer a direct child of fieldset
        'aria-labelledby': isFieldset && isHorizontal ? labelId : null
      }
    }, isHorizontal && isFieldset ? [h(_layout_form_row__WEBPACK_IMPORTED_MODULE_21__.BFormRow, [$label, $content])] : [$label, $content]);
  }
};

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-group/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-group/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormGroup": () => (/* reexport safe */ _form_group__WEBPACK_IMPORTED_MODULE_1__.BFormGroup),
/* harmony export */   "FormGroupPlugin": () => (/* binding */ FormGroupPlugin)
/* harmony export */ });
/* harmony import */ var _form_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-group */ "./node_modules/bootstrap-vue/esm/components/form-group/form-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormGroupPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormGroup: _form_group__WEBPACK_IMPORTED_MODULE_1__.BFormGroup,
    BFormFieldset: _form_group__WEBPACK_IMPORTED_MODULE_1__.BFormGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-input/form-input.js":
/*!****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-input/form-input.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormInput": () => (/* binding */ BFormInput),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _mixins_form_selection__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../mixins/form-selection */ "./node_modules/bootstrap-vue/esm/mixins/form-selection.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_form_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/form-text */ "./node_modules/bootstrap-vue/esm/mixins/form-text.js");
/* harmony import */ var _mixins_form_validity__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../mixins/form-validity */ "./node_modules/bootstrap-vue/esm/mixins/form-validity.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_listeners__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../mixins/listeners */ "./node_modules/bootstrap-vue/esm/mixins/listeners.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
















 // --- Constants ---
// Valid supported input types

var TYPES = ['text', 'password', 'email', 'number', 'url', 'tel', 'search', 'range', 'color', 'date', 'time', 'datetime', 'datetime-local', 'month', 'week']; // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.props), _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__.props), _mixins_form_size__WEBPACK_IMPORTED_MODULE_4__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_5__.props), _mixins_form_text__WEBPACK_IMPORTED_MODULE_6__.props), {}, {
  list: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING),
  max: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING),
  min: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING),
  // Disable mousewheel to prevent wheel from changing values (i.e. number/date)
  noWheel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, false),
  step: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING),
  type: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING, 'text', function (type) {
    return (0,_utils_array__WEBPACK_IMPORTED_MODULE_8__.arrayIncludes)(TYPES, type);
  })
})), _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_FORM_INPUT); // --- Main component ---
// @vue/component

var BFormInput = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_10__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_FORM_INPUT,
  // Mixin order is important!
  mixins: [_mixins_listeners__WEBPACK_IMPORTED_MODULE_11__.listenersMixin, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.idMixin, _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__.formControlMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_4__.formSizeMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_5__.formStateMixin, _mixins_form_text__WEBPACK_IMPORTED_MODULE_6__.formTextMixin, _mixins_form_selection__WEBPACK_IMPORTED_MODULE_12__.formSelectionMixin, _mixins_form_validity__WEBPACK_IMPORTED_MODULE_13__.formValidityMixin],
  props: props,
  computed: {
    localType: function localType() {
      // We only allow certain types
      var type = this.type;
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_8__.arrayIncludes)(TYPES, type) ? type : 'text';
    },
    computedAttrs: function computedAttrs() {
      var type = this.localType,
          name = this.name,
          form = this.form,
          disabled = this.disabled,
          placeholder = this.placeholder,
          required = this.required,
          min = this.min,
          max = this.max,
          step = this.step;
      return {
        id: this.safeId(),
        name: name,
        form: form,
        type: type,
        disabled: disabled,
        placeholder: placeholder,
        required: required,
        autocomplete: this.autocomplete || null,
        readonly: this.readonly || this.plaintext,
        min: min,
        max: max,
        step: step,
        list: type !== 'password' ? this.list : null,
        'aria-required': required ? 'true' : null,
        'aria-invalid': this.computedAriaInvalid
      };
    },
    computedListeners: function computedListeners() {
      return _objectSpread(_objectSpread({}, this.bvListeners), {}, {
        input: this.onInput,
        change: this.onChange,
        blur: this.onBlur
      });
    }
  },
  watch: {
    noWheel: function noWheel(newValue) {
      this.setWheelStopper(newValue);
    }
  },
  mounted: function mounted() {
    this.setWheelStopper(this.noWheel);
  },

  /* istanbul ignore next */
  deactivated: function deactivated() {
    // Turn off listeners when keep-alive component deactivated

    /* istanbul ignore next */
    this.setWheelStopper(false);
  },

  /* istanbul ignore next */
  activated: function activated() {
    // Turn on listeners (if no-wheel) when keep-alive component activated

    /* istanbul ignore next */
    this.setWheelStopper(this.noWheel);
  },
  beforeDestroy: function beforeDestroy() {
    /* istanbul ignore next */
    this.setWheelStopper(false);
  },
  methods: {
    setWheelStopper: function setWheelStopper(on) {
      var input = this.$el; // We use native events, so that we don't interfere with propagation

      (0,_utils_events__WEBPACK_IMPORTED_MODULE_14__.eventOnOff)(on, input, 'focus', this.onWheelFocus);
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_14__.eventOnOff)(on, input, 'blur', this.onWheelBlur);

      if (!on) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_14__.eventOff)(document, 'wheel', this.stopWheel);
      }
    },
    onWheelFocus: function onWheelFocus() {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_14__.eventOn)(document, 'wheel', this.stopWheel);
    },
    onWheelBlur: function onWheelBlur() {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_14__.eventOff)(document, 'wheel', this.stopWheel);
    },
    stopWheel: function stopWheel(event) {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_14__.stopEvent)(event, {
        propagation: false
      });
      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_15__.attemptBlur)(this.$el);
    }
  },
  render: function render(h) {
    return h('input', {
      class: this.computedClass,
      attrs: this.computedAttrs,
      domProps: {
        value: this.localValue
      },
      on: this.computedListeners,
      ref: 'input'
    });
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-input/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-input/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormInput": () => (/* reexport safe */ _form_input__WEBPACK_IMPORTED_MODULE_1__.BFormInput),
/* harmony export */   "FormInputPlugin": () => (/* binding */ FormInputPlugin)
/* harmony export */ });
/* harmony import */ var _form_input__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-input */ "./node_modules/bootstrap-vue/esm/components/form-input/form-input.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormInputPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormInput: _form_input__WEBPACK_IMPORTED_MODULE_1__.BFormInput,
    BInput: _form_input__WEBPACK_IMPORTED_MODULE_1__.BFormInput
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-radio/form-radio-group.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-radio/form-radio-group.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormRadioGroup": () => (/* binding */ BFormRadioGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_radio_check_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../mixins/form-radio-check-group */ "./node_modules/bootstrap-vue/esm/mixins/form-radio-check-group.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)(_mixins_form_radio_check_group__WEBPACK_IMPORTED_MODULE_1__.props, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_RADIO_GROUP); // --- Main component ---
// @vue/component

var BFormRadioGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_RADIO_GROUP,
  mixins: [_mixins_form_radio_check_group__WEBPACK_IMPORTED_MODULE_1__.formRadioCheckGroupMixin],
  provide: function provide() {
    return {
      bvRadioGroup: this
    };
  },
  props: props,
  computed: {
    isRadioGroup: function isRadioGroup() {
      return true;
    }
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-radio/form-radio.js":
/*!****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-radio/form-radio.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormRadio": () => (/* binding */ BFormRadio),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _utils_loose_equal__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/loose-equal */ "./node_modules/bootstrap-vue/esm/utils/loose-equal.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/form-radio-check */ "./node_modules/bootstrap-vue/esm/mixins/form-radio-check.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.props), _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__.props), _mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_4__.props), _mixins_form_size__WEBPACK_IMPORTED_MODULE_5__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_6__.props)), _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_FORM_RADIO); // --- Main component ---
// @vue/component

var BFormRadio = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_8__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_FORM_RADIO,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_2__.idMixin, _mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_4__.formRadioCheckMixin, // Includes shared render function
  _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__.formControlMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_5__.formSizeMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_6__.formStateMixin],
  inject: {
    bvGroup: {
      from: 'bvRadioGroup',
      default: false
    }
  },
  props: props,
  watch: {
    computedLocalChecked: function computedLocalChecked(newValue, oldValue) {
      if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_9__.looseEqual)(newValue, oldValue)) {
        this.$emit(_mixins_form_radio_check__WEBPACK_IMPORTED_MODULE_4__.MODEL_EVENT_NAME, newValue);
      }
    }
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-radio/index.js":
/*!***********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-radio/index.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormRadio": () => (/* reexport safe */ _form_radio__WEBPACK_IMPORTED_MODULE_1__.BFormRadio),
/* harmony export */   "BFormRadioGroup": () => (/* reexport safe */ _form_radio_group__WEBPACK_IMPORTED_MODULE_2__.BFormRadioGroup),
/* harmony export */   "FormRadioPlugin": () => (/* binding */ FormRadioPlugin)
/* harmony export */ });
/* harmony import */ var _form_radio__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-radio */ "./node_modules/bootstrap-vue/esm/components/form-radio/form-radio.js");
/* harmony import */ var _form_radio_group__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./form-radio-group */ "./node_modules/bootstrap-vue/esm/components/form-radio/form-radio-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var FormRadioPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormRadio: _form_radio__WEBPACK_IMPORTED_MODULE_1__.BFormRadio,
    BRadio: _form_radio__WEBPACK_IMPORTED_MODULE_1__.BFormRadio,
    BFormRadioGroup: _form_radio_group__WEBPACK_IMPORTED_MODULE_2__.BFormRadioGroup,
    BRadioGroup: _form_radio_group__WEBPACK_IMPORTED_MODULE_2__.BFormRadioGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-rating/form-rating.js":
/*!******************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-rating/form-rating.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormRating": () => (/* binding */ BFormRating),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_locale__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../utils/locale */ "./node_modules/bootstrap-vue/esm/utils/locale.js");
/* harmony import */ var _utils_math__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/math */ "./node_modules/bootstrap-vue/esm/utils/math.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _icons_icon__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../icons/icon */ "./node_modules/bootstrap-vue/esm/icons/icon.js");
/* harmony import */ var _icons_icons__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../icons/icons */ "./node_modules/bootstrap-vue/esm/icons/icons.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }
























 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING,
  event: _constants_events__WEBPACK_IMPORTED_MODULE_2__.EVENT_NAME_CHANGE
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event;

var MIN_STARS = 3;
var DEFAULT_STARS = 5; // --- Helper methods ---

var computeStars = function computeStars(stars) {
  return (0,_utils_math__WEBPACK_IMPORTED_MODULE_3__.mathMax)(MIN_STARS, (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toInteger)(stars, DEFAULT_STARS));
};

var clampValue = function clampValue(value, min, max) {
  return (0,_utils_math__WEBPACK_IMPORTED_MODULE_3__.mathMax)((0,_utils_math__WEBPACK_IMPORTED_MODULE_3__.mathMin)(value, max), min);
}; // --- Helper components ---
// @vue/component


var BVFormRatingStar = _vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_FORM_RATING_STAR,
  mixins: [_mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_7__.normalizeSlotMixin],
  props: {
    disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
    // If parent is focused
    focused: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
    hasClear: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
    rating: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER, 0),
    readonly: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
    star: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER, 0),
    variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
  },
  methods: {
    onClick: function onClick(event) {
      if (!this.disabled && !this.readonly) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_9__.stopEvent)(event, {
          propagation: false
        });
        this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_2__.EVENT_NAME_SELECTED, this.star);
      }
    }
  },
  render: function render(h) {
    var rating = this.rating,
        star = this.star,
        focused = this.focused,
        hasClear = this.hasClear,
        variant = this.variant,
        disabled = this.disabled,
        readonly = this.readonly;
    var minStar = hasClear ? 0 : 1;
    var type = rating >= star ? 'full' : rating >= star - 0.5 ? 'half' : 'empty';
    var slotScope = {
      variant: variant,
      disabled: disabled,
      readonly: readonly
    };
    return h('span', {
      staticClass: 'b-rating-star',
      class: {
        // When not hovered, we use this class to focus the current (or first) star
        focused: focused && rating === star || !(0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toInteger)(rating) && star === minStar,
        // We add type classes to we can handle RTL styling
        'b-rating-star-empty': type === 'empty',
        'b-rating-star-half': type === 'half',
        'b-rating-star-full': type === 'full'
      },
      attrs: {
        tabindex: !disabled && !readonly ? '-1' : null
      },
      on: {
        click: this.onClick
      }
    }, [h('span', {
      staticClass: 'b-rating-icon'
    }, [this.normalizeSlot(type, slotScope)])]);
  }
}); // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_10__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_11__.props), modelProps), (0,_utils_object__WEBPACK_IMPORTED_MODULE_10__.omit)(_mixins_form_control__WEBPACK_IMPORTED_MODULE_12__.props, ['required', 'autofocus'])), _mixins_form_size__WEBPACK_IMPORTED_MODULE_13__.props), {}, {
  // CSS color string (overrides variant)
  color: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  iconClear: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'x'),
  iconEmpty: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'star'),
  iconFull: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'star-fill'),
  iconHalf: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'star-half'),
  inline: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Locale for the formatted value (if shown)
  // Defaults to the browser locale. Falls back to `en`
  locale: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_STRING),
  noBorder: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  precision: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING),
  readonly: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  showClear: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  showValue: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  showValueMax: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  stars: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_STARS, function (value) {
    return (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toInteger)(value) >= MIN_STARS;
  }),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_8__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
})), _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_FORM_RATING); // --- Main component ---
// @vue/component

var BFormRating = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_6__.NAME_FORM_RATING,
  components: {
    BIconStar: _icons_icons__WEBPACK_IMPORTED_MODULE_14__.BIconStar,
    BIconStarHalf: _icons_icons__WEBPACK_IMPORTED_MODULE_14__.BIconStarHalf,
    BIconStarFill: _icons_icons__WEBPACK_IMPORTED_MODULE_14__.BIconStarFill,
    BIconX: _icons_icons__WEBPACK_IMPORTED_MODULE_14__.BIconX
  },
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_11__.idMixin, modelMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_13__.formSizeMixin],
  props: props,
  data: function data() {
    var value = (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toFloat)(this[MODEL_PROP_NAME], null);
    var stars = computeStars(this.stars);
    return {
      localValue: (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value) ? null : clampValue(value, 0, stars),
      hasFocus: false
    };
  },
  computed: {
    computedStars: function computedStars() {
      return computeStars(this.stars);
    },
    computedRating: function computedRating() {
      var value = (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toFloat)(this.localValue, 0);
      var precision = (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toInteger)(this.precision, 3); // We clamp the value between `0` and stars

      return clampValue((0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toFloat)(value.toFixed(precision)), 0, this.computedStars);
    },
    computedLocale: function computedLocale() {
      var locales = (0,_utils_array__WEBPACK_IMPORTED_MODULE_16__.concat)(this.locale).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_17__.identity);
      var nf = new Intl.NumberFormat(locales);
      return nf.resolvedOptions().locale;
    },
    isInteractive: function isInteractive() {
      return !this.disabled && !this.readonly;
    },
    isRTL: function isRTL() {
      return (0,_utils_locale__WEBPACK_IMPORTED_MODULE_18__.isLocaleRTL)(this.computedLocale);
    },
    formattedRating: function formattedRating() {
      var precision = (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toInteger)(this.precision);
      var showValueMax = this.showValueMax;
      var locale = this.computedLocale;
      var formatOptions = {
        notation: 'standard',
        minimumFractionDigits: isNaN(precision) ? 0 : precision,
        maximumFractionDigits: isNaN(precision) ? 3 : precision
      };
      var stars = this.computedStars.toLocaleString(locale);
      var value = this.localValue;
      value = (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value) ? showValueMax ? '-' : '' : value.toLocaleString(locale, formatOptions);
      return showValueMax ? "".concat(value, "/").concat(stars) : value;
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue, oldValue) {
    if (newValue !== oldValue) {
      var value = (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toFloat)(newValue, null);
      this.localValue = (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value) ? null : clampValue(value, 0, this.computedStars);
    }
  }), _defineProperty(_watch, "localValue", function localValue(newValue, oldValue) {
    if (newValue !== oldValue && newValue !== (this.value || 0)) {
      this.$emit(MODEL_EVENT_NAME, newValue || null);
    }
  }), _defineProperty(_watch, "disabled", function disabled(newValue) {
    if (newValue) {
      this.hasFocus = false;
      this.blur();
    }
  }), _watch),
  methods: {
    // --- Public methods ---
    focus: function focus() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_19__.attemptFocus)(this.$el);
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_19__.attemptBlur)(this.$el);
      }
    },
    // --- Private methods ---
    onKeydown: function onKeydown(event) {
      var keyCode = event.keyCode;

      if (this.isInteractive && (0,_utils_array__WEBPACK_IMPORTED_MODULE_16__.arrayIncludes)([_constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_LEFT, _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_DOWN, _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_RIGHT, _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_UP], keyCode)) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_9__.stopEvent)(event, {
          propagation: false
        });
        var value = (0,_utils_number__WEBPACK_IMPORTED_MODULE_4__.toInteger)(this.localValue, 0);
        var min = this.showClear ? 0 : 1;
        var stars = this.computedStars; // In RTL mode, LEFT/RIGHT are swapped

        var amountRtl = this.isRTL ? -1 : 1;

        if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_LEFT) {
          this.localValue = clampValue(value - amountRtl, min, stars) || null;
        } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_RIGHT) {
          this.localValue = clampValue(value + amountRtl, min, stars);
        } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_DOWN) {
          this.localValue = clampValue(value - 1, min, stars) || null;
        } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_UP) {
          this.localValue = clampValue(value + 1, min, stars);
        }
      }
    },
    onSelected: function onSelected(value) {
      if (this.isInteractive) {
        this.localValue = value;
      }
    },
    onFocus: function onFocus(event) {
      this.hasFocus = !this.isInteractive ? false : event.type === 'focus';
    },
    // --- Render methods ---
    renderIcon: function renderIcon(icon) {
      return this.$createElement(_icons_icon__WEBPACK_IMPORTED_MODULE_21__.BIcon, {
        props: {
          icon: icon,
          variant: this.disabled || this.color ? null : this.variant || null
        }
      });
    },
    iconEmptyFn: function iconEmptyFn() {
      return this.renderIcon(this.iconEmpty);
    },
    iconHalfFn: function iconHalfFn() {
      return this.renderIcon(this.iconHalf);
    },
    iconFullFn: function iconFullFn() {
      return this.renderIcon(this.iconFull);
    },
    iconClearFn: function iconClearFn() {
      return this.$createElement(_icons_icon__WEBPACK_IMPORTED_MODULE_21__.BIcon, {
        props: {
          icon: this.iconClear
        }
      });
    }
  },
  render: function render(h) {
    var _this = this;

    var disabled = this.disabled,
        readonly = this.readonly,
        name = this.name,
        form = this.form,
        inline = this.inline,
        variant = this.variant,
        color = this.color,
        noBorder = this.noBorder,
        hasFocus = this.hasFocus,
        computedRating = this.computedRating,
        computedStars = this.computedStars,
        formattedRating = this.formattedRating,
        showClear = this.showClear,
        isRTL = this.isRTL,
        isInteractive = this.isInteractive,
        $scopedSlots = this.$scopedSlots;
    var $content = [];

    if (showClear && !disabled && !readonly) {
      var $icon = h('span', {
        staticClass: 'b-rating-icon'
      }, [($scopedSlots[_constants_slots__WEBPACK_IMPORTED_MODULE_22__.SLOT_NAME_ICON_CLEAR] || this.iconClearFn)()]);
      $content.push(h('span', {
        staticClass: 'b-rating-star b-rating-star-clear flex-grow-1',
        class: {
          focused: hasFocus && computedRating === 0
        },
        attrs: {
          tabindex: isInteractive ? '-1' : null
        },
        on: {
          click: function click() {
            return _this.onSelected(null);
          }
        },
        key: 'clear'
      }, [$icon]));
    }

    for (var index = 0; index < computedStars; index++) {
      var value = index + 1;
      $content.push(h(BVFormRatingStar, {
        staticClass: 'flex-grow-1',
        style: color && !disabled ? {
          color: color
        } : {},
        props: {
          rating: computedRating,
          star: value,
          variant: disabled ? null : variant || null,
          disabled: disabled,
          readonly: readonly,
          focused: hasFocus,
          hasClear: showClear
        },
        on: {
          selected: this.onSelected
        },
        scopedSlots: {
          empty: $scopedSlots[_constants_slots__WEBPACK_IMPORTED_MODULE_22__.SLOT_NAME_ICON_EMPTY] || this.iconEmptyFn,
          half: $scopedSlots[_constants_slots__WEBPACK_IMPORTED_MODULE_22__.SLOT_NAME_ICON_HALF] || this.iconHalfFn,
          full: $scopedSlots[_constants_slots__WEBPACK_IMPORTED_MODULE_22__.SLOT_NAME_ICON_FULL] || this.iconFullFn
        },
        key: index
      }));
    }

    if (name) {
      $content.push(h('input', {
        attrs: {
          type: 'hidden',
          value: (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(this.localValue) ? '' : computedRating,
          name: name,
          form: form || null
        },
        key: 'hidden'
      }));
    }

    if (this.showValue) {
      $content.push(h('b', {
        staticClass: 'b-rating-value flex-grow-1',
        attrs: {
          'aria-hidden': 'true'
        },
        key: 'value'
      }, (0,_utils_string__WEBPACK_IMPORTED_MODULE_23__.toString)(formattedRating)));
    }

    return h('output', {
      staticClass: 'b-rating form-control align-items-center',
      class: [{
        'd-inline-flex': inline,
        'd-flex': !inline,
        'border-0': noBorder,
        disabled: disabled,
        readonly: !disabled && readonly
      }, this.sizeFormClass],
      attrs: {
        id: this.safeId(),
        dir: isRTL ? 'rtl' : 'ltr',
        tabindex: disabled ? null : '0',
        disabled: disabled,
        role: 'slider',
        'aria-disabled': disabled ? 'true' : null,
        'aria-readonly': !disabled && readonly ? 'true' : null,
        'aria-live': 'off',
        'aria-valuemin': showClear ? '0' : '1',
        'aria-valuemax': (0,_utils_string__WEBPACK_IMPORTED_MODULE_23__.toString)(computedStars),
        'aria-valuenow': computedRating ? (0,_utils_string__WEBPACK_IMPORTED_MODULE_23__.toString)(computedRating) : null
      },
      on: {
        keydown: this.onKeydown,
        focus: this.onFocus,
        blur: this.onFocus
      }
    }, $content);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-rating/index.js":
/*!************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-rating/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormRating": () => (/* reexport safe */ _form_rating__WEBPACK_IMPORTED_MODULE_1__.BFormRating),
/* harmony export */   "FormRatingPlugin": () => (/* binding */ FormRatingPlugin)
/* harmony export */ });
/* harmony import */ var _form_rating__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-rating */ "./node_modules/bootstrap-vue/esm/components/form-rating/form-rating.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormRatingPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormRating: _form_rating__WEBPACK_IMPORTED_MODULE_1__.BFormRating,
    BRating: _form_rating__WEBPACK_IMPORTED_MODULE_1__.BFormRating
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-select/form-select-option-group.js":
/*!*******************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-select/form-select-option-group.js ***!
  \*******************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormSelectOptionGroup": () => (/* binding */ BFormSelectOptionGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/form-options */ "./node_modules/bootstrap-vue/esm/mixins/form-options.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _form_select_option__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./form-select-option */ "./node_modules/bootstrap-vue/esm/components/form-select/form-select-option.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, _mixins_form_options__WEBPACK_IMPORTED_MODULE_2__.props), {}, {
  label: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, undefined, true) // Required

})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_SELECT_OPTION_GROUP); // --- Main component ---
// @vue/component

var BFormSelectOptionGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_SELECT_OPTION_GROUP,
  mixins: [_mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__.normalizeSlotMixin, _mixins_form_options__WEBPACK_IMPORTED_MODULE_2__.formOptionsMixin],
  props: props,
  render: function render(h) {
    var label = this.label;
    var $options = this.formOptions.map(function (option, index) {
      var value = option.value,
          text = option.text,
          html = option.html,
          disabled = option.disabled;
      return h(_form_select_option__WEBPACK_IMPORTED_MODULE_7__.BFormSelectOption, {
        attrs: {
          value: value,
          disabled: disabled
        },
        domProps: (0,_utils_html__WEBPACK_IMPORTED_MODULE_8__.htmlOrText)(html, text),
        key: "option_".concat(index)
      });
    });
    return h('optgroup', {
      attrs: {
        label: label
      }
    }, [this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_9__.SLOT_NAME_FIRST), $options, this.normalizeSlot()]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-select/form-select-option.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-select/form-select-option.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormSelectOption": () => (/* binding */ BFormSelectOption),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  value: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ANY, undefined, true) // Required

}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_SELECT_OPTION); // --- Main component ---
// @vue/component

var BFormSelectOption = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_SELECT_OPTION,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var value = props.value,
        disabled = props.disabled;
    return h('option', (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      attrs: {
        disabled: disabled
      },
      domProps: {
        value: value
      }
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-select/form-select.js":
/*!******************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-select/form-select.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormSelect": () => (/* binding */ BFormSelect),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _mixins_form_custom__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/form-custom */ "./node_modules/bootstrap-vue/esm/mixins/form-custom.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_model__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/model */ "./node_modules/bootstrap-vue/esm/mixins/model.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _helpers_mixin_options__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./helpers/mixin-options */ "./node_modules/bootstrap-vue/esm/components/form-select/helpers/mixin-options.js");
/* harmony import */ var _form_select_option__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./form-select-option */ "./node_modules/bootstrap-vue/esm/components/form-select/form-select-option.js");
/* harmony import */ var _form_select_option_group__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./form-select-option-group */ "./node_modules/bootstrap-vue/esm/components/form-select/form-select-option-group.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





















 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.props), _mixins_model__WEBPACK_IMPORTED_MODULE_3__.props), _mixins_form_control__WEBPACK_IMPORTED_MODULE_4__.props), _mixins_form_custom__WEBPACK_IMPORTED_MODULE_5__.props), _mixins_form_size__WEBPACK_IMPORTED_MODULE_6__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_7__.props), {}, {
  ariaInvalid: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_8__.PROP_TYPE_BOOLEAN_STRING, false),
  multiple: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_8__.PROP_TYPE_BOOLEAN, false),
  // Browsers default size to `0`, which shows 4 rows in most browsers in multiple mode
  // Size of `1` can bork out Firefox
  selectSize: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_8__.PROP_TYPE_NUMBER, 0)
})), _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_FORM_SELECT); // --- Main component ---
// @vue/component

var BFormSelect = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_10__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_FORM_SELECT,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_2__.idMixin, _mixins_model__WEBPACK_IMPORTED_MODULE_3__.modelMixin, _mixins_form_control__WEBPACK_IMPORTED_MODULE_4__.formControlMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_6__.formSizeMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_7__.formStateMixin, _mixins_form_custom__WEBPACK_IMPORTED_MODULE_5__.formCustomMixin, _helpers_mixin_options__WEBPACK_IMPORTED_MODULE_11__.optionsMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_12__.normalizeSlotMixin],
  props: props,
  data: function data() {
    return {
      localValue: this[_mixins_model__WEBPACK_IMPORTED_MODULE_3__.MODEL_PROP_NAME]
    };
  },
  computed: {
    computedSelectSize: function computedSelectSize() {
      // Custom selects with a size of zero causes the arrows to be hidden,
      // so dont render the size attribute in this case
      return !this.plain && this.selectSize === 0 ? null : this.selectSize;
    },
    inputClass: function inputClass() {
      return [this.plain ? 'form-control' : 'custom-select', this.size && this.plain ? "form-control-".concat(this.size) : null, this.size && !this.plain ? "custom-select-".concat(this.size) : null, this.stateClass];
    }
  },
  watch: {
    value: function value(newValue) {
      this.localValue = newValue;
    },
    localValue: function localValue() {
      this.$emit(_mixins_model__WEBPACK_IMPORTED_MODULE_3__.MODEL_EVENT_NAME, this.localValue);
    }
  },
  methods: {
    focus: function focus() {
      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_13__.attemptFocus)(this.$refs.input);
    },
    blur: function blur() {
      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_13__.attemptBlur)(this.$refs.input);
    },
    onChange: function onChange(event) {
      var _this = this;

      var target = event.target;
      var selectedValue = (0,_utils_array__WEBPACK_IMPORTED_MODULE_14__.from)(target.options).filter(function (o) {
        return o.selected;
      }).map(function (o) {
        return '_value' in o ? o._value : o.value;
      });
      this.localValue = target.multiple ? selectedValue : selectedValue[0];
      this.$nextTick(function () {
        _this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_15__.EVENT_NAME_CHANGE, _this.localValue);
      });
    }
  },
  render: function render(h) {
    var name = this.name,
        disabled = this.disabled,
        required = this.required,
        size = this.computedSelectSize,
        value = this.localValue;
    var $options = this.formOptions.map(function (option, index) {
      var value = option.value,
          label = option.label,
          options = option.options,
          disabled = option.disabled;
      var key = "option_".concat(index);
      return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_16__.isArray)(options) ? h(_form_select_option_group__WEBPACK_IMPORTED_MODULE_17__.BFormSelectOptionGroup, {
        props: {
          label: label,
          options: options
        },
        key: key
      }) : h(_form_select_option__WEBPACK_IMPORTED_MODULE_18__.BFormSelectOption, {
        props: {
          value: value,
          disabled: disabled
        },
        domProps: (0,_utils_html__WEBPACK_IMPORTED_MODULE_19__.htmlOrText)(option.html, option.text),
        key: key
      });
    });
    return h('select', {
      class: this.inputClass,
      attrs: {
        id: this.safeId(),
        name: name,
        form: this.form || null,
        multiple: this.multiple || null,
        size: size,
        disabled: disabled,
        required: required,
        'aria-required': required ? 'true' : null,
        'aria-invalid': this.computedAriaInvalid
      },
      on: {
        change: this.onChange
      },
      directives: [{
        name: 'model',
        value: value
      }],
      ref: 'input'
    }, [this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_20__.SLOT_NAME_FIRST), $options, this.normalizeSlot()]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-select/helpers/mixin-options.js":
/*!****************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-select/helpers/mixin-options.js ***!
  \****************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "optionsMixin": () => (/* binding */ optionsMixin),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_get__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../../utils/get */ "./node_modules/bootstrap-vue/esm/utils/get.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../../mixins/form-options */ "./node_modules/bootstrap-vue/esm/mixins/form-options.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }







 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, _mixins_form_options__WEBPACK_IMPORTED_MODULE_2__.props), {}, {
  labelField: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'label'),
  optionsField: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'options')
})), 'formOptions'); // --- Mixin ---
// @vue/component

var optionsMixin = _vue__WEBPACK_IMPORTED_MODULE_4__["default"].extend({
  mixins: [_mixins_form_options__WEBPACK_IMPORTED_MODULE_2__.formOptionsMixin],
  props: props,
  methods: {
    normalizeOption: function normalizeOption(option) {
      var key = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : null;

      // When the option is an object, normalize it
      if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isPlainObject)(option)) {
        var value = (0,_utils_get__WEBPACK_IMPORTED_MODULE_6__.get)(option, this.valueField);
        var text = (0,_utils_get__WEBPACK_IMPORTED_MODULE_6__.get)(option, this.textField);
        var options = (0,_utils_get__WEBPACK_IMPORTED_MODULE_6__.get)(option, this.optionsField, null); // When it has options, create an `<optgroup>` object

        if (!(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isNull)(options)) {
          return {
            label: String((0,_utils_get__WEBPACK_IMPORTED_MODULE_6__.get)(option, this.labelField) || text),
            options: this.normalizeOptions(options)
          };
        } // Otherwise create an `<option>` object


        return {
          value: (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(value) ? key || text : value,
          text: String((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isUndefined)(text) ? key : text),
          html: (0,_utils_get__WEBPACK_IMPORTED_MODULE_6__.get)(option, this.htmlField),
          disabled: Boolean((0,_utils_get__WEBPACK_IMPORTED_MODULE_6__.get)(option, this.disabledField))
        };
      } // Otherwise create an `<option>` object from the given value


      return {
        value: key || option,
        text: String(option),
        disabled: false
      };
    }
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-select/index.js":
/*!************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-select/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormSelect": () => (/* reexport safe */ _form_select__WEBPACK_IMPORTED_MODULE_1__.BFormSelect),
/* harmony export */   "BFormSelectOption": () => (/* reexport safe */ _form_select_option__WEBPACK_IMPORTED_MODULE_2__.BFormSelectOption),
/* harmony export */   "BFormSelectOptionGroup": () => (/* reexport safe */ _form_select_option_group__WEBPACK_IMPORTED_MODULE_3__.BFormSelectOptionGroup),
/* harmony export */   "FormSelectPlugin": () => (/* binding */ FormSelectPlugin)
/* harmony export */ });
/* harmony import */ var _form_select__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-select */ "./node_modules/bootstrap-vue/esm/components/form-select/form-select.js");
/* harmony import */ var _form_select_option__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./form-select-option */ "./node_modules/bootstrap-vue/esm/components/form-select/form-select-option.js");
/* harmony import */ var _form_select_option_group__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./form-select-option-group */ "./node_modules/bootstrap-vue/esm/components/form-select/form-select-option-group.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");




var FormSelectPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormSelect: _form_select__WEBPACK_IMPORTED_MODULE_1__.BFormSelect,
    BFormSelectOption: _form_select_option__WEBPACK_IMPORTED_MODULE_2__.BFormSelectOption,
    BFormSelectOptionGroup: _form_select_option_group__WEBPACK_IMPORTED_MODULE_3__.BFormSelectOptionGroup,
    BSelect: _form_select__WEBPACK_IMPORTED_MODULE_1__.BFormSelect,
    BSelectOption: _form_select_option__WEBPACK_IMPORTED_MODULE_2__.BFormSelectOption,
    BSelectOptionGroup: _form_select_option_group__WEBPACK_IMPORTED_MODULE_3__.BFormSelectOptionGroup
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-spinbutton/form-spinbutton.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-spinbutton/form-spinbutton.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormSpinbutton": () => (/* binding */ BFormSpinbutton),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_locale__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../utils/locale */ "./node_modules/bootstrap-vue/esm/utils/locale.js");
/* harmony import */ var _utils_math__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/math */ "./node_modules/bootstrap-vue/esm/utils/math.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _mixins_attrs__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../mixins/attrs */ "./node_modules/bootstrap-vue/esm/mixins/attrs.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _icons_icons__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../icons/icons */ "./node_modules/bootstrap-vue/esm/icons/icons.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

























 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  // Should this really be String, to match native number inputs?
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN_NUMBER
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // Default for spin button range and step


var DEFAULT_MIN = 1;
var DEFAULT_MAX = 100;
var DEFAULT_STEP = 1; // Delay before auto-repeat in ms

var DEFAULT_REPEAT_DELAY = 500; // Repeat interval in ms

var DEFAULT_REPEAT_INTERVAL = 100; // Repeat rate increased after number of repeats

var DEFAULT_REPEAT_THRESHOLD = 10; // Repeat speed multiplier (step multiplier, must be an integer)

var DEFAULT_REPEAT_MULTIPLIER = 4;
var KEY_CODES = [_constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_UP, _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_DOWN, _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_HOME, _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_END, _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_PAGEUP, _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_PAGEDOWN]; // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_4__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_5__.props), modelProps), (0,_utils_object__WEBPACK_IMPORTED_MODULE_4__.omit)(_mixins_form_control__WEBPACK_IMPORTED_MODULE_6__.props, ['required', 'autofocus'])), _mixins_form_size__WEBPACK_IMPORTED_MODULE_7__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_8__.props), {}, {
  ariaControls: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  ariaLabel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  formatterFn: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_FUNCTION),
  inline: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  labelDecrement: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Decrement'),
  labelIncrement: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Increment'),
  locale: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_STRING),
  max: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_MAX),
  min: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_MIN),
  placeholder: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  readonly: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  repeatDelay: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_REPEAT_DELAY),
  repeatInterval: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_REPEAT_INTERVAL),
  repeatStepMultiplier: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_REPEAT_MULTIPLIER),
  repeatThreshold: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_REPEAT_THRESHOLD),
  step: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, DEFAULT_STEP),
  vertical: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  wrap: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false)
})), _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_FORM_SPINBUTTON); // --- Main Component ---
// @vue/component

var BFormSpinbutton = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_10__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_FORM_SPINBUTTON,
  // Mixin order is important!
  mixins: [_mixins_attrs__WEBPACK_IMPORTED_MODULE_11__.attrsMixin, _mixins_id__WEBPACK_IMPORTED_MODULE_5__.idMixin, modelMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_7__.formSizeMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_8__.formStateMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_12__.normalizeSlotMixin],
  inheritAttrs: false,
  props: props,
  data: function data() {
    return {
      localValue: (0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toFloat)(this[MODEL_PROP_NAME], null),
      hasFocus: false
    };
  },
  computed: {
    spinId: function spinId() {
      return this.safeId();
    },
    computedInline: function computedInline() {
      return this.inline && !this.vertical;
    },
    computedReadonly: function computedReadonly() {
      return this.readonly && !this.disabled;
    },
    computedRequired: function computedRequired() {
      return this.required && !this.computedReadonly && !this.disabled;
    },
    computedStep: function computedStep() {
      return (0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toFloat)(this.step, DEFAULT_STEP);
    },
    computedMin: function computedMin() {
      return (0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toFloat)(this.min, DEFAULT_MIN);
    },
    computedMax: function computedMax() {
      // We round down to the nearest maximum step value
      var max = (0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toFloat)(this.max, DEFAULT_MAX);
      var step = this.computedStep;
      var min = this.computedMin;
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_14__.mathFloor)((max - min) / step) * step + min;
    },
    computedDelay: function computedDelay() {
      var delay = (0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toInteger)(this.repeatDelay, 0);
      return delay > 0 ? delay : DEFAULT_REPEAT_DELAY;
    },
    computedInterval: function computedInterval() {
      var interval = (0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toInteger)(this.repeatInterval, 0);
      return interval > 0 ? interval : DEFAULT_REPEAT_INTERVAL;
    },
    computedThreshold: function computedThreshold() {
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_14__.mathMax)((0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toInteger)(this.repeatThreshold, DEFAULT_REPEAT_THRESHOLD), 1);
    },
    computedStepMultiplier: function computedStepMultiplier() {
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_14__.mathMax)((0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toInteger)(this.repeatStepMultiplier, DEFAULT_REPEAT_MULTIPLIER), 1);
    },
    computedPrecision: function computedPrecision() {
      // Quick and dirty way to get the number of decimals
      var step = this.computedStep;
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_14__.mathFloor)(step) === step ? 0 : (step.toString().split('.')[1] || '').length;
    },
    computedMultiplier: function computedMultiplier() {
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_14__.mathPow)(10, this.computedPrecision || 0);
    },
    valueAsFixed: function valueAsFixed() {
      var value = this.localValue;
      return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value) ? '' : value.toFixed(this.computedPrecision);
    },
    computedLocale: function computedLocale() {
      var locales = (0,_utils_array__WEBPACK_IMPORTED_MODULE_16__.concat)(this.locale).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_17__.identity);
      var nf = new Intl.NumberFormat(locales);
      return nf.resolvedOptions().locale;
    },
    computedRTL: function computedRTL() {
      return (0,_utils_locale__WEBPACK_IMPORTED_MODULE_18__.isLocaleRTL)(this.computedLocale);
    },
    defaultFormatter: function defaultFormatter() {
      // Returns and `Intl.NumberFormat` formatter method reference
      var precision = this.computedPrecision;
      var nf = new Intl.NumberFormat(this.computedLocale, {
        style: 'decimal',
        useGrouping: false,
        minimumIntegerDigits: 1,
        minimumFractionDigits: precision,
        maximumFractionDigits: precision,
        notation: 'standard'
      }); // Return the format method reference

      return nf.format;
    },
    computedFormatter: function computedFormatter() {
      var formatterFn = this.formatterFn;
      return (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.hasPropFunction)(formatterFn) ? formatterFn : this.defaultFormatter;
    },
    computedAttrs: function computedAttrs() {
      return _objectSpread(_objectSpread({}, this.bvAttrs), {}, {
        role: 'group',
        lang: this.computedLocale,
        tabindex: this.disabled ? null : '-1',
        title: this.ariaLabel
      });
    },
    computedSpinAttrs: function computedSpinAttrs() {
      var spinId = this.spinId,
          value = this.localValue,
          required = this.computedRequired,
          disabled = this.disabled,
          state = this.state,
          computedFormatter = this.computedFormatter;
      var hasValue = !(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value);
      return _objectSpread(_objectSpread({
        dir: this.computedRTL ? 'rtl' : 'ltr'
      }, this.bvAttrs), {}, {
        id: spinId,
        role: 'spinbutton',
        tabindex: disabled ? null : '0',
        'aria-live': 'off',
        'aria-label': this.ariaLabel || null,
        'aria-controls': this.ariaControls || null,
        // TODO: May want to check if the value is in range
        'aria-invalid': state === false || !hasValue && required ? 'true' : null,
        'aria-required': required ? 'true' : null,
        // These attrs are required for role spinbutton
        'aria-valuemin': (0,_utils_string__WEBPACK_IMPORTED_MODULE_19__.toString)(this.computedMin),
        'aria-valuemax': (0,_utils_string__WEBPACK_IMPORTED_MODULE_19__.toString)(this.computedMax),
        // These should be `null` if the value is out of range
        // They must also be non-existent attrs if the value is out of range or `null`
        'aria-valuenow': hasValue ? value : null,
        'aria-valuetext': hasValue ? computedFormatter(value) : null
      });
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (value) {
    this.localValue = (0,_utils_number__WEBPACK_IMPORTED_MODULE_13__.toFloat)(value, null);
  }), _defineProperty(_watch, "localValue", function localValue(value) {
    this.$emit(MODEL_EVENT_NAME, value);
  }), _defineProperty(_watch, "disabled", function disabled(_disabled) {
    if (_disabled) {
      this.clearRepeat();
    }
  }), _defineProperty(_watch, "readonly", function readonly(_readonly) {
    if (_readonly) {
      this.clearRepeat();
    }
  }), _watch),
  created: function created() {
    // Create non reactive properties
    this.$_autoDelayTimer = null;
    this.$_autoRepeatTimer = null;
    this.$_keyIsDown = false;
  },
  beforeDestroy: function beforeDestroy() {
    this.clearRepeat();
  },

  /* istanbul ignore next */
  deactivated: function deactivated() {
    this.clearRepeat();
  },
  methods: {
    // --- Public methods ---
    focus: function focus() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_20__.attemptFocus)(this.$refs.spinner);
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_20__.attemptBlur)(this.$refs.spinner);
      }
    },
    // --- Private methods ---
    emitChange: function emitChange() {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_21__.EVENT_NAME_CHANGE, this.localValue);
    },
    stepValue: function stepValue(direction) {
      // Sets a new incremented or decremented value, supporting optional wrapping
      // Direction is either +1 or -1 (or a multiple thereof)
      var value = this.localValue;

      if (!this.disabled && !(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value)) {
        var step = this.computedStep * direction;
        var min = this.computedMin;
        var max = this.computedMax;
        var multiplier = this.computedMultiplier;
        var wrap = this.wrap; // We ensure that the value steps like a native input

        value = (0,_utils_math__WEBPACK_IMPORTED_MODULE_14__.mathRound)((value - min) / step) * step + min + step; // We ensure that precision is maintained (decimals)

        value = (0,_utils_math__WEBPACK_IMPORTED_MODULE_14__.mathRound)(value * multiplier) / multiplier; // Handle if wrapping is enabled

        this.localValue = value > max ? wrap ? min : max : value < min ? wrap ? max : min : value;
      }
    },
    onFocusBlur: function onFocusBlur(event) {
      if (!this.disabled) {
        this.hasFocus = event.type === 'focus';
      } else {
        this.hasFocus = false;
      }
    },
    stepUp: function stepUp() {
      var multiplier = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var value = this.localValue;

      if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value)) {
        this.localValue = this.computedMin;
      } else {
        this.stepValue(+1 * multiplier);
      }
    },
    stepDown: function stepDown() {
      var multiplier = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : 1;
      var value = this.localValue;

      if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value)) {
        this.localValue = this.wrap ? this.computedMax : this.computedMin;
      } else {
        this.stepValue(-1 * multiplier);
      }
    },
    onKeydown: function onKeydown(event) {
      var keyCode = event.keyCode,
          altKey = event.altKey,
          ctrlKey = event.ctrlKey,
          metaKey = event.metaKey;
      /* istanbul ignore if */

      if (this.disabled || this.readonly || altKey || ctrlKey || metaKey) {
        return;
      }

      if ((0,_utils_array__WEBPACK_IMPORTED_MODULE_16__.arrayIncludes)(KEY_CODES, keyCode)) {
        // https://w3c.github.io/aria-practices/#spinbutton
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.stopEvent)(event, {
          propagation: false
        });
        /* istanbul ignore if */

        if (this.$_keyIsDown) {
          // Keypress is already in progress
          return;
        }

        this.resetTimers();

        if ((0,_utils_array__WEBPACK_IMPORTED_MODULE_16__.arrayIncludes)([_constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_UP, _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_DOWN], keyCode)) {
          // The following use the custom auto-repeat handling
          this.$_keyIsDown = true;

          if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_UP) {
            this.handleStepRepeat(event, this.stepUp);
          } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_DOWN) {
            this.handleStepRepeat(event, this.stepDown);
          }
        } else {
          // These use native OS key repeating
          if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_PAGEUP) {
            this.stepUp(this.computedStepMultiplier);
          } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_PAGEDOWN) {
            this.stepDown(this.computedStepMultiplier);
          } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_HOME) {
            this.localValue = this.computedMin;
          } else if (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_2__.CODE_END) {
            this.localValue = this.computedMax;
          }
        }
      }
    },
    onKeyup: function onKeyup(event) {
      // Emit a change event when the keyup happens
      var keyCode = event.keyCode,
          altKey = event.altKey,
          ctrlKey = event.ctrlKey,
          metaKey = event.metaKey;
      /* istanbul ignore if */

      if (this.disabled || this.readonly || altKey || ctrlKey || metaKey) {
        return;
      }

      if ((0,_utils_array__WEBPACK_IMPORTED_MODULE_16__.arrayIncludes)(KEY_CODES, keyCode)) {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.stopEvent)(event, {
          propagation: false
        });
        this.resetTimers();
        this.$_keyIsDown = false;
        this.emitChange();
      }
    },
    handleStepRepeat: function handleStepRepeat(event, stepper) {
      var _this = this;

      var _ref = event || {},
          type = _ref.type,
          button = _ref.button;

      if (!this.disabled && !this.readonly) {
        /* istanbul ignore if */
        if (type === 'mousedown' && button) {
          // We only respond to left (main === 0) button clicks
          return;
        }

        this.resetTimers(); // Step the counter initially

        stepper(1);
        var threshold = this.computedThreshold;
        var multiplier = this.computedStepMultiplier;
        var delay = this.computedDelay;
        var interval = this.computedInterval; // Initiate the delay/repeat interval

        this.$_autoDelayTimer = setTimeout(function () {
          var count = 0;
          _this.$_autoRepeatTimer = setInterval(function () {
            // After N initial repeats, we increase the incrementing step amount
            // We do this to minimize screen reader announcements of the value
            // (values are announced every change, which can be chatty for SR users)
            // And to make it easer to select a value when the range is large
            stepper(count < threshold ? 1 : multiplier);
            count++;
          }, interval);
        }, delay);
      }
    },
    onMouseup: function onMouseup(event) {
      // `<body>` listener, only enabled when mousedown starts
      var _ref2 = event || {},
          type = _ref2.type,
          button = _ref2.button;
      /* istanbul ignore if */


      if (type === 'mouseup' && button) {
        // Ignore non left button (main === 0) mouse button click
        return;
      }

      (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.stopEvent)(event, {
        propagation: false
      });
      this.resetTimers();
      this.setMouseup(false); // Trigger the change event

      this.emitChange();
    },
    setMouseup: function setMouseup(on) {
      // Enable or disabled the body mouseup/touchend handlers
      // Use try/catch to handle case when called server side
      try {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.eventOnOff)(on, document.body, 'mouseup', this.onMouseup, false);
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.eventOnOff)(on, document.body, 'touchend', this.onMouseup, false);
      } catch (_unused) {}
    },
    resetTimers: function resetTimers() {
      clearTimeout(this.$_autoDelayTimer);
      clearInterval(this.$_autoRepeatTimer);
      this.$_autoDelayTimer = null;
      this.$_autoRepeatTimer = null;
    },
    clearRepeat: function clearRepeat() {
      this.resetTimers();
      this.setMouseup(false);
      this.$_keyIsDown = false;
    }
  },
  render: function render(h) {
    var _this2 = this;

    var spinId = this.spinId,
        value = this.localValue,
        inline = this.computedInline,
        readonly = this.computedReadonly,
        vertical = this.vertical,
        disabled = this.disabled,
        computedFormatter = this.computedFormatter;
    var hasValue = !(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_15__.isNull)(value);

    var makeButton = function makeButton(stepper, label, IconCmp, keyRef, shortcut, btnDisabled, slotName) {
      var $icon = h(IconCmp, {
        props: {
          scale: _this2.hasFocus ? 1.5 : 1.25
        },
        attrs: {
          'aria-hidden': 'true'
        }
      });
      var scope = {
        hasFocus: _this2.hasFocus
      };

      var handler = function handler(event) {
        if (!disabled && !readonly) {
          (0,_utils_events__WEBPACK_IMPORTED_MODULE_22__.stopEvent)(event, {
            propagation: false
          });

          _this2.setMouseup(true); // Since we `preventDefault()`, we must manually focus the button


          (0,_utils_dom__WEBPACK_IMPORTED_MODULE_20__.attemptFocus)(event.currentTarget);

          _this2.handleStepRepeat(event, stepper);
        }
      };

      return h('button', {
        staticClass: 'btn btn-sm border-0 rounded-0',
        class: {
          'py-0': !vertical
        },
        attrs: {
          tabindex: '-1',
          type: 'button',
          disabled: disabled || readonly || btnDisabled,
          'aria-disabled': disabled || readonly || btnDisabled ? 'true' : null,
          'aria-controls': spinId,
          'aria-label': label || null,
          'aria-keyshortcuts': shortcut || null
        },
        on: {
          mousedown: handler,
          touchstart: handler
        },
        key: keyRef || null,
        ref: keyRef
      }, [_this2.normalizeSlot(slotName, scope) || $icon]);
    }; // TODO: Add button disabled state when `wrap` is `false` and at value max/min


    var $increment = makeButton(this.stepUp, this.labelIncrement, _icons_icons__WEBPACK_IMPORTED_MODULE_23__.BIconPlus, 'inc', 'ArrowUp', false, _constants_slots__WEBPACK_IMPORTED_MODULE_24__.SLOT_NAME_INCREMENT);
    var $decrement = makeButton(this.stepDown, this.labelDecrement, _icons_icons__WEBPACK_IMPORTED_MODULE_23__.BIconDash, 'dec', 'ArrowDown', false, _constants_slots__WEBPACK_IMPORTED_MODULE_24__.SLOT_NAME_DECREMENT);
    var $hidden = h();

    if (this.name && !disabled) {
      $hidden = h('input', {
        attrs: {
          type: 'hidden',
          name: this.name,
          form: this.form || null,
          // TODO: Should this be set to '' if value is out of range?
          value: this.valueAsFixed
        },
        key: 'hidden'
      });
    }

    var $spin = h( // We use 'output' element to make this accept a `<label for="id">` (Except IE)
    'output', {
      staticClass: 'flex-grow-1',
      class: {
        'd-flex': vertical,
        'align-self-center': !vertical,
        'align-items-center': vertical,
        'border-top': vertical,
        'border-bottom': vertical,
        'border-left': !vertical,
        'border-right': !vertical
      },
      attrs: this.computedSpinAttrs,
      key: 'output',
      ref: 'spinner'
    }, [h('bdi', hasValue ? computedFormatter(value) : this.placeholder || '')]);
    return h('div', {
      staticClass: 'b-form-spinbutton form-control',
      class: [{
        disabled: disabled,
        readonly: readonly,
        focus: this.hasFocus,
        'd-inline-flex': inline || vertical,
        'd-flex': !inline && !vertical,
        'align-items-stretch': !vertical,
        'flex-column': vertical
      }, this.sizeFormClass, this.stateClass],
      attrs: this.computedAttrs,
      on: {
        keydown: this.onKeydown,
        keyup: this.onKeyup,
        // We use capture phase (`!` prefix) since focus and blur do not bubble
        '!focus': this.onFocusBlur,
        '!blur': this.onFocusBlur
      }
    }, vertical ? [$increment, $hidden, $spin, $decrement] : [$decrement, $hidden, $spin, $increment]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-spinbutton/index.js":
/*!****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-spinbutton/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormSpinbutton": () => (/* reexport safe */ _form_spinbutton__WEBPACK_IMPORTED_MODULE_1__.BFormSpinbutton),
/* harmony export */   "FormSpinbuttonPlugin": () => (/* binding */ FormSpinbuttonPlugin)
/* harmony export */ });
/* harmony import */ var _form_spinbutton__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-spinbutton */ "./node_modules/bootstrap-vue/esm/components/form-spinbutton/form-spinbutton.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormSpinbuttonPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormSpinbutton: _form_spinbutton__WEBPACK_IMPORTED_MODULE_1__.BFormSpinbutton,
    BSpinbutton: _form_spinbutton__WEBPACK_IMPORTED_MODULE_1__.BFormSpinbutton
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-tags/form-tag.js":
/*!*************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-tags/form-tag.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormTag": () => (/* binding */ BFormTag),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _badge_badge__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../badge/badge */ "./node_modules/bootstrap-vue/esm/components/badge/badge.js");
/* harmony import */ var _button_button_close__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../button/button-close */ "./node_modules/bootstrap-vue/esm/components/button/button-close.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }











 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.props), {}, {
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  noRemove: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  pill: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  removeLabel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'Remove tag'),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'span'),
  title: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  variant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'secondary')
})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_TAG); // --- Main component ---
// @vue/component

var BFormTag = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_TAG,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_2__.idMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__.normalizeSlotMixin],
  props: props,
  methods: {
    onRemove: function onRemove(event) {
      var type = event.type,
          keyCode = event.keyCode;

      if (!this.disabled && (type === 'click' || type === 'keydown' && keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_7__.CODE_DELETE)) {
        this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_8__.EVENT_NAME_REMOVE);
      }
    }
  },
  render: function render(h) {
    var title = this.title,
        tag = this.tag,
        variant = this.variant,
        pill = this.pill,
        disabled = this.disabled;
    var tagId = this.safeId();
    var tagLabelId = this.safeId('_taglabel_');
    var $remove = h();

    if (!this.noRemove && !disabled) {
      $remove = h(_button_button_close__WEBPACK_IMPORTED_MODULE_9__.BButtonClose, {
        staticClass: 'b-form-tag-remove',
        props: {
          ariaLabel: this.removeLabel
        },
        attrs: {
          'aria-controls': tagId,
          'aria-describedby': tagLabelId,
          'aria-keyshortcuts': 'Delete'
        },
        on: {
          click: this.onRemove,
          keydown: this.onRemove
        }
      });
    }

    var $tag = h('span', {
      staticClass: 'b-form-tag-content flex-grow-1 text-truncate',
      attrs: {
        id: tagLabelId
      }
    }, this.normalizeSlot() || title);
    return h(_badge_badge__WEBPACK_IMPORTED_MODULE_10__.BBadge, {
      staticClass: 'b-form-tag d-inline-flex align-items-baseline mw-100',
      class: {
        disabled: disabled
      },
      props: {
        tag: tag,
        variant: variant,
        pill: pill
      },
      attrs: {
        id: tagId,
        title: title || null,
        'aria-labelledby': tagLabelId
      }
    }, [$tag, $remove]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-tags/form-tags.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-tags/form-tags.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormTags": () => (/* binding */ BFormTags)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../constants/key-codes */ "./node_modules/bootstrap-vue/esm/constants/key-codes.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_regex__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/regex */ "./node_modules/bootstrap-vue/esm/constants/regex.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_css_escape__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../utils/css-escape */ "./node_modules/bootstrap-vue/esm/utils/css-escape.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_loose_equal__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/loose-equal */ "./node_modules/bootstrap-vue/esm/utils/loose-equal.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../button/button */ "./node_modules/bootstrap-vue/esm/components/button/button.js");
/* harmony import */ var _form_form_invalid_feedback__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../form/form-invalid-feedback */ "./node_modules/bootstrap-vue/esm/components/form/form-invalid-feedback.js");
/* harmony import */ var _form_form_text__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../form/form-text */ "./node_modules/bootstrap-vue/esm/components/form/form-text.js");
/* harmony import */ var _form_tag__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./form-tag */ "./node_modules/bootstrap-vue/esm/components/form-tags/form-tag.js");
var _watch;

function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

// Tagged input form control
// Based loosely on https://adamwathan.me/renderless-components-in-vuejs/


























 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY,
  defaultValue: []
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // Supported input types (for built in input)


var TYPES = ['text', 'email', 'tel', 'url', 'number']; // Default ignore input focus selector

var DEFAULT_INPUT_FOCUS_SELECTOR = ['.b-form-tag', 'button', 'input', 'select'].join(' '); // --- Helper methods ---
// Escape special chars in string and replace
// contiguous spaces with a whitespace match

var escapeRegExpChars = function escapeRegExpChars(str) {
  return (0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.escapeRegExp)(str).replace(_constants_regex__WEBPACK_IMPORTED_MODULE_3__.RX_SPACES, '\\s');
}; // Remove leading/trailing spaces from array of tags and remove duplicates


var cleanTags = function cleanTags(tags) {
  return (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.concat)(tags).map(function (tag) {
    return (0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.trim)((0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.toString)(tag));
  }).filter(function (tag, index, arr) {
    return tag.length > 0 && arr.indexOf(tag) === index;
  });
}; // Processes an input/change event, normalizing string or event argument


var processEventValue = function processEventValue(event) {
  return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isString)(event) ? event : (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isEvent)(event) ? event.target.value || '' : '';
}; // Returns a fresh empty `tagsState` object


var cleanTagsState = function cleanTagsState() {
  return {
    all: [],
    valid: [],
    invalid: [],
    duplicate: []
  };
}; // --- Props ---


var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_7__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_8__.props), modelProps), _mixins_form_control__WEBPACK_IMPORTED_MODULE_9__.props), _mixins_form_size__WEBPACK_IMPORTED_MODULE_10__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_11__.props), {}, {
  addButtonText: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Add'),
  addButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'outline-secondary'),
  // Enable change event triggering tag addition
  // Handy if using <select> as the input
  addOnChange: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  duplicateTagText: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Duplicate tag(s)'),
  // Disable the input focus behavior when clicking
  // on element matching the selector (or selectors)
  ignoreInputFocusSelector: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_STRING, DEFAULT_INPUT_FOCUS_SELECTOR),
  // Additional attributes to add to the input element
  inputAttrs: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_OBJECT, {}),
  inputClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_OBJECT_STRING),
  inputId: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  inputType: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'text', function (value) {
    return (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(TYPES, value);
  }),
  invalidTagText: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Invalid tag(s)'),
  limit: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER),
  limitTagsText: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Tag limit reached'),
  // Disable ENTER key from triggering tag addition
  noAddOnEnter: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Disable the focus ring on the root element
  noOuterFocus: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  noTagRemove: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  placeholder: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Add tag...'),
  // Enable deleting last tag in list when CODE_BACKSPACE is
  // pressed and input is empty
  removeOnDelete: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  // Character (or characters) that trigger adding tags
  separator: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_STRING),
  tagClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_ARRAY_OBJECT_STRING),
  tagPills: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  tagRemoveLabel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Remove tag'),
  tagRemovedLabel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Tag removed'),
  tagValidator: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_FUNCTION),
  tagVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'secondary')
})), _constants_components__WEBPACK_IMPORTED_MODULE_12__.NAME_FORM_TAGS); // --- Main component ---
// @vue/component

var BFormTags = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_13__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_12__.NAME_FORM_TAGS,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_8__.idMixin, modelMixin, _mixins_form_control__WEBPACK_IMPORTED_MODULE_9__.formControlMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_10__.formSizeMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_11__.formStateMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_14__.normalizeSlotMixin],
  props: props,
  data: function data() {
    return {
      hasFocus: false,
      newTag: '',
      tags: [],
      // Tags that were removed
      removedTags: [],
      // Populated when tags are parsed
      tagsState: cleanTagsState()
    };
  },
  computed: {
    computedInputId: function computedInputId() {
      return this.inputId || this.safeId('__input__');
    },
    computedInputType: function computedInputType() {
      // We only allow certain types
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(TYPES, this.inputType) ? this.inputType : 'text';
    },
    computedInputAttrs: function computedInputAttrs() {
      var disabled = this.disabled,
          form = this.form;
      return _objectSpread(_objectSpread({}, this.inputAttrs), {}, {
        // Must have attributes
        id: this.computedInputId,
        value: this.newTag,
        disabled: disabled,
        form: form
      });
    },
    computedInputHandlers: function computedInputHandlers() {
      return {
        input: this.onInputInput,
        change: this.onInputChange,
        keydown: this.onInputKeydown,
        reset: this.reset
      };
    },
    computedSeparator: function computedSeparator() {
      // Merge the array into a string
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.concat)(this.separator).filter(_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isString).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_15__.identity).join('');
    },
    computedSeparatorRegExp: function computedSeparatorRegExp() {
      // We use a computed prop here to precompile the RegExp
      // The RegExp is a character class RE in the form of `/[abc]+/`
      // where a, b, and c are the valid separator characters
      // -> `tags = str.split(/[abc]+/).filter(t => t)`
      var separator = this.computedSeparator;
      return separator ? new RegExp("[".concat(escapeRegExpChars(separator), "]+")) : null;
    },
    computedJoiner: function computedJoiner() {
      // When tag(s) are invalid or duplicate, we leave them
      // in the input so that the user can see them
      // If there are more than one tag in the input, we use the
      // first separator character as the separator in the input
      // We append a space if the first separator is not a space
      var joiner = this.computedSeparator.charAt(0);
      return joiner !== ' ' ? "".concat(joiner, " ") : joiner;
    },
    computeIgnoreInputFocusSelector: function computeIgnoreInputFocusSelector() {
      // Normalize to an single selector with selectors separated by `,`
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.concat)(this.ignoreInputFocusSelector).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_15__.identity).join(',').trim();
    },
    disableAddButton: function disableAddButton() {
      var _this = this;

      // If 'Add' button should be disabled
      // If the input contains at least one tag that can
      // be added, then the 'Add' button should be enabled
      var newTag = (0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.trim)(this.newTag);
      return newTag === '' || !this.splitTags(newTag).some(function (t) {
        return !(0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(_this.tags, t) && _this.validateTag(t);
      });
    },
    duplicateTags: function duplicateTags() {
      return this.tagsState.duplicate;
    },
    hasDuplicateTags: function hasDuplicateTags() {
      return this.duplicateTags.length > 0;
    },
    invalidTags: function invalidTags() {
      return this.tagsState.invalid;
    },
    hasInvalidTags: function hasInvalidTags() {
      return this.invalidTags.length > 0;
    },
    isLimitReached: function isLimitReached() {
      var limit = this.limit;
      return (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isNumber)(limit) && limit >= 0 && this.tags.length >= limit;
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue) {
    this.tags = cleanTags(newValue);
  }), _defineProperty(_watch, "tags", function tags(newValue, oldValue) {
    // Update the `v-model` (if it differs from the value prop)
    if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_16__.looseEqual)(newValue, this[MODEL_PROP_NAME])) {
      this.$emit(MODEL_EVENT_NAME, newValue);
    }

    if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_16__.looseEqual)(newValue, oldValue)) {
      newValue = (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.concat)(newValue).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_15__.identity);
      oldValue = (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.concat)(oldValue).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_15__.identity);
      this.removedTags = oldValue.filter(function (old) {
        return !(0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(newValue, old);
      });
    }
  }), _defineProperty(_watch, "tagsState", function tagsState(newValue, oldValue) {
    // Emit a tag-state event when the `tagsState` object changes
    if (!(0,_utils_loose_equal__WEBPACK_IMPORTED_MODULE_16__.looseEqual)(newValue, oldValue)) {
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_17__.EVENT_NAME_TAG_STATE, newValue.valid, newValue.invalid, newValue.duplicate);
    }
  }), _watch),
  created: function created() {
    // We do this in created to make sure an input event emits
    // if the cleaned tags are not equal to the value prop
    this.tags = cleanTags(this[MODEL_PROP_NAME]);
  },
  mounted: function mounted() {
    var _this2 = this;

    // Listen for form reset events, to reset the tags input
    var $form = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.closest)('form', this.$el);

    if ($form) {
      (0,_utils_events__WEBPACK_IMPORTED_MODULE_19__.eventOn)($form, 'reset', this.reset, _constants_events__WEBPACK_IMPORTED_MODULE_17__.EVENT_OPTIONS_PASSIVE);
      this.$on(_constants_events__WEBPACK_IMPORTED_MODULE_17__.HOOK_EVENT_NAME_BEFORE_DESTROY, function () {
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_19__.eventOff)($form, 'reset', _this2.reset, _constants_events__WEBPACK_IMPORTED_MODULE_17__.EVENT_OPTIONS_PASSIVE);
      });
    }
  },
  methods: {
    addTag: function addTag(newTag) {
      newTag = (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isString)(newTag) ? newTag : this.newTag;
      /* istanbul ignore next */

      if (this.disabled || (0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.trim)(newTag) === '' || this.isLimitReached) {
        // Early exit
        return;
      }

      var parsed = this.parseTags(newTag); // Add any new tags to the `tags` array, or if the
      // array of `allTags` is empty, we clear the input

      if (parsed.valid.length > 0 || parsed.all.length === 0) {
        // Clear the user input element (and leave in any invalid/duplicate tag(s)

        /* istanbul ignore if: full testing to be added later */
        if ((0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.matches)(this.getInput(), 'select')) {
          // The following is needed to properly
          // work with `<select>` elements
          this.newTag = '';
        } else {
          var invalidAndDuplicates = [].concat(_toConsumableArray(parsed.invalid), _toConsumableArray(parsed.duplicate));
          this.newTag = parsed.all.filter(function (tag) {
            return (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(invalidAndDuplicates, tag);
          }).join(this.computedJoiner).concat(invalidAndDuplicates.length > 0 ? this.computedJoiner.charAt(0) : '');
        }
      }

      if (parsed.valid.length > 0) {
        // We add the new tags in one atomic operation
        // to trigger reactivity once (instead of once per tag)
        // We do this after we update the new tag input value
        // `concat()` can be faster than array spread, when both args are arrays
        this.tags = (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.concat)(this.tags, parsed.valid);
      }

      this.tagsState = parsed; // Attempt to re-focus the input (specifically for when using the Add
      // button, as the button disappears after successfully adding a tag

      this.focus();
    },
    removeTag: function removeTag(tag) {
      var _this3 = this;

      /* istanbul ignore next */
      if (this.disabled) {
        return;
      } // TODO:
      //   Add `onRemoveTag(tag)` user method, which if returns `false`
      //   will prevent the tag from being removed (i.e. confirmation)
      //   Or emit cancelable `BvEvent`


      this.tags = this.tags.filter(function (t) {
        return t !== tag;
      }); // Return focus to the input (if possible)

      this.$nextTick(function () {
        _this3.focus();
      });
    },
    reset: function reset() {
      var _this4 = this;

      this.newTag = '';
      this.tags = [];
      this.$nextTick(function () {
        _this4.removedTags = [];
        _this4.tagsState = cleanTagsState();
      });
    },
    // --- Input element event handlers ---
    onInputInput: function onInputInput(event) {
      /* istanbul ignore next: hard to test composition events */
      if (this.disabled || (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isEvent)(event) && event.target.composing) {
        // `event.target.composing` is set by Vue (`v-model` directive)
        // https://github.com/vuejs/vue/blob/dev/src/platforms/web/runtime/directives/model.js
        return;
      }

      var newTag = processEventValue(event);
      var separatorRe = this.computedSeparatorRegExp;

      if (this.newTag !== newTag) {
        this.newTag = newTag;
      } // We ignore leading whitespace for the following


      newTag = (0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.trimLeft)(newTag);

      if (separatorRe && separatorRe.test(newTag.slice(-1))) {
        // A trailing separator character was entered, so add the tag(s)
        // Note: More than one tag on input event is possible via copy/paste
        this.addTag();
      } else {
        // Validate (parse tags) on input event
        this.tagsState = newTag === '' ? cleanTagsState() : this.parseTags(newTag);
      }
    },
    onInputChange: function onInputChange(event) {
      // Change is triggered on `<input>` blur, or `<select>` selected
      // This event is opt-in
      if (!this.disabled && this.addOnChange) {
        var newTag = processEventValue(event);
        /* istanbul ignore next */

        if (this.newTag !== newTag) {
          this.newTag = newTag;
        }

        this.addTag();
      }
    },
    onInputKeydown: function onInputKeydown(event) {
      // Early exit

      /* istanbul ignore next */
      if (this.disabled || !(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_5__.isEvent)(event)) {
        return;
      }

      var keyCode = event.keyCode;
      var value = event.target.value || '';
      /* istanbul ignore else: testing to be added later */

      if (!this.noAddOnEnter && keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_ENTER) {
        // Attempt to add the tag when user presses enter
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_19__.stopEvent)(event, {
          propagation: false
        });
        this.addTag();
      } else if (this.removeOnDelete && (keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_BACKSPACE || keyCode === _constants_key_codes__WEBPACK_IMPORTED_MODULE_20__.CODE_DELETE) && value === '') {
        // Remove the last tag if the user pressed backspace/delete and the input is empty
        (0,_utils_events__WEBPACK_IMPORTED_MODULE_19__.stopEvent)(event, {
          propagation: false
        });
        this.tags = this.tags.slice(0, -1);
      }
    },
    // --- Wrapper event handlers ---
    onClick: function onClick(event) {
      var _this5 = this;

      var ignoreFocusSelector = this.computeIgnoreInputFocusSelector;
      var target = event.target;

      if (!this.disabled && !(0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.isActiveElement)(target) && (!ignoreFocusSelector || !(0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.closest)(ignoreFocusSelector, target, true))) {
        this.$nextTick(function () {
          _this5.focus();
        });
      }
    },
    onFocusin: function onFocusin() {
      this.hasFocus = true;
    },
    onFocusout: function onFocusout() {
      this.hasFocus = false;
    },
    handleAutofocus: function handleAutofocus() {
      var _this6 = this;

      this.$nextTick(function () {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.requestAF)(function () {
          if (_this6.autofocus && !_this6.disabled) {
            _this6.focus();
          }
        });
      });
    },
    // --- Public methods ---
    focus: function focus() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.attemptFocus)(this.getInput());
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.attemptBlur)(this.getInput());
      }
    },
    // --- Private methods ---
    splitTags: function splitTags(newTag) {
      // Split the input into an array of raw tags
      newTag = (0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.toString)(newTag);
      var separatorRe = this.computedSeparatorRegExp; // Split the tag(s) via the optional separator
      // Normally only a single tag is provided, but copy/paste
      // can enter multiple tags in a single operation

      return (separatorRe ? newTag.split(separatorRe) : [newTag]).map(_utils_string__WEBPACK_IMPORTED_MODULE_2__.trim).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_15__.identity);
    },
    parseTags: function parseTags(newTag) {
      var _this7 = this;

      // Takes `newTag` value and parses it into `validTags`,
      // `invalidTags`, and duplicate tags as an object
      // Split the input into raw tags
      var tags = this.splitTags(newTag); // Base results

      var parsed = {
        all: tags,
        valid: [],
        invalid: [],
        duplicate: []
      }; // Parse the unique tags

      tags.forEach(function (tag) {
        if ((0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(_this7.tags, tag) || (0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(parsed.valid, tag)) {
          // Unique duplicate tags
          if (!(0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(parsed.duplicate, tag)) {
            parsed.duplicate.push(tag);
          }
        } else if (_this7.validateTag(tag)) {
          // We only add unique/valid tags
          parsed.valid.push(tag);
        } else {
          // Unique invalid tags
          if (!(0,_utils_array__WEBPACK_IMPORTED_MODULE_4__.arrayIncludes)(parsed.invalid, tag)) {
            parsed.invalid.push(tag);
          }
        }
      });
      return parsed;
    },
    validateTag: function validateTag(tag) {
      var tagValidator = this.tagValidator;
      return (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.hasPropFunction)(tagValidator) ? tagValidator(tag) : true;
    },
    getInput: function getInput() {
      // Returns the input element reference (or null if not found)
      // We need to escape `computedInputId` since it can be user-provided
      return (0,_utils_dom__WEBPACK_IMPORTED_MODULE_18__.select)("#".concat((0,_utils_css_escape__WEBPACK_IMPORTED_MODULE_21__.cssEscape)(this.computedInputId)), this.$el);
    },
    // Default User Interface render
    defaultRender: function defaultRender(_ref) {
      var addButtonText = _ref.addButtonText,
          addButtonVariant = _ref.addButtonVariant,
          addTag = _ref.addTag,
          disableAddButton = _ref.disableAddButton,
          disabled = _ref.disabled,
          duplicateTagText = _ref.duplicateTagText,
          inputAttrs = _ref.inputAttrs,
          inputClass = _ref.inputClass,
          inputHandlers = _ref.inputHandlers,
          inputType = _ref.inputType,
          invalidTagText = _ref.invalidTagText,
          isDuplicate = _ref.isDuplicate,
          isInvalid = _ref.isInvalid,
          isLimitReached = _ref.isLimitReached,
          limitTagsText = _ref.limitTagsText,
          noTagRemove = _ref.noTagRemove,
          placeholder = _ref.placeholder,
          removeTag = _ref.removeTag,
          tagClass = _ref.tagClass,
          tagPills = _ref.tagPills,
          tagRemoveLabel = _ref.tagRemoveLabel,
          tagVariant = _ref.tagVariant,
          tags = _ref.tags;
      var h = this.$createElement; // Make the list of tags

      var $tags = tags.map(function (tag) {
        tag = (0,_utils_string__WEBPACK_IMPORTED_MODULE_2__.toString)(tag);
        return h(_form_tag__WEBPACK_IMPORTED_MODULE_22__.BFormTag, {
          class: tagClass,
          // `BFormTag` will auto generate an ID
          // so we do not need to set the ID prop
          props: {
            disabled: disabled,
            noRemove: noTagRemove,
            pill: tagPills,
            removeLabel: tagRemoveLabel,
            tag: 'li',
            title: tag,
            variant: tagVariant
          },
          on: {
            remove: function remove() {
              return removeTag(tag);
            }
          },
          key: "tags_".concat(tag)
        }, tag);
      }); // Feedback IDs if needed

      var invalidFeedbackId = invalidTagText && isInvalid ? this.safeId('__invalid_feedback__') : null;
      var duplicateFeedbackId = duplicateTagText && isDuplicate ? this.safeId('__duplicate_feedback__') : null;
      var limitFeedbackId = limitTagsText && isLimitReached ? this.safeId('__limit_feedback__') : null; // Compute the `aria-describedby` attribute value

      var ariaDescribedby = [inputAttrs['aria-describedby'], invalidFeedbackId, duplicateFeedbackId, limitFeedbackId].filter(_utils_identity__WEBPACK_IMPORTED_MODULE_15__.identity).join(' '); // Input

      var $input = h('input', {
        staticClass: 'b-form-tags-input w-100 flex-grow-1 p-0 m-0 bg-transparent border-0',
        class: inputClass,
        style: {
          outline: 0,
          minWidth: '5rem'
        },
        attrs: _objectSpread(_objectSpread({}, inputAttrs), {}, {
          'aria-describedby': ariaDescribedby || null,
          type: inputType,
          placeholder: placeholder || null
        }),
        domProps: {
          value: inputAttrs.value
        },
        on: inputHandlers,
        // Directive needed to get `event.target.composing` set (if needed)
        directives: [{
          name: 'model',
          value: inputAttrs.value
        }],
        ref: 'input'
      }); // Add button

      var $button = h(_button_button__WEBPACK_IMPORTED_MODULE_23__.BButton, {
        staticClass: 'b-form-tags-button py-0',
        class: {
          // Only show the button if the tag can be added
          // We use the `invisible` class instead of not rendering
          // the button, so that we maintain layout to prevent
          // the user input from jumping around
          invisible: disableAddButton
        },
        style: {
          fontSize: '90%'
        },
        props: {
          disabled: disableAddButton || isLimitReached,
          variant: addButtonVariant
        },
        on: {
          click: function click() {
            return addTag();
          }
        },
        ref: 'button'
      }, [this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_24__.SLOT_NAME_ADD_BUTTON_TEXT) || addButtonText]); // ID of the tags + input `<ul>` list
      // Note we could concatenate `inputAttrs.id` with '__tag_list__'
      // but `inputId` may be `null` until after mount
      // `safeId()` returns `null`, if no user provided ID,
      // until after mount when a unique ID is generated

      var tagListId = this.safeId('__tag_list__');
      var $field = h('li', {
        staticClass: 'b-from-tags-field flex-grow-1',
        attrs: {
          role: 'none',
          'aria-live': 'off',
          'aria-controls': tagListId
        },
        key: 'tags_field'
      }, [h('div', {
        staticClass: 'd-flex',
        attrs: {
          role: 'group'
        }
      }, [$input, $button])]); // Wrap in an unordered list element (we use a list for accessibility)

      var $ul = h('ul', {
        staticClass: 'b-form-tags-list list-unstyled mb-0 d-flex flex-wrap align-items-center',
        attrs: {
          id: tagListId
        },
        key: 'tags_list'
      }, [$tags, $field]); // Assemble the feedback

      var $feedback = h();

      if (invalidTagText || duplicateTagText || limitTagsText) {
        // Add an aria live region for the invalid/duplicate tag
        // messages if the user has not disabled the messages
        var joiner = this.computedJoiner; // Invalid tag feedback if needed (error)

        var $invalid = h();

        if (invalidFeedbackId) {
          $invalid = h(_form_form_invalid_feedback__WEBPACK_IMPORTED_MODULE_25__.BFormInvalidFeedback, {
            props: {
              id: invalidFeedbackId,
              forceShow: true
            },
            key: 'tags_invalid_feedback'
          }, [this.invalidTagText, ': ', this.invalidTags.join(joiner)]);
        } // Duplicate tag feedback if needed (warning, not error)


        var $duplicate = h();

        if (duplicateFeedbackId) {
          $duplicate = h(_form_form_text__WEBPACK_IMPORTED_MODULE_26__.BFormText, {
            props: {
              id: duplicateFeedbackId
            },
            key: 'tags_duplicate_feedback'
          }, [this.duplicateTagText, ': ', this.duplicateTags.join(joiner)]);
        } // Limit tags feedback if needed (warning, not error)


        var $limit = h();

        if (limitFeedbackId) {
          $limit = h(_form_form_text__WEBPACK_IMPORTED_MODULE_26__.BFormText, {
            props: {
              id: limitFeedbackId
            },
            key: 'tags_limit_feedback'
          }, [limitTagsText]);
        }

        $feedback = h('div', {
          attrs: {
            'aria-live': 'polite',
            'aria-atomic': 'true'
          },
          key: 'tags_feedback'
        }, [$invalid, $duplicate, $limit]);
      } // Return the content


      return [$ul, $feedback];
    }
  },
  render: function render(h) {
    var name = this.name,
        disabled = this.disabled,
        required = this.required,
        form = this.form,
        tags = this.tags,
        computedInputId = this.computedInputId,
        hasFocus = this.hasFocus,
        noOuterFocus = this.noOuterFocus; // Scoped slot properties

    var scope = _objectSpread({
      // Array of tags (shallow copy to prevent mutations)
      tags: tags.slice(),
      // <input> v-bind:inputAttrs
      inputAttrs: this.computedInputAttrs,
      // We don't include this in the attrs, as users may want to override this
      inputType: this.computedInputType,
      // <input> v-on:inputHandlers
      inputHandlers: this.computedInputHandlers,
      // Methods
      removeTag: this.removeTag,
      addTag: this.addTag,
      reset: this.reset,
      // <input> :id="inputId"
      inputId: computedInputId,
      // Invalid/Duplicate state information
      isInvalid: this.hasInvalidTags,
      invalidTags: this.invalidTags.slice(),
      isDuplicate: this.hasDuplicateTags,
      duplicateTags: this.duplicateTags.slice(),
      isLimitReached: this.isLimitReached,
      // If the 'Add' button should be disabled
      disableAddButton: this.disableAddButton
    }, (0,_utils_object__WEBPACK_IMPORTED_MODULE_7__.pick)(this.$props, ['addButtonText', 'addButtonVariant', 'disabled', 'duplicateTagText', 'form', 'inputClass', 'invalidTagText', 'limit', 'limitTagsText', 'noTagRemove', 'placeholder', 'required', 'separator', 'size', 'state', 'tagClass', 'tagPills', 'tagRemoveLabel', 'tagVariant'])); // Generate the user interface


    var $content = this.normalizeSlot(_constants_slots__WEBPACK_IMPORTED_MODULE_24__.SLOT_NAME_DEFAULT, scope) || this.defaultRender(scope); // Generate the `aria-live` region for the current value(s)

    var $output = h('output', {
      staticClass: 'sr-only',
      attrs: {
        id: this.safeId('__selected_tags__'),
        role: 'status',
        for: computedInputId,
        'aria-live': hasFocus ? 'polite' : 'off',
        'aria-atomic': 'true',
        'aria-relevant': 'additions text'
      }
    }, this.tags.join(', ')); // Removed tag live region

    var $removed = h('div', {
      staticClass: 'sr-only',
      attrs: {
        id: this.safeId('__removed_tags__'),
        role: 'status',
        'aria-live': hasFocus ? 'assertive' : 'off',
        'aria-atomic': 'true'
      }
    }, this.removedTags.length > 0 ? "(".concat(this.tagRemovedLabel, ") ").concat(this.removedTags.join(', ')) : ''); // Add hidden inputs for form submission

    var $hidden = h();

    if (name && !disabled) {
      // We add hidden inputs for each tag if a name is provided
      // When there are currently no tags, a visually hidden input
      // with empty value is rendered for proper required handling
      var hasTags = tags.length > 0;
      $hidden = (hasTags ? tags : ['']).map(function (tag) {
        return h('input', {
          class: {
            'sr-only': !hasTags
          },
          attrs: {
            type: hasTags ? 'hidden' : 'text',
            value: tag,
            required: required,
            name: name,
            form: form
          },
          key: "tag_input_".concat(tag)
        });
      });
    } // Return the rendered output


    return h('div', {
      staticClass: 'b-form-tags form-control h-auto',
      class: [{
        focus: hasFocus && !noOuterFocus && !disabled,
        disabled: disabled
      }, this.sizeFormClass, this.stateClass],
      attrs: {
        id: this.safeId(),
        role: 'group',
        tabindex: disabled || noOuterFocus ? null : '-1',
        'aria-describedby': this.safeId('__selected_tags__')
      },
      on: {
        click: this.onClick,
        focusin: this.onFocusin,
        focusout: this.onFocusout
      }
    }, [$output, $removed, $content, $hidden]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-tags/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-tags/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormTag": () => (/* reexport safe */ _form_tag__WEBPACK_IMPORTED_MODULE_2__.BFormTag),
/* harmony export */   "BFormTags": () => (/* reexport safe */ _form_tags__WEBPACK_IMPORTED_MODULE_1__.BFormTags),
/* harmony export */   "FormTagsPlugin": () => (/* binding */ FormTagsPlugin)
/* harmony export */ });
/* harmony import */ var _form_tags__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-tags */ "./node_modules/bootstrap-vue/esm/components/form-tags/form-tags.js");
/* harmony import */ var _form_tag__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./form-tag */ "./node_modules/bootstrap-vue/esm/components/form-tags/form-tag.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var FormTagsPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormTags: _form_tags__WEBPACK_IMPORTED_MODULE_1__.BFormTags,
    BTags: _form_tags__WEBPACK_IMPORTED_MODULE_1__.BFormTags,
    BFormTag: _form_tag__WEBPACK_IMPORTED_MODULE_2__.BFormTag,
    BTag: _form_tag__WEBPACK_IMPORTED_MODULE_2__.BFormTag
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-textarea/form-textarea.js":
/*!**********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-textarea/form-textarea.js ***!
  \**********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormTextarea": () => (/* binding */ BFormTextarea),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_math__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../utils/math */ "./node_modules/bootstrap-vue/esm/utils/math.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../mixins/form-control */ "./node_modules/bootstrap-vue/esm/mixins/form-control.js");
/* harmony import */ var _mixins_form_selection__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../mixins/form-selection */ "./node_modules/bootstrap-vue/esm/mixins/form-selection.js");
/* harmony import */ var _mixins_form_size__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../mixins/form-size */ "./node_modules/bootstrap-vue/esm/mixins/form-size.js");
/* harmony import */ var _mixins_form_state__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../mixins/form-state */ "./node_modules/bootstrap-vue/esm/mixins/form-state.js");
/* harmony import */ var _mixins_form_text__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/form-text */ "./node_modules/bootstrap-vue/esm/mixins/form-text.js");
/* harmony import */ var _mixins_form_validity__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../mixins/form-validity */ "./node_modules/bootstrap-vue/esm/mixins/form-validity.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _mixins_listen_on_root__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../mixins/listen-on-root */ "./node_modules/bootstrap-vue/esm/mixins/listen-on-root.js");
/* harmony import */ var _mixins_listeners__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../mixins/listeners */ "./node_modules/bootstrap-vue/esm/mixins/listeners.js");
/* harmony import */ var _directives_visible_visible__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../directives/visible/visible */ "./node_modules/bootstrap-vue/esm/directives/visible/visible.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }



















 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.props), _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__.props), _mixins_form_size__WEBPACK_IMPORTED_MODULE_4__.props), _mixins_form_state__WEBPACK_IMPORTED_MODULE_5__.props), _mixins_form_text__WEBPACK_IMPORTED_MODULE_6__.props), {}, {
  maxRows: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING),
  // When in auto resize mode, disable shrinking to content height
  noAutoShrink: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, false),
  // Disable the resize handle of textarea
  noResize: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, false),
  rows: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING, 2),
  // 'soft', 'hard' or 'off'
  // Browser default is 'soft'
  wrap: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING, 'soft')
})), _constants_components__WEBPACK_IMPORTED_MODULE_8__.NAME_FORM_TEXTAREA); // --- Main component ---
// @vue/component

var BFormTextarea = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_9__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_8__.NAME_FORM_TEXTAREA,
  directives: {
    'b-visible': _directives_visible_visible__WEBPACK_IMPORTED_MODULE_10__.VBVisible
  },
  // Mixin order is important!
  mixins: [_mixins_listeners__WEBPACK_IMPORTED_MODULE_11__.listenersMixin, _mixins_id__WEBPACK_IMPORTED_MODULE_2__.idMixin, _mixins_listen_on_root__WEBPACK_IMPORTED_MODULE_12__.listenOnRootMixin, _mixins_form_control__WEBPACK_IMPORTED_MODULE_3__.formControlMixin, _mixins_form_size__WEBPACK_IMPORTED_MODULE_4__.formSizeMixin, _mixins_form_state__WEBPACK_IMPORTED_MODULE_5__.formStateMixin, _mixins_form_text__WEBPACK_IMPORTED_MODULE_6__.formTextMixin, _mixins_form_selection__WEBPACK_IMPORTED_MODULE_13__.formSelectionMixin, _mixins_form_validity__WEBPACK_IMPORTED_MODULE_14__.formValidityMixin],
  props: props,
  data: function data() {
    return {
      heightInPx: null
    };
  },
  computed: {
    computedStyle: function computedStyle() {
      var styles = {
        // Setting `noResize` to true will disable the ability for the user to
        // manually resize the textarea. We also disable when in auto height mode
        resize: !this.computedRows || this.noResize ? 'none' : null
      };

      if (!this.computedRows) {
        // Conditionally set the computed CSS height when auto rows/height is enabled
        // We avoid setting the style to `null`, which can override user manual resize handle
        styles.height = this.heightInPx; // We always add a vertical scrollbar to the textarea when auto-height is
        // enabled so that the computed height calculation returns a stable value

        styles.overflowY = 'scroll';
      }

      return styles;
    },
    computedMinRows: function computedMinRows() {
      // Ensure rows is at least 2 and positive (2 is the native textarea value)
      // A value of 1 can cause issues in some browsers, and most browsers
      // only support 2 as the smallest value
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_15__.mathMax)((0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toInteger)(this.rows, 2), 2);
    },
    computedMaxRows: function computedMaxRows() {
      return (0,_utils_math__WEBPACK_IMPORTED_MODULE_15__.mathMax)(this.computedMinRows, (0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toInteger)(this.maxRows, 0));
    },
    computedRows: function computedRows() {
      // This is used to set the attribute 'rows' on the textarea
      // If auto-height is enabled, then we return `null` as we use CSS to control height
      return this.computedMinRows === this.computedMaxRows ? this.computedMinRows : null;
    },
    computedAttrs: function computedAttrs() {
      var disabled = this.disabled,
          required = this.required;
      return {
        id: this.safeId(),
        name: this.name || null,
        form: this.form || null,
        disabled: disabled,
        placeholder: this.placeholder || null,
        required: required,
        autocomplete: this.autocomplete || null,
        readonly: this.readonly || this.plaintext,
        rows: this.computedRows,
        wrap: this.wrap || null,
        'aria-required': this.required ? 'true' : null,
        'aria-invalid': this.computedAriaInvalid
      };
    },
    computedListeners: function computedListeners() {
      return _objectSpread(_objectSpread({}, this.bvListeners), {}, {
        input: this.onInput,
        change: this.onChange,
        blur: this.onBlur
      });
    }
  },
  watch: {
    localValue: function localValue() {
      this.setHeight();
    }
  },
  mounted: function mounted() {
    this.setHeight();
  },
  methods: {
    // Called by intersection observer directive

    /* istanbul ignore next */
    visibleCallback: function visibleCallback(visible) {
      if (visible) {
        // We use a `$nextTick()` here just to make sure any
        // transitions or portalling have completed
        this.$nextTick(this.setHeight);
      }
    },
    setHeight: function setHeight() {
      var _this = this;

      this.$nextTick(function () {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_17__.requestAF)(function () {
          _this.heightInPx = _this.computeHeight();
        });
      });
    },

    /* istanbul ignore next: can't test getComputedStyle in JSDOM */
    computeHeight: function computeHeight() {
      if (this.$isServer || !(0,_utils_inspect__WEBPACK_IMPORTED_MODULE_18__.isNull)(this.computedRows)) {
        return null;
      }

      var el = this.$el; // Element must be visible (not hidden) and in document
      // Must be checked after above checks

      if (!(0,_utils_dom__WEBPACK_IMPORTED_MODULE_17__.isVisible)(el)) {
        return null;
      } // Get current computed styles


      var computedStyle = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_17__.getCS)(el); // Height of one line of text in px

      var lineHeight = (0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toFloat)(computedStyle.lineHeight, 1); // Calculate height of border and padding

      var border = (0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toFloat)(computedStyle.borderTopWidth, 0) + (0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toFloat)(computedStyle.borderBottomWidth, 0);
      var padding = (0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toFloat)(computedStyle.paddingTop, 0) + (0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toFloat)(computedStyle.paddingBottom, 0); // Calculate offset

      var offset = border + padding; // Minimum height for min rows (which must be 2 rows or greater for cross-browser support)

      var minHeight = lineHeight * this.computedMinRows + offset; // Get the current style height (with `px` units)

      var oldHeight = (0,_utils_dom__WEBPACK_IMPORTED_MODULE_17__.getStyle)(el, 'height') || computedStyle.height; // Probe scrollHeight by temporarily changing the height to `auto`

      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_17__.setStyle)(el, 'height', 'auto');
      var scrollHeight = el.scrollHeight; // Place the original old height back on the element, just in case `computedProp`
      // returns the same value as before

      (0,_utils_dom__WEBPACK_IMPORTED_MODULE_17__.setStyle)(el, 'height', oldHeight); // Calculate content height in 'rows' (scrollHeight includes padding but not border)

      var contentRows = (0,_utils_math__WEBPACK_IMPORTED_MODULE_15__.mathMax)((scrollHeight - padding) / lineHeight, 2); // Calculate number of rows to display (limited within min/max rows)

      var rows = (0,_utils_math__WEBPACK_IMPORTED_MODULE_15__.mathMin)((0,_utils_math__WEBPACK_IMPORTED_MODULE_15__.mathMax)(contentRows, this.computedMinRows), this.computedMaxRows); // Calculate the required height of the textarea including border and padding (in pixels)

      var height = (0,_utils_math__WEBPACK_IMPORTED_MODULE_15__.mathMax)((0,_utils_math__WEBPACK_IMPORTED_MODULE_15__.mathCeil)(rows * lineHeight + offset), minHeight); // Computed height remains the larger of `oldHeight` and new `height`,
      // when height is in `sticky` mode (prop `no-auto-shrink` is true)

      if (this.noAutoShrink && (0,_utils_number__WEBPACK_IMPORTED_MODULE_16__.toFloat)(oldHeight, 0) > height) {
        return oldHeight;
      } // Return the new computed CSS height in px units


      return "".concat(height, "px");
    }
  },
  render: function render(h) {
    return h('textarea', {
      class: this.computedClass,
      style: this.computedStyle,
      directives: [{
        name: 'b-visible',
        value: this.visibleCallback,
        // If textarea is within 640px of viewport, consider it visible
        modifiers: {
          '640': true
        }
      }],
      attrs: this.computedAttrs,
      domProps: {
        value: this.localValue
      },
      on: this.computedListeners,
      ref: 'input'
    });
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-textarea/index.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-textarea/index.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormTextarea": () => (/* reexport safe */ _form_textarea__WEBPACK_IMPORTED_MODULE_1__.BFormTextarea),
/* harmony export */   "FormTextareaPlugin": () => (/* binding */ FormTextareaPlugin)
/* harmony export */ });
/* harmony import */ var _form_textarea__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-textarea */ "./node_modules/bootstrap-vue/esm/components/form-textarea/form-textarea.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormTextareaPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormTextarea: _form_textarea__WEBPACK_IMPORTED_MODULE_1__.BFormTextarea,
    BTextarea: _form_textarea__WEBPACK_IMPORTED_MODULE_1__.BFormTextarea
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-timepicker/form-timepicker.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-timepicker/form-timepicker.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormTimepicker": () => (/* binding */ BFormTimepicker),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/model */ "./node_modules/bootstrap-vue/esm/utils/model.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_id__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/id */ "./node_modules/bootstrap-vue/esm/mixins/id.js");
/* harmony import */ var _icons_icons__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../icons/icons */ "./node_modules/bootstrap-vue/esm/icons/icons.js");
/* harmony import */ var _button_button__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../button/button */ "./node_modules/bootstrap-vue/esm/components/button/button.js");
/* harmony import */ var _form_btn_label_control_bv_form_btn_label_control__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../form-btn-label-control/bv-form-btn-label-control */ "./node_modules/bootstrap-vue/esm/components/form-btn-label-control/bv-form-btn-label-control.js");
/* harmony import */ var _time_time__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../time/time */ "./node_modules/bootstrap-vue/esm/components/time/time.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }















 // --- Constants ---

var _makeModelMixin = (0,_utils_model__WEBPACK_IMPORTED_MODULE_0__.makeModelMixin)('value', {
  type: _constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING,
  defaultValue: ''
}),
    modelMixin = _makeModelMixin.mixin,
    modelProps = _makeModelMixin.props,
    MODEL_PROP_NAME = _makeModelMixin.prop,
    MODEL_EVENT_NAME = _makeModelMixin.event; // --- Props ---


var timeProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.omit)(_time_time__WEBPACK_IMPORTED_MODULE_3__.props, ['hidden', 'id', 'value']);
var formBtnLabelControlProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.omit)(_form_btn_label_control_bv_form_btn_label_control__WEBPACK_IMPORTED_MODULE_4__.props, ['formattedValue', 'id', 'lang', 'rtl', 'value']);
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_2__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, _mixins_id__WEBPACK_IMPORTED_MODULE_6__.props), modelProps), timeProps), formBtnLabelControlProps), {}, {
  closeButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'outline-secondary'),
  labelCloseButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Close'),
  labelNowButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Select now'),
  labelResetButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'Reset'),
  noCloseButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  nowButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  nowButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'outline-primary'),
  resetButton: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  resetButtonVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'outline-danger'),
  resetValue: (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_DATE_STRING)
})), _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_FORM_TIMEPICKER); // --- Main component ---
// @vue/component

var BFormTimepicker = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_8__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_7__.NAME_FORM_TIMEPICKER,
  mixins: [_mixins_id__WEBPACK_IMPORTED_MODULE_6__.idMixin, modelMixin],
  props: props,
  data: function data() {
    return {
      // We always use `HH:mm:ss` value internally
      localHMS: this[MODEL_PROP_NAME] || '',
      // Context data from BTime
      localLocale: null,
      isRTL: false,
      formattedValue: '',
      // If the menu is opened
      isVisible: false
    };
  },
  computed: {
    computedLang: function computedLang() {
      return (this.localLocale || '').replace(/-u-.*$/i, '') || null;
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME, function (newValue) {
    this.localHMS = newValue || '';
  }), _defineProperty(_watch, "localHMS", function localHMS(newValue) {
    // We only update the v-model value when the timepicker
    // is open, to prevent cursor jumps when bound to a
    // text input in button only mode
    if (this.isVisible) {
      this.$emit(MODEL_EVENT_NAME, newValue || '');
    }
  }), _watch),
  methods: {
    // Public methods
    focus: function focus() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_9__.attemptFocus)(this.$refs.control);
      }
    },
    blur: function blur() {
      if (!this.disabled) {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_9__.attemptBlur)(this.$refs.control);
      }
    },
    // Private methods
    setAndClose: function setAndClose(value) {
      var _this = this;

      this.localHMS = value;
      this.$nextTick(function () {
        _this.$refs.control.hide(true);
      });
    },
    onInput: function onInput(hms) {
      if (this.localHMS !== hms) {
        this.localHMS = hms;
      }
    },
    onContext: function onContext(ctx) {
      var isRTL = ctx.isRTL,
          locale = ctx.locale,
          value = ctx.value,
          formatted = ctx.formatted;
      this.isRTL = isRTL;
      this.localLocale = locale;
      this.formattedValue = formatted;
      this.localHMS = value || ''; // Re-emit the context event

      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_CONTEXT, ctx);
    },
    onNowButton: function onNowButton() {
      var now = new Date();
      var hours = now.getHours();
      var minutes = now.getMinutes();
      var seconds = this.showSeconds ? now.getSeconds() : 0;
      var value = [hours, minutes, seconds].map(function (v) {
        return "00".concat(v || '').slice(-2);
      }).join(':');
      this.setAndClose(value);
    },
    onResetButton: function onResetButton() {
      this.setAndClose(this.resetValue);
    },
    onCloseButton: function onCloseButton() {
      this.$refs.control.hide(true);
    },
    onShow: function onShow() {
      this.isVisible = true;
    },
    onShown: function onShown() {
      var _this2 = this;

      this.$nextTick(function () {
        (0,_utils_dom__WEBPACK_IMPORTED_MODULE_9__.attemptFocus)(_this2.$refs.time);

        _this2.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_SHOWN);
      });
    },
    onHidden: function onHidden() {
      this.isVisible = false;
      this.$emit(_constants_events__WEBPACK_IMPORTED_MODULE_10__.EVENT_NAME_HIDDEN);
    },
    // Render function helpers
    defaultButtonFn: function defaultButtonFn(_ref) {
      var isHovered = _ref.isHovered,
          hasFocus = _ref.hasFocus;
      return this.$createElement(isHovered || hasFocus ? _icons_icons__WEBPACK_IMPORTED_MODULE_11__.BIconClockFill : _icons_icons__WEBPACK_IMPORTED_MODULE_11__.BIconClock, {
        attrs: {
          'aria-hidden': 'true'
        }
      });
    }
  },
  render: function render(h) {
    var localHMS = this.localHMS,
        disabled = this.disabled,
        readonly = this.readonly,
        $props = this.$props;
    var placeholder = (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_12__.isUndefinedOrNull)(this.placeholder) ? this.labelNoTimeSelected : this.placeholder; // Footer buttons

    var $footer = [];

    if (this.nowButton) {
      var label = this.labelNowButton;
      $footer.push(h(_button_button__WEBPACK_IMPORTED_MODULE_13__.BButton, {
        props: {
          size: 'sm',
          disabled: disabled || readonly,
          variant: this.nowButtonVariant
        },
        attrs: {
          'aria-label': label || null
        },
        on: {
          click: this.onNowButton
        },
        key: 'now-btn'
      }, label));
    }

    if (this.resetButton) {
      if ($footer.length > 0) {
        // Add a "spacer" between buttons ('&nbsp;')
        $footer.push(h('span', "\xA0"));
      }

      var _label = this.labelResetButton;
      $footer.push(h(_button_button__WEBPACK_IMPORTED_MODULE_13__.BButton, {
        props: {
          size: 'sm',
          disabled: disabled || readonly,
          variant: this.resetButtonVariant
        },
        attrs: {
          'aria-label': _label || null
        },
        on: {
          click: this.onResetButton
        },
        key: 'reset-btn'
      }, _label));
    }

    if (!this.noCloseButton) {
      // Add a "spacer" between buttons ('&nbsp;')
      if ($footer.length > 0) {
        $footer.push(h('span', "\xA0"));
      }

      var _label2 = this.labelCloseButton;
      $footer.push(h(_button_button__WEBPACK_IMPORTED_MODULE_13__.BButton, {
        props: {
          size: 'sm',
          disabled: disabled,
          variant: this.closeButtonVariant
        },
        attrs: {
          'aria-label': _label2 || null
        },
        on: {
          click: this.onCloseButton
        },
        key: 'close-btn'
      }, _label2));
    }

    if ($footer.length > 0) {
      $footer = [h('div', {
        staticClass: 'b-form-date-controls d-flex flex-wrap',
        class: {
          'justify-content-between': $footer.length > 1,
          'justify-content-end': $footer.length < 2
        }
      }, $footer)];
    }

    var $time = h(_time_time__WEBPACK_IMPORTED_MODULE_3__.BTime, {
      staticClass: 'b-form-time-control',
      props: _objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.pluckProps)(timeProps, $props)), {}, {
        value: localHMS,
        hidden: !this.isVisible
      }),
      on: {
        input: this.onInput,
        context: this.onContext
      },
      ref: 'time'
    }, $footer);
    return h(_form_btn_label_control_bv_form_btn_label_control__WEBPACK_IMPORTED_MODULE_4__.BVFormBtnLabelControl, {
      staticClass: 'b-form-timepicker',
      props: _objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_5__.pluckProps)(formBtnLabelControlProps, $props)), {}, {
        id: this.safeId(),
        value: localHMS,
        formattedValue: localHMS ? this.formattedValue : '',
        placeholder: placeholder,
        rtl: this.isRTL,
        lang: this.computedLang
      }),
      on: {
        show: this.onShow,
        shown: this.onShown,
        hidden: this.onHidden
      },
      scopedSlots: _defineProperty({}, _constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_BUTTON_CONTENT, this.$scopedSlots[_constants_slots__WEBPACK_IMPORTED_MODULE_14__.SLOT_NAME_BUTTON_CONTENT] || this.defaultButtonFn),
      ref: 'control'
    }, [$time]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form-timepicker/index.js":
/*!****************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form-timepicker/index.js ***!
  \****************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormTimepicker": () => (/* reexport safe */ _form_timepicker__WEBPACK_IMPORTED_MODULE_1__.BFormTimepicker),
/* harmony export */   "FormTimepickerPlugin": () => (/* binding */ FormTimepickerPlugin)
/* harmony export */ });
/* harmony import */ var _form_timepicker__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form-timepicker */ "./node_modules/bootstrap-vue/esm/components/form-timepicker/form-timepicker.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var FormTimepickerPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BFormTimepicker: _form_timepicker__WEBPACK_IMPORTED_MODULE_1__.BFormTimepicker,
    BTimepicker: _form_timepicker__WEBPACK_IMPORTED_MODULE_1__.BFormTimepicker
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form/form-datalist.js":
/*!*************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form/form-datalist.js ***!
  \*************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormDatalist": () => (/* binding */ BFormDatalist),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _mixins_form_options__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../mixins/form-options */ "./node_modules/bootstrap-vue/esm/mixins/form-options.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }








 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.sortKeys)(_objectSpread(_objectSpread({}, _mixins_form_options__WEBPACK_IMPORTED_MODULE_2__.props), {}, {
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, undefined, true) // Required

})), _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_DATALIST); // --- Main component ---
// @vue/component

var BFormDatalist = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_5__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_4__.NAME_FORM_DATALIST,
  mixins: [_mixins_form_options__WEBPACK_IMPORTED_MODULE_2__.formOptionsMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_6__.normalizeSlotMixin],
  props: props,
  render: function render(h) {
    var id = this.id;
    var $options = this.formOptions.map(function (option, index) {
      var value = option.value,
          text = option.text,
          html = option.html,
          disabled = option.disabled;
      return h('option', {
        attrs: {
          value: value,
          disabled: disabled
        },
        domProps: (0,_utils_html__WEBPACK_IMPORTED_MODULE_7__.htmlOrText)(html, text),
        key: "option_".concat(index)
      });
    });
    return h('datalist', {
      attrs: {
        id: id
      }
    }, [$options, this.normalizeSlot()]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form/form-invalid-feedback.js":
/*!*********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form/form-invalid-feedback.js ***!
  \*********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormInvalidFeedback": () => (/* binding */ BFormInvalidFeedback),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  ariaLive: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  forceShow: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  role: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  // Tri-state prop: `true`, `false`, or `null`
  state: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, null),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div'),
  tooltip: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_INVALID_FEEDBACK); // --- Main component ---
// @vue/component

var BFormInvalidFeedback = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_INVALID_FEEDBACK,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var tooltip = props.tooltip,
        ariaLive = props.ariaLive;
    var show = props.forceShow === true || props.state === false;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      class: {
        'd-block': show,
        'invalid-feedback': !tooltip,
        'invalid-tooltip': tooltip
      },
      attrs: {
        id: props.id || null,
        role: props.role || null,
        'aria-live': ariaLive || null,
        'aria-atomic': ariaLive ? 'true' : null
      }
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form/form-text.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form/form-text.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormText": () => (/* binding */ BFormText),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  inline: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'small'),
  textVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'muted')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_TEXT); // --- Main component ---
// @vue/component

var BFormText = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_TEXT,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      class: _defineProperty({
        'form-text': !props.inline
      }, "text-".concat(props.textVariant), props.textVariant),
      attrs: {
        id: props.id
      }
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form/form-valid-feedback.js":
/*!*******************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form/form-valid-feedback.js ***!
  \*******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormValidFeedback": () => (/* binding */ BFormValidFeedback),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  ariaLive: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  forceShow: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  role: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  // Tri-state prop: `true`, `false`, or `null`
  state: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, null),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div'),
  tooltip: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_VALID_FEEDBACK); // --- Main component ---
// @vue/component

var BFormValidFeedback = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_VALID_FEEDBACK,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var tooltip = props.tooltip,
        ariaLive = props.ariaLive;
    var show = props.forceShow === true || props.state === true;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      class: {
        'd-block': show,
        'valid-feedback': !tooltip,
        'valid-tooltip': tooltip
      },
      attrs: {
        id: props.id || null,
        role: props.role || null,
        'aria-live': ariaLive || null,
        'aria-atomic': ariaLive ? 'true' : null
      }
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form/form.js":
/*!****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form/form.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BForm": () => (/* binding */ BForm),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  inline: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  novalidate: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  validated: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM); // --- Main component ---
// @vue/component

var BForm = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h('form', (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      class: {
        'form-inline': props.inline,
        'was-validated': props.validated
      },
      attrs: {
        id: props.id,
        novalidate: props.novalidate
      }
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/form/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/form/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BForm": () => (/* reexport safe */ _form__WEBPACK_IMPORTED_MODULE_1__.BForm),
/* harmony export */   "BFormDatalist": () => (/* reexport safe */ _form_datalist__WEBPACK_IMPORTED_MODULE_2__.BFormDatalist),
/* harmony export */   "BFormInvalidFeedback": () => (/* reexport safe */ _form_invalid_feedback__WEBPACK_IMPORTED_MODULE_4__.BFormInvalidFeedback),
/* harmony export */   "BFormText": () => (/* reexport safe */ _form_text__WEBPACK_IMPORTED_MODULE_3__.BFormText),
/* harmony export */   "BFormValidFeedback": () => (/* reexport safe */ _form_valid_feedback__WEBPACK_IMPORTED_MODULE_5__.BFormValidFeedback),
/* harmony export */   "FormPlugin": () => (/* binding */ FormPlugin)
/* harmony export */ });
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./form */ "./node_modules/bootstrap-vue/esm/components/form/form.js");
/* harmony import */ var _form_datalist__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./form-datalist */ "./node_modules/bootstrap-vue/esm/components/form/form-datalist.js");
/* harmony import */ var _form_text__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./form-text */ "./node_modules/bootstrap-vue/esm/components/form/form-text.js");
/* harmony import */ var _form_invalid_feedback__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./form-invalid-feedback */ "./node_modules/bootstrap-vue/esm/components/form/form-invalid-feedback.js");
/* harmony import */ var _form_valid_feedback__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./form-valid-feedback */ "./node_modules/bootstrap-vue/esm/components/form/form-valid-feedback.js");
/* harmony import */ var _layout_form_row__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../layout/form-row */ "./node_modules/bootstrap-vue/esm/components/layout/form-row.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");







var FormPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BForm: _form__WEBPACK_IMPORTED_MODULE_1__.BForm,
    BFormDatalist: _form_datalist__WEBPACK_IMPORTED_MODULE_2__.BFormDatalist,
    BDatalist: _form_datalist__WEBPACK_IMPORTED_MODULE_2__.BFormDatalist,
    BFormText: _form_text__WEBPACK_IMPORTED_MODULE_3__.BFormText,
    BFormInvalidFeedback: _form_invalid_feedback__WEBPACK_IMPORTED_MODULE_4__.BFormInvalidFeedback,
    BFormFeedback: _form_invalid_feedback__WEBPACK_IMPORTED_MODULE_4__.BFormInvalidFeedback,
    BFormValidFeedback: _form_valid_feedback__WEBPACK_IMPORTED_MODULE_5__.BFormValidFeedback,
    // Added here for convenience
    BFormRow: _layout_form_row__WEBPACK_IMPORTED_MODULE_6__.BFormRow
  }
}); // BFormRow is not exported here as a named export, as it is exported by Layout



/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/image/img-lazy.js":
/*!*********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/image/img-lazy.js ***!
  \*********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BImgLazy": () => (/* binding */ BImgLazy),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_env__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/env */ "./node_modules/bootstrap-vue/esm/constants/env.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _directives_visible_visible__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../directives/visible/visible */ "./node_modules/bootstrap-vue/esm/directives/visible/visible.js");
/* harmony import */ var _img__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./img */ "./node_modules/bootstrap-vue/esm/components/image/img.js");
var _watch;

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }












 // --- Constants ---

var MODEL_PROP_NAME_SHOW = 'show';
var MODEL_EVENT_NAME_SHOW = _constants_events__WEBPACK_IMPORTED_MODULE_0__.MODEL_EVENT_NAME_PREFIX + MODEL_PROP_NAME_SHOW; // --- Props ---

var imgProps = (0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(_img__WEBPACK_IMPORTED_MODULE_2__.props, ['blank']);
var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makePropsConfigurable)(_objectSpread(_objectSpread({}, imgProps), {}, _defineProperty({
  blankColor: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING, 'transparent'),
  blankHeight: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_NUMBER_STRING),
  // If `null`, a blank image is generated
  blankSrc: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_STRING, null),
  blankWidth: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_NUMBER_STRING),
  // Distance away from viewport (in pixels)
  // before being considered "visible"
  offset: (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_NUMBER_STRING, 360)
}, MODEL_PROP_NAME_SHOW, (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_4__.PROP_TYPE_BOOLEAN, false))), _constants_components__WEBPACK_IMPORTED_MODULE_5__.NAME_IMG_LAZY); // --- Main component ---
// @vue/component

var BImgLazy = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_6__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_5__.NAME_IMG_LAZY,
  directives: {
    'b-visible': _directives_visible_visible__WEBPACK_IMPORTED_MODULE_7__.VBVisible
  },
  props: props,
  data: function data() {
    return {
      isShown: this[MODEL_PROP_NAME_SHOW]
    };
  },
  computed: {
    computedSrc: function computedSrc() {
      var blankSrc = this.blankSrc;
      return !blankSrc || this.isShown ? this.src : blankSrc;
    },
    computedBlank: function computedBlank() {
      return !(this.isShown || this.blankSrc);
    },
    computedWidth: function computedWidth() {
      var width = this.width;
      return this.isShown ? width : this.blankWidth || width;
    },
    computedHeight: function computedHeight() {
      var height = this.height;
      return this.isShown ? height : this.blankHeight || height;
    },
    computedSrcset: function computedSrcset() {
      var srcset = (0,_utils_array__WEBPACK_IMPORTED_MODULE_8__.concat)(this.srcset).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_9__.identity).join(',');
      return !this.blankSrc || this.isShown ? srcset : null;
    },
    computedSizes: function computedSizes() {
      var sizes = (0,_utils_array__WEBPACK_IMPORTED_MODULE_8__.concat)(this.sizes).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_9__.identity).join(',');
      return !this.blankSrc || this.isShown ? sizes : null;
    }
  },
  watch: (_watch = {}, _defineProperty(_watch, MODEL_PROP_NAME_SHOW, function (newValue, oldValue) {
    if (newValue !== oldValue) {
      // If `IntersectionObserver` support is not available, image is always shown
      var visible = _constants_env__WEBPACK_IMPORTED_MODULE_10__.HAS_INTERACTION_OBSERVER_SUPPORT ? newValue : true;
      this.isShown = visible; // Ensure the show prop is synced (when no `IntersectionObserver`)

      if (visible !== newValue) {
        this.$nextTick(this.updateShowProp);
      }
    }
  }), _defineProperty(_watch, "isShown", function isShown(newValue, oldValue) {
    // Update synched show prop
    if (newValue !== oldValue) {
      this.updateShowProp();
    }
  }), _watch),
  mounted: function mounted() {
    // If `IntersectionObserver` is not available, image is always shown
    this.isShown = _constants_env__WEBPACK_IMPORTED_MODULE_10__.HAS_INTERACTION_OBSERVER_SUPPORT ? this[MODEL_PROP_NAME_SHOW] : true;
  },
  methods: {
    updateShowProp: function updateShowProp() {
      this.$emit(MODEL_EVENT_NAME_SHOW, this.isShown);
    },
    doShow: function doShow(visible) {
      // If IntersectionObserver is not supported, the callback
      // will be called with `null` rather than `true` or `false`
      if ((visible || visible === null) && !this.isShown) {
        this.isShown = true;
      }
    }
  },
  render: function render(h) {
    var directives = [];

    if (!this.isShown) {
      var _modifiers;

      // We only add the visible directive if we are not shown
      directives.push({
        // Visible directive will silently do nothing if
        // IntersectionObserver is not supported
        name: 'b-visible',
        // Value expects a callback (passed one arg of `visible` = `true` or `false`)
        value: this.doShow,
        modifiers: (_modifiers = {}, _defineProperty(_modifiers, "".concat((0,_utils_number__WEBPACK_IMPORTED_MODULE_11__.toInteger)(this.offset, 0)), true), _defineProperty(_modifiers, "once", true), _modifiers)
      });
    }

    return h(_img__WEBPACK_IMPORTED_MODULE_2__.BImg, {
      directives: directives,
      props: _objectSpread({
        // Computed value props
        src: this.computedSrc,
        blank: this.computedBlank,
        width: this.computedWidth,
        height: this.computedHeight,
        srcset: this.computedSrcset || null,
        sizes: this.computedSizes || null
      }, (0,_utils_props__WEBPACK_IMPORTED_MODULE_3__.pluckProps)(imgProps, this.$props))
    });
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/image/img.js":
/*!****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/image/img.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BImg": () => (/* binding */ BImg),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_number__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/number */ "./node_modules/bootstrap-vue/esm/utils/number.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }









 // --- Constants --
// Blank image with fill template

var BLANK_TEMPLATE = '<svg width="%{w}" height="%{h}" ' + 'xmlns="http://www.w3.org/2000/svg" ' + 'viewBox="0 0 %{w} %{h}" preserveAspectRatio="none">' + '<rect width="100%" height="100%" style="fill:%{f};"></rect>' + '</svg>'; // --- Helper methods ---

var makeBlankImgSrc = function makeBlankImgSrc(width, height, color) {
  var src = encodeURIComponent(BLANK_TEMPLATE.replace('%{w}', (0,_utils_string__WEBPACK_IMPORTED_MODULE_0__.toString)(width)).replace('%{h}', (0,_utils_string__WEBPACK_IMPORTED_MODULE_0__.toString)(height)).replace('%{f}', color));
  return "data:image/svg+xml;charset=UTF-8,".concat(src);
}; // --- Props ---


var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makePropsConfigurable)({
  alt: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_STRING),
  blank: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  blankColor: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_STRING, 'transparent'),
  block: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  center: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  fluid: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  // Gives fluid images class `w-100` to make them grow to fit container
  fluidGrow: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  height: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_NUMBER_STRING),
  left: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  right: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  // Possible values:
  //   `false`: no rounding of corners
  //   `true`: slightly rounded corners
  //   'top': top corners rounded
  //   'right': right corners rounded
  //   'bottom': bottom corners rounded
  //   'left': left corners rounded
  //   'circle': circle/oval
  //   '0': force rounding off
  rounded: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN_STRING, false),
  sizes: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_ARRAY_STRING),
  src: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_STRING),
  srcset: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_ARRAY_STRING),
  thumbnail: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_BOOLEAN, false),
  width: (0,_utils_props__WEBPACK_IMPORTED_MODULE_1__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_2__.PROP_TYPE_NUMBER_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_IMG); // --- Main component ---
// @vue/component

var BImg = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_4__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_IMG,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var _class;

    var props = _ref.props,
        data = _ref.data;
    var alt = props.alt,
        src = props.src,
        block = props.block,
        fluidGrow = props.fluidGrow,
        rounded = props.rounded;
    var width = (0,_utils_number__WEBPACK_IMPORTED_MODULE_5__.toInteger)(props.width) || null;
    var height = (0,_utils_number__WEBPACK_IMPORTED_MODULE_5__.toInteger)(props.height) || null;
    var align = null;
    var srcset = (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.concat)(props.srcset).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_7__.identity).join(',');
    var sizes = (0,_utils_array__WEBPACK_IMPORTED_MODULE_6__.concat)(props.sizes).filter(_utils_identity__WEBPACK_IMPORTED_MODULE_7__.identity).join(',');

    if (props.blank) {
      if (!height && width) {
        height = width;
      } else if (!width && height) {
        width = height;
      }

      if (!width && !height) {
        width = 1;
        height = 1;
      } // Make a blank SVG image


      src = makeBlankImgSrc(width, height, props.blankColor || 'transparent'); // Disable srcset and sizes

      srcset = null;
      sizes = null;
    }

    if (props.left) {
      align = 'float-left';
    } else if (props.right) {
      align = 'float-right';
    } else if (props.center) {
      align = 'mx-auto';
      block = true;
    }

    return h('img', (0,_vue__WEBPACK_IMPORTED_MODULE_8__.mergeData)(data, {
      attrs: {
        src: src,
        alt: alt,
        width: width ? (0,_utils_string__WEBPACK_IMPORTED_MODULE_0__.toString)(width) : null,
        height: height ? (0,_utils_string__WEBPACK_IMPORTED_MODULE_0__.toString)(height) : null,
        srcset: srcset || null,
        sizes: sizes || null
      },
      class: (_class = {
        'img-thumbnail': props.thumbnail,
        'img-fluid': props.fluid || fluidGrow,
        'w-100': fluidGrow,
        rounded: rounded === '' || rounded === true
      }, _defineProperty(_class, "rounded-".concat(rounded), (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_9__.isString)(rounded) && rounded !== ''), _defineProperty(_class, align, align), _defineProperty(_class, 'd-block', block), _class)
    }));
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/image/index.js":
/*!******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/image/index.js ***!
  \******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BImg": () => (/* reexport safe */ _img__WEBPACK_IMPORTED_MODULE_1__.BImg),
/* harmony export */   "BImgLazy": () => (/* reexport safe */ _img_lazy__WEBPACK_IMPORTED_MODULE_2__.BImgLazy),
/* harmony export */   "ImagePlugin": () => (/* binding */ ImagePlugin)
/* harmony export */ });
/* harmony import */ var _img__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./img */ "./node_modules/bootstrap-vue/esm/components/image/img.js");
/* harmony import */ var _img_lazy__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./img-lazy */ "./node_modules/bootstrap-vue/esm/components/image/img-lazy.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");



var ImagePlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BImg: _img__WEBPACK_IMPORTED_MODULE_1__.BImg,
    BImgLazy: _img_lazy__WEBPACK_IMPORTED_MODULE_2__.BImgLazy
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/index.js":
/*!************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/index.js ***!
  \************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "componentsPlugin": () => (/* binding */ componentsPlugin)
/* harmony export */ });
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");
/* harmony import */ var _alert__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./alert */ "./node_modules/bootstrap-vue/esm/components/alert/index.js");
/* harmony import */ var _aspect__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./aspect */ "./node_modules/bootstrap-vue/esm/components/aspect/index.js");
/* harmony import */ var _avatar__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./avatar */ "./node_modules/bootstrap-vue/esm/components/avatar/index.js");
/* harmony import */ var _badge__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./badge */ "./node_modules/bootstrap-vue/esm/components/badge/index.js");
/* harmony import */ var _breadcrumb__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./breadcrumb */ "./node_modules/bootstrap-vue/esm/components/breadcrumb/index.js");
/* harmony import */ var _button__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./button */ "./node_modules/bootstrap-vue/esm/components/button/index.js");
/* harmony import */ var _button_group__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./button-group */ "./node_modules/bootstrap-vue/esm/components/button-group/index.js");
/* harmony import */ var _button_toolbar__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ./button-toolbar */ "./node_modules/bootstrap-vue/esm/components/button-toolbar/index.js");
/* harmony import */ var _calendar__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./calendar */ "./node_modules/bootstrap-vue/esm/components/calendar/index.js");
/* harmony import */ var _card__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ./card */ "./node_modules/bootstrap-vue/esm/components/card/index.js");
/* harmony import */ var _carousel__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ./carousel */ "./node_modules/bootstrap-vue/esm/components/carousel/index.js");
/* harmony import */ var _collapse__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ./collapse */ "./node_modules/bootstrap-vue/esm/components/collapse/index.js");
/* harmony import */ var _dropdown__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ./dropdown */ "./node_modules/bootstrap-vue/esm/components/dropdown/index.js");
/* harmony import */ var _embed__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ./embed */ "./node_modules/bootstrap-vue/esm/components/embed/index.js");
/* harmony import */ var _form__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ./form */ "./node_modules/bootstrap-vue/esm/components/form/index.js");
/* harmony import */ var _form_checkbox__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ./form-checkbox */ "./node_modules/bootstrap-vue/esm/components/form-checkbox/index.js");
/* harmony import */ var _form_datepicker__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ./form-datepicker */ "./node_modules/bootstrap-vue/esm/components/form-datepicker/index.js");
/* harmony import */ var _form_file__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ./form-file */ "./node_modules/bootstrap-vue/esm/components/form-file/index.js");
/* harmony import */ var _form_group__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ./form-group */ "./node_modules/bootstrap-vue/esm/components/form-group/index.js");
/* harmony import */ var _form_input__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ./form-input */ "./node_modules/bootstrap-vue/esm/components/form-input/index.js");
/* harmony import */ var _form_radio__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ./form-radio */ "./node_modules/bootstrap-vue/esm/components/form-radio/index.js");
/* harmony import */ var _form_rating__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ./form-rating */ "./node_modules/bootstrap-vue/esm/components/form-rating/index.js");
/* harmony import */ var _form_select__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ./form-select */ "./node_modules/bootstrap-vue/esm/components/form-select/index.js");
/* harmony import */ var _form_spinbutton__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ./form-spinbutton */ "./node_modules/bootstrap-vue/esm/components/form-spinbutton/index.js");
/* harmony import */ var _form_tags__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ./form-tags */ "./node_modules/bootstrap-vue/esm/components/form-tags/index.js");
/* harmony import */ var _form_textarea__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ./form-textarea */ "./node_modules/bootstrap-vue/esm/components/form-textarea/index.js");
/* harmony import */ var _form_timepicker__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ./form-timepicker */ "./node_modules/bootstrap-vue/esm/components/form-timepicker/index.js");
/* harmony import */ var _image__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ./image */ "./node_modules/bootstrap-vue/esm/components/image/index.js");
/* harmony import */ var _input_group__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ./input-group */ "./node_modules/bootstrap-vue/esm/components/input-group/index.js");
/* harmony import */ var _jumbotron__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ./jumbotron */ "./node_modules/bootstrap-vue/esm/components/jumbotron/index.js");
/* harmony import */ var _layout__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ./layout */ "./node_modules/bootstrap-vue/esm/components/layout/index.js");
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ./link */ "./node_modules/bootstrap-vue/esm/components/link/index.js");
/* harmony import */ var _list_group__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ./list-group */ "./node_modules/bootstrap-vue/esm/components/list-group/index.js");
/* harmony import */ var _media__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ./media */ "./node_modules/bootstrap-vue/esm/components/media/index.js");
/* harmony import */ var _modal__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ./modal */ "./node_modules/bootstrap-vue/esm/components/modal/index.js");
/* harmony import */ var _nav__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ./nav */ "./node_modules/bootstrap-vue/esm/components/nav/index.js");
/* harmony import */ var _navbar__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ./navbar */ "./node_modules/bootstrap-vue/esm/components/navbar/index.js");
/* harmony import */ var _overlay__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ./overlay */ "./node_modules/bootstrap-vue/esm/components/overlay/index.js");
/* harmony import */ var _pagination__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ./pagination */ "./node_modules/bootstrap-vue/esm/components/pagination/index.js");
/* harmony import */ var _pagination_nav__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ./pagination-nav */ "./node_modules/bootstrap-vue/esm/components/pagination-nav/index.js");
/* harmony import */ var _popover__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ./popover */ "./node_modules/bootstrap-vue/esm/components/popover/index.js");
/* harmony import */ var _progress__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ./progress */ "./node_modules/bootstrap-vue/esm/components/progress/index.js");
/* harmony import */ var _sidebar__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ./sidebar */ "./node_modules/bootstrap-vue/esm/components/sidebar/index.js");
/* harmony import */ var _skeleton__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ./skeleton */ "./node_modules/bootstrap-vue/esm/components/skeleton/index.js");
/* harmony import */ var _spinner__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ./spinner */ "./node_modules/bootstrap-vue/esm/components/spinner/index.js");
/* harmony import */ var _table__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ./table */ "./node_modules/bootstrap-vue/esm/components/table/index.js");
/* harmony import */ var _tabs__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ./tabs */ "./node_modules/bootstrap-vue/esm/components/tabs/index.js");
/* harmony import */ var _time__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ./time */ "./node_modules/bootstrap-vue/esm/components/time/index.js");
/* harmony import */ var _toast__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ./toast */ "./node_modules/bootstrap-vue/esm/components/toast/index.js");
/* harmony import */ var _tooltip__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ./tooltip */ "./node_modules/bootstrap-vue/esm/components/tooltip/index.js");
 // Component group plugins













































 // Table plugin includes TableLitePlugin and TableSimplePlugin





 // Main plugin to install all component group plugins

var componentsPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  plugins: {
    AlertPlugin: _alert__WEBPACK_IMPORTED_MODULE_1__.AlertPlugin,
    AspectPlugin: _aspect__WEBPACK_IMPORTED_MODULE_2__.AspectPlugin,
    AvatarPlugin: _avatar__WEBPACK_IMPORTED_MODULE_3__.AvatarPlugin,
    BadgePlugin: _badge__WEBPACK_IMPORTED_MODULE_4__.BadgePlugin,
    BreadcrumbPlugin: _breadcrumb__WEBPACK_IMPORTED_MODULE_5__.BreadcrumbPlugin,
    ButtonPlugin: _button__WEBPACK_IMPORTED_MODULE_6__.ButtonPlugin,
    ButtonGroupPlugin: _button_group__WEBPACK_IMPORTED_MODULE_7__.ButtonGroupPlugin,
    ButtonToolbarPlugin: _button_toolbar__WEBPACK_IMPORTED_MODULE_8__.ButtonToolbarPlugin,
    CalendarPlugin: _calendar__WEBPACK_IMPORTED_MODULE_9__.CalendarPlugin,
    CardPlugin: _card__WEBPACK_IMPORTED_MODULE_10__.CardPlugin,
    CarouselPlugin: _carousel__WEBPACK_IMPORTED_MODULE_11__.CarouselPlugin,
    CollapsePlugin: _collapse__WEBPACK_IMPORTED_MODULE_12__.CollapsePlugin,
    DropdownPlugin: _dropdown__WEBPACK_IMPORTED_MODULE_13__.DropdownPlugin,
    EmbedPlugin: _embed__WEBPACK_IMPORTED_MODULE_14__.EmbedPlugin,
    FormPlugin: _form__WEBPACK_IMPORTED_MODULE_15__.FormPlugin,
    FormCheckboxPlugin: _form_checkbox__WEBPACK_IMPORTED_MODULE_16__.FormCheckboxPlugin,
    FormDatepickerPlugin: _form_datepicker__WEBPACK_IMPORTED_MODULE_17__.FormDatepickerPlugin,
    FormFilePlugin: _form_file__WEBPACK_IMPORTED_MODULE_18__.FormFilePlugin,
    FormGroupPlugin: _form_group__WEBPACK_IMPORTED_MODULE_19__.FormGroupPlugin,
    FormInputPlugin: _form_input__WEBPACK_IMPORTED_MODULE_20__.FormInputPlugin,
    FormRadioPlugin: _form_radio__WEBPACK_IMPORTED_MODULE_21__.FormRadioPlugin,
    FormRatingPlugin: _form_rating__WEBPACK_IMPORTED_MODULE_22__.FormRatingPlugin,
    FormSelectPlugin: _form_select__WEBPACK_IMPORTED_MODULE_23__.FormSelectPlugin,
    FormSpinbuttonPlugin: _form_spinbutton__WEBPACK_IMPORTED_MODULE_24__.FormSpinbuttonPlugin,
    FormTagsPlugin: _form_tags__WEBPACK_IMPORTED_MODULE_25__.FormTagsPlugin,
    FormTextareaPlugin: _form_textarea__WEBPACK_IMPORTED_MODULE_26__.FormTextareaPlugin,
    FormTimepickerPlugin: _form_timepicker__WEBPACK_IMPORTED_MODULE_27__.FormTimepickerPlugin,
    ImagePlugin: _image__WEBPACK_IMPORTED_MODULE_28__.ImagePlugin,
    InputGroupPlugin: _input_group__WEBPACK_IMPORTED_MODULE_29__.InputGroupPlugin,
    JumbotronPlugin: _jumbotron__WEBPACK_IMPORTED_MODULE_30__.JumbotronPlugin,
    LayoutPlugin: _layout__WEBPACK_IMPORTED_MODULE_31__.LayoutPlugin,
    LinkPlugin: _link__WEBPACK_IMPORTED_MODULE_32__.LinkPlugin,
    ListGroupPlugin: _list_group__WEBPACK_IMPORTED_MODULE_33__.ListGroupPlugin,
    MediaPlugin: _media__WEBPACK_IMPORTED_MODULE_34__.MediaPlugin,
    ModalPlugin: _modal__WEBPACK_IMPORTED_MODULE_35__.ModalPlugin,
    NavPlugin: _nav__WEBPACK_IMPORTED_MODULE_36__.NavPlugin,
    NavbarPlugin: _navbar__WEBPACK_IMPORTED_MODULE_37__.NavbarPlugin,
    OverlayPlugin: _overlay__WEBPACK_IMPORTED_MODULE_38__.OverlayPlugin,
    PaginationPlugin: _pagination__WEBPACK_IMPORTED_MODULE_39__.PaginationPlugin,
    PaginationNavPlugin: _pagination_nav__WEBPACK_IMPORTED_MODULE_40__.PaginationNavPlugin,
    PopoverPlugin: _popover__WEBPACK_IMPORTED_MODULE_41__.PopoverPlugin,
    ProgressPlugin: _progress__WEBPACK_IMPORTED_MODULE_42__.ProgressPlugin,
    SidebarPlugin: _sidebar__WEBPACK_IMPORTED_MODULE_43__.SidebarPlugin,
    SkeletonPlugin: _skeleton__WEBPACK_IMPORTED_MODULE_44__.SkeletonPlugin,
    SpinnerPlugin: _spinner__WEBPACK_IMPORTED_MODULE_45__.SpinnerPlugin,
    TablePlugin: _table__WEBPACK_IMPORTED_MODULE_46__.TablePlugin,
    TabsPlugin: _tabs__WEBPACK_IMPORTED_MODULE_47__.TabsPlugin,
    TimePlugin: _time__WEBPACK_IMPORTED_MODULE_48__.TimePlugin,
    ToastPlugin: _toast__WEBPACK_IMPORTED_MODULE_49__.ToastPlugin,
    TooltipPlugin: _tooltip__WEBPACK_IMPORTED_MODULE_50__.TooltipPlugin
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/input-group/index.js":
/*!************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/input-group/index.js ***!
  \************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BInputGroup": () => (/* reexport safe */ _input_group__WEBPACK_IMPORTED_MODULE_1__.BInputGroup),
/* harmony export */   "BInputGroupAddon": () => (/* reexport safe */ _input_group_addon__WEBPACK_IMPORTED_MODULE_2__.BInputGroupAddon),
/* harmony export */   "BInputGroupAppend": () => (/* reexport safe */ _input_group_append__WEBPACK_IMPORTED_MODULE_4__.BInputGroupAppend),
/* harmony export */   "BInputGroupPrepend": () => (/* reexport safe */ _input_group_prepend__WEBPACK_IMPORTED_MODULE_3__.BInputGroupPrepend),
/* harmony export */   "BInputGroupText": () => (/* reexport safe */ _input_group_text__WEBPACK_IMPORTED_MODULE_5__.BInputGroupText),
/* harmony export */   "InputGroupPlugin": () => (/* binding */ InputGroupPlugin)
/* harmony export */ });
/* harmony import */ var _input_group__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./input-group */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group.js");
/* harmony import */ var _input_group_addon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./input-group-addon */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-addon.js");
/* harmony import */ var _input_group_prepend__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./input-group-prepend */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-prepend.js");
/* harmony import */ var _input_group_append__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./input-group-append */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-append.js");
/* harmony import */ var _input_group_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./input-group-text */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-text.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");






var InputGroupPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BInputGroup: _input_group__WEBPACK_IMPORTED_MODULE_1__.BInputGroup,
    BInputGroupAddon: _input_group_addon__WEBPACK_IMPORTED_MODULE_2__.BInputGroupAddon,
    BInputGroupPrepend: _input_group_prepend__WEBPACK_IMPORTED_MODULE_3__.BInputGroupPrepend,
    BInputGroupAppend: _input_group_append__WEBPACK_IMPORTED_MODULE_4__.BInputGroupAppend,
    BInputGroupText: _input_group_text__WEBPACK_IMPORTED_MODULE_5__.BInputGroupText
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-addon.js":
/*!************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/input-group/input-group-addon.js ***!
  \************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BInputGroupAddon": () => (/* binding */ BInputGroupAddon),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _input_group_text__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./input-group-text */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-text.js");




 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  append: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  isText: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_INPUT_GROUP_ADDON); // --- Main component ---
// @vue/component

var BInputGroupAddon = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_INPUT_GROUP_ADDON,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var append = props.append;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      class: {
        'input-group-append': append,
        'input-group-prepend': !append
      },
      attrs: {
        id: props.id
      }
    }), props.isText ? [h(_input_group_text__WEBPACK_IMPORTED_MODULE_5__.BInputGroupText, children)] : children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-append.js":
/*!*************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/input-group/input-group-append.js ***!
  \*************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BInputGroupAppend": () => (/* binding */ BInputGroupAppend),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _input_group_addon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./input-group-addon */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-addon.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(_input_group_addon__WEBPACK_IMPORTED_MODULE_2__.props, ['append']), _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_INPUT_GROUP_APPEND); // --- Main component ---
// @vue/component

var BInputGroupAppend = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_4__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_INPUT_GROUP_APPEND,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    // Pass all our data down to child, and set `append` to `true`
    return h(_input_group_addon__WEBPACK_IMPORTED_MODULE_2__.BInputGroupAddon, (0,_vue__WEBPACK_IMPORTED_MODULE_5__.mergeData)(data, {
      props: _objectSpread(_objectSpread({}, props), {}, {
        append: true
      })
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-prepend.js":
/*!**************************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/input-group/input-group-prepend.js ***!
  \**************************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BInputGroupPrepend": () => (/* binding */ BInputGroupPrepend),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _input_group_addon__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./input-group-addon */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-addon.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }





 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_1__.omit)(_input_group_addon__WEBPACK_IMPORTED_MODULE_2__.props, ['append']), _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_INPUT_GROUP_PREPEND); // --- Main component ---
// @vue/component

var BInputGroupPrepend = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_4__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_3__.NAME_INPUT_GROUP_PREPEND,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    // Pass all our data down to child, and set `append` to `true`
    return h(_input_group_addon__WEBPACK_IMPORTED_MODULE_2__.BInputGroupAddon, (0,_vue__WEBPACK_IMPORTED_MODULE_5__.mergeData)(data, {
      props: _objectSpread(_objectSpread({}, props), {}, {
        append: false
      })
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-text.js":
/*!***********************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/input-group/input-group-text.js ***!
  \***********************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BInputGroupText": () => (/* binding */ BInputGroupText),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_INPUT_GROUP_TEXT); // --- Main component ---
// @vue/component

var BInputGroupText = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_INPUT_GROUP_TEXT,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      staticClass: 'input-group-text'
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/input-group/input-group.js":
/*!******************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/input-group/input-group.js ***!
  \******************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BInputGroup": () => (/* binding */ BInputGroup),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/normalize-slot */ "./node_modules/bootstrap-vue/esm/utils/normalize-slot.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _input_group_append__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ./input-group-append */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-append.js");
/* harmony import */ var _input_group_prepend__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ./input-group-prepend */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-prepend.js");
/* harmony import */ var _input_group_text__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ./input-group-text */ "./node_modules/bootstrap-vue/esm/components/input-group/input-group-text.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  append: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  appendHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  id: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  prepend: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  prependHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  size: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_INPUT_GROUP); // --- Main component ---
// @vue/component

var BInputGroup = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_INPUT_GROUP,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        slots = _ref.slots,
        scopedSlots = _ref.scopedSlots;
    var prepend = props.prepend,
        prependHtml = props.prependHtml,
        append = props.append,
        appendHtml = props.appendHtml,
        size = props.size;
    var $scopedSlots = scopedSlots || {};
    var $slots = slots();
    var slotScope = {};
    var $prepend = h();
    var hasPrependSlot = (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_PREPEND, $scopedSlots, $slots);

    if (hasPrependSlot || prepend || prependHtml) {
      $prepend = h(_input_group_prepend__WEBPACK_IMPORTED_MODULE_6__.BInputGroupPrepend, [hasPrependSlot ? (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_PREPEND, slotScope, $scopedSlots, $slots) : h(_input_group_text__WEBPACK_IMPORTED_MODULE_7__.BInputGroupText, {
        domProps: (0,_utils_html__WEBPACK_IMPORTED_MODULE_8__.htmlOrText)(prependHtml, prepend)
      })]);
    }

    var $append = h();
    var hasAppendSlot = (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_APPEND, $scopedSlots, $slots);

    if (hasAppendSlot || append || appendHtml) {
      $append = h(_input_group_append__WEBPACK_IMPORTED_MODULE_9__.BInputGroupAppend, [hasAppendSlot ? (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_APPEND, slotScope, $scopedSlots, $slots) : h(_input_group_text__WEBPACK_IMPORTED_MODULE_7__.BInputGroupText, {
        domProps: (0,_utils_html__WEBPACK_IMPORTED_MODULE_8__.htmlOrText)(appendHtml, append)
      })]);
    }

    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_10__.mergeData)(data, {
      staticClass: 'input-group',
      class: _defineProperty({}, "input-group-".concat(size), size),
      attrs: {
        id: props.id || null,
        role: 'group'
      }
    }), [$prepend, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_DEFAULT, slotScope, $scopedSlots, $slots), $append]);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/jumbotron/index.js":
/*!**********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/jumbotron/index.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BJumbotron": () => (/* reexport safe */ _jumbotron__WEBPACK_IMPORTED_MODULE_1__.BJumbotron),
/* harmony export */   "JumbotronPlugin": () => (/* binding */ JumbotronPlugin)
/* harmony export */ });
/* harmony import */ var _jumbotron__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./jumbotron */ "./node_modules/bootstrap-vue/esm/components/jumbotron/jumbotron.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var JumbotronPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BJumbotron: _jumbotron__WEBPACK_IMPORTED_MODULE_1__.BJumbotron
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/jumbotron/jumbotron.js":
/*!**************************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/jumbotron/jumbotron.js ***!
  \**************************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BJumbotron": () => (/* binding */ BJumbotron),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_slots__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/slots */ "./node_modules/bootstrap-vue/esm/constants/slots.js");
/* harmony import */ var _utils_html__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/html */ "./node_modules/bootstrap-vue/esm/utils/html.js");
/* harmony import */ var _utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/normalize-slot */ "./node_modules/bootstrap-vue/esm/utils/normalize-slot.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _layout_container__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../layout/container */ "./node_modules/bootstrap-vue/esm/components/layout/container.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }








 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  bgVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  borderVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  containerFluid: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN_STRING, false),
  fluid: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN, false),
  header: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  headerHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  headerLevel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_NUMBER_STRING, 3),
  headerTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'h1'),
  lead: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  leadHtml: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING),
  leadTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'p'),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div'),
  textVariant: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING)
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_JUMBOTRON); // --- Main component ---
// @vue/component

var BJumbotron = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_JUMBOTRON,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var _class2;

    var props = _ref.props,
        data = _ref.data,
        slots = _ref.slots,
        scopedSlots = _ref.scopedSlots;
    var header = props.header,
        headerHtml = props.headerHtml,
        lead = props.lead,
        leadHtml = props.leadHtml,
        textVariant = props.textVariant,
        bgVariant = props.bgVariant,
        borderVariant = props.borderVariant;
    var $scopedSlots = scopedSlots || {};
    var $slots = slots();
    var slotScope = {};
    var $header = h();
    var hasHeaderSlot = (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_HEADER, $scopedSlots, $slots);

    if (hasHeaderSlot || header || headerHtml) {
      var headerLevel = props.headerLevel;
      $header = h(props.headerTag, {
        class: _defineProperty({}, "display-".concat(headerLevel), headerLevel),
        domProps: hasHeaderSlot ? {} : (0,_utils_html__WEBPACK_IMPORTED_MODULE_6__.htmlOrText)(headerHtml, header)
      }, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_HEADER, slotScope, $scopedSlots, $slots));
    }

    var $lead = h();
    var hasLeadSlot = (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.hasNormalizedSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_LEAD, $scopedSlots, $slots);

    if (hasLeadSlot || lead || leadHtml) {
      $lead = h(props.leadTag, {
        staticClass: 'lead',
        domProps: hasLeadSlot ? {} : (0,_utils_html__WEBPACK_IMPORTED_MODULE_6__.htmlOrText)(leadHtml, lead)
      }, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_LEAD, slotScope, $scopedSlots, $slots));
    }

    var $children = [$header, $lead, (0,_utils_normalize_slot__WEBPACK_IMPORTED_MODULE_4__.normalizeSlot)(_constants_slots__WEBPACK_IMPORTED_MODULE_5__.SLOT_NAME_DEFAULT, slotScope, $scopedSlots, $slots)]; // If fluid, wrap content in a container

    if (props.fluid) {
      $children = [h(_layout_container__WEBPACK_IMPORTED_MODULE_7__.BContainer, {
        props: {
          fluid: props.containerFluid
        }
      }, $children)];
    }

    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_8__.mergeData)(data, {
      staticClass: 'jumbotron',
      class: (_class2 = {
        'jumbotron-fluid': props.fluid
      }, _defineProperty(_class2, "text-".concat(textVariant), textVariant), _defineProperty(_class2, "bg-".concat(bgVariant), bgVariant), _defineProperty(_class2, "border-".concat(borderVariant), borderVariant), _defineProperty(_class2, "border", borderVariant), _class2)
    }), $children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/layout/col.js":
/*!*****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/layout/col.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCol": () => (/* binding */ BCol),
/* harmony export */   "generateProps": () => (/* binding */ generateProps)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _constants_regex__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../constants/regex */ "./node_modules/bootstrap-vue/esm/constants/regex.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_config__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/config */ "./node_modules/bootstrap-vue/esm/utils/config.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_memoize__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/memoize */ "./node_modules/bootstrap-vue/esm/utils/memoize.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }












 // --- Constants ---

var ALIGN_SELF_VALUES = ['auto', 'start', 'end', 'center', 'baseline', 'stretch']; // --- Helper methods ---
// Compute a breakpoint class name

var computeBreakpoint = function computeBreakpoint(type, breakpoint, value) {
  var className = type;

  if ((0,_utils_inspect__WEBPACK_IMPORTED_MODULE_0__.isUndefinedOrNull)(value) || value === false) {
    return undefined;
  }

  if (breakpoint) {
    className += "-".concat(breakpoint);
  } // Handling the boolean style prop when accepting `[Boolean, String, Number]`
  // means Vue will not convert `<b-col sm></b-col>` to `sm: true` for us
  // Since the default is `false`, '' indicates the prop's presence


  if (type === 'col' && (value === '' || value === true)) {
    // .col-md
    return (0,_utils_string__WEBPACK_IMPORTED_MODULE_1__.lowerCase)(className);
  } // .order-md-6


  className += "-".concat(value);
  return (0,_utils_string__WEBPACK_IMPORTED_MODULE_1__.lowerCase)(className);
}; // Memoized function for better performance on generating class names


var computeBreakpointClass = (0,_utils_memoize__WEBPACK_IMPORTED_MODULE_2__.memoize)(computeBreakpoint); // Cached copy of the breakpoint prop names

var breakpointPropMap = (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.create)(null); // --- Props ---
// Prop generator for lazy generation of props

var generateProps = function generateProps() {
  // Grab the breakpoints from the cached config (exclude the '' (xs) breakpoint)
  var breakpoints = (0,_utils_config__WEBPACK_IMPORTED_MODULE_4__.getBreakpointsUpCached)().filter(_utils_identity__WEBPACK_IMPORTED_MODULE_5__.identity); // i.e. 'col-sm', 'col-md-6', 'col-lg-auto', ...

  var breakpointCol = breakpoints.reduce(function (props, breakpoint) {
    props[breakpoint] = (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN_NUMBER_STRING);
    return props;
  }, (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.create)(null)); // i.e. 'offset-md-1', 'offset-lg-12', ...

  var breakpointOffset = breakpoints.reduce(function (props, breakpoint) {
    props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.suffixPropName)(breakpoint, 'offset')] = (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING);
    return props;
  }, (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.create)(null)); // i.e. 'order-md-1', 'order-lg-12', ...

  var breakpointOrder = breakpoints.reduce(function (props, breakpoint) {
    props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.suffixPropName)(breakpoint, 'order')] = (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING);
    return props;
  }, (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.create)(null)); // For loop doesn't need to check `.hasOwnProperty()`
  // when using an object created from `null`

  breakpointPropMap = (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.assign)((0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.create)(null), {
    col: (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.keys)(breakpointCol),
    offset: (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.keys)(breakpointOffset),
    order: (0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.keys)(breakpointOrder)
  }); // Return the generated props

  return (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_3__.sortKeys)(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, breakpointCol), breakpointOffset), breakpointOrder), {}, {
    // Flex alignment
    alignSelf: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING, null, function (value) {
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_8__.arrayIncludes)(ALIGN_SELF_VALUES, value);
    }),
    // Generic flexbox 'col' (xs)
    col: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_BOOLEAN, false),
    // i.e. 'col-1', 'col-2', 'col-auto', ...
    cols: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING),
    offset: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING),
    order: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_NUMBER_STRING),
    tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_6__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_7__.PROP_TYPE_STRING, 'div')
  })), _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_COL);
}; // --- Main component ---
// We do not use Vue.extend here as that would evaluate the props
// immediately, which we do not want to happen
// @vue/component

var BCol = {
  name: _constants_components__WEBPACK_IMPORTED_MODULE_9__.NAME_COL,
  functional: true,

  get props() {
    // Allow props to be lazy evaled on first access and
    // then they become a non-getter afterwards.
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get#Smart_self-overwriting_lazy_getters
    delete this.props; // eslint-disable-next-line no-return-assign

    return this.props = generateProps();
  },

  render: function render(h, _ref) {
    var _classList$push;

    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var cols = props.cols,
        offset = props.offset,
        order = props.order,
        alignSelf = props.alignSelf;
    var classList = []; // Loop through `col`, `offset`, `order` breakpoint props

    for (var type in breakpointPropMap) {
      // Returns colSm, offset, offsetSm, orderMd, etc.
      var _keys = breakpointPropMap[type];

      for (var i = 0; i < _keys.length; i++) {
        // computeBreakpoint(col, colSm => Sm, value=[String, Number, Boolean])
        var c = computeBreakpointClass(type, _keys[i].replace(type, ''), props[_keys[i]]); // If a class is returned, push it onto the array.

        if (c) {
          classList.push(c);
        }
      }
    }

    var hasColClasses = classList.some(function (className) {
      return _constants_regex__WEBPACK_IMPORTED_MODULE_10__.RX_COL_CLASS.test(className);
    });
    classList.push((_classList$push = {
      // Default to .col if no other col-{bp}-* classes generated nor `cols` specified.
      col: props.col || !hasColClasses && !cols
    }, _defineProperty(_classList$push, "col-".concat(cols), cols), _defineProperty(_classList$push, "offset-".concat(offset), offset), _defineProperty(_classList$push, "order-".concat(order), order), _defineProperty(_classList$push, "align-self-".concat(alignSelf), alignSelf), _classList$push));
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_11__.mergeData)(data, {
      class: classList
    }), children);
  }
};

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/layout/container.js":
/*!***********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/layout/container.js ***!
  \***********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BContainer": () => (/* binding */ BContainer),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }




 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  // String breakpoint name new in Bootstrap v4.4.x
  fluid: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_BOOLEAN_STRING, false),
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CONTAINER); // --- Main component ---
// @vue/component

var BContainer = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_CONTAINER,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var fluid = props.fluid;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      class: _defineProperty({
        container: !(fluid || fluid === ''),
        'container-fluid': fluid === true || fluid === ''
      }, "container-".concat(fluid), fluid && fluid !== true)
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/layout/form-row.js":
/*!**********************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/layout/form-row.js ***!
  \**********************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BFormRow": () => (/* binding */ BFormRow),
/* harmony export */   "props": () => (/* binding */ props)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");



 // --- Props ---

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makePropsConfigurable)({
  tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_0__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_1__.PROP_TYPE_STRING, 'div')
}, _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_ROW); // --- Main component ---
// @vue/component

var BFormRow = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_3__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_2__.NAME_FORM_ROW,
  functional: true,
  props: props,
  render: function render(h, _ref) {
    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_4__.mergeData)(data, {
      staticClass: 'form-row'
    }), children);
  }
});

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/layout/index.js":
/*!*******************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/layout/index.js ***!
  \*******************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BCol": () => (/* reexport safe */ _col__WEBPACK_IMPORTED_MODULE_3__.BCol),
/* harmony export */   "BContainer": () => (/* reexport safe */ _container__WEBPACK_IMPORTED_MODULE_1__.BContainer),
/* harmony export */   "BFormRow": () => (/* reexport safe */ _form_row__WEBPACK_IMPORTED_MODULE_4__.BFormRow),
/* harmony export */   "BRow": () => (/* reexport safe */ _row__WEBPACK_IMPORTED_MODULE_2__.BRow),
/* harmony export */   "LayoutPlugin": () => (/* binding */ LayoutPlugin)
/* harmony export */ });
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./container */ "./node_modules/bootstrap-vue/esm/components/layout/container.js");
/* harmony import */ var _row__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./row */ "./node_modules/bootstrap-vue/esm/components/layout/row.js");
/* harmony import */ var _col__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./col */ "./node_modules/bootstrap-vue/esm/components/layout/col.js");
/* harmony import */ var _form_row__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./form-row */ "./node_modules/bootstrap-vue/esm/components/layout/form-row.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");





var LayoutPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BContainer: _container__WEBPACK_IMPORTED_MODULE_1__.BContainer,
    BRow: _row__WEBPACK_IMPORTED_MODULE_2__.BRow,
    BCol: _col__WEBPACK_IMPORTED_MODULE_3__.BCol,
    BFormRow: _form_row__WEBPACK_IMPORTED_MODULE_4__.BFormRow
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/layout/row.js":
/*!*****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/layout/row.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BRow": () => (/* binding */ BRow),
/* harmony export */   "generateProps": () => (/* binding */ generateProps)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue-functional-data-merge/dist/lib.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_config__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../utils/config */ "./node_modules/bootstrap-vue/esm/utils/config.js");
/* harmony import */ var _utils_identity__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/identity */ "./node_modules/bootstrap-vue/esm/utils/identity.js");
/* harmony import */ var _utils_memoize__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/memoize */ "./node_modules/bootstrap-vue/esm/utils/memoize.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_string__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../utils/string */ "./node_modules/bootstrap-vue/esm/utils/string.js");
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }










 // --- Constants ---

var COMMON_ALIGNMENT = ['start', 'end', 'center']; // --- Helper methods ---
// Compute a `row-cols-{breakpoint}-{cols}` class name
// Memoized function for better performance on generating class names

var computeRowColsClass = (0,_utils_memoize__WEBPACK_IMPORTED_MODULE_0__.memoize)(function (breakpoint, cols) {
  cols = (0,_utils_string__WEBPACK_IMPORTED_MODULE_1__.trim)((0,_utils_string__WEBPACK_IMPORTED_MODULE_1__.toString)(cols));
  return cols ? (0,_utils_string__WEBPACK_IMPORTED_MODULE_1__.lowerCase)(['row-cols', breakpoint, cols].filter(_utils_identity__WEBPACK_IMPORTED_MODULE_2__.identity).join('-')) : null;
}); // Get the breakpoint name from the `rowCols` prop name
// Memoized function for better performance on extracting breakpoint names

var computeRowColsBreakpoint = (0,_utils_memoize__WEBPACK_IMPORTED_MODULE_0__.memoize)(function (prop) {
  return (0,_utils_string__WEBPACK_IMPORTED_MODULE_1__.lowerCase)(prop.replace('cols', ''));
}); // Cached copy of the `row-cols` breakpoint prop names
// Will be populated when the props are generated

var rowColsPropList = []; // --- Props ---
// Prop generator for lazy generation of props

var generateProps = function generateProps() {
  // i.e. 'row-cols-2', 'row-cols-md-4', 'row-cols-xl-6', ...
  var rowColsProps = (0,_utils_config__WEBPACK_IMPORTED_MODULE_3__.getBreakpointsUpCached)().reduce(function (props, breakpoint) {
    props[(0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.suffixPropName)(breakpoint, 'cols')] = (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_NUMBER_STRING);
    return props;
  }, (0,_utils_object__WEBPACK_IMPORTED_MODULE_6__.create)(null)); // Cache the row-cols prop names

  rowColsPropList = (0,_utils_object__WEBPACK_IMPORTED_MODULE_6__.keys)(rowColsProps); // Return the generated props

  return (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_6__.sortKeys)(_objectSpread(_objectSpread({}, rowColsProps), {}, {
    alignContent: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, null, function (value) {
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_7__.arrayIncludes)((0,_utils_array__WEBPACK_IMPORTED_MODULE_7__.concat)(COMMON_ALIGNMENT, 'between', 'around', 'stretch'), value);
    }),
    alignH: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, null, function (value) {
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_7__.arrayIncludes)((0,_utils_array__WEBPACK_IMPORTED_MODULE_7__.concat)(COMMON_ALIGNMENT, 'between', 'around'), value);
    }),
    alignV: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, null, function (value) {
      return (0,_utils_array__WEBPACK_IMPORTED_MODULE_7__.arrayIncludes)((0,_utils_array__WEBPACK_IMPORTED_MODULE_7__.concat)(COMMON_ALIGNMENT, 'baseline', 'stretch'), value);
    }),
    noGutters: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_BOOLEAN, false),
    tag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_4__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_5__.PROP_TYPE_STRING, 'div')
  })), _constants_components__WEBPACK_IMPORTED_MODULE_8__.NAME_ROW);
}; // --- Main component ---
// We do not use `Vue.extend()` here as that would evaluate the props
// immediately, which we do not want to happen
// @vue/component

var BRow = {
  name: _constants_components__WEBPACK_IMPORTED_MODULE_8__.NAME_ROW,
  functional: true,

  get props() {
    // Allow props to be lazy evaled on first access and
    // then they become a non-getter afterwards
    // https://developer.mozilla.org/en-US/docs/Web/JavaScript/Reference/Functions/get#Smart_self-overwriting_lazy_getters
    delete this.props;
    this.props = generateProps();
    return this.props;
  },

  render: function render(h, _ref) {
    var _classList$push;

    var props = _ref.props,
        data = _ref.data,
        children = _ref.children;
    var alignV = props.alignV,
        alignH = props.alignH,
        alignContent = props.alignContent; // Loop through row-cols breakpoint props and generate the classes

    var classList = [];
    rowColsPropList.forEach(function (prop) {
      var c = computeRowColsClass(computeRowColsBreakpoint(prop), props[prop]); // If a class is returned, push it onto the array

      if (c) {
        classList.push(c);
      }
    });
    classList.push((_classList$push = {
      'no-gutters': props.noGutters
    }, _defineProperty(_classList$push, "align-items-".concat(alignV), alignV), _defineProperty(_classList$push, "justify-content-".concat(alignH), alignH), _defineProperty(_classList$push, "align-content-".concat(alignContent), alignContent), _classList$push));
    return h(props.tag, (0,_vue__WEBPACK_IMPORTED_MODULE_9__.mergeData)(data, {
      staticClass: 'row',
      class: classList
    }), children);
  }
};

/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/link/index.js":
/*!*****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/link/index.js ***!
  \*****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BLink": () => (/* reexport safe */ _link__WEBPACK_IMPORTED_MODULE_1__.BLink),
/* harmony export */   "LinkPlugin": () => (/* binding */ LinkPlugin)
/* harmony export */ });
/* harmony import */ var _link__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./link */ "./node_modules/bootstrap-vue/esm/components/link/link.js");
/* harmony import */ var _utils_plugins__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/plugins */ "./node_modules/bootstrap-vue/esm/utils/plugins.js");


var LinkPlugin = /*#__PURE__*/(0,_utils_plugins__WEBPACK_IMPORTED_MODULE_0__.pluginFactory)({
  components: {
    BLink: _link__WEBPACK_IMPORTED_MODULE_1__.BLink
  }
});


/***/ }),

/***/ "./node_modules/bootstrap-vue/esm/components/link/link.js":
/*!****************************************************************!*\
  !*** ./node_modules/bootstrap-vue/esm/components/link/link.js ***!
  \****************************************************************/
/***/ ((__unused_webpack_module, __webpack_exports__, __webpack_require__) => {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export */ __webpack_require__.d(__webpack_exports__, {
/* harmony export */   "BLink": () => (/* binding */ BLink),
/* harmony export */   "nuxtLinkProps": () => (/* binding */ nuxtLinkProps),
/* harmony export */   "props": () => (/* binding */ props),
/* harmony export */   "routerLinkProps": () => (/* binding */ routerLinkProps)
/* harmony export */ });
/* harmony import */ var _vue__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../vue */ "./node_modules/vue/dist/vue.esm.js");
/* harmony import */ var _constants_components__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../constants/components */ "./node_modules/bootstrap-vue/esm/constants/components.js");
/* harmony import */ var _constants_events__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../constants/events */ "./node_modules/bootstrap-vue/esm/constants/events.js");
/* harmony import */ var _constants_props__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../constants/props */ "./node_modules/bootstrap-vue/esm/constants/props.js");
/* harmony import */ var _utils_array__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../utils/array */ "./node_modules/bootstrap-vue/esm/utils/array.js");
/* harmony import */ var _utils_dom__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../utils/dom */ "./node_modules/bootstrap-vue/esm/utils/dom.js");
/* harmony import */ var _utils_events__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../utils/events */ "./node_modules/bootstrap-vue/esm/utils/events.js");
/* harmony import */ var _utils_inspect__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../utils/inspect */ "./node_modules/bootstrap-vue/esm/utils/inspect.js");
/* harmony import */ var _utils_object__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../utils/object */ "./node_modules/bootstrap-vue/esm/utils/object.js");
/* harmony import */ var _utils_props__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../utils/props */ "./node_modules/bootstrap-vue/esm/utils/props.js");
/* harmony import */ var _utils_router__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../utils/router */ "./node_modules/bootstrap-vue/esm/utils/router.js");
/* harmony import */ var _mixins_attrs__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../mixins/attrs */ "./node_modules/bootstrap-vue/esm/mixins/attrs.js");
/* harmony import */ var _mixins_listen_on_root__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../mixins/listen-on-root */ "./node_modules/bootstrap-vue/esm/mixins/listen-on-root.js");
/* harmony import */ var _mixins_listeners__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../mixins/listeners */ "./node_modules/bootstrap-vue/esm/mixins/listeners.js");
/* harmony import */ var _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../mixins/normalize-slot */ "./node_modules/bootstrap-vue/esm/mixins/normalize-slot.js");
function _toConsumableArray(arr) { return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _unsupportedIterableToArray(arr) || _nonIterableSpread(); }

function _nonIterableSpread() { throw new TypeError("Invalid attempt to spread non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _iterableToArray(iter) { if (typeof Symbol !== "undefined" && Symbol.iterator in Object(iter)) return Array.from(iter); }

function _arrayWithoutHoles(arr) { if (Array.isArray(arr)) return _arrayLikeToArray(arr); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }















 // --- Constants ---

var ROOT_EVENT_NAME_CLICKED = (0,_utils_events__WEBPACK_IMPORTED_MODULE_0__.getRootEventName)(_constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_LINK, 'clicked'); // --- Props ---
// `<router-link>` specific props

var routerLinkProps = {
  activeClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  append: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  event: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_ARRAY_STRING, _constants_events__WEBPACK_IMPORTED_MODULE_4__.EVENT_NAME_CLICK),
  exact: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  exactActiveClass: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  replace: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  routerTag: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, 'a'),
  to: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_OBJECT_STRING)
}; // `<nuxt-link>` specific props

var nuxtLinkProps = {
  noPrefetch: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  // Must be `null` to fall back to the value defined in the
  // `nuxt.config.js` configuration file for `router.prefetchLinks`
  // We convert `null` to `undefined`, so that Nuxt.js will use the
  // compiled default
  // Vue treats `undefined` as default of `false` for Boolean props,
  // so we must set it as `null` here to be a true tri-state prop
  prefetch: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, null)
}; // All `<b-link>` props

var props = (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makePropsConfigurable)((0,_utils_object__WEBPACK_IMPORTED_MODULE_5__.sortKeys)(_objectSpread(_objectSpread(_objectSpread({}, nuxtLinkProps), routerLinkProps), {}, {
  active: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  disabled: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_BOOLEAN, false),
  href: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  // Must be `null` if no value provided
  rel: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, null),
  // To support 3rd party router links based on `<router-link>` (i.e. `g-link` for Gridsome)
  // Default is to auto choose between `<router-link>` and `<nuxt-link>`
  // Gridsome doesn't provide a mechanism to auto detect and has caveats
  // such as not supporting FQDN URLs or hash only URLs
  routerComponentName: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING),
  target: (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.makeProp)(_constants_props__WEBPACK_IMPORTED_MODULE_3__.PROP_TYPE_STRING, '_self')
})), _constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_LINK); // --- Main component ---
// @vue/component

var BLink = /*#__PURE__*/_vue__WEBPACK_IMPORTED_MODULE_6__["default"].extend({
  name: _constants_components__WEBPACK_IMPORTED_MODULE_1__.NAME_LINK,
  // Mixin order is important!
  mixins: [_mixins_attrs__WEBPACK_IMPORTED_MODULE_7__.attrsMixin, _mixins_listeners__WEBPACK_IMPORTED_MODULE_8__.listenersMixin, _mixins_listen_on_root__WEBPACK_IMPORTED_MODULE_9__.listenOnRootMixin, _mixins_normalize_slot__WEBPACK_IMPORTED_MODULE_10__.normalizeSlotMixin],
  inheritAttrs: false,
  props: props,
  computed: {
    computedTag: function computedTag() {
      // We don't pass `this` as the first arg as we need reactivity of the props
      var to = this.to,
          disabled = this.disabled,
          routerComponentName = this.routerComponentName;
      return (0,_utils_router__WEBPACK_IMPORTED_MODULE_11__.computeTag)({
        to: to,
        disabled: disabled,
        routerComponentName: routerComponentName
      }, this);
    },
    isRouterLink: function isRouterLink() {
      return (0,_utils_router__WEBPACK_IMPORTED_MODULE_11__.isRouterLink)(this.computedTag);
    },
    computedRel: function computedRel() {
      // We don't pass `this` as the first arg as we need reactivity of the props
      var target = this.target,
          rel = this.rel;
      return (0,_utils_router__WEBPACK_IMPORTED_MODULE_11__.computeRel)({
        target: target,
        rel: rel
      });
    },
    computedHref: function computedHref() {
      // We don't pass `this` as the first arg as we need reactivity of the props
      var to = this.to,
          href = this.href;
      return (0,_utils_router__WEBPACK_IMPORTED_MODULE_11__.computeHref)({
        to: to,
        href: href
      }, this.computedTag);
    },
    computedProps: function computedProps() {
      var prefetch = this.prefetch;
      return this.isRouterLink ? _objectSpread(_objectSpread({}, (0,_utils_props__WEBPACK_IMPORTED_MODULE_2__.pluckProps)(_objectSpread(_objectSpread({}, routerLinkProps), nuxtLinkProps), this)), {}, {
        // Coerce `prefetch` value `null` to be `undefined`
        prefetch: (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_12__.isBoolean)(prefetch) ? prefetch : undefined,
        // Pass `router-tag` as `tag` prop
        tag: this.routerTag
      }) : {};
    },
    computedAttrs: function computedAttrs() {
      var bvAttrs = this.bvAttrs,
          href = this.computedHref,
          rel = this.computedRel,
          disabled = this.disabled,
          target = this.target,
          routerTag = this.routerTag,
          isRouterLink = this.isRouterLink;
      return _objectSpread(_objectSpread(_objectSpread(_objectSpread({}, bvAttrs), href ? {
        href: href
      } : {}), isRouterLink && !(0,_utils_dom__WEBPACK_IMPORTED_MODULE_13__.isTag)(routerTag, 'a') ? {} : {
        rel: rel,
        target: target
      }), {}, {
        tabindex: disabled ? '-1' : (0,_utils_inspect__WEBPACK_IMPORTED_MODULE_12__.isUndefin