
<?php $__env->startSection('title','Emart | My Account'); ?>
<?php $__env->startSection("content"); ?>   
<!-- Home Start -->
<section id="home" class="home-main-block product-home">
  <div class="container">
    <div class="row">
      <div class="col-lg-12">
        <nav aria-label="breadcrumb" class="breadcrumb-main-block">
          <ol class="breadcrumb">
            <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" title="Home"><?php echo e(__('Home')); ?></a></li>
            <li class="breadcrumb-item"><?php echo e(__('Account')); ?></li>
            <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('2FA Auth')); ?></li>
          </ol>
        </nav>
        <div class="about-breadcrumb-block wishlist-breadcrumb" style="background-image: url('<?= URL::to('/'); ?>/frontend/assets/images/wishlist/breadcrum.png');">
          <div class="breadcrumb-nav">
              <h3 class="breadcrumb-title"><?php echo e(__('2FA Auth')); ?></h3>
          </div>
        </div>
      </div>
    </div>
  </div>
</section>
<!-- Home End -->

<!-- My Account Start -->
<section id="my-account" class="my-account-main-block popular-item-main-block">
    <div class="container">
        <div class="row">
            <?php $active['active'] = '2Fa'; ?>
            <?php echo $__env->make('frontend.profile.sidebar',$active, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="col-lg-9 col-md-8">
                <div class="tab-content" id="v-pills-tabContent">
                    <div class="personal-info-block">
                        <div class="card-header">
                            <h3 class="section-title"><?php echo e(__('Enable 2 Factor Auth')); ?></h3>
                        </div>
                        <div class="card-body">
                            <p>
                                Two factor authentication (2FA) strengthens access security by requiring two methods (also referred to as factors) to verify your identity. Two factor authentication protects against phishing, social engineering and password brute force attacks and secures your logins from attackers exploiting weak or stolen credentials.
                            </p>

                            <?php if($data['google2fa_url'] != '' ): ?>
                                1. Scan this QR code with your Google Authenticator App:
                            <?php endif; ?>
                            
                            <?php if($data['google2fa_url'] != '' ): ?>
                            <div>
                                <?php echo $data['google2fa_url']; ?>

                            </div>
                            <?php endif; ?>
                            <hr>
                            <?php if($data['google2fa_url'] == '' ): ?>
                            <form action="<?php echo e(url('/generate2faSecret')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                
                                <div class="form-group">
                                    <button type="submit" class="btn btn-md btn-primary">
                                        Generate Secret Key to Enable 2FA
                                    </button>
                                </div>

                            </form>
                            <?php endif; ?>

                            <?php if(auth()->user()->google2fa_secret != '' && auth()->user()->google2fa_enable == 0 ): ?>
                            <form action="<?php echo e(url('/2fa-valid')); ?>" method="POST">
                                <?php echo csrf_field(); ?>
                                <div class="form-group">
                                    <label class="font-weight-normal">Enter pin from app or above code: <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" name="one_time_password">
                                </div>

                                <div class="form-group">
                                    <button type="submit" class="btn btn-md btn-primary mt-4">
                                        <?php echo e(__('Enable 2FA Auth')); ?>

                                    </button>
                                </div>
                            </form>
                            <?php endif; ?>

                            <?php if(auth()->user()->google2fa_enable == 1): ?>
                                <form action="<?php echo e(url('/disable-2fa')); ?>" method="POST">
                                    <?php echo csrf_field(); ?>

                                    <div class="form-group">
                                        <label class="font-weight-normal">Enter current password to disable 2FA: <span class="text-danger">*</span></label>
                                        <input required type="password" placeholder="Enter current password" class="form-control <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="password">

                                        <?php $__errorArgs = ['password'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <span class="invalid-feedback text-danger" role="alert">
                                                <strong><?php echo e($message); ?></strong>
                                            </span>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <div class="form-group">
                                        <button type="submit" class="btn btn-md btn-primary mt-4">
                                            <?php echo e(__('Disable 2FA Auth')); ?>

                                        </button>
                                    </div>
                                </form>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- My Account End -->

<?php $__env->stopSection(); ?>


<?php echo $__env->make("frontend.layout.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\wetransfer_khushbu-zip_2023-10-03_0759\khushbu\resources\views/frontend/profile/2fa_auth.blade.php ENDPATH**/ ?>