
<?php $__env->startSection('title',__('All Menus | ')); ?>
<?php $__env->startSection('body'); ?>

<?php $pages = app('App\Page'); ?>

<?php
  $data['heading'] = 'All Menu';
  $data['title0'] = 'Menu Management';
  $data['title1'] = 'All Menu';
?>
<?php echo $__env->make('admin.layouts.topbar',$data, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>

<div class="contentbar bardashboard-card"> 
  <div class="row">
    
    <div class="col-lg-12">

      <?php if($errors->any()): ?>
        <div class="alert alert-danger" role="alert">
          <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <p><?php echo e($error); ?><button type="button" class="close" data-dismiss="alert" aria-label="Close">
              <span aria-hidden="true">&times;</span></button></p>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </div>
      <?php endif; ?>


      <div class="card m-b-30">
        <div class="card-header">
          
          <div class="row">
            <div class="col-lg-8">
              <h5 class="box-title"><?php echo e(__('All')); ?> <?php echo e(__('Menu List')); ?></h5>
            </div>
            <div class="col-md-4">
              <div class="widgetbar">
                <div class="wrapper-tooltip">
                    <button type="button" class="btn btn-primary-rgba"><i class="fa fa-info-circle float-right"></i></button>
                    <div class="tooltip"><?php echo e(__('Drag and Drop to sort the Menu Order')); ?></div>
                </div>                        
              </div>
            </div>
          </div>
          
        </div>
        <div class="card-body">
          <ul class="nav nav-tabs custom-tab-line mb-3" id="defaultTabLine" role="tablist">
            <li class="nav-item">
              <a class="nav-link active" id="pills-home-tab" data-toggle="pill" href="#pills-home" role="tab"
                aria-controls="pills-home" aria-selected="true"><?php echo e(__('Top Menus')); ?></a>
            </li>
            <li class="nav-item">
              <a class="nav-link" id="pills-profile-tab" data-toggle="pill" href="#pills-profile" role="tab"
                aria-controls="pills-profile" aria-selected="false"><?php echo e(__('Footer Menus')); ?></a>
            </li>

          </ul>
          <div class="tab-content" id="pills-tabContent">

            <div class="tab-pane fade show active" id="pills-home" role="tabpanel" aria-labelledby="pills-home-tab">
              
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('menu.create')): ?>
              <a href=" <?php echo e(route('menu.create')); ?> " class="float-right btn btn-primary-rgba mr-2">
                <i class="feather icon-plus mr-2"></i> <?php echo e(__("Add Menu")); ?>

              </a>
              <?php endif; ?>
              <?php if (app(\Illuminate\Contracts\Auth\Access\Gate::class)->check('menu.delete')): ?>
              <a data-toggle="modal" data-target="#bulk_delete" class="float-right btn btn-danger-rgba mr-2">
                <i class="feather icon-trash-2 mr-2"></i> <?php echo e(__("Delete Selected")); ?>

              </a>
              <?php endif; ?>


              <br>
              <br>


              <table id="menu_table" class="width100 table table-bordered table-striped table-hover w-100">
                <thead>
                  <th>
                    <div class="inline">
                      <input id="checkboxAll" type="checkbox" class="filled-in" name="checked[]" value="all" />
                      <label for="checkboxAll" class="material-checkbox"></label>
                    </div>
                  </th>
                  <th>#</th>
                  <th><?php echo e(__('Title')); ?></th>
                  <th>
                    <?php echo e(__('Additonal Detail')); ?>

                  </th>
                  <th>
                    <?php echo e(__('Action')); ?>

                  </th>
                </thead>

                <tbody id="menucontent">

                </tbody>
              </table>
            </div>
            <div class="tab-pane fade" id="pills-profile" role="tabpanel" aria-labelledby="pills-profile-tab">

              

              <a data-toggle="modal" data-target="#bulk_delete_fm" class="ml-2 float-left btn btn-danger-rgba">
                <i class="feather icon-trash-2 mr-2"></i> <?php echo e(__("Delete Selected")); ?>

              </a>

              <button data-toggle="modal" data-target="#help" class="float-right btn btn-success-rgba">
                <i class="fa fa-question-circle"></i> <?php echo e(__("Help")); ?>

              </button>

              <a title="Create a new footer menu" data-toggle="modal" data-target="#createnewfootermenu"
                class="mr-2 float-right btn btn-md btn-primary-rgba">
                <i class="feather icon-plus"></i> <?php echo e(__("Create")); ?>

              </a>

              

              

              <div class="modal fade" id="createnewfootermenu" tabindex="-1" role="dialog"
                aria-labelledby="myModalLabel">
                <div class="modal-dialog" role="document">
                  <div class="modal-content">
                    <div class="modal-header">
                      <h4 class="modal-title" id="myModalLabel"><?php echo e(__("Create new footer menu")); ?></h4>

                      <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
                          aria-hidden="true">&times;</span></button>
                    </div>

                    <div class="modal-body">
                      <form action="<?php echo e(route('footermenu.store')); ?>" method="POST">
                        <?php echo csrf_field(); ?>

                        <div class="form-group">
                          <label><?php echo e(__("Menu title:")); ?> <span class="required">*</span></label>
                          <input name="title" type="text" class="form-control" required placeholder="<?php echo e(__('enter menu title')); ?>">
                        </div>

                        <div class="form-group">
                          <label><?php echo e(__("Link by:")); ?> <span class="required">*</span></label>
                          <select required class="form-control select2" name="link_by" id="link_by">
                            <option value="page"><?php echo e(__("Pages")); ?></option>
                            <option value="url"><?php echo e(__('URL')); ?></option>
                          </select>
                        </div>

                        <div class="form-group" id="pagebox">
                          <label><?php echo e(__("Select pages:")); ?> <span class="required">*</span></label>
                          <select required="" class="form-control select2" name="page_id" id="page_id">
                            <?php $__currentLoopData = $pages->where('status','=','1')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($page->id); ?>"><?php echo e($page->name); ?></option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                          </select>
                        </div>

                        <div id="urlbox" class="form-group display-none">
                          <label><?php echo e(__("URL:")); ?> <span class="required">*</span></label>
                          <input class="form-control" type="url" placeholder="<?php echo e(__('enter custom url')); ?>" name="url"
                            id="inputurl">
                        </div>

                        <div class="form-group">
                          <label><?php echo e(__('Widget Position:')); ?><span class="required">*</span></label>
                          <select name="widget_postion" id="position" class="form-control select2">
                            <option value="footer_wid_3">
                              <?php echo e(__("Footer Widget 3")); ?>

                            </option>
                            <option value="footer_wid_4">
                              <?php echo e(__("Footer Widget 4")); ?>

                            </option>
                          </select>
                        </div>

                        <div class="form-group">
                          <label><?php echo e(__('Status:')); ?></label>
                          <br>
                          <label class="switch">
                            <input type="checkbox" name="status">
                            <span class="knob"></span>
                          </label>
                        </div>

                        <div class="form-group">
                          <button class="btn btn-md btn-primary-rgba" type="submit"><?php echo e(__("Create")); ?></button>
                        </div>

                      </form>
                    </div>

                  </div>
                </div>
              </div>
              <br><br>
              <table id="full_detail_table" class="table table-bordered table-striped table-hover w-100">
                <?php $footermenus = app('App\FooterMenu'); ?>
                <thead>
                  <tr>
                    <th>
                      <div class="inline">
                        <input id="checkboxAll_fm" type="checkbox" class="filled-in" name="checked_fm[]" value="all" />
                        <label for="checkboxAll_fm" class="material-checkbox"></label>
                      </div>
                    </th>
                    <th>#</th>
                    <th><?php echo e(__("Menu Title")); ?></th>
                    <th><?php echo e(__("Info.")); ?></th>
                    <th>
                      <?php echo e(__("Action")); ?>

                    </th>
                  </tr>
                </thead>

                <tbody>
                  <?php $__currentLoopData = $footermenus->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $fm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <tr>
                    <td>
                      <div class="inline">
                        <input type="checkbox" form="bulk_delete_form_fm"
                          class="fm_menus_cbox filled-in material-checkbox-input" name="checked_fm[]"
                          value="<?php echo e($fm->id); ?>" id="fm<?php echo e($fm->id); ?>">
                        <label for="fm<?php echo e($fm->id); ?>" class="material-checkbox"></label>
                      </div>
                    </td>
                    <td><?php echo e($key + 1); ?></td>
                    <td><b><?php echo e($fm->title); ?></b></td>
                    <td>
                      <p>
                        <?php if($fm->link_by == 'page'): ?>
                        <b><?php echo e(__("Linked to:")); ?></b> <?php echo e(__("Page")); ?>

                        <?php else: ?>
                        <b><?php echo e(__("Linked to:")); ?></b> <?php echo e(__('URL')); ?>

                        <?php endif; ?>
                      </p>

                      <p>
                        <b>Widget Position:</b>
                        <?php echo e($fm->widget_postion == 'footer_wid_3' ? __("Footer Widget 3") : __("Footer Widget 4")); ?>

                      </p>

                      <p> <b><?php echo e(__('Status:')); ?> </b>
                        <?php if($fm->status == '1'): ?>
                        <span class="badge badge-success"><?php echo e(__("Active")); ?></span>
                        <?php else: ?>
                        <span class="badge badge-danger">
                          <?php echo e(__("Deactive")); ?>

                        </span>
                        <?php endif; ?>
                      </p>
                    </td>

                    <td>
                      <div class="dropdown">
                        <button class="btn btn-round btn-outline-primary" type="button" id="CustomdropdownMenuButton1"
                          data-toggle="dropdown" aria-haspopup="true" aria-expanded="false"><i
                            class="feather icon-more-vertical-"></i></button>
                        <div class="dropdown-menu" aria-labelledby="CustomdropdownMenuButton1">

                          <a class="dropdown-item" href="#editmenuModal<?php echo e($fm->id); ?>" data-toggle="modal"><i
                              class="feather icon-edit mr-2"></i><?php echo e(__('Edit')); ?></a>



                          <a class="dropdown-item btn btn-link" data-toggle="modal" href="#footermenudel<?php echo e($fm->id); ?>">
                            <i class="feather icon-delete mr-2"></i><?php echo e(__("Delete")); ?></a>
                          </a>

                        </div>
                      </div>


                    </td>
                  </tr>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
              </table>
            </div>

          </div>
        </div>
      </div>
    </div>
  </div>
</div>
<div class="modal fade" id="help" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">
          <?php echo e(__("Example of Footer Widgets & Footer Sections")); ?>

        </h4>

        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
            aria-hidden="true">&times;</span></button>
      </div>

      <div class="modal-body">
        <img src="<?php echo e(url('images/footerhelp.png')); ?>" title="Footer Help Example" alt="help-footer" class="img-fluid">
      </div>

    </div>
  </div>
</div>

<?php $__currentLoopData = $footermenus->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $fm): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
<div class="modal fade" id="editmenuModal<?php echo e($fm->id); ?>" tabindex="-1" role="dialog" aria-labelledby="myModalLabel">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h4 class="modal-title" id="myModalLabel">
          <?php echo e(__("Edit footer menu")); ?>

        </h4>

        <button type="button" class="close" data-dismiss="modal" aria-label="Close"><span
            aria-hidden="true">&times;</span></button>
      </div>

      <div class="modal-body">
        <form action="<?php echo e(route('footermenu.update',$fm->id)); ?>" method="POST">
          <?php echo csrf_field(); ?>

          <div class="form-group">
            <label><?php echo e(__("Menu title:")); ?> <span class="required">*</span></label>
            <input name="title" value="<?php echo e($fm->title); ?>" type="text" class="form-control" required
              placeholder="<?php echo e(__("enter menu title")); ?>">
          </div>

          <div class="form-group">
            <label><?php echo e(__('Link by:')); ?> <span class="required">*</span></label>
            <select required class="form-control select2 link_by_edit" name="link_by" id="link_by_edit">
              <option <?php echo e($fm->link_by == 'page' ? "selected" : ""); ?> value="page"><?php echo e(__('Pages')); ?></option>
              <option <?php echo e($fm->link_by == 'url' ? "selected" : ""); ?> value="url"><?php echo e(__("URL")); ?></option>
            </select>
          </div>

          <div class="form-group select2 pagebox_edit <?php echo e($fm->link_by == 'page' ? '' : 'display-none'); ?>"
            id="pagebox_edit">
            <label><?php echo e(__('Select pages:')); ?> <span class="required">*</span></label>
            <select <?php echo e($fm->link_by == 'page' ? 'required' : ''); ?> class="form-control page_id_edit" name="page_id"
              id="page_id_edit">
              <?php $__currentLoopData = $pages->where('status','=','1')->get(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $page): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
              <option <?php echo e($fm->page_id == $page->id ? "selected"  : ""); ?> value="<?php echo e($page->id); ?>"><?php echo e($page->name); ?>

              </option>
              <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
          </div>

          <div id="urlbox_edit" class="urlbox_edit form-group <?php echo e($fm->link_by == 'url' ? '' : 'display-none'); ?>">
            <label><?php echo e(__("URL:")); ?> <span class="required">*</span></label>
            <input value="<?php echo e($fm->url); ?>" class="form-control" type="url" placeholder="<?php echo e(__("enter custom url")); ?>" name="url"
              id="inputurl-edit">
          </div>

          <div class="form-group">
            <label><?php echo e(__("Widget Position:")); ?> <span class="required">*</span></label>
            <select name="widget_postion" id="position" class="form-control select2">
              <option <?php echo e($fm->widget_postion == 'footer_wid_3' ? "selected" : ""); ?> value="footer_wid_3">
                <?php echo e(__("Footer Widget 3")); ?>

              </option>
              <option <?php echo e($fm->widget_postion == 'footer_wid_4' ? "selected" : ""); ?> value="footer_wid_4">
                <?php echo e(__("Footer Widget 4")); ?>

              </option>
            </select>
          </div>

          <div class="form-group">
            <label><?php echo e(__('Status:')); ?></label>
            <br>
            <label class="switch">
              <input type="checkbox" name="status" <?php echo e($fm->status == 1 ? "checked" : ""); ?>>
              <span class="knob"></span>
            </label>
          </div>

          <div class="form-group">
            <button class="btn btn-md btn-primary" <?php if(env('DEMO_LOCK')==0): ?> type="submit" <?php else: ?> disabled=""
              title="<?php echo e(__("This action is disabled in demo !")); ?>" <?php endif; ?>><?php echo e(__("Update")); ?></button>
          </div>

        </form>
      </div>

    </div>
  </div>
</div>

<div id="footermenudel<?php echo e($fm->id); ?>" class="delete-modal modal fade" role="dialog">
  <div class="modal-dialog modal-sm">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <div class="delete-icon"></div>
      </div>
      <div class="modal-body text-center">
        <h4 class="modal-heading"><?php echo e(__("Are You Sure ?")); ?></h4>
        <p>
          <?php echo e(__("Do you really want to delete this menu? This process cannot be undone.")); ?>

        </p>
      </div>
      <div class="modal-footer">
        <form method="post" action="<?php echo e(route('footermenu.delete',$fm->id)); ?>" class="pull-right">
          <?php echo csrf_field(); ?>
          <?php echo method_field('delete'); ?>


          <button type="reset" class="btn btn-gray translate-y-3" data-dismiss="modal"><?php echo e(__("NO")); ?></button>
          <button type="submit" class="btn btn-danger"><?php echo e(__("YES")); ?></button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

<!-- Top menu Bulk Delete Modal -->
<div id="bulk_delete" class="delete-modal modal fade" role="dialog">
  <div class="modal-dialog modal-sm">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <div class="delete-icon"></div>
      </div>
      <div class="modal-body text-center">
        <h4 class="modal-heading"><?php echo e(__("Are You Sure ?")); ?></h4>
        <p>
          <?php echo e(__("Do you really want to delete these top menus? This process cannot be undone.")); ?>

        </p>
      </div>
      <div class="modal-footer">
        <form id="bulk_delete_form" method="post" action="<?php echo e(route('bulk.delete.topmenu')); ?>">
          <?php echo csrf_field(); ?>
          <?php echo method_field('DELETE'); ?>
          <button type="reset" class="btn btn-gray translate-y-3" data-dismiss="modal"><?php echo e(__("NO")); ?></button>
          <button type="submit" class="btn btn-danger"><?php echo e(__("YES")); ?></button>
        </form>
      </div>
    </div>
  </div>
</div>

<!-- Footer menu Bulk Delete Modal -->
<div id="bulk_delete_fm" class="delete-modal modal fade" role="dialog">
  <div class="modal-dialog modal-sm">
    <!-- Modal content-->
    <div class="modal-content">
      <div class="modal-header">
        <button type="button" class="close" data-dismiss="modal">&times;</button>
        <div class="delete-icon"></div>
      </div>
      <div class="modal-body text-center">
        <h4 class="modal-heading"><?php echo e(__("Are You Sure ?")); ?></h4>
        <p>
          <?php echo e(__('Do you really want to delete these footer menus? This process cannot be undone.')); ?>

        </p>
      </div>
      <div class="modal-footer">
        <form id="bulk_delete_form_fm" method="post" action="<?php echo e(route('bulk.delete.fm')); ?>">
          <?php echo csrf_field(); ?>
          <?php echo method_field('DELETE'); ?>
          <button type="reset" class="btn btn-gray translate-y-3" data-dismiss="modal"><?php echo e(__("NO")); ?></button>
          <button type="submit" class="btn btn-danger"><?php echo e(__("YES")); ?></button>
        </form>
      </div>
    </div>
  </div>
</div>
<?php $__env->stopSection(); ?>
<?php $__env->startSection('custom-script'); ?>
<script>
  var url = <?php echo json_encode(route('menu.index'), 15, 512) ?>;
  var sorturl = <?php echo json_encode(route('menu.sort'), 15, 512) ?>;
  var customcatid = null;
</script>
<script src="<?php echo e(url('js/menu.js')); ?>"></script>
<script src="<?php echo e(url('js/footermenu.js')); ?>"></script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('admin.layouts.master-soyuz', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\emart_live_preview\emart\resources\views/admin/menu/index.blade.php ENDPATH**/ ?>