
<?php $__env->startSection('title','Emart | Flash Deal Detail'); ?>
<?php $__env->startSection("content"); ?>   
    <!-- Home Start -->
    <section id="home" class="home-main-block">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <nav aria-label="breadcrumb" class="breadcrumb-main-block">
                        <ol class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" title="Home"><?php echo e(__('Home')); ?></a></li>
                            <li class="breadcrumb-item"><?php echo e(__('Flash Deals')); ?></li>
                            <li class="breadcrumb-item" aria-current="page"><?php echo e($deal->title); ?></li>
                        </ol>
                    </nav>
                    <div class="about-breadcrumb-block wishlist-breadcrumb" style="background-image: url('<?= URL::to('/'); ?>/frontend/assets/images/wishlist/breadcrum.png');">
                    <div class="breadcrumb-nav">
                        <h3 class="breadcrumb-title"><?php echo e($deal->title); ?></h3>
                    </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <!-- Flash Deal Bg Start -->
    <div id="flash-deal-bg" class="flashdeal-bg-main-block">
      <div class="container">
        <div class="flashdeal-bg-block">
          <div class="flashdeal-bg-block-img">
            <img src="<?php echo e(url('frontend/assets/images/flash_deals/flash-deal-bg.png')); ?>" class="img-fluid" alt="<?php echo e($deal->title); ?>">
            <div class="flashdeal-bg-dtl">
              <div class="row">
                <div class="col-lg-8">
                  <div class="featured-countdown">
                    <div id="countdown">
                      <ul>
                        <li><span id="days"></span>Days</li>
                        <li><span id="hours"></span>Hours</li>
                        <li><span id="minutes"></span>Min</li>
                        <li><span id="seconds"></span>Sec</li>
                      </ul>
                    </div>
                  </div>
                </div>
                <div class="col-lg-4">
                  <div class="flashdeal-bg-img">
                    <img src="<?php echo e(url('images/flashdeals/'.$deal->background_image)); ?>" class="img-fluid" alt="<?php echo e($deal->title); ?>">
                  </div>
                </div>
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
    <!-- Flash Deal Bg End -->
    
    <!-- Flash Deal Start -->
    <section id="flash-deal-dtl" class="flash-deal-dtl-main-block">
        <div class="container">
            <div class="row">
                <?php $__empty_1 = true; $__currentLoopData = $deal->saleitems; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                <div class="col-lg-3">
                    <div class="flash-deal-dtl-block">
                        <?php if(isset($item->variant)): ?>
                            <div class="flash-deal-dtl-img">
                                <?php if(isset($item->variant->variantimages)): ?>
                                <a href="<?php echo e(App\Helpers\ProductUrl::getUrl($item->variant->id)); ?>" title="<?php echo e($item->variant->products->name); ?>">
                                    <img src="<?php echo e(url('variantimages/'.$item->variant->variantimages->main_image)); ?>" class="img-fluid" alt="<?php echo e($item->variant->products->name); ?>">
                                </a>
                                <?php endif; ?>
                                <div class="overlay-bg"></div>
                                <div class="featured-product-icon">
                                    <ul>
                                        <li><a href="<?php echo e(App\Helpers\ProductUrl::getUrl($item->variant?$item->variant->id:'')); ?>" title="eye"><i data-feather="eye"></i></a></li>
                                        <?php if(auth()->guard()->check()): ?>
                                            <?php if(Auth::user()->wishlist()->count() < 1): ?> 
                                                <li class="lnk wishlist">
                                                    <a class="addtowish" mainid="<?php echo e($item->variant->id); ?>" title="<?php echo e(__('Add To WishList')); ?>" data-add="<?php echo e(url('AddToWishList/'.$item->variant->id)); ?>" title="<?php echo e(__('Add To WishList')); ?>"> <i data-feather="heart"></i></a>
                                                </li>
                                            <?php else: ?>

                                                <?php
                                                    $ifinwishlist = App\Wishlist::where('user_id',Auth::user()->id)->where('pro_id',$item->variant->id)->first();
                                                ?>

                                                <?php if(!empty($ifinwishlist)): ?>
                                                <li class="lnk wishlist active">
                                                    <a class="addtowish" mainid="<?php echo e($item->variant->id); ?>" title="<?php echo e(__('Remove From Wishlist')); ?>" data-add="<?php echo e(url('removeWishList/'.$item->variant->id)); ?>"> <i data-feather="heart"></i>
                                                    </a>
                                                </li>
                                                <?php else: ?>
                                                <li class="lnk wishlist">
                                                <a title="<?php echo e(__('Add To WishList')); ?>" class="addtowish" mainid="<?php echo e($item->variant->id); ?>" data-add="<?php echo e(url('AddToWishList/'.$item->variant->id)); ?>"> <i data-feather="heart"></i> </a>
                                                </li>
                                                <?php endif; ?>

                                            <?php endif; ?>
                                        <?php endif; ?>
                                        <li>
                                            
                                            <form method="POST" action="<?php echo e(route('add.product.cart',['id' => $item->variant->products->id ,'variantid' =>$item->variant->products->id, 'varprice' => $item->variant->products->vender_price?$item->variant->products->vender_price:"0"  , 'varofferprice' => $item->variant->products->vender_offer_price?$item->variant->products->vender_offer_price:"0" ,'qty' =>'1'])); ?>" class="addVariantProCard<?php echo e($item->variant->products->id); ?>">
                                                <?php echo e(csrf_field()); ?>

                                                <a href="javascript:" onclick="addVariantProCard(<?php echo e($item->variant->products->id); ?>)" title="<?php echo e(__('Add to Card')); ?>"><i data-feather="briefcase"></i></a>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                                <div class="flash-deal-dtl-detail">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <h6 class="flash-deal-dtl-title"><a href="<?php echo e(App\Helpers\ProductUrl::getUrl($item->variant->id)); ?>" title="<?php echo e($item->variant->products->name); ?>"><?php echo e(substr($item->variant->products->name, 0,20)); ?></a></h6>
                                            <p><?php echo e(substr(strip_tags($item->variant->products->des), 0, 30)); ?><?php echo e(strlen(strip_tags($item->variant->products->des))>30 ? '...' : ""); ?></p>
                                            <div class="flash-deal-dtl-offer">
                                                <span class="badge text-bg-warning">Upto : <?php echo e($item->discount); ?>% (<?php echo e($item->discount_type); ?>)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php else: ?>
                            <div class="flash-deal-dtl-img">
                                <a href="<?php echo e(route('show.product',['id' => $item->simple_product->id, 'slug' => $item->simple_product->slug])); ?>" title="<?php echo e($item->simple_product->thumbnail); ?>">
                                    <img src="<?php echo e(url('images/simple_products/'.$item->simple_product->thumbnail)); ?>" class="img-fluid" alt="<?php echo e($item->simple_product->thumbnail); ?>">
                                </a>
                                <div class="overlay-bg"></div>
                                <div class="flash-deal-dtl-icon">
                                    <ul>
                                        <li><a href="<?php echo e(route('show.product',['id' => $item->simple_product->id, 'slug' => $item->simple_product->slug])); ?>" title="eye"><i data-feather="eye"></i></a></li>
                                        <?php if(auth()->guard()->check()): ?>

                                        <?php if($item->type != 'ex_product'): ?>
                                            <li>
                                                <a class="add_in_wish_simple" data-proid="<?php echo e($item->id); ?>" data-status="<?php echo e(inwishlist($item->id)); ?>" data-toggle="tooltip" data-placement="right" title="<?php echo e(__('Wishlist')); ?>" href="javascript:void(0)">
                                                    <i data-feather="heart"></i>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php endif; ?>
                                        <li>
                                            <form method="POST" action="<?php echo e($item->type == 'ex_product' ? $item->external_product_link : route('add.cart.simple',['pro_id' => $item->simple_product->id, 'price' => $item->simple_product->price, 'offerprice' => $item->simple_product->offer_price])); ?>" class="addSimpleCardFrom<?php echo e($item->simple_product->id); ?>">
                                                <?php echo csrf_field(); ?>
                                                <input name="qty" type="hidden" value="<?php echo e($item->min_order_qty); ?>" max="<?php echo e($item->max_order_qty); ?>" class="qty-section">
                                                <a href="javascript:" onclick="addSimpleProCard(<?php echo e($item->simple_product->id); ?>)" title="<?php echo e(__('Add To Card')); ?>"><i data-feather="briefcase"></i></a>
                                            </form>
                                        </li>
                                    </ul>
                                </div>
                                <div class="flash-deal-dtl-detail">
                                    <div class="row">
                                        <div class="col-lg-12">
                                            <h6 class="flash-deal-dtl-title"><a href="<?php echo e(route('show.product',['id' => $item->simple_product->id, 'slug' => $item->simple_product->slug])); ?>" title="<?php echo e($item->simple_product->product_name); ?>"><?php echo e(substr($item->simple_product->product_name, 0, 20)); ?></a></h6>
                                            <p><?php echo e(substr(strip_tags($item->simple_product->product_detail), 0, 30)); ?><?php echo e(strlen(strip_tags($item->simple_product->product_detail))>30 ? '...' : ""); ?></p>
                                            <div class="flash-deal-dtl-offer">
                                                <span class="badge text-bg-warning">Upto <?php echo e($item->discount); ?>% (<?php echo e($item->discount_type); ?>)</span>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endif; ?>

                    </div>
                </div>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </div>
        </div>
    </section>
    <!-- Flash Deal End -->

<?php $__env->stopSection(); ?>
<?php $__env->startSection('script'); ?>
<script>
    (function () {
        const second = 1000,
            minute = second * 60,
            hour = minute * 60,
            day = hour * 24;

        let birthday = "<?php echo e(date('M d, Y h:i:s',strtotime($deal->end_date))); ?>",
            countDown = new Date(birthday).getTime(),
            x = setInterval(function () {

                let now = new Date().getTime(),
                    distance = countDown - now;

                document.getElementById("days").innerText = Math.floor(distance / (day)),
                    document.getElementById("hours").innerText = Math.floor((distance % (day)) / (hour)),
                    document.getElementById("minutes").innerText = Math.floor((distance % (hour)) / (minute)),
                    document.getElementById("seconds").innerText = Math.floor((distance % (minute)) / second);

                //do something later when date is reached
                if (distance < 0) {
                    let headline = document.getElementById("headline"),
                        countdown = document.getElementById("countdown"),
                        content = document.getElementById("content");

                    headline.innerText = "It's my birthday!";
                    countdown.style.display = "none";
                    content.style.display = "block";

                    clearInterval(x);
                }
                //seconds
            }, 0)
    }());
</script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make("frontend.layout.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\wetransfer_khushbu-zip_2023-10-03_0759\khushbu\resources\views/frontend/flash_deal.blade.php ENDPATH**/ ?>