
<?php $__env->startSection('title','Emart | My Account'); ?>
<?php $__env->startSection("content"); ?>   

<!-- Home Start -->
<section id="home" class="home-main-block">
    <div class="container">
        <div class="row">
            <div class="col-lg-12">
                <nav aria-label="breadcrumb" class="breadcrumb-main-block">
                    <ol class="breadcrumb">
                        <li class="breadcrumb-item"><a href="<?php echo e(url('/')); ?>" title="Home"><?php echo e(__('Home')); ?></a></li>
                        <li class="breadcrumb-item"><?php echo e(__('Account')); ?></li>
                        <li class="breadcrumb-item active" aria-current="page"><?php echo e(__('My Bank Account')); ?></li>
                    </ol>
                </nav>
                <div class="about-breadcrumb-block wishlist-breadcrumb" style="background-image: url('frontend/assets/images/wishlist/breadcrum.png');">
                  <div class="breadcrumb-nav">
                      <h3 class="breadcrumb-title"><?php echo e(__('My Bank Account')); ?></h3>
                  </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- Home End -->

<!-- My Account Start -->
<section id="my-account" class="my-account-main-block popular-item-main-block">
    <div class="container">
        <div class="row">
            <?php $active['active'] = 'Mybankac'; ?>
            <?php echo $__env->make('frontend.profile.sidebar',$active, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
            <div class="col-lg-9 col-md-8">
                <div class="tab-content" id="v-pills-tabContent">
                    <div class="personal-info-block bank-acc-block">
                        <div class="row">
                            <div class="col-lg-6">
                                <h3 class="section-title"><?php echo e(__('My Bank Account')); ?></h3>
                            </div>
                            <div class="col-lg-6">
                                <a href="javascript:" data-bs-toggle="modal" data-bs-target="#addbank" class="btn btn-info"><i data-feather="plus" width="18px" height="18px"></i>Add New Bank</a>
                                <!-- Add Modal -->
                                <div class="modal fade" id="addbank" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                    <div class="modal-dialog">
                                        <div class="modal-content">
                                            <div class="modal-header">
                                                <h5 class="p-2 modal-title" id="myModalLabel"><?php echo e(__('Add New Bank')); ?></h5>
                                                <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                            </div>
                                            <form action="<?php echo e(route('user.bank.add')); ?>" method="POST">
                                                <?php echo csrf_field(); ?>
                                                <div class="modal-body">
                                           
                                                    <div class="row">
                                                        <div class="col-lg-6">
                                                            <div class="mb-3">
                                                                <div class="form-group">
                                                                    <label class="font-weight-bold"><?php echo e(__('Ac Holder Name')); ?>: <span class="required">*</span></label>
                                                                    <input value="" required="" type="text" class="form-control" name="acname">
                                                                    <div class="required"></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <div class="mb-3">
                                                                <div class="form-group">
                                                                    <label class="font-weight-bold"><?php echo e(__('Bank Name')); ?>: <span class="required">*</span></label>
                                                                    <input value="" required="" type="text" class="form-control" name="bankname">
                                                                    <div class="required"></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <div class="mb-3">
                                                                <div class="form-group">
                                                                    <label class="font-weight-bold"><?php echo e(__('Account No')); ?>.: <span class="required">*</span></label>
                                                                    <input pattern="[0-9]+" value="" required="" type="text" class="form-control" name="acno">
                                                                    <div class="required"></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                        <div class="col-lg-6">
                                                            <div class="mb-3">
                                                                <div class="form-group">
                                                                    <label class="font-weight-bold"><?php echo e(__('IFSC / SWIFT Code')); ?>: <span class="required">*</span></label>
                                                                    <input value="" required="" type="text" class="form-control" name="ifsc">
                                                                    <div class="required"></div>
                                                                </div>
                                                            </div>
                                                        </div>
                                                    </div>                                                
                                                </div>
                                                <div class="modal-footer">
                                                    <button type="submit" class="btn btn-primary">Save</button>
                                                </div>
                                            </form>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <div class="card-body">
                            <div class="row mt-4">
                                <div class="table-responsive">
                                    <table class="table manage-address-block">
                                        <thead>
                                            <tr>
                                                <th scope="col">#</th>
                                                <th><?php echo e(__('A/C Holder Name')); ?></th>
                                                <th><?php echo e(__('Bank name')); ?></th>
                                                <th><?php echo e(__('IFSC / SWIFT Code')); ?></th>
                                                <th><?php echo e(__('A/C No')); ?>.</th>
                                                <th><?php echo e(__('Action')); ?></th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                        <?php $__currentLoopData = Auth::user()->banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                            <tr>
                                                <th scope="row"><?php echo e($key+1); ?></th>
                                                <td><?php echo e($bank->acname); ?></td>
                                                <td><?php echo e($bank->bankname); ?></td>
                                                <td><?php echo e($bank->ifsc); ?></td>
                                                <td><?php echo e($bank->acno); ?></td>
                                                <td>
                                                    <div class="manage-add-btn">
                                                        <button title="<?php echo e(__('Edit')); ?>" data-bs-toggle="modal" data-bs-target="#editbank<?php echo e($bank->id); ?>" class="editlabel btn btn-sm btn-info">
                                                            <i data-feather="edit"></i>
                                                        </button>
                                                        <button <?php if(env('DEMO_LOCK')==0): ?> data-bs-toggle="modal" data-bs-target="#deletebank<?php echo e($bank->id); ?>"
                                                                title="<?php echo e(__('Delete')); ?>" <?php else: ?> disabled="disabled" title="This action is disabled in demo !"
                                                                <?php endif; ?> class="delbtn btn btn-danger btn-sm"><i data-feather="trash"></i>
                                                        </button>
                                                    </div>
                                                </td>
                                            </tr>
                                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                        </tbody>
                                    </table>
                                    <?php $__currentLoopData = Auth::user()->banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <!-- Edit Modal -->
                                    <div class="modal fade" id="editbank<?php echo e($bank->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                        <div class="modal-dialog">
                                            <div class="modal-content">
                                                <div class="modal-header">
                                                    <h5 class="p-2 modal-title" id="myModalLabel"><?php echo e(__('Edit Bank')); ?></h5>
                                                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                </div>
                                                <form action="<?php echo e(route('user.bank.update',$bank->id)); ?>" method="POST">
                                                    <?php echo csrf_field(); ?>
                                                    <div class="modal-body">
                                                        <div class="row">
                                                            <div class="col-lg-6">           
                                                                <div class="form-group">
                                                                    <label><?php echo e(__('Ac Holder Name')); ?> <span class="required">*</span></label>
                                                                    <input value="<?php echo e($bank->acname); ?>" required="" type="text" class="form-control" name="acname">
                                                                    <div class="required"><?php echo e($errors->first('acname')); ?></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">       
                                                                <div class="form-group">
                                                                    <label><?php echo e(__('Bank Name')); ?>: <span class="required">*</span></label>
                                                                    <input value="<?php echo e($bank->bankname); ?>" required="" type="text" class="form-control" name="bankname">
                                                                    <div class="required"><?php echo e($errors->first('bankname')); ?></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">  
                                                                <div class="form-group">
                                                                    <label><?php echo e(__('Account No')); ?>.: <span class="required">*</span></label>
                                                                    <input pattern="[0-9]+" value="<?php echo e($bank->acno); ?>" required="" type="text" class="form-control" name="acno">
                                                                    <div class="required"><?php echo e($errors->first('acno')); ?></div>
                                                                </div>
                                                            </div>
                                                            <div class="col-lg-6">  
                                                                <div class="form-group">
                                                                    <label><?php echo e(__('IFSC / SWIFT Code')); ?>: <span class="required">*</span></label>
                                                                    <input value="<?php echo e($bank->ifsc); ?>" required="" type="text" class="form-control" name="ifsc">
                                                                    <div class="required"><?php echo e($errors->first('ifsc')); ?></div>
                                                                </div>
                                                            </div>  
                                                        </div>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <button <?php if(env('DEMO_LOCK')==0): ?> type="submit" <?php else: ?> title="This action is disabled in demo !" disabled="disabled" <?php endif; ?> class="btn btn-primary">
                                                            <?php echo e(__('Save')); ?>

                                                        </button>
                                                    </div>
                                                </form>
                                            </div>
                                        </div>
                                    </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                                    <?php $__currentLoopData = Auth::user()->banks; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key=> $bank): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <!-- Delete Modal -->
                                        <div class="modal fade delete-modal" id="deletebank<?php echo e($bank->id); ?>" tabindex="-1" aria-labelledby="exampleModalLabel" aria-hidden="true">
                                            <div class="modal-dialog">
                                                <div class="modal-content">
                                                    <div class="modal-header">
                                                        <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                                                        <div class="delete-icon"></div>
                                                    </div>
                                                    <div class="modal-body text-center">
                                                        <h5 class="modal-heading"><?php echo e(__('Are You Sure ?')); ?></h5>
                                                        <p><?php echo e(__('Do you really want to delete this bank account')); ?> <b><?php echo e(__('bankname')); ?></b>?<?php echo e(__('This process cannot be undone')); ?>.</p>
                                                    </div>
                                                    <div class="modal-footer">
                                                        <form method="post" action="<?php echo e(route('user.bank.delete',$bank->id)); ?>" class="pull-right">
                                                            <?php echo e(csrf_field()); ?>

                                                            <?php echo e(method_field("DELETE")); ?>

                                                            <button type="reset" class="btn btn-primary translate-y-3" data-bs-dismiss="modal">
                                                                <?php echo e(__('No')); ?>

                                                            </button>
                                                            <button type="submit" class="btn btn-danger">
                                                                <?php echo e(__('Yes')); ?>

                                                            </button>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                    
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<!-- My Account End -->

<?php $__env->stopSection(); ?>
<?php echo $__env->make("frontend.layout.master", \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\wetransfer_khushbu-zip_2023-10-03_0759\khushbu\resources\views/frontend/profile/mybankac.blade.php ENDPATH**/ ?>