<div class="col-lg-4 col-md-6 col-6">
    <div class="featured-product-block">
        <div class="featured-product-img">
            <a href="<?php echo e($product->getURL($sub)); ?>" title="">
                <?php if(count($product->subvariants)>0): ?>

                    <?php if(isset($sub->variantimages['main_image'])): ?>

                    <img class="img-fluid" src="<?php echo e(url('variantimages/thumbnails/'.$sub->variantimages['main_image'])); ?>" alt="<?php echo e($sub->products->name); ?>" />

                    <?php endif; ?>

                <?php else: ?>

                    <img class="img-fluid" title="<?php echo e($sub->name); ?>" src="<?php echo e(url('images/no-image.png')); ?>" alt="<?php echo e(__('No Image')); ?>" />

                <?php endif; ?>
            </a>
            <div class="overlay-bg"></div>
            <div class="featured-product-icon">
                <ul>
                    <li><a href="<?php echo e($product->getURL($sub)); ?>" title="eye"><i data-feather="eye"></i></a></li>
                    <?php if(auth()->guard()->check()): ?>
                        <?php if(Auth::user()->wishlist()->count() < 1): ?> 
                            <li class="lnk wishlist">
                                <a class="addtowish" mainid="<?php echo e($product->id); ?>" title="<?php echo e(__('Add To WishList')); ?>" data-add="<?php echo e(url('AddToWishList/'.$product->id)); ?>" title="<?php echo e(__('Add To WishList')); ?>"> <i data-feather="heart"></i></a>
                            </li>
                        <?php else: ?>

                            <?php
                                $ifinwishlist = App\Wishlist::where('user_id',Auth::user()->id)->where('pro_id',$product->id)->first();
                            ?>

                            <?php if(!empty($ifinwishlist)): ?>
                            <li class="lnk wishlist active">
                                <a class="addtowish" mainid="<?php echo e($product->id); ?>" title="<?php echo e(__('Remove From Wishlist')); ?>" data-add="<?php echo e(url('removeWishList/'.$product->id)); ?>"> <i data-feather="heart"></i>
                                </a>
                            </li>
                            <?php else: ?>
                            <li class="lnk wishlist">
                                <a title="<?php echo e(__('Add To WishList')); ?>" class="addtowish" mainid="<?php echo e($product->id); ?>" data-add="<?php echo e(url('AddToWishList/'.$product->id)); ?>"> <i data-feather="heart"></i> </a>
                            </li>
                            <?php endif; ?>

                        <?php endif; ?>
                    <?php endif; ?>
                   
                    <li>
                        <form method="POST" action="<?php echo e(route('add.product.cart',['id' => $product->id ,'variantid' =>$sub->id, 'varprice' => $show_price, 'varofferprice' => $convert_price ,'qty' =>$sub->min_order_qty])); ?>" class="addVariantProCard<?php echo e($product->id); ?>">
                            <?php echo e(csrf_field()); ?>

                            <a href="javascript:" onclick="addVariantProCard(<?php echo e($product->id); ?>)" title="<?php echo e(__('Add to Card')); ?>"><i data-feather="briefcase"></i></a>
                        </form>
                    </li>
                </ul>
            </div>
            <?php if($product['sale_tag'] !== NULL && $product['sale_tag'] != ''): ?>
            <div class="featured-product-badge">               
                <span class="badge text-bg-primary">
                            
                    <?php echo e($product['sale_tag']); ?>


                </span>
            </div>
            <?php endif; ?>
        </div>
        <div class="featured-product-dtl">
            <div class="row">
                <div class="col-xl-8 col-lg-7 col-md-7 col-7">
                    <h6 class="featured-product-title truncate">
                        <a href="<?php echo e($product->getURL($sub)); ?>"><?php echo e($product->name); ?>

                            (<?php echo e(variantname($sub)); ?>)
                        </a>
                    </h6>
                    <p><?php echo e(__('By')); ?> 
                        <a href="<?php echo e(route('store.view',['uuid' => $product->store->uuid ?? 0, 'title' => $product->store->name])); ?>"><?php echo e($product->store->name); ?> 
                            <?php if($product->store->verified_store): ?>
                            <div class="verified-icon">
                                <i data-feather="check-circle"></i>
                            </div>
                            <?php endif; ?>
                        </a>
                    </p>
                </div>
                <div class="col-xl-4 col-lg-5 col-md-5 col-5">
                    <div class="featured-product-price">
                        <?php if($price_login == 0 || auth()->check()): ?>
                              
                            <?php if($convert_price != 0): ?>

                                <span>
                                    <i class="<?php echo e(session()->get('currency')['value']); ?>"></i>
                                    <?php echo e(price_format($convert_price * $conversion_rate)); ?>

                                </span>
                                <s>
                                    <i class="<?php echo e(session()->get('currency')['value']); ?>"></i>
                                    <?php echo e(price_format($show_price * $conversion_rate)); ?>

                                </s>

                            <?php else: ?>

                                <span>
                                    <i class="<?php echo e(session()->get('currency')['value']); ?>"></i>
                                    <?php echo e(price_format($show_price * $conversion_rate)); ?>

                                </span>

                            <?php endif; ?>

                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div><?php /**PATH C:\laragon\www\emart_live_preview\emart\resources\views/frontend/product_filter/filterproduct.blade.php ENDPATH**/ ?>